/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.service.impl;

import com.adobe.aem.formsndocuments.publish.AssetReferenceProvider;
import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.service.FormsFoundationException;
import com.adobe.forms.foundation.service.util.FormsFoundationUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={FormsRelationService.class})
public class FormsRelationServiceImpl
implements FormsRelationService {
    @org.apache.felix.scr.annotations.Reference(referenceInterface=ReferenceProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ReferenceProvider> referenceProviders = new CopyOnWriteArrayList<ReferenceProvider>();
    @org.apache.felix.scr.annotations.Reference(referenceInterface=QueryBuilder.class)
    private QueryBuilder queryBuilder;
    @org.apache.felix.scr.annotations.Reference(referenceInterface=ResourceResolverFactory.class)
    private ResourceResolverFactory resolverFactory;
    @org.apache.felix.scr.annotations.Reference(referenceInterface=ResourceResolverHelper.class)
    private ResourceResolverHelper resourceResolverHelper;
    @org.apache.felix.scr.annotations.Reference
    private FormsFoundationUtils formsFoundationUtils;
    private final Logger log = LoggerFactory.getLogger(FormsRelationServiceImpl.class);

    @Override
    public void getAllRelatedChildAssets(ResourceResolver resolver, String path, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.getRelatedChildAssets(resolver, path, true, allRelatedChildAssets);
    }

    @Override
    public void getFirstLevelRelatedChildAssets(ResourceResolver resolver, String path, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.getRelatedChildAssets(resolver, path, false, allRelatedChildAssets);
    }

    private void getRelatedChildAssets(ResourceResolver resolver, String path, boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.log.debug("Enter :  getAllRelatedChildAssets for asset : " + path);
        Session session = resolver.adaptTo(Session.class);
        try {
            Resource assetResource;
            if (path != null && session.nodeExists(path) && (assetResource = resolver.getResource(path)) != null) {
                this.log.debug("Adding form to allRelatedChildAssets : " + path);
                if (allRelatedChildAssets.add(new AssetInfo(assetResource, FMUtils.getAssetType(session, path)))) {
                    this.getRelatedChildFMAssets(resolver, path, allLevel, allRelatedChildAssets);
                }
                if (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path) || FMUtils.isAdaptiveDocument(session, path)) {
                    String guidePagePath = FMUtils.getPagePathFromAsset(path);
                    Resource pageResource = resolver.getResource(guidePagePath);
                    this.log.debug("Adding form to allRelatedChildAssets : " + guidePagePath);
                    if (allRelatedChildAssets.add(new AssetInfo(pageResource, FMConstants.CoreAssetType.NONFMASSET))) {
                        this.findReferences(this.referenceProviders, pageResource, allLevel, allRelatedChildAssets, session);
                    }
                }
            }
            this.log.debug("Exit :  getAllRelatedChildAssets for asset : " + path);
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private void findReferences(List<ReferenceProvider> referenceProviders, Resource r, boolean allLevel, Set<AssetInfo> allRelatedChildAssets, Session session) {
        this.log.debug("Enter :  findReferences for asset : " + r.getPath());
        for (ReferenceProvider referenceProvider : referenceProviders) {
            if (referenceProvider instanceof AssetReferenceProvider) continue;
            List<Reference> refList = referenceProvider.findReferences(r);
            for (Reference ref : refList) {
                try {
                    Resource resource = ref.getResource();
                    AssetInfo formInfo = new AssetInfo(resource, FMUtils.getAssetType(session, resource.getPath()));
                    if (FMUtils.getAssetType(session, resource.getPath()).equals((Object)FMConstants.CoreAssetType.NONFMASSET)) {
                        formInfo.setNonFMAssetType(ref.getType());
                    }
                    if (allRelatedChildAssets.contains(formInfo)) continue;
                    if (allLevel && resource.getPath().startsWith("/content/dam/formsanddocuments")) {
                        this.getAllRelatedChildAssets(resource.getResourceResolver(), resource.getPath(), allRelatedChildAssets);
                        continue;
                    }
                    this.log.debug("Adding form to allRelatedChildAssets : " + resource.getPath());
                    allRelatedChildAssets.add(formInfo);
                }
                catch (FormsMgrException e) {
                    this.log.error("Error finding dependency of asset : " + r.getPath(), (Throwable)e);
                }
            }
        }
        this.log.debug("Exit :  findReferences for asset : " + r.getPath());
    }

    @Override
    public void getAllRelatedChildFMAssets(ResourceResolver resourceResolver, String path, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.getRelatedChildFMAssets(resourceResolver, path, true, allRelatedChildAssets);
    }

    @Override
    public void getFirstLevelRelatedChildFMAssets(ResourceResolver resourceResolver, String path, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.getRelatedChildFMAssets(resourceResolver, path, false, allRelatedChildAssets);
    }

    private void getRelatedChildFMAssets(ResourceResolver resourceResolver, String path, boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws FormsMgrException {
        this.log.debug("Enter :  getAllRelatedChildFMAssets for asset : " + path);
        Session session = resourceResolver.adaptTo(Session.class);
        try {
            if (session.nodeExists(path)) {
                if (FMUtils.isFormset(session, path)) {
                    this.getAllRelatedChildAssetsForFormset(resourceResolver, path, allLevel, allRelatedChildAssets);
                } else if (session.nodeExists(path) && FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) {
                    this.getAllRelatedChildAssetsForGuideOrFragment(resourceResolver, path, allLevel, allRelatedChildAssets);
                } else if (path != null && session.nodeExists(path) && FMUtils.isXDPForm(session, path)) {
                    this.getAllRelatedChildAssetsForXDP(resourceResolver, path, allLevel, allRelatedChildAssets);
                } else if (path != null && session.nodeExists(path) && FMUtils.isTheme(session, path)) {
                    this.getAllRelatedChildAssetsForTheme(resourceResolver, path, allLevel, allRelatedChildAssets);
                }
            }
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        this.log.debug("Exit :  getAllRelatedChildFMAssets for asset : " + path);
    }

    @Override
    public Set<AssetInfo> getDependentParentFMAssets(ResourceResolver resourceResolver, String path) throws FormsMgrException {
        this.log.debug("Enter :  getDependentParentFMAssets for asset : " + path);
        try {
            if (path == null || path.isEmpty() || resourceResolver == null) {
                throw new FormsMgrException("AEM-FMG-700-001", new Object[0]);
            }
            Session session = resourceResolver.adaptTo(Session.class);
            HashSet<AssetInfo> dependentAssets = new HashSet<AssetInfo>();
            SearchResult result = this.searchParentDependentFMAssets(session, path);
            if (result != null) {
                Iterator<Node> iter = result.getNodes();
                while (iter.hasNext()) {
                    String nodePath = iter.next().getPath();
                    if (nodePath.startsWith("/content/forms/af")) {
                        nodePath = FMUtils.getAssetPathFromPage(nodePath.substring(0, nodePath.indexOf("jcr:content") - 1));
                    }
                    dependentAssets.add(new AssetInfo(resourceResolver.getResource(nodePath), FMUtils.getAssetType(session, nodePath)));
                }
            }
            this.log.debug("Exit : getDependentParentFMAssets for asset : " + path);
            return dependentAssets;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    @Override
    public boolean hasDependentParentFMAssets(ResourceResolver resourceResolver, String path) throws FormsMgrException {
        try {
            if (path == null || path.isEmpty() || resourceResolver == null) {
                throw new FormsMgrException("AEM-FMG-700-001", new Object[0]);
            }
            Session session = resourceResolver.adaptTo(Session.class);
            if (FMUtils.isFolder(session, path)) {
                NodeIterator iter = session.getNode(path).getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("dam:Asset") || !this.hasDependentParentFMAssets(resourceResolver, node.getPath())) continue;
                    return true;
                }
            } else {
                SearchResult result = this.searchParentDependentFMAssets(session, path);
                if (result != null && result.getTotalMatches() > 0L) {
                    return true;
                }
            }
            return false;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    @Override
    public void setDirtyFlag(Session session, String path) throws FormsMgrException {
        try {
            HashSet<AssetInfo> dependentGuidesAndFragments = new HashSet<AssetInfo>();
            this.findDependentGuidesAndFragments(session, path, dependentGuidesAndFragments);
            for (AssetInfo assetInfo : dependentGuidesAndFragments) {
                String assetPath = assetInfo.getResource().getPath();
                this.log.info("Setting formModelChanged property in guide/fragment:" + assetPath);
                if (!FMUtils.isXFABasedForm(session, assetPath)) continue;
                Node assetNode = session.getNode(assetPath);
                Node metadataNode = FMUtils.getMetadataNode(assetNode, false);
                metadataNode.setProperty("formModelChanged", true);
            }
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    @Override
    public void getAssociatedTags(ResourceResolver resourceResolver, Set<AssetInfo> allRelatedChildAssets) {
        HashSet<AssetInfo> tagInfoSet = new HashSet<AssetInfo>();
        for (AssetInfo assetInfo : allRelatedChildAssets) {
            String assetPath = assetInfo.getResource().getPath();
            try {
                TagManager tm = resourceResolver.adaptTo(TagManager.class);
                Resource metaDataResource = resourceResolver.getResource(assetPath + "/" + "jcr:content" + "/" + "metadata");
                if (metaDataResource == null) continue;
                for (Tag tag : tm.getTags(metaDataResource)) {
                    AssetInfo tagInfo = new AssetInfo(tag.adaptTo(Resource.class), FMConstants.CoreAssetType.NONFMASSET);
                    tagInfo.setNonFMAssetType("Tag");
                    tagInfoSet.add(tagInfo);
                }
            }
            catch (FormsMgrException e) {
                this.log.error("Error while finding Tags for asset " + assetPath, (Throwable)e);
            }
        }
        allRelatedChildAssets.addAll(tagInfoSet);
    }

    @Override
    public Set<AssetInfo> getDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsMgrException {
        this.log.debug("Enter :  getDDEReferences for data dictionary : " + dataDictionaryID);
        HashSet<AssetInfo> dependentAssets = new HashSet<AssetInfo>();
        try {
            if (dataDictionaryID == null || dataDictionaryID.isEmpty() || ddeReferenceNames == null || ddeReferenceNames.size() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new Object[0]);
            }
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            if (resolver == null) {
                throw new FormsMgrException("AEM-FMG-900-003", new Object[0]);
            }
            Session session = resolver.adaptTo(Session.class);
            SearchResult result = this.searchDDEReferences(session, ddeReferenceNames);
            Iterator<Node> iter = result.getNodes();
            while (iter.hasNext()) {
                String assetPath = this.getAssetPathUsingDD(resolver, dataDictionaryID, iter.next().getPath());
                if (assetPath == null) continue;
                dependentAssets.add(new AssetInfo(resolver.getResource(assetPath), FMUtils.getAssetType(session, assetPath)));
            }
            this.log.debug("Exit : getDDEReferences for data dictionary : " + dataDictionaryID);
            return dependentAssets;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    @Override
    public boolean hasDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsMgrException {
        this.log.debug("Enter :  hasDDEReferences for data dictionary : " + dataDictionaryID);
        try {
            if (dataDictionaryID == null || dataDictionaryID.isEmpty() || ddeReferenceNames == null || ddeReferenceNames.size() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new Object[0]);
            }
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            if (resolver == null) {
                throw new FormsMgrException("AEM-FMG-900-003", new Object[0]);
            }
            Session session = resolver.adaptTo(Session.class);
            SearchResult result = this.searchDDEReferences(session, ddeReferenceNames);
            Iterator<Node> iter = result.getNodes();
            while (iter.hasNext()) {
                String assetPath = this.getAssetPathUsingDD(resolver, dataDictionaryID, iter.next().getPath());
                if (assetPath == null) continue;
                return true;
            }
            this.log.debug("Exit :  hasDDEReferences for data dictionary : " + dataDictionaryID);
            return false;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private Predicate getPathPredicate(String path) {
        Predicate pathPredicate = new Predicate("path");
        pathPredicate.set("path", path);
        pathPredicate.set("exact", "false");
        return pathPredicate;
    }

    private Predicate getTypePredicate(String type) {
        Predicate typePredicate = new Predicate("type");
        typePredicate.set("type", type);
        return typePredicate;
    }

    private PredicateGroup getPredicateGroup(boolean allRequired) {
        PredicateGroup predicateGroup = new PredicateGroup();
        predicateGroup.setAllRequired(allRequired);
        return predicateGroup;
    }

    private SearchResult searchParentDependentFMAssets(Session session, String path) throws FormsMgrException {
        FormsAssetType assetType;
        this.log.debug("Enter :  searchParentDependentFMAssets for asset : " + path);
        SearchResult result = null;
        Predicate typePredicate = this.getTypePredicate("nt:unstructured");
        Predicate pathPredicate = this.getPathPredicate("/content/forms/af");
        PredicateGroup predicateGroup = this.getPredicateGroup(true);
        PredicateGroup refPredicateGroup = this.getPredicateGroup(false);
        try {
            assetType = this.formsFoundationUtils.getAssetType(path);
        }
        catch (FormsFoundationException e) {
            throw new FormsMgrException(e.getMessage(), e);
        }
        Predicate refPredicate = null;
        switch (assetType) {
            case XDP: {
                pathPredicate.set("path", "/content/dam/formsanddocuments");
                typePredicate.set("type", "dam:Asset");
                refPredicate = this.getPredicate("jcr:content/metadata/xdpRef", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/metadata/dorTemplateRef", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/metadata/metaTemplateRef", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/related/forms/sling:members/sling:resources", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/metadata/references", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case ADAPTIVE_FORM_FRAGMENT: 
            case ADAPTIVE_FORM: {
                refPredicateGroup.setAllRequired(true);
                refPredicate = this.getPredicate("sling:resourceType", "fd/af/components/panel");
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("fragRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case FM_RESOURCE: {
                pathPredicate.set("path", "/content/dam/formsanddocuments");
                typePredicate.set("type", "dam:Asset");
                refPredicate = this.getPredicate("jcr:content/metadata/images", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/metadata/xfaStyleSheets", path);
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPredicate("jcr:content/metadata/xsdRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case THEME: {
                refPredicate = this.getPredicate("themeRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case LETTER: {
                refPredicate = this.getPredicate("letterRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case TEXT: 
            case LIST: 
            case CONDITION: {
                refPredicate = this.getPredicate("assetRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case DATA_DICTIONARY: {
                refPredicate = this.getPredicate("ddRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            default: {
                this.log.info("Asset of type " + assetType + " is not supported.");
                return null;
            }
        }
        predicateGroup.add(typePredicate);
        predicateGroup.add(pathPredicate);
        predicateGroup.add(refPredicateGroup);
        Query query = this.queryBuilder.createQuery(predicateGroup, session);
        result = query.getResult();
        this.log.debug("Query execution time (ms) " + result.getExecutionTimeMillis());
        this.log.debug("Exit :  searchParentDependentFMAssets for asset : " + path);
        return result;
    }

    private SearchResult searchDDEReferences(Session session, List<String> ddeReferenceNames) {
        this.log.debug("Enter :  searchDDEReferences");
        Predicate typePredicate = this.getTypePredicate("nt:unstructured");
        Predicate pathPredicate = this.getPathPredicate("/content/forms/af");
        PredicateGroup predicateGroup = this.getPredicateGroup(true);
        PredicateGroup refPredicateGroup = this.getPredicateGroup(false);
        Predicate refPredicate = null;
        for (String ddeName : ddeReferenceNames) {
            refPredicate = this.getPredicate("bindRef", ddeName);
            refPredicateGroup.add(refPredicate);
        }
        predicateGroup.add(typePredicate);
        predicateGroup.add(pathPredicate);
        predicateGroup.add(refPredicateGroup);
        Query query = this.queryBuilder.createQuery(predicateGroup, session);
        SearchResult result = query.getResult();
        this.log.debug("Query execution time (ms) to find data dictionary references " + result.getExecutionTimeMillis());
        this.log.debug("Exit : searchDDEReferences");
        return result;
    }

    private String getAssetPathUsingDD(ResourceResolver resourceResolver, String dataDictionaryID, String guideContainerPath) throws FormsMgrException, RepositoryException {
        int index = guideContainerPath.indexOf("jcr:content/guideContainer");
        if (index == -1) {
            this.log.error("guideContainer path to asset not found : " + guideContainerPath);
            return null;
        }
        String assetPath = FMUtils.getAssetPathFromPage(guideContainerPath.substring(0, index));
        String metadataPath = assetPath + "jcr:content/metadata";
        Session session = resourceResolver.adaptTo(Session.class);
        if (session.nodeExists(metadataPath)) {
            String ddID;
            Node node = session.getNode(metadataPath);
            if (node.hasProperty("ddRef") && dataDictionaryID.equals(ddID = node.getProperty("ddRef").getString())) {
                return assetPath;
            }
        } else {
            this.log.error("node not found at path : " + guideContainerPath);
        }
        return null;
    }

    private void findDependentGuidesAndFragments(Session session, String path, Set<AssetInfo> dependentGuidesAndFragments) throws FormsMgrException {
        ResourceResolver resolver = FMUtils.getResourceResolver(this.resolverFactory, session);
        if (FMUtils.isXDPForm(session, path)) {
            Set<AssetInfo> dependentAssets = this.getDependentParentFMAssets(resolver, path);
            for (AssetInfo assetInfo : dependentAssets) {
                FMConstants.CoreAssetType assetType = assetInfo.getType();
                if (FMConstants.CoreAssetType.AFFRAGMENT.equals((Object)assetType) || FMConstants.CoreAssetType.GUIDE.equals((Object)assetType)) {
                    dependentGuidesAndFragments.add(assetInfo);
                    continue;
                }
                if (!FMConstants.CoreAssetType.FORM.equals((Object)assetType)) continue;
                String assetPath = assetInfo.getResource().getPath();
                this.findDependentGuidesAndFragments(session, assetPath, dependentGuidesAndFragments);
            }
        }
    }

    private Predicate getPredicate(String propertyPath, String propertyVal) {
        Predicate refPredicate = new Predicate("property");
        refPredicate.set("property", propertyPath);
        refPredicate.set("operation", "equals");
        refPredicate.set("value", propertyVal);
        return refPredicate;
    }

    private void getAllRelatedChildAssetsForFormset(ResourceResolver resourceResolver, String formsetPath, boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws Exception {
        Session session = resourceResolver.adaptTo(Session.class);
        Node formsetNode = session.getNode(formsetPath);
        if (formsetNode.hasProperty("jcr:content/related/forms/sling:members/sling:resources")) {
            Value[] forms;
            for (Value value : forms = formsetNode.getProperty("jcr:content/related/forms/sling:members/sling:resources").getValues()) {
                String formPath = value.getString();
                if (!session.nodeExists(formPath)) continue;
                this.addFormAndDependents(allRelatedChildAssets, resourceResolver, formPath, allLevel);
            }
        }
    }

    private void getAllRelatedChildAssetsForGuideOrFragment(ResourceResolver resourceResolver, String guidePath, boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws Exception {
        String formPath;
        String guidePagePath;
        Session session = resourceResolver.adaptTo(Session.class);
        if (!session.nodeExists(guidePagePath = FMUtils.getPagePathFromAsset(guidePath))) {
            throw new FormsMgrException("Page corresponding to guide node does not exists.");
        }
        this.addFormAndDependents(allRelatedChildAssets, resourceResolver, guidePath, false);
        if (FMUtils.isXFABasedForm(session, guidePath)) {
            formPath = FMUtils.getXDPRefPath(session, guidePagePath);
            if (session.nodeExists(formPath)) {
                this.addFormAndDependents(allRelatedChildAssets, resourceResolver, formPath, allLevel);
            } else {
                this.log.error("Error finding dependency of adaptive form/fragment : {}. Invalid XDP path : {}", (Object)guidePath, (Object)formPath);
            }
        } else {
            if (FMUtils.hasXSDRef(session, guidePath)) {
                String xsdRefPath = FMUtils.getXSDRefPath(session, guidePagePath);
                if (session.nodeExists(xsdRefPath)) {
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, xsdRefPath, false);
                    this.log.info("Finding dependency for Guide/AF Fragment : " + guidePath + ". corresponding XSD Resource:" + xsdRefPath);
                } else {
                    this.log.error("Error finding dependency of adaptive form : {}. Invalid XSD path : {}", (Object)guidePath, (Object)xsdRefPath);
                }
            }
            if (FMUtils.hasDORTemplate(session, guidePath)) {
                formPath = FMUtils.getDORRefPath(session, guidePagePath);
                if (session.nodeExists(formPath)) {
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, formPath, allLevel);
                    this.log.info("Finding dependency for Guide/Fragment : " + guidePath + ". corresponding XFAForm(DOR) : " + formPath);
                } else {
                    this.log.error("Error finding dependency of adaptive form/fragment : {}. Invalid document of record path : {}", (Object)guidePath, (Object)formPath);
                }
            } else if (FMUtils.hasMetaTemplate(session, guidePath)) {
                String metaTemplatePath = FMUtils.getMetaTemplateRefPath(session, guidePagePath);
                if (session.nodeExists(metaTemplatePath)) {
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, metaTemplatePath, allLevel);
                    this.log.info("Finding dependency for Guide : " + guidePath + ". corresponding XFAForm Metatemplate : " + metaTemplatePath);
                } else {
                    this.log.error("Error finding dependency of Guide : {}. Invalid Metatemplate path : {}", (Object)guidePath, (Object)metaTemplatePath);
                }
            }
        }
        String themeRefPath = FMUtils.getThemeRef(session, guidePath);
        if (themeRefPath != null) {
            if (session.nodeExists(themeRefPath)) {
                this.addFormAndDependents(allRelatedChildAssets, resourceResolver, themeRefPath, true);
                this.log.info("Finding dependency for Guide : " + guidePath + ". corresponding Theme Asset : " + themeRefPath);
            } else {
                this.log.error("Error finding dependency of Guide : {}. Invalid Theme path : {}", (Object)guidePath, (Object)themeRefPath);
            }
        }
    }

    private void getAllRelatedChildAssetsForXDP(ResourceResolver resourceResolver, String xdpPath, Boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws Exception {
        Session session = resourceResolver.adaptTo(Session.class);
        if (session.nodeExists(xdpPath) && FMUtils.isXDPForm(session, xdpPath)) {
            String formPath;
            Value[] forms;
            Node xdpNode = session.getNode(xdpPath);
            if (xdpNode.hasProperty("jcr:content/metadata/references")) {
                for (Value value : forms = xdpNode.getProperty("jcr:content/metadata/references").getValues()) {
                    formPath = value.getString();
                    if (!session.nodeExists(formPath)) continue;
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, formPath, allLevel);
                }
            }
            if (xdpNode.hasProperty("jcr:content/metadata/images")) {
                for (Value value : forms = xdpNode.getProperty("jcr:content/metadata/images").getValues()) {
                    formPath = value.getString();
                    if (!session.nodeExists(formPath)) continue;
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, formPath, false);
                }
            }
            if (xdpNode.hasProperty("jcr:content/metadata/xfaStyleSheets")) {
                Value[] xfsStyleSheets;
                for (Value xfsStyleSheet : xfsStyleSheets = xdpNode.getProperty("jcr:content/metadata/xfaStyleSheets").getValues()) {
                    String xfsStyleSheetPath = xfsStyleSheet.getString();
                    if (!session.nodeExists(xfsStyleSheetPath)) continue;
                    this.addFormAndDependents(allRelatedChildAssets, resourceResolver, xfsStyleSheetPath, false);
                }
            }
        }
    }

    private void addFormAndDependents(Set<AssetInfo> allRelatedChildAssets, ResourceResolver resourceResolver, String formPath, boolean addDependents) throws FormsMgrException {
        Session session = resourceResolver.adaptTo(Session.class);
        Resource resource = resourceResolver.getResource(formPath);
        AssetInfo formInfo = new AssetInfo(resource, FMUtils.getAssetType(session, formPath));
        this.log.debug("Adding form to allRelatedChildAssets : " + formPath);
        if (allRelatedChildAssets.add(formInfo) && addDependents) {
            this.getRelatedChildFMAssets(resourceResolver, formPath, true, allRelatedChildAssets);
        }
    }

    protected void bindReferenceProviders(ReferenceProvider referenceProvider) {
        this.referenceProviders.add(referenceProvider);
    }

    protected void unbindReferenceProviders(ReferenceProvider referenceProvider) {
        this.referenceProviders.remove(referenceProvider);
    }

    private void getAllRelatedChildAssetsForTheme(ResourceResolver resourceResolver, String themePath, Boolean allLevel, Set<AssetInfo> allRelatedChildAssets) throws Exception {
        Session session = resourceResolver.adaptTo(Session.class);
        if (session.nodeExists(themePath) && FMUtils.isTheme(session, themePath)) {
            Node themeNode = session.getNode(themePath);
            String clientLibLocation = FMUtils.getClientlibPath(themeNode);
            if (session.nodeExists(clientLibLocation)) {
                this.addFormAndDependents(allRelatedChildAssets, resourceResolver, clientLibLocation, allLevel);
            }
            if (themeNode.hasProperty("jcr:content/metadata/images")) {
                Value[] images;
                for (Value image : images = themeNode.getProperty("jcr:content/metadata/images").getValues()) {
                    Resource assetResource = resourceResolver.getResource(image.getString());
                    if (assetResource == null) continue;
                    allRelatedChildAssets.add(new AssetInfo(assetResource, FMConstants.CoreAssetType.NONFMASSET));
                }
            }
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        this.formsFoundationUtils = formsFoundationUtils;
    }

    protected void unbindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        if (this.formsFoundationUtils == formsFoundationUtils) {
            this.formsFoundationUtils = null;
        }
    }
}

