/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.service.impl;

import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.forms.foundation.provider.DependencyProvider;
import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.forms.foundation.service.FormsFoundationException;
import com.adobe.forms.foundation.service.util.FormsFoundationUtils;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
public class SitesDependencyProviderImpl
implements DependencyProvider {
    private static final Logger logger = LoggerFactory.getLogger(SitesDependencyProviderImpl.class);
    @Reference
    private FormsFoundationUtils formsFoundationUtils;
    @Reference
    private FormsRelationService formsRelationService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(referenceInterface=QueryBuilder.class)
    private QueryBuilder queryBuilder;

    public Map<FormsAssetType, Set<String>> getImmediateParentDependencies(String assetId) throws FormsFoundationException {
        HashMap<FormsAssetType, Set<String>> parentDeps = new HashMap<FormsAssetType, Set<String>>();
        try {
            if (assetId == null || assetId.isEmpty()) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            ResourceResolver resolver = FMUtils.getResourceResolver(this.resourceResolverFactory, this.formsFoundationUtils.getCurrentSession());
            SearchResult result = this.searchDependentParentAssets(assetId);
            if (result != null) {
                HashSet<String> referringPages = new HashSet<String>();
                Iterator<Node> iter = result.getNodes();
                while (iter.hasNext()) {
                    String nodePath = iter.next().getPath();
                    Resource cqPageResouce = FMUtils.getClosestNodeUpInHierarchy(resolver, nodePath, "jcr:primaryType", "cq:Page", true);
                    if (cqPageResouce == null) continue;
                    referringPages.add(cqPageResouce.getPath());
                }
                parentDeps.put(FormsAssetType.CQ_PAGE, referringPages);
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
        return parentDeps;
    }

    public boolean hasParentDependencies(String assetId) throws FormsFoundationException {
        try {
            if (assetId == null || assetId.isEmpty()) {
                Object[] obj = null;
                throw new FormsFoundationException("AEM-FF-002", obj);
            }
            SearchResult result = this.searchDependentParentAssets(assetId);
            if (result != null && result.getTotalMatches() > 0L) {
                return true;
            }
        }
        catch (FormsFoundationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsFoundationException((Throwable)e);
        }
        return false;
    }

    public Map<FormsAssetType, Set<String>> getDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsFoundationException {
        return new HashMap<FormsAssetType, Set<String>>();
    }

    public boolean hasDDEReferences(String dataDictionaryID, List<String> ddeReferenceNames) throws FormsFoundationException {
        return false;
    }

    private SearchResult searchDependentParentAssets(String path) throws FormsFoundationException {
        logger.debug("Enter :  searchDependentParentAssets for asset : " + path);
        if (path.startsWith("/content/forms/af")) {
            path = FMUtils.getAssetPathFromPage(path);
        }
        PredicateGroup predicateGroup = new PredicateGroup();
        predicateGroup.setAllRequired(true);
        Predicate typePredicate = new Predicate("type");
        typePredicate.set("type", "nt:unstructured");
        Predicate pathPredicate = new Predicate("path");
        pathPredicate.set("path", "/content");
        pathPredicate.set("exact", "false");
        PredicateGroup refPredicateGroup = new PredicateGroup();
        FormsAssetType assetType = this.formsFoundationUtils.getAssetType(path);
        switch (assetType) {
            case ADAPTIVE_DOCUMENT: 
            case ADAPTIVE_FORM: {
                refPredicateGroup.setAllRequired(true);
                Predicate refPredicate = this.getPropertyPredicate("sling:resourceType", "fd/af/components/aemform");
                refPredicateGroup.add(refPredicate);
                refPredicate = this.getPropertyPredicate("formRef", path);
                refPredicateGroup.add(refPredicate);
                break;
            }
            case THEME: {
                return null;
            }
            default: {
                return null;
            }
        }
        predicateGroup.add(typePredicate);
        predicateGroup.add(pathPredicate);
        predicateGroup.add(refPredicateGroup);
        Query query = this.queryBuilder.createQuery(predicateGroup, this.formsFoundationUtils.getCurrentSession());
        SearchResult result = query.getResult();
        logger.debug("Query execution time (ms) " + result.getExecutionTimeMillis());
        logger.debug("Exit :  searchParentDependentAssets for asset : " + path);
        return result;
    }

    private Predicate getPropertyPredicate(String propertyPath, String propertyVal) {
        Predicate refPredicate = new Predicate("property");
        refPredicate.set("property", propertyPath);
        refPredicate.set("operation", "equals");
        refPredicate.set("value", propertyVal);
        return refPredicate;
    }

    protected void bindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        this.formsFoundationUtils = formsFoundationUtils;
    }

    protected void unbindFormsFoundationUtils(FormsFoundationUtils formsFoundationUtils) {
        if (this.formsFoundationUtils == formsFoundationUtils) {
            this.formsFoundationUtils = null;
        }
    }

    protected void bindFormsRelationService(FormsRelationService formsRelationService) {
        this.formsRelationService = formsRelationService;
    }

    protected void unbindFormsRelationService(FormsRelationService formsRelationService) {
        if (this.formsRelationService == formsRelationService) {
            this.formsRelationService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

