/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.service.impl;

import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.forms.common.service.StaleAssetIndicatorService;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.policies.ContentPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={StaleAssetIndicatorService.class})
public class StaleAssetIndicatorServiceImpl
implements StaleAssetIndicatorService {
    @Reference(referenceInterface=FormsRelationService.class)
    private FormsRelationService formsRelationService;
    private final Logger logger = LoggerFactory.getLogger(StaleAssetIndicatorServiceImpl.class);
    private Map<String, AssetTreeLMTEntry> assetTreeLMTTable = new ConcurrentHashMap<String, AssetTreeLMTEntry>();

    @Override
    public long getAssetTreeLMT(Resource resource) {
        AssetTreeLMTEntry assetTreeLMTEntry;
        block9: {
            ResourceResolver resourceResolver = resource.getResourceResolver();
            Session session = resourceResolver.adaptTo(Session.class);
            String assetPath = resource.getPath();
            if (null == session) {
                this.logger.error("[StaleAssetIndicator] : Failed to get valid Session for " + assetPath);
                return Long.MAX_VALUE;
            }
            if (null == assetPath || "".equals(assetPath)) {
                this.logger.error("[StaleAssetIndicator] : Empty asset path");
                return Long.MAX_VALUE;
            }
            assetTreeLMTEntry = this.assetTreeLMTTable.get(assetPath);
            if (null == assetTreeLMTEntry) {
                this.logger.debug("[StaleAssetIndicator] : Cache Miss " + assetPath);
                assetTreeLMTEntry = this.reCacheAssetTreeLMTTableEntry(resourceResolver, session, assetPath);
            } else {
                try {
                    long assetCurrentLMT = FMUtils.getLastModifiedOrCreated(session, assetPath);
                    if (assetCurrentLMT < 1L || assetTreeLMTEntry.assetLMT == Long.MAX_VALUE || assetCurrentLMT > assetTreeLMTEntry.assetLMT) {
                        this.logger.debug("[StaleAssetIndicator] : Cache Stale " + assetPath);
                        assetTreeLMTEntry = this.reCacheAssetTreeLMTTableEntry(resourceResolver, session, assetPath);
                        break block9;
                    }
                    for (DependantEntry dependant : assetTreeLMTEntry.dependants) {
                        long dependantCurrentLMT = FMUtils.getLastModifiedOrCreated(session, dependant.path);
                        if (dependantCurrentLMT >= 1L && dependant.lmt >= 1L && dependantCurrentLMT <= dependant.lmt) continue;
                        this.logger.debug("[StaleAssetIndicator] : Cache Stale " + assetPath);
                        assetTreeLMTEntry = this.reCacheAssetTreeLMTTableEntry(resourceResolver, session, assetPath);
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.error("[StaleAssetIndicator] : Failed to get all related Child Assets for " + assetPath, (Throwable)e);
                }
            }
        }
        if (null != assetTreeLMTEntry) {
            return Math.max(assetTreeLMTEntry.assetLMT, assetTreeLMTEntry.assetTreeLMT);
        }
        return Long.MAX_VALUE;
    }

    private AssetTreeLMTEntry reCacheAssetTreeLMTTableEntry(ResourceResolver resourceResolver, Session session, String assetPath) {
        AssetTreeLMTEntry assetTreeLMTEntry = null;
        HashSet<AssetInfo> relatedChildAssets = new HashSet<AssetInfo>();
        long assetTreeLMT = -1L;
        ArrayList<DependantEntry> dependants = null;
        try {
            this.assetTreeLMTTable.remove(assetPath);
            long assetLMT = FMUtils.getLastModifiedOrCreated(session, assetPath);
            this.formsRelationService.getAllRelatedChildAssets(resourceResolver, assetPath, relatedChildAssets);
            if (null != relatedChildAssets) {
                dependants = new ArrayList<DependantEntry>();
                for (AssetInfo asset : relatedChildAssets) {
                    if (!this.isSupportedDependant(asset)) continue;
                    long assetCurrentLMT = asset.getLastModifiedOrCreatedTime(session);
                    dependants.add(new DependantEntry(asset.getResource().getPath(), assetCurrentLMT));
                    assetTreeLMT = assetTreeLMT > assetCurrentLMT ? assetTreeLMT : assetCurrentLMT;
                }
                assetLMT = assetLMT > 0L ? assetLMT : Long.MAX_VALUE;
                assetTreeLMT = assetTreeLMT > 0L ? assetTreeLMT : Long.MAX_VALUE;
                assetTreeLMTEntry = new AssetTreeLMTEntry(assetLMT, assetTreeLMT, dependants);
                this.assetTreeLMTTable.put(assetPath, assetTreeLMTEntry);
                this.logger.debug("[StaleAssetIndicator] : Cache put : " + assetPath + " : " + assetTreeLMTEntry.assetLMT + " : " + assetTreeLMTEntry.assetTreeLMT);
            }
        }
        catch (Exception e) {
            this.logger.error("[StaleAssetIndicator] : Failed to get all related Child Assets for " + assetPath, (Throwable)e);
        }
        return assetTreeLMTEntry;
    }

    private boolean isSupportedDependant(AssetInfo assetInfo) {
        try {
            Resource assetResource = assetInfo.getResource();
            Template afTemplate = assetResource.adaptTo(Template.class);
            if (afTemplate != null) {
                return false;
            }
            ContentPolicy contentPolicy = assetResource.adaptTo(ContentPolicy.class);
            if (contentPolicy != null) {
                return false;
            }
            Node assetNode = assetResource.adaptTo(Node.class);
            if (assetNode.isNodeType("cq:ClientLibraryFolder")) {
                return false;
            }
        }
        catch (RepositoryException e) {
            this.logger.warn("[StaleAssetIndicator] : Failed to deduce if {0} is a supported asset.", (Object)assetInfo.getResource().getPath());
        }
        return true;
    }

    protected void bindFormsRelationService(FormsRelationService formsRelationService) {
        this.formsRelationService = formsRelationService;
    }

    protected void unbindFormsRelationService(FormsRelationService formsRelationService) {
        if (this.formsRelationService == formsRelationService) {
            this.formsRelationService = null;
        }
    }

    private class AssetTreeLMTEntry {
        public final long assetLMT;
        public final long assetTreeLMT;
        public final List<DependantEntry> dependants;

        public AssetTreeLMTEntry(long assetLMT, long assetTreeLMT, List<DependantEntry> dependants) {
            this.assetLMT = assetLMT;
            this.assetTreeLMT = assetTreeLMT;
            this.dependants = new ArrayList<DependantEntry>(dependants);
        }
    }

    private class DependantEntry {
        public final String path;
        public final long lmt;

        public DependantEntry(String path, long lmt) {
            this.path = path;
            this.lmt = lmt;
        }
    }
}

