/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.servlet;

import com.adobe.aem.formsndocuments.publish.PublishService;
import com.adobe.aem.formsndocuments.service.FMCRUDService;
import com.adobe.aem.formsndocuments.service.FormsRelationService;
import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMUtils;
import com.adobe.aem.formsndocuments.util.SettingsHolder;
import com.adobe.aem.formsndocuments.util.ThumbnailUtil;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.forms.foundation.service.FormsDependencyManager;
import com.adobe.forms.foundation.service.FormsFoundationException;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.servlet.Servlet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="BaseFormsManagementServlet", description="BaseFormsManagementServlet")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.resourceTypes", value={"fd/fm/baseManageServlet"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class BaseFMServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1L;
    @Reference(referenceInterface=PublishService.class)
    private PublishService publishService;
    @Reference(referenceInterface=FMCRUDService.class)
    private FMCRUDService fmCRUDService;
    @Reference(referenceInterface=FormsRelationService.class)
    private FormsRelationService formsRelationService;
    @Reference
    private FormsDependencyManager formsDependencyManager;
    private static final String IMAGE = "image";
    private static final String IMAGE_BASE64_ENCODED = "base64image";
    private final String FUNC_LITERAL = "func";
    private final String NODEPATH_LITERAL = "nodePath";
    private final String ASSETPATH_LITERAL = "assetPath";
    private final String ERROR_CODE_LITERAL = "code";
    private final String ERROR_TYPE_LITERAL = "type";
    private final String ERROR_TITLE_LITERAL = "title";
    private final String ERROR_UNRESOLVED_MESSAGE_LITERAL = "unresolvedMessage";
    private final String ERROR_DESCRIPTION_LITERAL = "description";
    private final String ERROR_MESSAGE_ARGS_LITERAL = "messageArgs";
    private final String ERROR_ROOTCAUSE_LITERAL = "rootCause";
    private final String ERROR_EXTENDEDDATA_LITERAL = "extendedData";
    private final String PUBLISH_LITERAL = "activate";
    private final String DEACTIVATE_LITERAL = "deactivate";
    private final String GET_RELATED_ASSET_TO_PUBLISH = "getRelatedAssetsToPublish";
    private final String DELETEASSET_LITERAL = "deleteAsset";
    private final String EXCEPTION_ERRORTYPE = "error";
    private final String EXCEPTION_ERRORCODE = "ALC-FMG-001-001";
    private final String UPLOAD_SAMPLE_DATA = "uploadSampleData";
    private final String IS_IE = "isIE";
    private final String SAMPLEDATA_LITERAL = "sampleData";
    private final String CREATE_FORMSET = "createFormset";
    private final String CREATE_FRAGMENT_FROM_PANEL = "createFragmentFromPanel";
    private final String UPDATE_FORMSET = "updateFormset";
    private final String GET_FORMS_IN_A_FORMSET = "getFormsInAFormset";
    private final String GET_DEPENDENT_PARENT_FM_ASSETS = "getDependentParentFMAssets";
    private final String HAS_DEPENDENT_PARENT_ASSETS = "hasDependentParentAssets";
    private final String GET_ALL_RELATED_CHILD_ASSETS = "getAllRelatedChildAssets";
    private final String GENERATE_FORMSET_THUMBNAIL = "generateFormsetThumbnail";
    private final String GENERATE_THUMBNAIL = "generateThumbnail";
    private final String GET_FIRST_LEVEL_RELATED_CHILD_ASSETS = "getFirstLevelRelatedChildAssets";
    private final String CREATE_THEME = "createTheme";
    private final String CHECK_NODE_EXIST = "checkNodeExist";
    private final String MOVE_NODE = "moveNode";
    private final String PASTE_THEME = "pasteTheme";
    private final String CLEAN_UP_FORMS = "cleanUpForms";
    private final Logger log = LoggerFactory.getLogger(BaseFMServlet.class);

    protected void activate(ComponentContext componentContext) throws RepositoryException {
        this.log.info("Activated: FormsManagementServlet started");
    }

    protected void deactivate(ComponentContext context) {
        this.log.info("Deactivated: FormsManagementServlet stopped");
    }

    @Override
    public void doPost(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        this.requestHandler(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestHandler(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        try {
            resp.setContentType("application/json;charset=utf-8");
            String func = req.getParameter("func");
            if (func != null) {
                if (func.equals("activate")) {
                    this.publishAssets(req, resp);
                } else if (func.equals("deactivate")) {
                    this.deactivateAssets(req, resp);
                } else if (func.equals("getRelatedAssetsToPublish")) {
                    this.getRelatedAssetsToPublish(req, resp);
                } else if (func.equals("getAllRelatedChildAssets")) {
                    this.getAllRelatedChildAssets(req, resp);
                } else if (func.equals("uploadSampleData")) {
                    this.uploadSampleData(req, resp);
                } else if (func.equals("deleteAsset")) {
                    this.deleteAsset(req, resp);
                } else if (func.equals("createFormset")) {
                    this.createFormset(req, resp);
                } else if (func.equals("createFragmentFromPanel")) {
                    this.createFragmentFromPanel(req, resp);
                } else if (func.equals("getFormsInAFormset")) {
                    this.getFormsInAFormset(req, resp);
                } else if (func.equals("getDependentParentFMAssets")) {
                    this.getDependentParentFMAssets(req, resp);
                } else if (func.equals("hasDependentParentAssets")) {
                    this.hasDependentParentAssets(req, resp);
                } else if (func.equals("updateFormset")) {
                    this.updateFormset(req, resp);
                } else if (func.equals("generateFormsetThumbnail")) {
                    this.generateFormsetThumbnail(req, resp);
                } else if (func.equals("generateThumbnail")) {
                    this.generateThumbnail(req, resp);
                } else if (func.equals("getFirstLevelRelatedChildAssets")) {
                    this.getFirstLevelRelatedChildAssets(req, resp);
                } else if (func.equals("createTheme")) {
                    this.createTheme(req, resp);
                } else if (func.equals("checkNodeExist")) {
                    this.checkNodeExist(req, resp);
                } else if (func.equals("moveNode")) {
                    this.moveNode(req, resp);
                } else if (func.equals("pasteTheme")) {
                    this.pasteTheme(req, resp);
                } else if (func.equals("cleanUpForms")) {
                    this.cleanUpForms(req, resp);
                }
            }
        }
        catch (Exception e) {
            PrintWriter writer = null;
            try {
                writer = resp.getWriter();
                this.log.error("Error in Servlet Request: " + e.getMessage(), (Throwable)e);
                JSONObject errorJson = new JSONObject();
                String code = "ALC-FMG-001-001";
                String cause = null;
                String message = e.getMessage();
                String unresolvedMessage = null;
                ArrayList<String> messageArgs = null;
                if (e.getCause() != null) {
                    cause = e.getCause().toString();
                }
                if (cause == null) {
                    cause = e.toString();
                }
                if (message == null) {
                    message = cause;
                }
                if (e instanceof FormsMgrException) {
                    FormsMgrException fme = (FormsMgrException)e;
                    if (fme.getCode() != null && !fme.getCode().isEmpty()) {
                        code = fme.getCode();
                        message = fme.getMessage();
                        unresolvedMessage = fme.getUnresolvedMessage();
                    }
                    if (fme.getMessageArgs() != null && fme.getMessageArgs().length > 0) {
                        messageArgs = new ArrayList<String>();
                        for (Object arg : fme.getMessageArgs()) {
                            if (arg == null || arg instanceof String) {
                                messageArgs.add((String)arg);
                                continue;
                            }
                            messageArgs.add(arg.toString());
                        }
                    }
                }
                errorJson.put("code", code);
                errorJson.put("type", "error");
                errorJson.put("title", message);
                errorJson.put("description", message);
                errorJson.put("unresolvedMessage", unresolvedMessage);
                errorJson.put("messageArgs", messageArgs);
                errorJson.put("rootCause", e.toString());
                errorJson.append("extendedData", null);
                writer.write(errorJson.toString());
            }
            catch (Exception ex) {
                this.log.error("Error in Servlet Request catch block: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private void publishAssets(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException, IOException, JSONException {
        Session session = req.getResourceResolver().adaptTo(Session.class);
        String nodePath = req.getParameter("nodePath");
        if (nodePath == null || nodePath.length() == 0) {
            throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", nodePath});
        }
        String[] nodePaths = nodePath.split("\\|");
        ArrayList<String> nodePathList = new ArrayList<String>(Arrays.asList(nodePaths));
        this.publishService.publish(session, nodePathList);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void deactivateAssets(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException, IOException, JSONException {
        Session session = req.getResourceResolver().adaptTo(Session.class);
        String nodePath = req.getParameter("nodePath");
        if (nodePath == null || nodePath.length() == 0) {
            throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", nodePath});
        }
        String[] nodePaths = nodePath.split("\\|");
        ArrayList<String> nodePathList = new ArrayList<String>(Arrays.asList(nodePaths));
        this.publishService.deactivate(session, nodePathList);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void getRelatedAssetsToPublish(SlingHttpServletRequest request, SlingHttpServletResponse response) throws FormsMgrException {
        PrintWriter writer = null;
        try {
            ResourceResolver resourceResolver = request.getResourceResolver();
            String path = request.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            writer = response.getWriter();
            Set<AssetInfo> toBePublishedAssets = this.publishService.getRelatedAssetsToPublish(resourceResolver, path);
            writer.print(FMUtils.convertSetOfFormInfoToJSONObject(toBePublishedAssets).toString());
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void getAllRelatedChildAssets(SlingHttpServletRequest request, SlingHttpServletResponse response) throws FormsMgrException {
        PrintWriter writer = null;
        try {
            ResourceResolver resourceResolver = request.getResourceResolver();
            String path = request.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            writer = response.getWriter();
            HashSet<AssetInfo> allRelatedChildAssets = new HashSet<AssetInfo>();
            this.formsRelationService.getAllRelatedChildAssets(resourceResolver, path, allRelatedChildAssets);
            writer.print(FMUtils.convertSetOfFormInfoToJSONObject(allRelatedChildAssets).toString());
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void getFirstLevelRelatedChildAssets(SlingHttpServletRequest request, SlingHttpServletResponse response) throws FormsMgrException {
        PrintWriter writer = null;
        try {
            ResourceResolver resourceResolver = request.getResourceResolver();
            String path = request.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            writer = response.getWriter();
            HashSet<AssetInfo> allRelatedChildAssets = new HashSet<AssetInfo>();
            this.formsRelationService.getFirstLevelRelatedChildAssets(resourceResolver, path, allRelatedChildAssets);
            writer.print(FMUtils.convertSetOfFormInfoToJSONObject(allRelatedChildAssets).toString());
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void uploadSampleData(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException, IOException, JSONException {
        block8: {
            try {
                ResourceResolver resourceResolver = req.getResourceResolver();
                Session session = resourceResolver.adaptTo(Session.class);
                String nodePath = req.getParameter("nodePath");
                Boolean isIE = Boolean.valueOf(req.getParameter("isIE"));
                InputStream inputStream = null;
                if (FMUtils.isGuide(session, nodePath) || FMUtils.isXDPForm(session, nodePath) || FMUtils.isPDFForm(session, nodePath) || FMUtils.isFormset(session, nodePath) || FMUtils.isAFFragment(session, nodePath) || FMUtils.isAdaptiveDocument(session, nodePath)) {
                    RequestParameter param = req.getRequestParameter("sampleData");
                    if (param != null) {
                        inputStream = param.getInputStream();
                    }
                    if (inputStream != null) {
                        String fileId = this.storeSampleData(inputStream, session);
                        PrintWriter writer = resp.getWriter();
                        JSONObject previewObject = new JSONObject();
                        fileId = "crx://" + fileId;
                        previewObject.put("sampleDataId", fileId);
                        if (isIE.booleanValue()) {
                            resp.setContentType("text/html;charset=utf-8");
                            writer.write("<textarea>");
                        }
                        writer.write(previewObject.toString());
                        if (isIE.booleanValue()) {
                            writer.write("</textarea>");
                        }
                        writer.close();
                    } else {
                        this.log.error("No Input Data");
                    }
                    break block8;
                }
                Object[] args = new Object[]{"Form", nodePath};
                throw new FormsMgrException("No valid {0} object exists at path : {1}.", args);
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
    }

    private String storeSampleData(InputStream instream, Session session) throws FormsMgrException {
        try {
            String rootPath = "/content/dam/formsanddocuments";
            long time = System.nanoTime();
            String fileId = "" + time;
            String fileName = "tempArchive_" + fileId;
            String tempStoragePath = rootPath + "/" + "temp_archive_storage";
            String tempArchiveLocation = tempStoragePath + "/" + fileName;
            int i = 0;
            while (session.nodeExists(tempArchiveLocation)) {
                fileId = "" + i++ + time;
                fileName = "tempArchive_" + fileId;
                tempArchiveLocation = tempStoragePath + "/" + fileName;
            }
            Node tempNode = null;
            if (!session.nodeExists(tempStoragePath)) {
                Node rootNode = session.getNode(rootPath);
                tempNode = rootNode.addNode("temp_archive_storage");
            } else {
                tempNode = session.getNode(tempStoragePath);
            }
            Node tempArchiveNode = tempNode.addNode(fileName, "{http://www.jcp.org/jcr/nt/1.0}file");
            ValueFactory valFactory = session.getValueFactory();
            Binary binary = valFactory.createBinary(instream);
            Node contentNode = tempArchiveNode.addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}resource");
            contentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}mimeType");
            contentNode.setProperty("jcr:data", binary);
            contentNode.setProperty("jcr:mimeType", ".xml");
            session.save();
            return tempArchiveLocation;
        }
        catch (RepositoryException e) {
            throw new FormsMgrException(e);
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private void deleteAsset(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException {
        String assetPath = req.getParameter("assetPath");
        try {
            if (!SettingsHolder.getInstance().getLcInstance().booleanValue()) {
                ResourceResolver resourceResolver = req.getResourceResolver();
                Session session = resourceResolver.adaptTo(Session.class);
                this.fmCRUDService.deleteCRXResource(session, assetPath);
            } else {
                this.log.error("In case of LC setup, delete API of FormsManagementServlet should be invoked.");
            }
            FMUtils.writeRequestStatusSuccess(resp, false);
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFragmentFromPanel(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        JSONObject fragmentJson = new JSONObject(req.getParameter("assetJson"));
        String affPath = this.fmCRUDService.createFragmentFromPanel(req.getResourceResolver(), fragmentJson);
        PrintWriter writer = null;
        try {
            JSONObject respJson = new JSONObject();
            respJson.put("fragmentPath", affPath);
            writer = resp.getWriter();
            writer.write(respJson.toString());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void createFormset(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        JSONObject formsetJSON = new JSONObject(req.getParameter("assetJson"));
        this.fmCRUDService.createFormset(req.getResourceResolver(), formsetJSON);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void updateFormset(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        JSONObject formsetJSON = new JSONObject(req.getParameter("assetJson"));
        this.fmCRUDService.updateFormset(req.getResourceResolver(), formsetJSON);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void generateFormsetThumbnail(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        String formsetPath = req.getParameter("nodePath");
        this.fmCRUDService.generateFormsetThumbnail(req.getResourceResolver(), formsetPath);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void getFormsInAFormset(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException {
        String assetPath = req.getParameter("assetPath");
        Session session = req.getResourceResolver().adaptTo(Session.class);
        try {
            JSONArray formsArray;
            JSONObject respJson;
            if (assetPath != null && session.nodeExists(assetPath)) {
                respJson = new JSONObject();
                formsArray = new JSONArray();
                Node formsetNode = session.getNode(assetPath);
                if (formsetNode.hasProperty("jcr:content/related/forms/sling:members/sling:resources")) {
                    Value[] forms;
                    for (Value value : forms = formsetNode.getProperty("jcr:content/related/forms/sling:members/sling:resources").getValues()) {
                        String formPath = value.getString();
                        String title = "";
                        if (!session.nodeExists(formPath)) continue;
                        Node formNode = session.getNode(formPath);
                        if (formNode.hasProperty("jcr:content/metadata/title")) {
                            title = FMUtils.getMetadataNode(formNode, false).getProperty("title").getString();
                        }
                        if (title.isEmpty()) {
                            title = formNode.getName();
                        }
                        JSONObject formObject = new JSONObject();
                        formObject.put("path", formPath);
                        formObject.put("title", title);
                        formsArray.put(formObject);
                    }
                }
            } else {
                Object[] args = new Object[]{assetPath};
                throw new FormsMgrException("AEM-FMG-700-002", args);
            }
            respJson.put("referencedForms", formsArray);
            resp.getWriter().write(respJson.toString());
            resp.getWriter().close();
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private void getDependentParentFMAssets(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException {
        PrintWriter writer = null;
        try {
            ResourceResolver resourceResolver = req.getResourceResolver();
            String path = req.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            writer = resp.getWriter();
            Set<AssetInfo> dependentParentAssets = this.formsRelationService.getDependentParentFMAssets(resourceResolver, path);
            writer.print(FMUtils.convertSetOfFormInfoToJSONObject(dependentParentAssets).toString());
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void hasDependentParentAssets(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException {
        PrintWriter writer = null;
        try {
            String path = req.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            writer = resp.getWriter();
            boolean response = this.formsDependencyManager.hasParentDependencies(path);
            JSONObject relatedAssetsJson = new JSONObject();
            relatedAssetsJson.put("hasDependentParentAssets", response);
            writer.write(relatedAssetsJson.toString());
        }
        catch (FormsFoundationException e) {
            throw new FormsMgrException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateThumbnail(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        InputStream is = null;
        try {
            ResourceResolver resourceResolver = req.getResourceResolver();
            String path = req.getParameter("nodePath");
            if (path == null || path.length() == 0) {
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"nodePath", path});
            }
            Resource resource = resourceResolver.getResource(path);
            RequestParameter image = req.getRequestParameter(IMAGE);
            RequestParameter imageBase64Encoded = req.getRequestParameter(IMAGE_BASE64_ENCODED);
            Boolean isIE = Boolean.valueOf(req.getParameter("isIE"));
            if (resource != null && (image != null && image.getInputStream() != null || imageBase64Encoded != null)) {
                if (image != null && image.getInputStream() != null) {
                    is = image.getInputStream();
                } else if (imageBase64Encoded != null) {
                    String base64EncodeString = imageBase64Encoded.getString();
                    byte[] decodedArray = Base64.decodeBase64((String)base64EncodeString);
                    is = new ByteArrayInputStream(decodedArray);
                }
                ThumbnailUtil.addThumbnailToAsset(resource, is);
                resourceResolver.commit();
            }
            FMUtils.writeRequestStatusSuccess(resp, isIE);
        }
        catch (Exception e) {
            this.log.error("Error while creating new rendition", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private void createTheme(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        JSONObject themeJson = new JSONObject(req.getParameter("assetJson"));
        this.fmCRUDService.createTheme(req.getResourceResolver(), themeJson);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodeExist(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        String nodePath = req.getParameter("path");
        boolean isNodeExist = this.fmCRUDService.checkNodeExist(req.getResourceResolver(), nodePath);
        PrintWriter writer = null;
        try {
            JSONObject respJson = new JSONObject();
            respJson.put("NODE_EXIST", isNodeExist);
            writer = resp.getWriter();
            writer.write(respJson.toString());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void moveNode(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        String sourceLocation = req.getParameter("sourceLocation");
        String destinationLocation = req.getParameter("destinationLocation");
        FMUtils.moveNode(req.getResourceResolver(), sourceLocation, destinationLocation);
        FMUtils.writeRequestStatusSuccess(resp, false);
    }

    private void cleanUpForms(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException, IOException, JSONException {
        try {
            String[] formPaths = req.getParameterValues("formPaths");
            ResourceResolver resourceResolver = req.getResourceResolver();
            Session session = resourceResolver.adaptTo(Session.class);
            for (String formPath : formPaths) {
                if (formPath != null) {
                    if ((formPath = formPath.trim()).startsWith("/content/dam/formsanddocuments")) {
                        this.fmCRUDService.cleanUpReviewInfo(session, formPath);
                        this.fmCRUDService.cleanUpAnalyticsInfo(session, formPath);
                        this.fmCRUDService.cleanUpFormABTestingInfo(session, formPath);
                    } else if (formPath.startsWith("/content/forms/af")) {
                        this.fmCRUDService.cleanUpFormPageABTestingInfo(session, formPath);
                    }
                }
                session.save();
            }
            FMUtils.writeRequestStatusSuccess(resp, false);
        }
        catch (RepositoryException e) {
            throw FMUtils.getFormsMgrException((Exception)((Object)e));
        }
    }

    private void pasteTheme(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws FormsMgrException {
        String themeSrcPath = req.getParameter("srcPath").trim();
        String themeDestPath = req.getParameter("destPath").trim();
        String destParentPath = req.getParameter("destParentPath").trim();
        ResourceResolver resourceResolver = req.getResourceResolver();
        Session session = resourceResolver.adaptTo(Session.class);
        try {
            if (session.nodeExists(themeSrcPath) && session.nodeExists(themeDestPath)) {
                Node themeSrcNode = session.getNode(themeSrcPath);
                Node themeDestNode = session.getNode(themeDestPath);
                String clientlibRefPath = FMUtils.getClientlibPath(themeSrcNode);
                Node srcClientLib = session.getNode(clientlibRefPath);
                String destClientLibParentPath = destParentPath.replace("/content/dam/formsanddocuments-themes", "/etc/clientlibs/fd/themes");
                Node destClientLibParentNode = JcrUtil.createPath(destClientLibParentPath, "nt:folder", "nt:folder", session, false);
                Node destClientLibNode = JcrUtil.copy(srcClientLib, destClientLibParentNode, themeDestNode.getName());
                String destCategoryName = FMUtils.getCategoryNameFromClientLibPath(destClientLibParentPath + "/" + themeDestNode.getName());
                destClientLibNode.setProperty("categories", new String[]{destCategoryName});
                Node metadataNode = themeDestNode.getNode("jcr:content/metadata");
                metadataNode.setProperty("clientlibCategory", destCategoryName);
                metadataNode.setProperty("clientlibRef", destClientLibParentPath);
                this.fmCRUDService.cleanUpForm(session, themeDestPath);
                session.save();
            }
            FMUtils.writeRequestStatusSuccess(resp, false);
        }
        catch (Exception e) {
            throw FMUtils.getFormsMgrException(e);
        }
    }

    protected void bindPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    protected void unbindPublishService(PublishService publishService) {
        if (this.publishService == publishService) {
            this.publishService = null;
        }
    }

    protected void bindFmCRUDService(FMCRUDService fMCRUDService) {
        this.fmCRUDService = fMCRUDService;
    }

    protected void unbindFmCRUDService(FMCRUDService fMCRUDService) {
        if (this.fmCRUDService == fMCRUDService) {
            this.fmCRUDService = null;
        }
    }

    protected void bindFormsRelationService(FormsRelationService formsRelationService) {
        this.formsRelationService = formsRelationService;
    }

    protected void unbindFormsRelationService(FormsRelationService formsRelationService) {
        if (this.formsRelationService == formsRelationService) {
            this.formsRelationService = null;
        }
    }

    protected void bindFormsDependencyManager(FormsDependencyManager formsDependencyManager) {
        this.formsDependencyManager = formsDependencyManager;
    }

    protected void unbindFormsDependencyManager(FormsDependencyManager formsDependencyManager) {
        if (this.formsDependencyManager == formsDependencyManager) {
            this.formsDependencyManager = null;
        }
    }
}

