/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.util;

import com.adobe.aem.formsndocuments.transferobjects.AssetInfo;
import com.adobe.aem.formsndocuments.util.FMConstants;
import com.adobe.aemforms.fm.exception.FormsMgrException;
import com.adobe.forms.foundation.service.FormsAssetType;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.policies.ContentPolicy;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMUtils {
    private static final Logger log = LoggerFactory.getLogger(FMUtils.class);

    public static Node getMetadataNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node metadataNode = null;
            Node contentNode = FMUtils.getContentNode(formNode, create);
            if (contentNode != null) {
                if (!contentNode.hasNode("metadata")) {
                    if (create) {
                        metadataNode = contentNode.addNode("metadata", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    }
                } else {
                    metadataNode = contentNode.getNode("metadata");
                }
            }
            return metadataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getMetadataNode(Session session, String formPath, boolean create) throws FormsMgrException {
        try {
            Node metadataNode = null;
            if (session != null) {
                Node formNode = session.getNode(FMUtils.getAssetPathFromPage(formPath));
                metadataNode = FMUtils.getMetadataNode(formNode, create);
            }
            return metadataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getAnalyticsDataNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node analyticsDataNode = null;
            Node contentNode = FMUtils.getContentNode(formNode, create);
            if (contentNode != null) {
                if (!contentNode.hasNode("analyticsdatanode")) {
                    if (create) {
                        analyticsDataNode = contentNode.addNode("analyticsdatanode", "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    }
                } else {
                    analyticsDataNode = contentNode.getNode("analyticsdatanode");
                }
            }
            return analyticsDataNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Node getContentNode(Node formNode, boolean create) throws FormsMgrException {
        try {
            Node contentNode = null;
            if (!formNode.hasNode("jcr:content")) {
                if (create) {
                    contentNode = formNode.addNode("jcr:content", "dam:AssetContent");
                }
            } else {
                contentNode = formNode.getNode("jcr:content");
            }
            return contentNode;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean isFolder(Session session, String path) throws FormsMgrException {
        boolean isFolderNode = false;
        if (session != null) {
            try {
                Property prop;
                Node folderNode = null;
                folderNode = session.getNode(path);
                String primaryType = folderNode.getPrimaryNodeType().getName();
                if (primaryType.equals("sling:OrderedFolder") && folderNode.hasProperty("lcFolder") && (prop = folderNode.getProperty("lcFolder")).getLong() == (long)FMConstants.FOLDER_STATE.VALID.ordinal()) {
                    isFolderNode = true;
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isFolderNode;
    }

    public static boolean isApplication(Session session, String path) throws FormsMgrException {
        boolean isApplicationNode = false;
        if (session != null) {
            try {
                Property prop;
                Node applicationNode = null;
                applicationNode = session.getNode(path);
                if (applicationNode.hasProperty("lcApplication") && (prop = applicationNode.getProperty("lcApplication")).getLong() == (long)FMConstants.APPLICATION_STATE.VALID.ordinal()) {
                    isApplicationNode = true;
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isApplicationNode;
    }

    public static boolean isXDPForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("xfaForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isResource(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("lcResource"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isGuide(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("guide"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isPDFForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("pdfForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isPrintForm(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("printForm"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isFormset(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("formset"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isAFFragment(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("affragment"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isAdaptiveDocument(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("adaptivedocument"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    public static boolean isTheme(Session session, String path) throws FormsMgrException {
        return FMUtils.isValidAssetType(session, path, Collections.singletonList("theme"), FMConstants.FORM_STATE.VALID.ordinal());
    }

    private static boolean isValidAssetType(Session session, String path, List<String> assetTypes, long validValue) throws FormsMgrException {
        if (session != null) {
            try {
                Node assetNode = null;
                assetNode = session.getNode(path);
                if (assetNode == null) {
                    return false;
                }
                String primaryType = assetNode.getPrimaryNodeType().getName();
                if (primaryType.equals("dam:Asset")) {
                    Node contentNode = FMUtils.getContentNode(assetNode, false);
                    if (contentNode == null) {
                        return false;
                    }
                    for (String assetType : assetTypes) {
                        Property prop;
                        if (!contentNode.hasProperty(assetType) || (prop = contentNode.getProperty(assetType)).getLong() != validValue) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return false;
    }

    public static boolean isXFABasedForm(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("formmodel") && metadataNode.getProperty("formmodel").getString().equals("formtemplates");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasDORTemplate(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null && metadataNode.hasProperty("dorType")) {
                return "select".equals(metadataNode.getProperty("dorType").getString()) && metadataNode.hasProperty("dorTemplateRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasMetaTemplate(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && FMUtils.isGuide(session, path) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("metaTemplateRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean hasXSDRef(Session session, String path) throws FormsMgrException {
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (FMUtils.isGuide(session, path) || FMUtils.isAFFragment(session, path)) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null) {
                return metadataNode.hasProperty("xsdRef");
            }
            return false;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean isLockedAsset(Session session, String path) throws FormsMgrException {
        boolean isLocked = false;
        if (session != null) {
            try {
                if (session.nodeExists(path)) {
                    Node assetNode = session.getNode(path);
                    if (path.startsWith("/content/dam/formsanddocuments-themes/themeLibrary") || path.startsWith("/etc/clientlibs/fd/themes/themeLibrary")) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        return isLocked;
    }

    public static Property getNodeProperty(String propertyName, Node node) throws FormsMgrException {
        try {
            Property property;
            if (node.hasProperty(propertyName) && (property = node.getProperty(propertyName)) != null) {
                return property;
            }
            return null;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getXDPRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("xdpRef")) {
                return guideContainerNode.getProperty("xdpRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getDORRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("dorTemplateRef")) {
                return guideContainerNode.getProperty("dorTemplateRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getMetaTemplateRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.nodeExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("metaTemplateRef")) {
                return guideContainerNode.getProperty("metaTemplateRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getXSDRefPath(Session session, String guidePath) throws FormsMgrException {
        try {
            String guideContainerNodePath = guidePath + "/" + "jcr:content/guideContainer";
            if (!session.itemExists(guideContainerNodePath)) {
                throw new FormsMgrException("AEM-FMG-800-001", new String[]{guidePath});
            }
            Node guideContainerNode = session.getNode(guideContainerNodePath);
            if (guideContainerNode.hasProperty("xsdRef")) {
                return guideContainerNode.getProperty("xsdRef").getString();
            }
            throw new FormsMgrException("AEM-FMG-800-003", new String[]{guidePath});
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Map<String, String> createGuideRenderURL(Node guideNode, String sampleDataId, Session session) throws FormsMgrException {
        try {
            HashMap<String, String> renderUrlMap = new HashMap<String, String>();
            String cqPagePath = FMUtils.getPagePathFromAsset(guideNode.getPath());
            if (!session.nodeExists(cqPagePath)) {
                throw new FormsMgrException("CQ Page corresponding to Guide Node does not exists");
            }
            renderUrlMap.put("formUrl", cqPagePath + ".html");
            String completeDataUrl = FMUtils.createDataUrl(sampleDataId, session);
            renderUrlMap.put("dataRef", completeDataUrl);
            return renderUrlMap;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static Map<String, String> createFormsetRenderURLParams(Node formNode, String type, String submitUrl, String profile, String sampleDataId, Session session) throws FormsMgrException {
        try {
            HashMap<String, String> renderUrlMap = new HashMap<String, String>();
            Node metadataNode = FMUtils.getMetadataNode(formNode, false);
            if (profile == null || profile.trim().equals("")) {
                profile = metadataNode != null && metadataNode.hasProperty("profile") ? metadataNode.getProperty("profile").getString() : "/content/forms/formsets/profiles/default";
            }
            if (submitUrl == null) {
                submitUrl = metadataNode != null && metadataNode.hasProperty("submitUrl") ? metadataNode.getProperty("submitUrl").getString() : null;
            }
            String templateName = null;
            String contentRoot = null;
            String formsetPath = null;
            String contentUri = formNode.getPath();
            if (contentUri == null) {
                throw new FormsMgrException("Failed to render form. Null ContentRootURI.");
            }
            int index = contentUri.lastIndexOf("/");
            templateName = contentUri.substring(index + 1);
            contentRoot = contentUri.substring(0, index);
            formsetPath = contentRoot + "/" + templateName;
            String completeDataUrl = FMUtils.createDataUrl(sampleDataId, session);
            String formUrl = profile + "." + type;
            renderUrlMap.put("formUrl", formUrl);
            renderUrlMap.put("formsetPath", formsetPath);
            renderUrlMap.put("dataRef", completeDataUrl);
            renderUrlMap.put("submitUrl", submitUrl);
            return renderUrlMap;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    private static String createDataUrl(String dataId, Session session) throws FormsMgrException {
        String dataUrl = null;
        String urlPrefix = "crx://";
        if (dataId != null && dataId.trim().length() > 0 && !dataId.contains("://") && !dataId.trim().equals("None")) {
            dataUrl = FMUtils.getSampleDataPath(dataId, session);
        }
        String completeDataUrl = null;
        completeDataUrl = dataUrl != null && !dataUrl.trim().equals("") ? urlPrefix + dataUrl : (dataId != null && !dataId.trim().equals("") && dataId.contains("://") ? dataId : "");
        return completeDataUrl;
    }

    private static String getSampleDataPath(String fileId, Session session) throws FormsMgrException {
        try {
            String fileName = "tempArchive_" + fileId;
            String tempArchiveLocation = "/content/dam/formsanddocuments/temp_archive_storage/" + fileName;
            Node tempNode = null;
            if (!session.nodeExists(tempArchiveLocation)) {
                log.error("temp node doesn't exist " + tempArchiveLocation);
                return null;
            }
            tempNode = session.getNode(tempArchiveLocation);
            return tempNode.getPath();
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean isForm(FMConstants.CoreAssetType assetType) {
        return assetType == FMConstants.CoreAssetType.FORM || assetType == FMConstants.CoreAssetType.PDFFORM || assetType == FMConstants.CoreAssetType.PRINTFORM;
    }

    public static String getFormType(FMConstants.CoreAssetType assetType) {
        if (FMConstants.CoreAssetType.FORM == assetType) {
            return "xfaForm";
        }
        if (FMConstants.CoreAssetType.PDFFORM == assetType) {
            return "pdfForm";
        }
        if (FMConstants.CoreAssetType.PRINTFORM == assetType) {
            return "printForm";
        }
        throw new RuntimeException("Invalid form type");
    }

    public static void deleteTempArchives(Session session) throws FormsMgrException {
        block11: {
            String rootPath = "/content/dam/formsanddocuments";
            String tempStoragePath = rootPath + "/" + "temp_archive_storage";
            try {
                if (!session.nodeExists(tempStoragePath)) break block11;
                Node tempStorageNode = session.getNode(tempStoragePath);
                NodeIterator iter = tempStorageNode.getNodes();
                if (iter != null) {
                    int i = 0;
                    while ((long)i < iter.getSize()) {
                        Node node = iter.nextNode();
                        if (node.hasProperty("jcr:created")) {
                            long creationTime;
                            Calendar cal = Calendar.getInstance();
                            long currentTime = cal.getTime().getTime();
                            if (currentTime - (creationTime = node.getProperty("jcr:created").getDate().getTime().getTime()) > 1800000L) {
                                log.info("Deleting temp archive : " + node.getPath());
                                node.remove();
                                session.save();
                            }
                        } else {
                            long currentTime = System.nanoTime();
                            String name = node.getName();
                            if (name.startsWith("tempArchive_")) {
                                String creationTimeString = name.substring("tempArchive".length() + 1);
                                try {
                                    Long creationTime = Long.parseLong(creationTimeString);
                                    if (currentTime - creationTime > 1800000000000L) {
                                        log.info("Deleting temp archive without mixin : " + node.getPath());
                                        node.remove();
                                        session.save();
                                    }
                                }
                                catch (NumberFormatException e) {
                                    log.warn(node.getName() + " does not have a valid system time name. Failed to delete", (Throwable)e);
                                }
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                log.info("No Temp Archive files.");
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
    }

    public static ResourceResolver getResourceResolver(ResourceResolverFactory resourceResolverFactory, Session session) throws FormsMgrException {
        try {
            HashMap<String, Object> authInfo = new HashMap<String, Object>();
            authInfo.put("user.jcr.session", session);
            return resourceResolverFactory.getResourceResolver(authInfo);
        }
        catch (LoginException e) {
            throw new FormsMgrException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRequestStatusSuccess(SlingHttpServletResponse resp, boolean isIE) throws IOException, JSONException {
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
            JSONObject successJson = new JSONObject();
            successJson.put("requestStatus", "success");
            if (isIE) {
                resp.setContentType("text/html;charset=utf-8");
                writer.write("<textarea>");
            }
            writer.write(successJson.toString());
            if (isIE) {
                writer.write("</textarea>");
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static Node getFolderNode(Session session, String rootNodePath, boolean create, String folderType) throws FormsMgrException {
        try {
            Node workspaceRootNode;
            Node workingNode = null;
            if (session.nodeExists(rootNodePath)) {
                return session.getNode(rootNodePath);
            }
            if (!create) {
                throw new FormsMgrException("Node " + rootNodePath + " does not exist. Please check logs for more detail.");
            }
            String[] pathElems = rootNodePath.split("/");
            Node parentNode = workspaceRootNode = session.getRootNode();
            String rootPath = rootNodePath;
            if (rootPath.endsWith("/")) {
                rootPath = rootPath.substring(0, rootPath.length() - 1);
            }
            for (String path : pathElems) {
                if (path.equals("")) continue;
                workingNode = !parentNode.hasNode(path) ? parentNode.addNode(path, folderType) : parentNode.getNode(path);
                parentNode = workingNode;
            }
            session.save();
            return workingNode;
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getPagePathFromAsset(String assetPath) {
        return assetPath.replace("/content/dam/formsanddocuments", "/content/forms/af");
    }

    public static String getAssetPathFromPage(String pagePath) {
        return pagePath.replace("/content/forms/af", "/content/dam/formsanddocuments");
    }

    public static Resource getClosestNodeUpInHierarchy(ResourceResolver resolver, String path, String inputPropertyName, String inputPropertyValue, boolean includeCurrentNode) throws FormsMgrException {
        try {
            if (resolver == null || path == null || path.isEmpty() || inputPropertyName == null || inputPropertyName.isEmpty() || inputPropertyValue == null || inputPropertyValue.isEmpty()) {
                throw new FormsMgrException("AEM-FMG-700-001");
            }
            Resource res = resolver.getResource(path);
            String propeVal = null;
            ValueMap map = null;
            if (res != null && !includeCurrentNode) {
                res = res.getParent();
            }
            while (res != null && !inputPropertyValue.equals(propeVal = (String)(map = res.getValueMap()).get(inputPropertyName))) {
                res = res.getParent();
            }
            return res;
        }
        catch (FormsMgrException e) {
            log.error("exception while finding node in getClosestNodeUpInHierarchy() : " + e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception while finding node in getClosestNodeUpInHierarchy() : " + e);
            throw new FormsMgrException(e);
        }
    }

    public static long getLastModifiedOrCreated(Session session, String assetPath) throws FormsMgrException {
        try {
            Property lastUpdateProperty = null;
            Node assetNode = session.getNode(assetPath);
            Node contentNode = FMUtils.getContentNode(assetNode, false);
            if (assetNode.isNodeType("cq:Template")) {
                return -1L;
            }
            if (assetNode.isNodeType("cq:ClientLibraryFolder")) {
                return -1L;
            }
            if (assetNode.hasProperty("sling:resourceType") && "wcm/core/components/policy/policy".equals(assetNode.getProperty("sling:resourceType").getString())) {
                return -1L;
            }
            if (contentNode != null && contentNode.hasProperty("jcr:lastModified")) {
                lastUpdateProperty = contentNode.getProperty("jcr:lastModified");
            } else if (contentNode != null && contentNode.hasProperty("jcr:created")) {
                lastUpdateProperty = contentNode.getProperty("jcr:created");
            } else if (assetNode.hasProperty("jcr:lastModified")) {
                lastUpdateProperty = assetNode.getProperty("jcr:lastModified");
            }
            if (lastUpdateProperty == null) {
                return -1L;
            }
            return lastUpdateProperty.getDate().getTimeInMillis();
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static String getDisplayAssetType(Session session, String nodePath) throws FormsMgrException {
        if (FMUtils.isXDPForm(session, nodePath)) {
            return "Form Template";
        }
        if (FMUtils.isResource(session, nodePath)) {
            return "Resource";
        }
        if (FMUtils.isGuide(session, nodePath)) {
            return "Adaptive Form";
        }
        if (FMUtils.isPDFForm(session, nodePath)) {
            return "PDF Form";
        }
        if (FMUtils.isPrintForm(session, nodePath)) {
            return "Document";
        }
        if (FMUtils.isFormset(session, nodePath)) {
            return "Form Set";
        }
        throw new FormsMgrException("Invalid Resource for publishing:" + nodePath);
    }

    public static String getNameFromPath(String path) throws FormsMgrException {
        String name = null;
        int nameStartIndex = path.lastIndexOf("/");
        if (nameStartIndex < 0 || nameStartIndex >= path.length() - 1) {
            throw new FormsMgrException("Invalid asset path: " + path);
        }
        name = path.substring(nameStartIndex + 1);
        return name;
    }

    public static FMConstants.CoreAssetType getAssetType(Session session, String nodePath) throws FormsMgrException {
        if (session != null) {
            try {
                if (!session.nodeExists(nodePath)) {
                    Object[] args = new Object[]{nodePath};
                    throw new FormsMgrException("AEM-FMG-700-002", args);
                }
                if (FMUtils.isXDPForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.FORM;
                }
                if (FMUtils.isPDFForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.PDFFORM;
                }
                if (FMUtils.isPrintForm(session, nodePath)) {
                    return FMConstants.CoreAssetType.PRINTFORM;
                }
                if (FMUtils.isFolder(session, nodePath) || FMUtils.isApplication(session, nodePath)) {
                    return FMConstants.CoreAssetType.FOLDER;
                }
                if (FMUtils.isResource(session, nodePath)) {
                    return FMConstants.CoreAssetType.RESOURCE;
                }
                if (FMUtils.isGuide(session, nodePath)) {
                    return FMConstants.CoreAssetType.GUIDE;
                }
                if (FMUtils.isFormset(session, nodePath)) {
                    return FMConstants.CoreAssetType.FORMSET;
                }
                if (FMUtils.isAFFragment(session, nodePath)) {
                    return FMConstants.CoreAssetType.AFFRAGMENT;
                }
                if (FMUtils.isAdaptiveDocument(session, nodePath)) {
                    return FMConstants.CoreAssetType.ADAPTIVEDOCUMENT;
                }
                if (FMUtils.isTheme(session, nodePath)) {
                    return FMConstants.CoreAssetType.THEME;
                }
                return FMConstants.CoreAssetType.NONFMASSET;
            }
            catch (Exception e) {
                throw new FormsMgrException(e);
            }
        }
        log.error("Unable to get a JCR session");
        throw new FormsMgrException("Invalid session object.");
    }

    public static FormsMgrException getFormsMgrException(Exception e) {
        if (e instanceof FormsMgrException) {
            return (FormsMgrException)e;
        }
        return new FormsMgrException(e);
    }

    public static void unscheduleJob(JobManager jobManager, String formPath, String replicationAtribute) {
        Collection<ScheduledJobInfo> scheduledJobs = jobManager.getScheduledJobs();
        for (ScheduledJobInfo eachJob : scheduledJobs) {
            Map<String, Object> eachJobProps = eachJob.getJobProperties();
            if (!eachJob.getJobTopic().equals("com/adobe/aem/formsndocuments/scheduler/formreplication") || !eachJobProps.get("event.form.path").equals(formPath) || !eachJobProps.get("event.replication.attribute").equals(replicationAtribute)) continue;
            eachJob.unschedule();
            break;
        }
    }

    public static String getRootLevelAssetType(Session session, String assetPath) throws RepositoryException {
        if (assetPath != null && assetPath.startsWith("/content/dam/formsanddocuments")) {
            int endIndex = assetPath.indexOf("/", "/content/dam/formsanddocuments".length() + 1);
            if (endIndex > 0) {
                assetPath = assetPath.substring(0, endIndex);
            }
            if (session.nodeExists(assetPath)) {
                Node rootFolderNode = session.getNode(assetPath);
                if (rootFolderNode.hasProperty("lcApplication")) {
                    return "lcApplication";
                }
                if (rootFolderNode.hasProperty("lcFolder")) {
                    return "lcFolder";
                }
                if (rootFolderNode.hasProperty("xfaForm")) {
                    return "xfaForm";
                }
                if (rootFolderNode.hasProperty("pdfForm")) {
                    return "pdfForm";
                }
                if (rootFolderNode.hasProperty("printForm")) {
                    return "printForm";
                }
                if (rootFolderNode.hasProperty("lcResource")) {
                    return "lcResource";
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream oInpStream) throws IOException {
        byte[] result = new byte[]{};
        if (oInpStream == null) {
            return result;
        }
        BufferedInputStream oStream = new BufferedInputStream(oInpStream);
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        int nRead = 0;
        int nBlkSize = 32768;
        byte[] buffer = new byte[nBlkSize];
        try {
            while ((nRead = oStream.read(buffer, 0, nBlkSize)) != -1) {
                oBAOS.write(buffer, 0, nRead);
            }
            result = oBAOS.toByteArray();
        }
        catch (IOException e) {
            log.debug("Error while generating a byte array from input stream.", (Throwable)e);
        }
        finally {
            try {
                if (oStream != null) {
                    oStream.close();
                }
                if (oBAOS != null) {
                    oBAOS.close();
                }
                if (oInpStream != null) {
                    oInpStream.close();
                }
            }
            catch (IOException e) {
                log.debug("Error while attempting to close input/output stream.", (Throwable)e);
            }
        }
        return result;
    }

    public static Session getFnDServiceUserSession(SlingRepository repository) throws RepositoryException {
        Session session = repository.loginService(null, null);
        return session;
    }

    public static ResourceResolver getFnDServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory) throws LoginException {
        ResourceResolver resourceResolver = resourceResolverFactory.getServiceResourceResolver(null);
        return resourceResolver;
    }

    public static JSONObject convertSetOfFormInfoToJSONObject(Set<AssetInfo> formInfoList) throws FormsMgrException {
        try {
            JSONObject rootJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (AssetInfo formInfo : formInfoList) {
                JSONObject formInfoJSON = new JSONObject();
                Resource resource = formInfo.getResource();
                if (resource != null) {
                    Session session = resource.getResourceResolver().adaptTo(Session.class);
                    String title = FMUtils.getResourceTitle(resource);
                    if (title != null && !title.isEmpty()) {
                        formInfoJSON.put("name", title);
                    } else {
                        formInfoJSON.put("name", resource.getName());
                    }
                    formInfoJSON.put("type", formInfo.getPublishAssetType());
                    formInfoJSON.put("path", resource.getPath());
                    ReplicationStatus replStatus = resource.adaptTo(ReplicationStatus.class);
                    long lastModified = FMUtils.getLastModifiedOrCreated(session, resource.getPath());
                    formInfoJSON.put("lastModified", lastModified);
                    if (replStatus != null) {
                        boolean published = replStatus.isDelivered() || replStatus.isActivated();
                        formInfoJSON.put("published", published);
                        if (published) {
                            long lastPublished = replStatus.getLastPublished().getTimeInMillis();
                            formInfoJSON.put("lastPublished", lastPublished);
                            boolean outdated = lastPublished < lastModified;
                            formInfoJSON.put("outdated", outdated);
                            formInfoJSON.put("status", outdated ? "outdated" : "not available");
                        }
                    }
                    formInfoJSON.put("disabled", !FMUtils.canReplicate(resource.getPath(), session));
                }
                jsonArray.put(formInfoJSON);
            }
            rootJson.put("assets", jsonArray);
            return rootJson;
        }
        catch (Exception e) {
            throw new FormsMgrException(e);
        }
    }

    public static boolean canReplicate(String path, Session session) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
    }

    public static void prepareJsonToCreateDAMAsset(ResourceResolver resourceResolver, JSONObject inOutAssetJSON, FMConstants.CoreAssetType assetType, String formPath, String formName) throws FormsMgrException {
        if (resourceResolver == null || inOutAssetJSON == null || formPath == null || formName == null) {
            log.error("invalid input parametrs in prepareJsonToCreateDAMAsset()");
            throw new FormsMgrException("AEM-FMG-700-001");
        }
        try {
            String[] tags;
            formName = formName.replaceAll("[^a-zA-Z0-9_-]", "-");
            Session session = resourceResolver.adaptTo(Session.class);
            if (!session.nodeExists(formPath)) {
                log.error("DAM Asset to be created at non existant path : " + formPath);
                Object[] args = new Object[]{formPath};
                throw new FormsMgrException("AEM-FMG-700-002", args);
            }
            String assetPath = ResourceUtil.normalize(formPath + "/" + formName);
            inOutAssetJSON.put("path", assetPath);
            JSONObject assetJcrProperties = new JSONObject();
            switch (assetType) {
                case GUIDE: {
                    inOutAssetJSON.put("assetType", "guide");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/af/render");
                    break;
                }
                case AFFRAGMENT: {
                    inOutAssetJSON.put("assetType", "affragment");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/af/render");
                    break;
                }
                case FORMSET: {
                    inOutAssetJSON.put("assetType", "formset");
                    assetJcrProperties.put("sling:resourceType", "fd/fm/formset/render");
                }
            }
            inOutAssetJSON.put("assetJcrProperties", assetJcrProperties);
            JSONObject metaDataProperties = inOutAssetJSON.getJSONObject("metadataProperties");
            metaDataProperties.put("allowedRenderFormat", "HTML");
            metaDataProperties.put("author", resourceResolver.getUserID());
            metaDataProperties.put("jcr:primaryType", "nt:unstructured");
            if (!metaDataProperties.has("title") || metaDataProperties.getString("title").isEmpty()) {
                metaDataProperties.put("title", formName);
            }
            if (metaDataProperties.has("xdpRef") && metaDataProperties.getString("xdpRef").isEmpty()) {
                metaDataProperties.remove("xdpRef");
            }
            if (metaDataProperties.has("xsdRef") && metaDataProperties.getString("xsdRef").isEmpty()) {
                metaDataProperties.remove("xsdRef");
            }
            if (metaDataProperties.has("description") && metaDataProperties.getString("description").isEmpty()) {
                metaDataProperties.remove("description");
            }
            if (metaDataProperties.has("cq:tags") && (tags = (String[])metaDataProperties.get("cq:tags")) != null && tags.length > 0) {
                metaDataProperties.put("cq:tags", new JSONArray(Arrays.asList(tags)));
            }
        }
        catch (FormsMgrException fmException) {
            throw fmException;
        }
        catch (Exception e) {
            log.error("error while creating json to create DAM Asset", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-800-005");
        }
    }

    public static Node createCQPageNode(ResourceResolver resourceResolver, JSONObject paramsJson, FMConstants.CoreAssetType assetType, FMConstants.FORM_MODEL form_model, String templatePath) throws FormsMgrException {
        try {
            String cqPagePath = FMUtils.getPagePathFromAsset(paramsJson.getString("path"));
            JcrUtils.getOrCreateByPath(cqPagePath, "sling:OrderedFolder", "sling:OrderedFolder", resourceResolver.adaptTo(Session.class), false);
            AssetManager assetManager = resourceResolver.adaptTo(AssetManager.class);
            if (assetType == FMConstants.CoreAssetType.GUIDE) {
                assetManager.copyAsset(templatePath, cqPagePath);
            } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
                assetManager.copyAsset("/libs/fd/af/templateForFragment/defaultFragmentTemplate", cqPagePath);
            }
            Resource cqPageResource = resourceResolver.getResource(cqPagePath);
            Resource thumbnailResource = resourceResolver.getResource(cqPageResource, "thumbnail.png");
            if (thumbnailResource != null) {
                resourceResolver.delete(thumbnailResource);
            }
            ModifiableValueMap mvm = cqPageResource.adaptTo(ModifiableValueMap.class);
            mvm.remove("jcr:title");
            mvm.remove("jcr:description");
            mvm.remove("allowedPaths");
            mvm.put("jcr:primaryType", "cq:Page");
            Resource jcrContentResource = resourceResolver.getResource(cqPageResource, "jcr:content");
            mvm = jcrContentResource.adaptTo(ModifiableValueMap.class);
            if (assetType == FMConstants.CoreAssetType.GUIDE) {
                mvm.put("cq:template", templatePath);
            } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
                mvm.put("cq:template", "/libs/fd/af/templateForFragment/defaultFragmentTemplate");
            }
            mvm.put("jcr:language", "en");
            mvm.put("cq:lastModifiedBy", resourceResolver.getUserID());
            mvm.put("cq:lastModified", Calendar.getInstance());
            mvm.remove("guideComponentType");
            JSONObject metadataProperties = paramsJson.getJSONObject("metadataProperties");
            mvm.put("jcr:title", metadataProperties.getString("title"));
            Resource guideContainerResource = resourceResolver.getResource(cqPageResource, "jcr:content/guideContainer");
            mvm = guideContainerResource.adaptTo(ModifiableValueMap.class);
            if (assetType == FMConstants.CoreAssetType.GUIDE) {
                if (form_model == FMConstants.FORM_MODEL.FORM_TEMPLATE) {
                    mvm.put("xdpRef", metadataProperties.getString("xdpRef"));
                } else if (form_model == FMConstants.FORM_MODEL.XML_SCHEMA) {
                    mvm.put("xsdRef", metadataProperties.getString("xsdRef"));
                }
            } else if (assetType == FMConstants.CoreAssetType.AFFRAGMENT) {
                if (form_model == FMConstants.FORM_MODEL.FORM_TEMPLATE) {
                    mvm.put("xdpRef", metadataProperties.getString("xdpRef"));
                    mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                } else if (form_model == FMConstants.FORM_MODEL.XML_SCHEMA) {
                    mvm.put("xsdRef", metadataProperties.getString("xsdRef"));
                    mvm.put("fragmentModelRoot", metadataProperties.getString("fragmentModelRoot"));
                }
            }
            Resource guideRootPanelItemResource = resourceResolver.getResource(guideContainerResource, "rootPanel/items");
            if (guideContainerResource != null) {
                Node itemNode = guideRootPanelItemResource.adaptTo(Node.class);
                NodeIterator Iter2 = itemNode.getNodes();
                while (Iter2.hasNext()) {
                    Iter2.nextNode().remove();
                }
            }
            return cqPageResource.adaptTo(Node.class);
        }
        catch (Exception e) {
            log.error("Error while creating cq page Node : ", (Throwable)e);
            throw new FormsMgrException("AEM-FMG-900-005");
        }
    }

    public static void JsonToJcrNode(Node node, JSONObject jsonObject) throws JSONException, RepositoryException {
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object property = jsonObject.get(key);
            FMUtils.handleProperty(node, key, property);
        }
    }

    private static void handleProperty(Node node, String name, Object property) throws JSONException, RepositoryException {
        if (JSONObject.class.isAssignableFrom(property.getClass())) {
            JSONObject nodeJson = (JSONObject)property;
            if (nodeJson.has("jcr:primaryType") && nodeJson.getString("jcr:primaryType").equals("nt:file")) {
                return;
            }
            Node childNode = node.addNode(name, "nt:unstructured");
            FMUtils.JsonToJcrNode(childNode, (JSONObject)property);
        } else {
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes")) {
                return;
            }
            String[] propertyValue = property;
            if (property instanceof String) {
                propertyValue = StringUtils.trim((String)((String)property));
            } else if (property instanceof JSONArray) {
                JSONArray arrJson = (JSONArray)property;
                int len = arrJson.length();
                String[] strArr = new String[len];
                for (int i = 0; i < len; ++i) {
                    strArr[i] = arrJson.getString(i);
                }
                propertyValue = strArr;
            }
            JcrResourceUtil.setProperty(node, name, propertyValue);
        }
    }

    public static void moveNode(ResourceResolver resolver, String sourceLocation, String destinationLocation) throws FormsMgrException {
        if (sourceLocation == null || "".equals(sourceLocation)) {
            log.error("Exception in moveNode() as source path is not valid");
            Object[] args = new Object[]{"sourceLocation", sourceLocation};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        if (destinationLocation == null || "".equals(destinationLocation)) {
            log.error("Exception in moveNode() as destination path is not valid");
            Object[] args = new Object[]{"destinationLocation", destinationLocation};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        Session session = resolver.adaptTo(Session.class);
        int index = sourceLocation.lastIndexOf("/");
        String nodeName = sourceLocation.substring(index);
        try {
            if (!session.nodeExists(sourceLocation)) {
                log.error("Exception in moveNode() as source location" + sourceLocation + "does not exist");
                Object[] args = new Object[]{"sourceLocation", sourceLocation};
                throw new FormsMgrException("AEM-FMG-700-001", args);
            }
            if (session.nodeExists(destinationLocation + nodeName)) {
                log.error("Exception in moveNode() as resource already exist at destination");
                Object[] args = new Object[]{nodeName, destinationLocation};
                throw new FormsMgrException("AEM-FMG-900-002", args);
            }
            session.move(sourceLocation, destinationLocation + nodeName);
            resolver.commit();
        }
        catch (FormsMgrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception in moveNode() while moving node from" + sourceLocation + "to" + destinationLocation, (Throwable)e);
            throw new FormsMgrException(e);
        }
    }

    public static String getClientlibPath(Node resourceNode) throws FormsMgrException {
        String clientLibProperty = "./jcr:content/metadata/clientlibRef";
        String clientLibPath = "";
        try {
            if (resourceNode != null && resourceNode.hasProperty(clientLibProperty)) {
                clientLibPath = resourceNode.getProperty(clientLibProperty).getString() + "/" + resourceNode.getName();
            }
        }
        catch (ValueFormatException e) {
            log.error("Exception in getClientlibNode()", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getClientlibNode()", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getClientlibNode()", (Throwable)e);
            throw new FormsMgrException(e);
        }
        return clientLibPath;
    }

    public static String getThemeRef(Session session, String path) throws FormsMgrException {
        String themeRefPath = null;
        try {
            Node formNode;
            Node metadataNode;
            if (session.nodeExists(path) && (metadataNode = FMUtils.getMetadataNode(formNode = session.getNode(path), false)) != null && metadataNode.hasProperty("themeRef")) {
                themeRefPath = metadataNode.getProperty("themeRef").getString();
            }
            return themeRefPath;
        }
        catch (ValueFormatException e) {
            log.error("Exception in getThemeRef() due to ValueFormatException", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getThemeRef() due to PathNotFoundException", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getThemeRef() due to RepositoryException", (Throwable)e);
            throw new FormsMgrException(e);
        }
    }

    public static String getCategoryNameFromClientLibPath(String clientLibPath) {
        String categoryName = "fdtheme";
        clientLibPath = clientLibPath.replace("/etc/clientlibs/fd/themes", "");
        clientLibPath = clientLibPath.replaceAll("\\s+", "");
        categoryName = categoryName + clientLibPath.replace("/", ".");
        return categoryName;
    }

    public static Node getRenditionNode(Node formNode, boolean create) throws FormsMgrException {
        Node renditionNode = null;
        Node contentNode = FMUtils.getContentNode(formNode, create);
        if (contentNode != null) {
            try {
                if (!contentNode.hasNode("renditions")) {
                    if (create) {
                        renditionNode = contentNode.addNode("renditions", "{http://www.jcp.org/jcr/nt/1.0}folder");
                    }
                } else {
                    renditionNode = contentNode.getNode("renditions");
                }
            }
            catch (RepositoryException e) {
                throw new FormsMgrException(e);
            }
        }
        return renditionNode;
    }

    public static String getResourceTitle(Resource resource) throws FormsMgrException {
        try {
            String title = null;
            Template template = resource.adaptTo(Template.class);
            if (template != null) {
                return template.getTitle();
            }
            ContentPolicy contentPolicy = resource.adaptTo(ContentPolicy.class);
            if (contentPolicy != null) {
                ValueMap contentPolicyProps = contentPolicy.getProperties();
                return contentPolicyProps.get("jcr:title", null);
            }
            Node resourceNode = resource.adaptTo(Node.class);
            Node metadataNode = FMUtils.getMetadataNode(resourceNode, false);
            if (metadataNode != null && metadataNode.hasProperty("title")) {
                title = metadataNode.getProperty("title").getString();
            }
            return title;
        }
        catch (ValueFormatException e) {
            log.error("Exception in getResourceTitle() due to ValueFormatException", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (PathNotFoundException e) {
            log.error("Exception in getResourceTitle() due to PathNotFoundException", (Throwable)e);
            throw new FormsMgrException(e);
        }
        catch (RepositoryException e) {
            log.error("Exception in getResourceTitle() due to RepositoryException", (Throwable)e);
            throw new FormsMgrException(e);
        }
    }

    public static FormsAssetType getFormsFoundationAssetType(FMConstants.CoreAssetType coreAssetType) throws FormsMgrException {
        FormsAssetType formsAssetType = null;
        switch (coreAssetType) {
            case FORM: {
                formsAssetType = FormsAssetType.XDP;
                break;
            }
            case RESOURCE: {
                formsAssetType = FormsAssetType.FM_RESOURCE;
                break;
            }
            case GUIDE: {
                formsAssetType = FormsAssetType.ADAPTIVE_FORM;
                break;
            }
            case FORMSET: {
                formsAssetType = FormsAssetType.FORMSET;
                break;
            }
            case AFFRAGMENT: {
                formsAssetType = FormsAssetType.ADAPTIVE_FORM_FRAGMENT;
                break;
            }
            case ADAPTIVEDOCUMENT: {
                formsAssetType = FormsAssetType.ADAPTIVE_DOCUMENT;
                break;
            }
            case THEME: {
                formsAssetType = FormsAssetType.THEME;
                break;
            }
            case PDFFORM: {
                formsAssetType = FormsAssetType.PDF;
                break;
            }
            case PRINTFORM: {
                formsAssetType = FormsAssetType.PRINT_FORM;
                break;
            }
            case FOLDER: {
                formsAssetType = FormsAssetType.FOLDER;
                break;
            }
            case NONFMASSET: 
            case ALL: {
                log.error("FM Asset Type " + (Object)((Object)coreAssetType) + " cannot be converted into FormsAssetType.");
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"FM Asset Type", coreAssetType.toString()});
            }
            default: {
                log.error("If there is any new addition in FM CoreAssetType, it should be handled here.");
                throw new FormsMgrException("AEM-FMG-700-001", new String[]{"FM Asset Type", coreAssetType.toString()});
            }
        }
        log.debug("FM Core Asset type : " + (Object)((Object)coreAssetType) + "converted into Forms Foundation Asset Type : " + formsAssetType);
        return formsAssetType;
    }

    public static boolean hasMixin(Node node, String mixinName) throws RepositoryException {
        if (node == null || mixinName == null) {
            return false;
        }
        NodeType[] nodeTypes = node.getMixinNodeTypes();
        if (nodeTypes != null) {
            for (NodeType nodeType : nodeTypes) {
                if (!mixinName.equals(nodeType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void addMixin(Node node, String[] mixinNames) throws FormsMgrException {
        if (node == null) {
            Object[] args = new Object[]{"asset path", node};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        if (mixinNames == null) {
            Object[] args = new Object[]{"mixins", mixinNames};
            throw new FormsMgrException("AEM-FMG-700-001", args);
        }
        try {
            for (String mixinName : mixinNames) {
                if (FMUtils.hasMixin(node, mixinName)) continue;
                node.addMixin(mixinName);
            }
        }
        catch (Exception e) {
            throw new FormsMgrException("AEM-FMG-700-026", e);
        }
    }
}

