/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.util;

import com.adobe.aem.formsndocuments.bootstrap.PrincipalImpl;
import com.adobe.aem.formsndocuments.exception.FormsNDocumentsException;
import com.adobe.granite.taskmanagement.Task;
import com.adobe.granite.taskmanagement.TaskManager;
import com.adobe.granite.taskmanagement.TaskManagerException;
import com.adobe.granite.workflow.exec.Status;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RnCUtil {
    public static final String PROJECT_TYPE = "project";
    public static final String PROJECT_SUB_TYPE = "projectsubtask";
    public static final String TASK_DUE_DATE = "taskDueDate";
    public static final String ASSET_PATH = "assetPath";
    public static final String REVIEWERS = "reviewers";
    public static final String REVIEW_NAME = "reviewName";
    public static final String REVIEW_ID = "reviewId";
    public static final String REVIEW_INITIATOR = "reviewInitiator";
    public static final String REVIEW_DESCRIPTION = "reviewDescription";
    public static final String REVIEW_PROJECT_NAME = "reviewProjectName";
    public static final String REVIEW_GROUP = "reviewGroup";
    public static final String REVIEW_DEADLINE = "reviewDeadline";
    public static final String UNDER_REVIEW = "underReview";
    public static final String REVIEW_CONTAINER_NODE_NAME = "reviewcontainer";
    public static final String REVIEW_TASKS_PATH = "/jcr:content/reviewcontainer/reviewtasks";
    private static final String USER_ID = "User Id";
    private static final String GROUP_ID = "Group Id";
    private static final String CRX_PATH = "CRX Path";
    private static final String PROJECT_NAME = "Project Name";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static Logger logger = LoggerFactory.getLogger(RnCUtil.class);

    public static boolean isTaskEligibleForUpdate(Status status) {
        return !Status.COMPLETE.equals((Object)status) && !Status.TERMINATED.equals((Object)status);
    }

    public static Boolean isMemberOfGroup(String groupId, String userId, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        logger.trace("Entering isMemberOfGroup.");
        if (groupId == null || groupId != null && groupId.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, groupId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        if (userId == null || userId != null && userId.isEmpty()) {
            Object[] args = new Object[]{USER_ID, userId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        User userAuthorizable = (User)um.getAuthorizable(userId);
        if (userAuthorizable == null) {
            Object[] args = new Object[]{USER_ID, userId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        if (userAuthorizable.isAdmin()) {
            return true;
        }
        Iterator<Group> grpItr = userAuthorizable.memberOf();
        while (grpItr.hasNext()) {
            Group group = grpItr.next();
            if (!groupId.equals(group.getID())) continue;
            return true;
        }
        logger.trace("Exiting isMemberOfGroup.");
        return false;
    }

    public static List<String> getGroupMembers(String groupId, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        logger.trace("Entering getGroupMembers.");
        if (groupId == null || groupId != null && groupId.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, groupId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        ArrayList<String> members = new ArrayList<String>();
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        Group reviewGroup = (Group)um.getAuthorizable(groupId);
        if (reviewGroup == null) {
            Object[] args = new Object[]{GROUP_ID, groupId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        Iterator<Authorizable> memberIterator = reviewGroup.getDeclaredMembers();
        while (memberIterator.hasNext()) {
            members.add(memberIterator.next().getID());
        }
        logger.trace("Exiting getGroupMembers.");
        return members;
    }

    public static List<Task> getProjectSubTasks(String reviewProjectName, ResourceResolver resourceResolver) throws FormsNDocumentsException, TaskManagerException {
        logger.trace("Entering getProjectSubTasks.");
        if (reviewProjectName == null || reviewProjectName != null && reviewProjectName.isEmpty()) {
            Object[] args = new Object[]{PROJECT_NAME, reviewProjectName};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        List<Task> subTaskList = null;
        TaskManager taskManager = resourceResolver.adaptTo(TaskManager.class);
        Task task = taskManager.getTask(reviewProjectName, true);
        if (task != null) {
            subTaskList = task.getSubTasks();
        }
        logger.trace("Exiting getProjectSubTasks.");
        return subTaskList;
    }

    public static ResourceResolver getResourceResolver(Session session, ResourceResolverFactory resourceResolverFactory) throws LoginException {
        logger.trace("Entering getResourceResolver.");
        HashMap<String, Object> authInfo = new HashMap<String, Object>(1);
        authInfo.put("user.jcr.session", session);
        ResourceResolver resourceResolver = resourceResolverFactory.getResourceResolver(authInfo);
        logger.trace("Exiting getResourceResolver.");
        return resourceResolver;
    }

    public static Node getNode(String assetPath, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering getNode.");
        if (assetPath == null || assetPath != null && assetPath.isEmpty()) {
            Object[] args = new Object[]{CRX_PATH, assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        Resource resource = resourceResolver.getResource(assetPath);
        logger.trace("Exiting getNode.");
        if (resource == null) {
            return null;
        }
        return resource.adaptTo(Node.class);
    }

    public static void removeGroup(String groupName, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        logger.trace("Entering removeGroup.");
        if (groupName == null || groupName != null && groupName.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, groupName};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        Authorizable authorizable = um.getAuthorizable(groupName);
        authorizable.remove();
        logger.trace("Exiting removeGroup.");
    }

    public static Group createGroup(String groupName, String relativePath, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        Group group;
        logger.trace("Entering createGroup.");
        if (groupName == null || groupName != null && groupName.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, groupName};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        if (relativePath == null || relativePath.isEmpty()) {
            group = um.createGroup(groupName);
        } else {
            PrincipalImpl principal = new PrincipalImpl(groupName);
            group = um.createGroup(groupName, principal, relativePath);
        }
        logger.trace("Exiting createGroup.");
        return group;
    }

    public static void addUserToGroup(String reviewer, String reviewGroupId, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        logger.trace("Entering addUserToGroup.");
        if (reviewGroupId == null || reviewGroupId != null && reviewGroupId.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, reviewGroupId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        if (reviewer == null || reviewer != null && reviewer.isEmpty()) {
            Object[] args = new Object[]{USER_ID, reviewer};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        Authorizable authorizable = um.getAuthorizable(reviewer);
        Group reviewGroup = (Group)um.getAuthorizable(reviewGroupId);
        reviewGroup.addMember(authorizable);
        logger.trace("Exiting addUserToGroup.");
    }

    public static void removeUserFromGroup(String reviewer, String reviewGroupId, ResourceResolver resourceResolver) throws FormsNDocumentsException, RepositoryException {
        logger.trace("Entering removeUserFromGroup.");
        if (reviewGroupId == null || reviewGroupId != null && reviewGroupId.isEmpty()) {
            Object[] args = new Object[]{GROUP_ID, reviewGroupId};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        if (reviewer == null || reviewer != null && reviewer.isEmpty()) {
            Object[] args = new Object[]{USER_ID, reviewer};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        UserManager um = resourceResolver.adaptTo(UserManager.class);
        Authorizable authorizable = um.getAuthorizable(reviewer);
        Group reviewGroup = (Group)um.getAuthorizable(reviewGroupId);
        reviewGroup.removeMember(authorizable);
        logger.trace("Exiting removeUserFromGroup.");
    }

    public static Task createProject(String reviewName, String assetPath, String deadline, String assignee, ResourceResolver bundleResourceResolver, ResourceResolver resourceResolver) throws FormsNDocumentsException, TaskManagerException {
        logger.trace("Entering createProject.");
        String reviewTasksRootPath = assetPath + REVIEW_TASKS_PATH;
        RnCUtil.checkAssetPathArgument(reviewTasksRootPath);
        RnCUtil.checkCreateReviewArguments(reviewName, new String[]{assignee}, deadline, bundleResourceResolver);
        Resource assetResource = resourceResolver.getResource(reviewTasksRootPath);
        TaskManager taskManager = assetResource.adaptTo(TaskManager.class);
        Task task = taskManager.getTaskManagerFactory().newTask(PROJECT_TYPE);
        task.setName(reviewName);
        task.setDescription(reviewName);
        task.setContentPath(assetPath);
        task.setProperty(TASK_DUE_DATE, deadline);
        task = taskManager.createTask(task);
        logger.trace("Exiting createProject.");
        return task;
    }

    public static void terminateProjectActiveTasks(String reviewProjectName, ResourceResolver resourceResolver) throws FormsNDocumentsException, TaskManagerException {
        logger.trace("Entering terminateProjectActiveTasks.");
        if (reviewProjectName == null || reviewProjectName != null && reviewProjectName.isEmpty()) {
            Object[] args = new Object[]{PROJECT_NAME, reviewProjectName};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        TaskManager taskManager = resourceResolver.adaptTo(TaskManager.class);
        Task task = taskManager.getTask(reviewProjectName, true);
        if (task != null && Status.ACTIVE.equals((Object)task.getStatus())) {
            List<Task> subTaskList = task.getSubTasks();
            if (subTaskList != null) {
                for (Task subTask : subTaskList) {
                    if (!RnCUtil.isTaskEligibleForUpdate(subTask.getStatus())) continue;
                    taskManager.terminateTask(subTask.getId());
                }
            }
            taskManager.completeTask(task.getId(), null);
        }
        logger.trace("Exiting terminateProjectActiveTasks.");
    }

    public static void updateProjectDeadline(String reviewProjectName, String deadline, ResourceResolver resourceResolver) throws FormsNDocumentsException, TaskManagerException {
        logger.trace("Entering updateProjectDeadline.");
        RnCUtil.checkReviewDeadlineArgument(deadline);
        TaskManager taskManager = resourceResolver.adaptTo(TaskManager.class);
        Task task = taskManager.getTask(reviewProjectName, true);
        if (task != null && Status.ACTIVE.equals((Object)task.getStatus())) {
            task.setProperty(TASK_DUE_DATE, deadline);
            taskManager.saveTask(task);
            List<Task> subTaskList = task.getSubTasks();
            if (subTaskList != null) {
                for (Task subTask : subTaskList) {
                    if (!RnCUtil.isTaskEligibleForUpdate(subTask.getStatus())) continue;
                    subTask.setProperty(TASK_DUE_DATE, deadline);
                    taskManager.saveTask(subTask);
                }
            }
        }
        logger.trace("Exiting updateProjectDeadline.");
    }

    public static void updateProjectDescription(String reviewProjectName, String description, ResourceResolver resourceResolver) throws TaskManagerException {
        logger.trace("Entering updateProjectDescription.");
        if (description == null) {
            return;
        }
        TaskManager taskManager = resourceResolver.adaptTo(TaskManager.class);
        Task task = taskManager.getTask(reviewProjectName, true);
        if (task != null && Status.ACTIVE.equals((Object)task.getStatus())) {
            task.setDescription(description);
            taskManager.saveTask(task);
            List<Task> subTaskList = task.getSubTasks();
            if (subTaskList != null) {
                for (Task subTask : subTaskList) {
                    if (!RnCUtil.isTaskEligibleForUpdate(subTask.getStatus())) continue;
                    subTask.setDescription(description);
                    taskManager.saveTask(subTask);
                }
            }
        }
        logger.trace("Exiting updateProjectDescription.");
    }

    public static Task createTask(String reviewProjectName, String reviewName, String deadline, String reviewer, String assetPath, String reviewDescription, ResourceResolver bundleResourceResolver, ResourceResolver resourceResolver) throws FormsNDocumentsException, TaskManagerException {
        logger.trace("Entering createTask.");
        RnCUtil.checkCreateReviewArguments(reviewName, new String[]{reviewer}, deadline, bundleResourceResolver);
        String reviewTasksRootPath = assetPath + REVIEW_TASKS_PATH;
        Resource assetResource = resourceResolver.getResource(reviewTasksRootPath);
        TaskManager taskManager = assetResource.adaptTo(TaskManager.class);
        Task task = taskManager.getTaskManagerFactory().newTask(PROJECT_SUB_TYPE);
        task.setName(reviewName);
        task.setDescription(reviewDescription);
        task.setCurrentAssignee(reviewer);
        task.setContentPath(assetPath);
        task.setProperty(TASK_DUE_DATE, deadline);
        task = taskManager.createTask(reviewProjectName, task);
        logger.trace("Exiting createTask.");
        return task;
    }

    public static boolean isInArray(String searchId, String[] idArray) {
        logger.trace("Entering isInArray.");
        if (searchId != null && idArray != null && idArray.length > 0) {
            for (String id : idArray) {
                if (!searchId.equals(id)) continue;
                logger.trace("Exiting isInArray.");
                return true;
            }
        }
        logger.trace("Exiting isInArray.");
        return false;
    }

    public static void checkCreateReviewArguments(String reviewName, String[] reviewerList, String deadline, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering checkCreateReviewArguments.");
        if (reviewName == null || reviewName != null && reviewName.isEmpty()) {
            Object[] args = new Object[]{REVIEW_NAME, reviewName};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        RnCUtil.checkUpdateReviewArguments(reviewerList, deadline, resourceResolver);
        logger.trace("Exiting checkCreateReviewArguments.");
    }

    public static void checkUpdateReviewArguments(String[] reviewerList, String deadline, ResourceResolver bundleResourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering checkUpdateReviewArguments.");
        if (reviewerList == null || reviewerList != null && reviewerList.length < 1) {
            Object[] args = new Object[]{REVIEWERS, reviewerList};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        String reviewerId = "";
        try {
            UserManager um = bundleResourceResolver.adaptTo(UserManager.class);
            String[] arr$ = reviewerList;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String reviewer;
                reviewerId = reviewer = arr$[i$];
                Authorizable authorizable = um.getAuthorizable(reviewer);
                if (authorizable != null) continue;
                Object[] args = new Object[]{reviewer};
                throw new FormsNDocumentsException("AEM-FMG-700-021", args);
            }
        }
        catch (RepositoryException e) {
            logger.error("User with id " + reviewerId + " doesn't exist ", (Throwable)e);
            Object[] args = new Object[]{reviewerId};
            throw new FormsNDocumentsException("AEM-FMG-700-021", args);
        }
        RnCUtil.checkReviewDeadlineArgument(deadline);
        logger.trace("Exiting checkUpdateReviewArguments.");
    }

    public static void checkReviewDeadlineArgument(String deadline) throws FormsNDocumentsException {
        logger.trace("Entering checkReviewDeadlineArgument.");
        if (deadline != null && !deadline.isEmpty()) {
            try {
                Date deadlineDate = sdf.parse(deadline);
                Date now = new Date();
                if (deadlineDate.compareTo(now) <= 0) {
                    Object[] args = null;
                    throw new FormsNDocumentsException("AEM-FMG-700-024", args);
                }
            }
            catch (ParseException e) {
                logger.error("Exception while parsing review deadline date format", (Throwable)e);
                Object[] args = new Object[]{REVIEW_DEADLINE, deadline};
                throw new FormsNDocumentsException("AEM-FMG-700-001", args);
            }
        }
        logger.trace("Exiting checkReviewDeadlineArgument.");
    }

    public static void checkAssetPathArgument(String assetPath) throws FormsNDocumentsException {
        logger.trace("Entering checkAssetPathArgument.");
        if (assetPath == null || assetPath != null && assetPath.isEmpty()) {
            Object[] args = new Object[]{ASSET_PATH, assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-001", args);
        }
        logger.trace("Exiting checkAssetPathArgument.");
    }

    public static Node checkNodeExistance(String assetPath, ResourceResolver resourceResolver) throws FormsNDocumentsException {
        logger.trace("Entering checkNodeExsistance.");
        Node asset = RnCUtil.getNode(assetPath, resourceResolver);
        if (asset == null) {
            Object[] args = new Object[]{assetPath};
            throw new FormsNDocumentsException("AEM-FMG-700-002", args);
        }
        logger.trace("Exiting checkNodeExsistance.");
        return asset;
    }
}

