/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.util;

import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.Rendition;
import com.day.cq.commons.ImageHelper;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.thumbnail.ThumbnailConfigImpl;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;

public class ThumbnailUtil {
    private static final String RENDITION_TO_CREATE_THUMBNAIL = "cq5dam.thumbnail.319.319.png";
    private static final String THUMBNAIL_MIMETYPE = "image/png";
    private static final Collection<ThumbnailConfig> thumbnailConfigs;

    public static void addThumbnail(Resource res, Iterator<Asset> members) throws IOException {
        int width = 319;
        int height = 319;
        Layer thumbnailLayer = new Layer(width, height, Color.WHITE);
        ArrayList<Layer> memberLayers = new ArrayList<Layer>();
        int assetCount = 0;
        while (members.hasNext() && assetCount < 4) {
            Asset member = members.next();
            Rendition rendition = member.getRendition(RENDITION_TO_CREATE_THUMBNAIL);
            if (rendition == null) continue;
            Layer memberLayer = ImageHelper.createLayer(rendition);
            memberLayers.add(memberLayer);
            ++assetCount;
        }
        for (int i = 0; i < memberLayers.size(); ++i) {
            Layer addedLayer;
            if (memberLayers.size() == 1) {
                thumbnailLayer = ThumbnailUtil.cropAsset((Layer)memberLayers.get(i), width, height);
                continue;
            }
            if (memberLayers.size() == 2) {
                addedLayer = ThumbnailUtil.cropAsset((Layer)memberLayers.get(i), width, height / 2);
                int posY = i * (1 + height / 2);
                thumbnailLayer.drawImage(addedLayer.getImage(), null, 0, posY);
                continue;
            }
            if (memberLayers.size() <= 2) continue;
            addedLayer = ThumbnailUtil.cropAsset((Layer)memberLayers.get(i), width / 2, height / 2);
            int posX = i % 2 * (1 + width / 2);
            int posY = (i > 1 ? 1 : 0) * (1 + height / 2);
            thumbnailLayer.drawImage(addedLayer.getImage(), null, posX, posY);
        }
        ThumbnailUtil.addThumbnailToAsset(res, thumbnailLayer);
    }

    public static void addThumbnailToAsset(Resource res, InputStream is) throws IOException {
        ThumbnailUtil.addThumbnailToAsset(res, new Layer(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addThumbnailToAsset(Resource res, Layer thumbnailLayer) throws IOException {
        Asset asset = res.adaptTo(Asset.class);
        BufferedImage image = thumbnailLayer.getImage();
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("thumbnail", ".tmp");
            ArrayList<ThumbnailConfig> cfg = new ArrayList<ThumbnailConfig>(thumbnailConfigs);
            Collections.sort(cfg, new Comparator<ThumbnailConfig>(){

                @Override
                public int compare(ThumbnailConfig o1, ThumbnailConfig o2) {
                    if (o1.getWidth() == o2.getWidth()) {
                        return o2.getHeight() - o1.getHeight();
                    }
                    return o2.getWidth() - o1.getWidth();
                }
            });
            Layer layer = null;
            for (ThumbnailConfig config : cfg) {
                if (layer == null || config.getWidth() > layer.getWidth() || config.getHeight() > layer.getHeight()) {
                    if (layer != null) {
                        layer.dispose();
                    }
                    layer = new Layer(image);
                }
                Layer tLayer = ThumbnailUtil.createThumb(layer, config);
                FileOutputStream out = null;
                FileInputStream in = null;
                try {
                    out = FileUtils.openOutputStream((File)tmpFile);
                    tLayer.write(THUMBNAIL_MIMETYPE, 0.8, out);
                    IOUtils.closeQuietly((OutputStream)out);
                    in = FileUtils.openInputStream((File)tmpFile);
                    HashMap<String, Object> rhMap = new HashMap<String, Object>();
                    rhMap.put("rendition.mime", THUMBNAIL_MIMETYPE);
                    asset.setRendition(DamUtil.getThumbnailName(config), in, rhMap);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly((OutputStream)out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                if (tLayer == layer) continue;
                tLayer.dispose();
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tmpFile);
        }
    }

    private static Layer cropAsset(Layer layer, int width, int height) {
        Rectangle cropRect = new Rectangle(0, 0, width, height);
        Layer outputLayer = new Layer(width, height, Color.WHITE);
        Layer cropLayer = layer;
        cropLayer.crop(cropRect);
        outputLayer.merge(cropLayer);
        return outputLayer;
    }

    private static Layer createThumb(Layer layer, ThumbnailConfig config) {
        Layer finalLayer = null;
        int maxWidth = config.getWidth();
        int maxHeight = config.getHeight();
        boolean doCenter = config.doCenter();
        int width = layer.getWidth();
        int height = layer.getHeight();
        Color bgColor = layer.getBackgroundColor();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = width * maxHeight / height;
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = height * maxWidth / width;
                }
            } else {
                newWidth = maxWidth;
                newHeight = height * maxWidth / width;
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = width * maxHeight / height;
                }
            }
            layer.resize(newWidth, newHeight, true);
        }
        if ((layer.getHeight() < maxHeight || layer.getWidth() < maxWidth) && doCenter) {
            Color bg = null != bgColor ? bgColor : Color.WHITE;
            finalLayer = new Layer(maxWidth, maxHeight, bg);
            finalLayer.setTransparency(bg);
            int y = (maxHeight - layer.getHeight()) / 2;
            int x = (maxWidth - layer.getWidth()) / 2;
            layer.setX(x);
            layer.setY(y);
            finalLayer.merge(layer);
        }
        if (finalLayer == null) {
            return layer;
        }
        return finalLayer;
    }

    static {
        ThumbnailConfigImpl config1 = new ThumbnailConfigImpl(140, 100, false);
        ThumbnailConfigImpl config2 = new ThumbnailConfigImpl(48, 48, false);
        ThumbnailConfigImpl config3 = new ThumbnailConfigImpl(319, 319, false);
        thumbnailConfigs = Arrays.asList(config1, config2, config3);
    }
}

