/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.cache;

import com.adobe.aemds.guide.cache.Cache;
import com.adobe.aemds.guide.cache.api.CacheConfig;
import com.adobe.aemds.guide.cache.api.CacheStore;
import com.adobe.aemds.guide.cache.api.CacheStoreProvider;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, metatype=true, label="Adaptive Form Cache Manager", description="Adaptive Form Cache Manager Service")
@Service(value={CacheManager.class})
public class CacheManager {
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private static float LOAD_FACTOR = 0.75f;
    @Reference
    private CacheStoreProvider provider;
    @Reference
    private AdaptiveFormConfigurationService configuration;
    private CacheConfig existingCacheConfig;

    protected void activate() {
        int maximumEntries = this.configuration.maximumCacheEntries();
        CacheConfig cacheConfig = new CacheConfig((int)((float)maximumEntries * LOAD_FACTOR), maximumEntries);
        if (this.existingCacheConfig != null && this.existingCacheConfig.getMaximumEntries() != cacheConfig.getMaximumEntries()) {
            Set<String> cacheNames = this.caches.keySet();
            this.caches.clear();
            for (String cacheName : cacheNames) {
                this.caches.put(cacheName, this.getNewCache(this.existingCacheConfig));
            }
        }
        this.existingCacheConfig = cacheConfig;
    }

    private Cache getNewCache(CacheConfig cacheConfig) {
        CacheStore cacheStore = this.provider.newCacheStore(cacheConfig);
        return new Cache(cacheStore);
    }

    public void dumpCacheInfo() {
    }

    public Cache getOrCreateCache(String cacheName) {
        if (!this.caches.containsKey(cacheName)) {
            int maximumEntries = this.configuration.maximumCacheEntries();
            CacheConfig cacheConfig = new CacheConfig((int)((float)maximumEntries * LOAD_FACTOR), maximumEntries);
            this.caches.put(cacheName, this.getNewCache(cacheConfig));
        }
        return this.caches.get(cacheName);
    }

    protected void bindProvider(CacheStoreProvider cacheStoreProvider) {
        this.provider = cacheStoreProvider;
    }

    protected void unbindProvider(CacheStoreProvider cacheStoreProvider) {
        if (this.provider == cacheStoreProvider) {
            this.provider = null;
        }
    }

    protected void bindConfiguration(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        this.configuration = adaptiveFormConfigurationService;
    }

    protected void unbindConfiguration(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        if (this.configuration == adaptiveFormConfigurationService) {
            this.configuration = null;
        }
    }
}

