/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.cache.impl;

import com.adobe.aemds.guide.cache.CacheObject;
import com.adobe.aemds.guide.cache.api.CacheStore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCacheStore
implements CacheStore {
    private Logger logger = LoggerFactory.getLogger(LRUCacheStore.class);
    private Map<Object, CacheObject> cache;
    private int maxEntries;

    public LRUCacheStore(int initialCapacity, int entries) {
        this.maxEntries = entries;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<Object, CacheObject>(initialCapacity + 1, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCacheStore.this.maxEntries;
            }
        });
    }

    public CacheObject get(Object key) {
        return this.cache.get(key);
    }

    public CacheObject put(Object key, CacheObject value) {
        return this.cache.put(key, value);
    }

    public void clearAll() {
        this.cache.clear();
    }

    public void clear(String key) {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
    }

    public boolean entryExists(Object key) {
        return this.cache.containsKey(key);
    }
}

