/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.cq.sightly.WCMUse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class AEMForm
extends WCMUse {
    public static final int NO_FORM_SELECTED = -1;
    public static final int MOBILE_FORM = 1;
    public static final int ADAPTIVE_FORM = 2;
    public static final int MOBILE_FORMSET = 3;
    public static final int INLINE_SUBMIT = 4;
    public static final int PAGE_REFRESH_SUBMIT = 5;
    private static final int THANKYOU_PAGE = 6;
    private static final int THANKYOU_MESSAGE = 7;
    protected Resource mResource;
    protected ValueMap mResourceProps;

    public void activate() throws Exception {
        this.mResource = this.getResource();
        this.mResourceProps = this.getProperties();
        SlingHttpServletRequest request = this.getRequest();
        request.setAttribute("formContainerPath", this.mResource.getPath());
    }

    protected String getClientLibCategory(String themePath) {
        if ("".equals(themePath)) {
            return "";
        }
        Resource themeResource = this.getResource().getResourceResolver().getResource(themePath + "/jcr:content/metadata");
        if (themeResource == null) {
            throw new GuideException("Invalid Theme Name " + themePath);
        }
        ValueMap themeProps = themeResource.getValueMap();
        return themeProps.get("clientlibCategory", "");
    }

    public String getThemeName() {
        return this.getClientLibCategory(this.getThemeRef());
    }

    public String getFormPath() {
        return this.mResourceProps.get("formRef", "");
    }

    protected String getThemeRef() {
        return this.mResourceProps.get("themeRef", "");
    }

    public String getFormEditPagePath() {
        return this.getFormPath();
    }

    public int getFormType() {
        if ("".equals(this.getFormPath())) {
            return -1;
        }
        ResourceResolver resolver = this.mResource.getResourceResolver();
        Resource formResource = resolver.getResource(this.getFormPath());
        if (formResource == null) {
            throw new GuideException("Invalid Form Path set");
        }
        Resource jcrContent = formResource.getChild("jcr:content");
        if (jcrContent == null) {
            throw new GuideException("Invalid Form Path set. No jcr:content node inside Form");
        }
        ValueMap props = jcrContent.getValueMap();
        if (props.get("guide", 0) == 1 || props.get("adaptivedocument", 0) == 1) {
            return 2;
        }
        return 1;
    }

    public boolean getIsAdaptiveForm() {
        return this.getFormType() == 2;
    }

    public boolean getIsMobileForm() {
        return this.getFormType() == 1;
    }

    public boolean getIsMobileFormset() {
        return this.getFormType() == 3;
    }

    public boolean getIsFormSelected() {
        return this.getFormType() != -1;
    }

    public String getSubmitType() {
        if ("message".equals(this.getThankyouConfig())) {
            return "inline";
        }
        return this.mResourceProps.get("submitType", "inline");
    }

    public String getThankyouMessage() {
        return this.mResourceProps.get("thankyouMessage", "");
    }

    public String getThankyouPage() {
        return this.mResourceProps.get("thankyouPage", "");
    }

    public String getThankyouConfig() {
        return this.mResourceProps.get("thankyouConfig", "page");
    }

    public String getHeight() {
        String height = this.mResourceProps.get("height", "auto");
        if (!"auto".equals(height)) {
            try {
                height = Integer.parseInt(height) + "px";
            }
            catch (NumberFormatException ex) {
                height = "auto";
            }
        }
        return height;
    }

    public String getCssClientlib() {
        return this.mResourceProps.get("cssClientlib", "");
    }
}

