/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.AEMForm;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.api.Page;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class AdaptiveForm
extends AEMForm {
    public String getFormPagePath() {
        String formPath = super.getFormPath();
        return GuideUtils.guideRefToGuidePath(formPath);
    }

    public String getFormEditPagePath() {
        String formPagePath = this.getFormPagePath();
        return formPagePath.substring(0, formPagePath.indexOf("/jcr:content"));
    }

    public String getFormTitle() {
        String pageTitle = this.getFormPageTitle();
        return pageTitle != null ? pageTitle : this.getFormPageName();
    }

    private String getFormPageTitle() {
        return this.getFormPage().getTitle();
    }

    private String getFormPageName() {
        return this.getFormPage().getName();
    }

    private Page getFormPage() {
        return this.getFormPageResource().adaptTo(Page.class);
    }

    private Resource getFormPageResource() {
        return this.getGuideContainerResource().getParent().getParent();
    }

    private Resource getGuideContainerResource() {
        return this.getResourceResolver().getResource(this.getFormPagePath());
    }

    public String getFormThemeName() {
        Resource resource = this.getResourceResolver().getResource(this.getFormPagePath());
        String clientLibName = this.getThemeName();
        ValueMap valueMap = resource.getValueMap();
        if ("".equals(clientLibName) && resource != null) {
            String formThemeRef = valueMap.get("themeRef", "");
            String formClientLib = this.getClientLibCategory(formThemeRef);
            if ("".equals(formClientLib)) {
                clientLibName = this.getCssClientlib();
            } else {
                return "";
            }
        }
        if ("".equals(clientLibName)) {
            String containerType = valueMap.get("sling:resourceType", "");
            clientLibName = "fd/adaddon/components/guideDocumentContainer".equals(containerType) ? "guide.theme.ad" : "guide.theme2.default";
        }
        return clientLibName;
    }

    public String getAcceptLangParamString() {
        String lang;
        String usePageLocale = (String)this.mResourceProps.get("usePageLocale");
        if (usePageLocale != null && usePageLocale.equals("true") && (lang = (String)this.getPageProperties().get("jcr:language")) != null && !lang.isEmpty()) {
            return "&afAcceptLang=" + lang;
        }
        return "";
    }
}

