/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.ExpressionEditorResourcePropertyTransformer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class AdaptiveFormResourcePropertyTransformer
extends ExpressionEditorResourcePropertyTransformer {
    private Map<String, Integer> elementSOMMap = new HashMap<String, Integer>();

    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        ValueMap props = resource.adaptTo(ValueMap.class);
        if ("layout".equals(resource.getName()) || "guideCompositeFieldItem".equals(props.get("guideNodeClass"))) {
            return null;
        }
        JSONObject obj = new JSONObject();
        if (!"items".equals(resource.getName())) {
            String name = props.get("name", null);
            String type = props.get("sling:resourceType", null);
            String fragRef = (String)props.get("fragRef");
            if (fragRef != null) {
                type = "FRAGMENT";
            }
            if (name == null) {
                name = resource.getName();
            }
            if ("fd/af/components/guideContainer".equals(type)) {
                name = "Form Container";
            } else if ("fd/adaddon/components/guideDocumentContainer".equals(type)) {
                name = "Document Container";
            }
            String id = name;
            if (parentSOM.length() > 0) {
                String key = id = parentSOM + "." + name;
                Integer somCounter = this.elementSOMMap.get(key);
                int counter = 0;
                if (somCounter != null) {
                    counter = somCounter;
                    id = parentSOM + "." + name + "[" + counter + "]";
                }
                this.elementSOMMap.put(key, counter + 1);
            }
            obj.put("id", id);
            obj.put("fragRef", fragRef);
            obj.put("name", name);
            obj.put("type", type);
            obj.put("displayName", props.get("jcr:title"));
            obj.put("path", resource.getPath());
        }
        return obj;
    }
}

