/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.ResourcePropertyTransformer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class ExpressionEditorResourcePropertyTransformer
implements ResourcePropertyTransformer {
    private static final Map<String, String> nodeClassToTypeMap = new HashMap<String, String>();
    private static final String[] expressionTypes;
    private Map<String, Integer> elementSOMMap = new HashMap<String, Integer>();

    public String getType(String guideNodeClass) {
        String result = nodeClassToTypeMap.get(guideNodeClass);
        if (result == null) {
            result = guideNodeClass;
        }
        return result;
    }

    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        ValueMap props = resource.adaptTo(ValueMap.class);
        if ("layout".equals(resource.getName()) || "guideCompositeFieldItem".equals(props.get("guideNodeClass"))) {
            return null;
        }
        JSONObject obj = new JSONObject();
        if (!"items".equals(resource.getName())) {
            int index;
            String name = (String)props.get("name");
            String nodeClass = (String)props.get("guideNodeClass");
            if (StringUtils.isEmpty((CharSequence)nodeClass)) {
                return null;
            }
            String type = this.getType(nodeClass);
            if (type == null) {
                return null;
            }
            if (props.containsKey("completionExpReq") && ((Boolean)((Object)props.get("completionExpReq", Boolean.class))).booleanValue()) {
                type = type + "|NAVIGABLE_PANEL";
            }
            if (props.containsKey("summaryExpVisible") && "yes".equals(props.get("summaryExpVisible", String.class))) {
                type = type + "|REPEATABLE_PANEL";
            }
            if ("FORM".equals(type)) {
                name = "FORM";
            }
            if ((index = parentSOM.lastIndexOf(46)) >= 0 && "toolbar".equals(parentSOM.substring(index + 1)) && "guideButton".equals(nodeClass)) {
                type = type + "|TOOLBAR_BUTTON";
            }
            String id = name;
            if (parentSOM.length() > 0) {
                String key = id = parentSOM + "." + name;
                Integer somCounter = this.elementSOMMap.get(key);
                int counter = 0;
                if (somCounter != null) {
                    counter = somCounter;
                    id = parentSOM + "." + name + "[" + counter + "]";
                }
                this.elementSOMMap.put(key, counter + 1);
            }
            obj.put("id", id);
            obj.put("SOM", id);
            obj.put("name", name);
            obj.put("type", type);
            obj.put("status", this.getStatus(props));
            obj.put("displayName", props.get("jcr:title"));
            obj.put("options", this.getOptions(props));
            obj.put("path", resource.getPath());
            obj.put("path", resource.getPath());
            obj.put("resourceType", props.get("sling:resourceType"));
            String fragRef = (String)props.get("fragRef");
            obj.put("isFragment", StringUtils.isNotEmpty((CharSequence)fragRef));
        }
        return obj;
    }

    private JSONObject getOptions(ValueMap props) throws JSONException {
        Object options = props.get("options");
        if (options != null && options instanceof String[]) {
            String[] optionStrings = (String[])options;
            JSONObject jsonObject = new JSONObject();
            for (String optionString : optionStrings) {
                String value;
                if (!StringUtils.isNotBlank((CharSequence)optionString)) continue;
                String[] parts = optionString.split("=");
                String label = value = parts[0];
                if (parts.length > 1) {
                    label = parts[1];
                }
                jsonObject.put(value, label);
            }
            return jsonObject;
        }
        return null;
    }

    private String getStatus(ValueMap props) throws JSONException {
        String status;
        block3: {
            block2: {
                status = "none";
                if (!props.containsKey("expJson")) break block2;
                String jsonString = (String)props.get("expJson");
                JSONObject expJson = new JSONObject(jsonString);
                JSONArray rules = (JSONArray)expJson.get("items");
                if (rules.length() <= 0) break block3;
                boolean isValid = true;
                for (int i = 0; i < rules.length() && isValid; ++i) {
                    JSONObject rule = (JSONObject)rules.get(i);
                    isValid = rule.has("isValid") ? rule.getBoolean("isValid") : true;
                }
                status = isValid ? "valid" : "invalid";
                break block3;
            }
            for (String script : expressionTypes) {
                if (!props.containsKey(script)) continue;
                status = "valid";
                break;
            }
        }
        return status;
    }

    static {
        nodeClassToTypeMap.put("rootPanelNode", "ROOTPANEL|PANEL|AFCOMPONENT");
        nodeClassToTypeMap.put("guidePanel", "PANEL|AFCOMPONENT");
        nodeClassToTypeMap.put("guideRadioButton", "RADIO BUTTON|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideDropDownList", "DROP DOWN|FIELD|AFCOMPONENT|STRING|DROPDOWN");
        nodeClassToTypeMap.put("guideChart", "CHART|AFCOMPONENT");
        nodeClassToTypeMap.put("guideCheckBox", "CHECK BOX|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideSwitch", "SWITCH|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideFileUpload", "FILE ATTACHEMENT|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTextBox", "TEXT FIELD|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideButton", "BUTTON|AFCOMPONENT");
        nodeClassToTypeMap.put("guideContainerNode", "FORM");
        nodeClassToTypeMap.put("guideDatePicker", "DATE FIELD|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideImage", "IMAGE|AFCOMPONENT");
        nodeClassToTypeMap.put("guideNumericBox", "NUMBER FIELD|FIELD|AFCOMPONENT|NUMBER");
        nodeClassToTypeMap.put("guidePasswordBox", "PASSWORD FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideScribble", "SCRIBBLE FIELD|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTermsAndConditions", "TERMS AND CONDITIONS|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTextDraw", "STATIC TEXT|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTable", "TABLE|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTableRow", "TABLE ROW|AFCOMPONENT");
        expressionTypes = new String[]{"clickExp", "navigationChangeExp", "visibleExp", "initScript", "calcExp", "valueCommitScript", "validateExp", "completionExp", "summaryExp", "optionsExp", "enabledExp"};
    }
}

