/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideIntegrationService;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.forms.common.service.FormsCommonConfigurationService;
import com.adobe.forms.common.utils.TempStorageUtils;
import com.day.cq.i18n.I18n;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideContainer
extends GuideNode {
    private GuideModelTransformer guideModelTransformer = null;
    private String defaultDataXml = null;
    private boolean renderCall = false;

    public GuideContainer() {
    }

    public GuideContainer(SlingHttpServletRequest request, Resource resource) {
        this.setResource(resource);
        this.setSlingRequest(request);
    }

    public GuideContainer(Resource resource) {
        this.setResource(resource);
    }

    public String getRedirect() {
        String redirect = this.resourceProps.get("redirect", "");
        if (redirect.length() > 0) {
            int lastSlash = redirect.lastIndexOf(47);
            if (redirect.indexOf(46, lastSlash) == -1) {
                redirect = redirect + ".html";
            }
        } else {
            redirect = this.getPath() + "." + "guideThankYouPage.html";
        }
        return redirect;
    }

    public void setMaxCallCounter(SlingHttpServletRequest request) {
        AdaptiveFormConfigurationService adaptiveFormConfigurationService;
        boolean setSlingMaxCalls = false;
        SlingBindings slingBindings = GuideUtils.getSlingBinding(request);
        if (slingBindings != null && (adaptiveFormConfigurationService = slingBindings.getSling().getService(AdaptiveFormConfigurationService.class)) != null) {
            setSlingMaxCalls = adaptiveFormConfigurationService.isSlingMaxCallValueSmall();
        }
        if (setSlingMaxCalls && request.getAttribute("sling.max.calls") == null) {
            try {
                request.setAttribute("sling.max.calls", 20000);
            }
            catch (Exception e) {
                this.logger.error("Cannot increase sling max call value", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        String referredXsdOrXdp = "";
        try {
            if (!this.getXdpRef().equals("")) {
                referredXsdOrXdp = this.getXdpRef();
                authoringConfig.put("xdpRef", referredXsdOrXdp);
            } else if (!this.getXsdRef().equals("")) {
                referredXsdOrXdp = this.getXsdRef();
                authoringConfig.put("xsdRef", referredXsdOrXdp);
            }
        }
        catch (Exception e) {
            this.logger.error("AF: Unable to fetch xsdRef or xdpRef" + e.getMessage(), (Throwable)e);
        }
        return authoringConfig;
    }

    public String getXdpRef() {
        return this.resourceProps.get("xdpRef", "");
    }

    public String getLetterRef() {
        return this.resourceProps.get("letterRef", "");
    }

    public String getAutoSaveStrategyFilePath() {
        String autoSaveStrategyType = this.resourceProps.get("autoSaveStrategyType", "");
        if (autoSaveStrategyType != null && !autoSaveStrategyType.isEmpty()) {
            return autoSaveStrategyType;
        }
        return null;
    }

    public String getDorTemplateRef() {
        return this.resourceProps.get("dorTemplateRef", "");
    }

    public Calendar getLastModifiedTime() throws RepositoryException {
        ValueMap properties = this.resource.getParent().adaptTo(ValueMap.class);
        return (Calendar)((Object)properties.get("cq:lastModified", Calendar.class));
    }

    public String getXsdRef() {
        return this.resourceProps.get("xsdRef", "");
    }

    public String getCssFileRef() {
        return this.resourceProps.get("cssFileRef", null);
    }

    @Override
    public String getClientLibRef() {
        return this.resourceProps.get("clientLibRef", null);
    }

    public boolean isHasToolbar() {
        return this.resource.getChild("toolbar") != null;
    }

    public String getAfPath() {
        return this.resourceProps.get("afPath", null);
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.resource.getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            guideItemsContainer.setResource(toolbarResource);
            guideItemsContainer.setSlingRequest(this.slingRequest);
            return guideItemsContainer;
        }
        return null;
    }

    public GuidePanel getRootPanel() {
        return GuideUtils.getRootPanel(this.resource, this.slingRequest);
    }

    public boolean isGuideSyncRequired() {
        boolean hasXDP = !"".equals(this.getXdpRef());
        return hasXDP && this.resourceProps.containsKey("formModelChanged");
    }

    public boolean isShowAuthoringWarnings() {
        String resourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        boolean showWarnings = true;
        if ("fd/adaddon/components/guideDocumentContainer".equals(resourceType)) {
            showWarnings = false;
        }
        return showWarnings;
    }

    public String getStatusBarTitle() {
        I18n i18n = new I18n(this.slingRequest.getResourceBundle(this.slingRequest.getLocale()));
        return i18n.get("Adaptive Form Warnings");
    }

    public String getMobileLayout() {
        String returnLayout = "fd/af/layouts/mobile/simple";
        String mobileLayout = null;
        try {
            mobileLayout = (String)this.getLayoutProperty("mobileLayout");
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving mobile layout. " + e.getMessage(), (Throwable)e);
        }
        if (mobileLayout != null && !mobileLayout.isEmpty()) {
            returnLayout = mobileLayout;
        }
        return returnLayout;
    }

    public Boolean getParseGridLayoutForMenu() {
        Boolean parseGridLayoutForMenu = null;
        try {
            parseGridLayoutForMenu = Boolean.valueOf(String.valueOf(this.getLayoutProperty("parseGridLayoutForMenu")));
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving parseGridLayoutForMenu check. " + e.getMessage(), (Throwable)e);
        }
        if (parseGridLayoutForMenu == null) {
            parseGridLayoutForMenu = Boolean.FALSE;
        }
        return parseGridLayoutForMenu;
    }

    public String getXDPName() {
        String xdpRef = this.getXdpRef();
        if (xdpRef != null && xdpRef.length() > 0) {
            return StringUtils.substring((String)xdpRef, (int)(StringUtils.lastIndexOf((CharSequence)xdpRef, (CharSequence)"/") + 1));
        }
        return null;
    }

    public boolean isXDPValid() {
        return GuideUtils.isXDPValid(this.resource);
    }

    public void setGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    private GuideModelTransformer getGuideModelTransformer() {
        SlingBindings bindings = GuideUtils.getSlingBinding(this.getSlingRequest());
        if (bindings == null) {
            return this.guideModelTransformer;
        }
        return bindings.getSling().getService(GuideModelTransformer.class);
    }

    private Map<String, String> getXfaJsonMap() throws GuideException {
        String xdpRef = this.getXdpRef();
        Map<String, String> xfaJsonMap = null;
        Boolean isValidXdp = xdpRef != null && xdpRef.length() > 0 && this.isXDPValid();
        if (isValidXdp.booleanValue()) {
            GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
            xfaJsonMap = guideModelTransformer.exportXfaJson(this.resource);
        }
        return xfaJsonMap;
    }

    public String getXfaRenderContext() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String renderContext = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("xfaRenderContext")) {
            renderContext = xfaJsonMap.get("xfaRenderContext");
        }
        return renderContext;
    }

    public String getXfaJson() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String xfaJson = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("formdom")) {
            xfaJson = xfaJsonMap.get("formdom");
        }
        return xfaJson;
    }

    public String getGuideCurrentStateJson() {
        String guideStatePathRef;
        String guideCurrentStateJson = "";
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        String guideStatePath = (String)this.slingRequest.getAttribute("guideStatePath");
        if (guideStatePath == null || guideStatePath.isEmpty()) {
            guideStatePath = this.slingRequest.getParameter("guideStatePath");
        }
        if ((guideStatePathRef = (String)this.slingRequest.getAttribute("guideStatePathRef")) == null || guideStatePathRef.isEmpty()) {
            guideStatePathRef = this.slingRequest.getParameter("guideStatePathRef");
        }
        if (guideStatePath != null && !guideStatePath.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideState(guideStatePath);
        } else if (guideStatePathRef != null && !guideStatePathRef.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideStateFromStore(guideStatePathRef);
        }
        if (guideCurrentStateJson.length() == 0) {
            String prefillService;
            String data;
            boolean dataPresent = false;
            JSONCreationOptions options = new JSONCreationOptions();
            options.setI18n(this.i18n).setFormContainerPath(this.getFormContainerPath());
            String dataRef = (String)this.slingRequest.getAttribute("dataRef");
            if (dataRef == null || dataRef.isEmpty()) {
                dataRef = this.slingRequest.getParameter("dataRef");
            }
            if (dataRef != null && !dataRef.isEmpty()) {
                options.setDataRef(dataRef);
                dataPresent = true;
            }
            if ((data = (String)this.slingRequest.getAttribute("data")) == null || data.isEmpty()) {
                data = this.slingRequest.getParameter("data");
            }
            if (data != null && !data.isEmpty()) {
                options.setDataRef(null).setData(data);
                dataPresent = true;
            }
            if ((prefillService = (String)this.resourceProps.get("prefillService")) != null) {
                dataPresent = true;
            }
            if (dataPresent) {
                guideCurrentStateJson = guideModelTransformer.getDataJson(this.resource, options);
            }
        }
        return guideCurrentStateJson;
    }

    private String getFormContainerPath() {
        if (this.slingRequest == null) {
            return null;
        }
        String formContainerPath = (String)this.slingRequest.getAttribute("formContainerPath");
        if (formContainerPath == null) {
            formContainerPath = this.slingRequest.getParameter("formContainerPath");
        }
        return formContainerPath;
    }

    public String getGuideCurrentStateJson(String dataXml) {
        JSONCreationOptions options = new JSONCreationOptions();
        options.setData(dataXml).setI18n(this.i18n).setFormContainerPath(this.getFormContainerPath());
        return this.guideModelTransformer.getDataJson(this.resource, options);
    }

    public String getGuideContext() {
        return this.exportInitialGuideContext();
    }

    public String getGuideJson() {
        I18n i18ntemp = this.i18n;
        if (this.slingRequest != null && this.getIsEditMode().booleanValue()) {
            i18ntemp = null;
        }
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        return guideModelTransformer.exportGuideJson(this.resource, i18ntemp);
    }

    public String getLayout() {
        String layoutpath = "";
        try {
            Map<String, Object> layoutproperties = null;
            String containerName = GuideContainerThreadLocal.getGuideContainerName();
            layoutproperties = containerName != null ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, containerName) : (GuideUtils.isGuideContainerResource(this.resource) ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, this.resource.getName()) : NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, "guideContainer"));
            layoutpath = (String)layoutproperties.get("sling:resourceType");
            if (layoutpath.startsWith("/libs/") || layoutpath.startsWith("/apps/")) {
                layoutpath = layoutpath.substring(6);
            }
        }
        catch (Exception ex) {
            this.logger.error("Unable to get layout of guide container" + ex.getMessage());
            throw new GuideException(ex.getMessage(), ex);
        }
        return layoutpath;
    }

    public List<String> getGuideIntegrationServiceScriptPaths() {
        SlingBindings bindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
        GuideIntegrationService guideIntegrationService = bindings.getSling().getService(GuideIntegrationService.class);
        return guideIntegrationService.getScriptPaths();
    }

    private String createGuideInitializationState(String dataXml, String locale) {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter(jsonStringWriter);
        GuideModelTransformer guideTransformer = this.getGuideModelTransformer();
        Map<String, Object> jsonMap = guideTransformer.syncXfaProps(this, locale);
        try {
            jsonWriter.object();
            jsonWriter.key("guidejson").value((String)jsonMap.get("guidejson"));
            jsonWriter.key("guidecontext").value(this.getGuideContext());
            String mergedJson = dataXml != null ? this.getGuideCurrentStateJson(dataXml) : this.getGuideCurrentStateJson();
            jsonWriter.key("guidemergedjson").value(mergedJson);
            jsonWriter.key("xfajson").value((String)jsonMap.get("xfajson"));
            jsonWriter.key("xfarendercontext").value(this.getXfaRenderContext());
            jsonWriter.endObject();
        }
        catch (JSONException ex) {
            this.logger.error("Error in getting guide initialization state" + ex.getMessage());
            throw new GuideException(ex.getMessage(), ex);
        }
        return jsonStringWriter.toString();
    }

    public String getGuideInitializationState() {
        String locale = GuideUtils.getGuideRuntimeLocale(this.slingRequest, this.resource);
        return this.createGuideInitializationState(null, locale);
    }

    public String getGuideInitializationState(String dataXml, String locale) {
        return this.createGuideInitializationState(dataXml, locale);
    }

    public void setRenderCall(boolean isRenderCall) {
        this.renderCall = isRenderCall;
    }

    public boolean isRenderCall() {
        return this.renderCall;
    }

    public JSONObject getCustomContextPropJson(HttpServletRequest request) {
        Object attr = request.getAttribute("customContextProperty");
        JSONObject customContextPropJson = new JSONObject();
        if (attr != null) {
            try {
                customContextPropJson = new JSONObject(attr.toString());
            }
            catch (JSONException e) {
                this.logger.error("Failed to parse JSON for customContextProperty attribute", (Throwable)e);
            }
        }
        return customContextPropJson;
    }

    public String getPagePath() {
        String path = "";
        Resource parent = this.resource;
        while ((parent = parent.getParent()) != null) {
            if (!parent.isResourceType("foundation/components/page") && !parent.isResourceType("wcm/foundation/components/page")) continue;
            path = parent.getPath();
        }
        return path;
    }

    private String exportInitialGuideContext() throws GuideException {
        JSONObject contextObject = new JSONObject();
        try {
            SlingBindings bindings;
            SlingHttpServletRequest slingRequest;
            String guideName = this.getName();
            ValueMap guideProps = this.getResource().adaptTo(ValueMap.class);
            contextObject.put("guidePath", this.getPath());
            contextObject.put("guideName", guideName);
            if (guideProps.containsKey("xsdRef")) {
                contextObject.put("xsdRef", guideProps.get("xsdRef", ""));
            }
            if (guideProps.containsKey("xdpRef") && GuideUtils.isXDPValid(this.getResource())) {
                contextObject.put("xdpRef", guideProps.get("xdpRef", ""));
            }
            if ((slingRequest = this.getSlingRequest()) != null && (bindings = GuideUtils.getSlingBinding(this.getSlingRequest())) != null) {
                FormsCommonConfigurationService formsCommonConfigurationService = bindings.getSling().getService(FormsCommonConfigurationService.class);
                AdaptiveFormConfigurationService adaptiveFormConfigurationService = bindings.getSling().getService(AdaptiveFormConfigurationService.class);
                boolean isAnonymous = slingRequest.getAuthType() == null;
                String tempStorageConfig = formsCommonConfigurationService.getTempStorageConfig();
                contextObject.put("disablePreview", TempStorageUtils.isPreviewDisabled(tempStorageConfig, isAnonymous));
                contextObject.put("makeFileNameUnique", adaptiveFormConfigurationService.getMakeFileNamesUnique());
                contextObject.put("scriptingBehaviourVersion", adaptiveFormConfigurationService.getScriptingCompatibilityMode());
            }
        }
        catch (Exception e) {
            this.logger.error("Error in getting guideContext", (Throwable)e);
            throw new GuideException(e);
        }
        return contextObject.toString();
    }
}

