/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.day.cq.wcm.foundation.Image;
import com.day.cq.wcm.foundation.Placeholder;
import java.io.IOException;
import java.io.Serializable;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;

public class GuideImage
extends GuideField
implements Serializable {
    private Image image;

    public String getImageSrc() throws RepositoryException, IOException {
        this.image = new Image(this.resource);
        Boolean containsData = this.image.getData() != null;
        Boolean containsBindRef = !this.image.get("bindRef").isEmpty();
        Boolean isTouchMode = Placeholder.isAuthoringUIModeTouch((ServletRequest)this.slingRequest);
        this.image.setIsInUITouchMode(isTouchMode);
        if (containsData.booleanValue()) {
            this.image.setSelector(".img");
            return this.image.getSrc();
        }
        if (containsBindRef.booleanValue()) {
            return "";
        }
        return "/libs/fd/af/components/guideimage/icon.jpg";
    }

    public String getStyles() {
        String style = "";
        String width = this.getWidth();
        String height = this.getHeight();
        style = style + (width.length() > 0 ? "width:" + width + "%;" : "");
        style = style + (height.length() > 0 ? "height:" + height + "px;" : "");
        return style;
    }

    public String getDropTargetClass() throws RepositoryException {
        if (this.image.getData() == null) {
            return "cq-placeholder cq-dd-image";
        }
        return "cq-dd-image";
    }

    public String getAltText() {
        String altText = this.resourceProps.get("altText", "");
        if ("".equals(altText)) {
            String title = this.resourceProps.get("jcr:title", "");
            altText = "".equals(title) ? this.resourceProps.get("name", "") : title;
        }
        return this.externalize(altText);
    }

    public String getHeight() {
        return this.resourceProps.get("height", "");
    }

    public String getGuideFieldType() {
        return "guideImage";
    }
}

