/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.WCMMode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidePanel
extends GuideItemsContainer
implements Serializable {
    public int getMinOccur() {
        return this.resourceProps.get("minOccur", 1);
    }

    public int getMaxOccur() {
        return this.resourceProps.get("maxOccur", 1);
    }

    public int getInitialOccur() {
        return this.resourceProps.get("initialOccur", 1);
    }

    public String getFragRefPropertyFromResource() {
        return this.resourceProps.get("fragRef", "");
    }

    public String getFragRef() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        String fragRefContainerPath = "";
        String fragRefRootPanelPath = "";
        if (fragRefAssetPath.length() > 0) {
            fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRefAssetPath);
            Resource fragRefRootPanel = GuideUtils.getRootPanel(this.resource.getResourceResolver().getResource(fragRefContainerPath));
            if (fragRefRootPanel != null) {
                fragRefRootPanelPath = fragRefRootPanel.getPath();
            }
        }
        return fragRefRootPanelPath;
    }

    public boolean isFragmentAvailable() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        Resource fragmentContainer = resourceResolver.getResource(fragRefAssetPath);
        if (fragmentContainer != null) {
            String fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRefAssetPath);
            Resource fragRefRootPanel = GuideUtils.getRootPanel(this.resource.getResourceResolver().getResource(fragRefContainerPath));
            if (fragRefRootPanel != null) {
                return true;
            }
        }
        return false;
    }

    public Map<String, String> getFragmentDetails() {
        ResourceResolver resourceResolver;
        HashMap<String, String> fragDetails = new HashMap<String, String>();
        String fragRef = this.getFragRef();
        XSSAPI xssApi = this.getXssapi();
        StringBuilder fragFieldDetails = new StringBuilder("");
        if (fragRef.length() > 0 && (resourceResolver = this.getResource().getResourceResolver()) != null) {
            Resource fragment = resourceResolver.getResource(fragRef.substring(0, fragRef.indexOf("guideContainer") - 1));
            String title = (String)fragment.adaptTo(ValueMap.class).get("jcr:title");
            fragDetails.put("title", GuideELUtils.encodeForHtml(title, xssApi));
            Resource fragRefRootPanel = fragment.getChild("guideContainer").getChild("rootPanel");
            if (fragRefRootPanel != null) {
                int numberOfFieldsListed = 0;
                for (Resource itemResource : fragRefRootPanel.getChild("items").getChildren()) {
                    ValueMap itemValueMap = ResourceUtil.getValueMap(itemResource);
                    String fieldLabel = itemValueMap.get("jcr:title", "");
                    if (fieldLabel == null || fieldLabel.length() == 0) {
                        fieldLabel = itemValueMap.get("name", "");
                    }
                    if (!StringUtils.isEmpty((String)fieldLabel)) {
                        GuideELUtils.encodeForHtml(fieldLabel, xssApi);
                        fragFieldDetails.append(fieldLabel).append("<br>");
                    }
                    if (++numberOfFieldsListed != GuideConstants.NO_OF_FIELDS_TO_DISPLAY_FOR_FRAG_PLACEHOLDER) continue;
                    break;
                }
                fragDetails.put("fieldDetails", fragFieldDetails.toString());
            }
        }
        return fragDetails;
    }

    public String getOptimizeRenderPerformance() {
        return this.resourceProps.get("optimizeRenderPerformance", "");
    }

    public String getAssetRef() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        String optimizeRenderLayout = this.getOptimizeRenderPerformance();
        if (StringUtils.isNotEmpty((String)fragRefAssetPath) && StringUtils.isNotEmpty((String)optimizeRenderLayout)) {
            return fragRefAssetPath;
        }
        return null;
    }

    public String getLayoutFromFragRootPanel() {
        Resource layout;
        ResourceResolver resourceResolver;
        Resource fragRefRootPanel;
        String fragRef = this.getFragRef();
        if (fragRef.length() > 0 && (fragRefRootPanel = (resourceResolver = this.resource.getResourceResolver()).getResource(fragRef)) != null && (layout = fragRefRootPanel.getChild("layout")) != null) {
            return (String)layout.adaptTo(ValueMap.class).get("sling:resourceType");
        }
        return null;
    }

    public String getAfFragmentMarker() {
        String afFragmentClass = "";
        SlingHttpServletRequest request = this.slingRequest;
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        if (fragRefAssetPath.length() > 0 && WCMMode.EDIT.equals((Object)WCMMode.fromRequest((ServletRequest)request))) {
            afFragmentClass = "afFragmentMarker";
        }
        return afFragmentClass;
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        Boolean nonNavigable = Boolean.FALSE;
        try {
            nonNavigable = Boolean.valueOf((String)this.getLayoutProperty("nonNavigable"));
        }
        catch (PersistenceException e) {
            this.logger.error("AF: Unable to fetch nonNavigable property" + e.getMessage(), (Throwable)e);
        }
        authoringConfig.put("nonNavigable", nonNavigable);
        return authoringConfig;
    }

    public String getPanelInlineStyles() {
        return this.getInlineStyles("Panel");
    }

    public String getPanelDescriptionInlineStyles() {
        return this.getInlineStyles("PanelDescription");
    }

    @Override
    public boolean getIsRepeatable() {
        return this.getMinOccur() != 1 || this.getMaxOccur() != 1;
    }

    public boolean isHasToolbar() {
        return this.resource.getChild("toolbar") != null;
    }

    public String getLongDescription() {
        return this.externalize(this.resourceProps.get("longDescription", ""));
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.resource.getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            guideItemsContainer.setResource(toolbarResource);
            guideItemsContainer.setSlingRequest(this.slingRequest);
            return guideItemsContainer;
        }
        return null;
    }

    public void updateCompletionAndSummary(Resource layoutNode) throws PersistenceException {
        ModifiableValueMap layoutproperties = layoutNode.adaptTo(ModifiableValueMap.class);
        if (layoutproperties == null) {
            return;
        }
        String layoutCmpPath = (String)layoutproperties.get("sling:resourceType");
        if (layoutCmpPath != null) {
            ResourceResolver resolver = this.resource.getResourceResolver();
            Resource panel = layoutNode.getParent();
            if (panel != null) {
                Resource getChildrenResource = panel.getChild("items");
                if (getChildrenResource != null) {
                    Iterator<Resource> it = getChildrenResource.listChildren();
                    while (it.hasNext()) {
                        Resource child = it.next();
                        ModifiableValueMap childMap = child.adaptTo(ModifiableValueMap.class);
                        String guideNodeClass = childMap.get("guideNodeClass", "");
                        if (!guideNodeClass.equals("rootPanelNode") && !guideNodeClass.equals("guidePanel")) continue;
                        String oldValue = childMap.get("summaryExpVisible", "");
                        if (layoutCmpPath.equals("fd/af/layouts/panel/accordion")) {
                            if (oldValue.length() != 0 && oldValue.equals("yes")) continue;
                            childMap.put("summaryExpVisible", "yes");
                            continue;
                        }
                        if (oldValue.length() <= 0) continue;
                        childMap.remove("summaryExpVisible");
                    }
                }
                String wizardTabLayout = (String)layoutproperties.get("guideNavigatorTab");
                ModifiableValueMap panelValueMap = panel.adaptTo(ModifiableValueMap.class);
                boolean compOldValue = panelValueMap.get("completionExpReq", false);
                if ("wizard-tab".equals(wizardTabLayout)) {
                    if (!compOldValue) {
                        panelValueMap.put("completionExpReq", true);
                    }
                } else if (compOldValue) {
                    panelValueMap.put("completionExpReq", false);
                }
                resolver.commit();
            }
        }
    }

    private void setLayoutProperties(Resource layoutNode) throws PersistenceException {
        if (layoutNode != null) {
            ResourceResolver resolver;
            Resource layoutCmp;
            ModifiableValueMap layoutproperties = layoutNode.adaptTo(ModifiableValueMap.class);
            if (layoutproperties == null) {
                return;
            }
            String layoutCmpPath = (String)layoutproperties.get("sling:resourceType");
            if (layoutCmpPath != null && (layoutCmp = (resolver = this.resource.getResourceResolver()).getResource(layoutCmpPath)) != null) {
                Boolean currentEnableLayoutOptimization;
                Boolean enableLayoutOptimization;
                String currentIsNonNavigable;
                String isNonNavigable;
                String currentVal;
                ValueMap layoutCmpProps = ResourceUtil.getValueMap(layoutCmp);
                String tabType = layoutCmpProps.get("guideNavigatorTab", "tab");
                if (!StringUtils.equals((String)tabType, (String)(currentVal = layoutproperties.get("guideNavigatorTab", "tab")))) {
                    layoutproperties.put("guideNavigatorTab", tabType);
                }
                if (!StringUtils.equals((String)(isNonNavigable = layoutCmpProps.get("nonNavigable", "false")), (String)(currentIsNonNavigable = layoutproperties.get("nonNavigable", "false")))) {
                    layoutproperties.put("nonNavigable", isNonNavigable);
                }
                if ((enableLayoutOptimization = layoutCmpProps.get("enableLayoutOptimization", false)) != (currentEnableLayoutOptimization = layoutproperties.get("enableLayoutOptimization", false))) {
                    layoutproperties.put("enableLayoutOptimization", enableLayoutOptimization);
                }
                resolver.commit();
            }
        }
    }

    @Override
    public void setSlingRequest(SlingHttpServletRequest slingRequest) {
        super.setSlingRequest(slingRequest);
        Resource layout = this.resource.getChild("layout");
        if (this.getIsEditMode().booleanValue() && layout != null) {
            try {
                this.setLayoutProperties(layout);
                this.updateCompletionAndSummary(layout);
            }
            catch (PersistenceException e) {
                this.logger.error("AF: Unable to set layout Properties" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

