/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.progressive;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import java.io.StringWriter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class GuideProgressiveField {
    private String id;
    private String path;
    private String prefixId;
    private ResourceResolver resourceResolver;
    private String fragRefPreviousPrefixID = null;

    public GuideProgressiveField(String id, String path, String prefixId, ResourceResolver resourceResolver) {
        this.id = id;
        this.path = path;
        this.prefixId = prefixId;
        this.resourceResolver = resourceResolver;
    }

    public String convertToJSON() {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter(jsonStringWriter);
        try {
            jsonWriter.object();
            jsonWriter.key("id").value(this.getId());
            jsonWriter.key("path").value(this.getPath());
            jsonWriter.key("prefixId").value(this.getPrefixId());
            jsonWriter.endObject();
        }
        catch (JSONException ex) {
            throw new GuideException(ex.getMessage(), ex);
        }
        return jsonStringWriter.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getPrefixId() {
        return this.prefixId;
    }

    public void getMarkedFragmentPrefixId() {
        GuideFragmentHolder guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
        if (guideFragmentHolder != null) {
            this.fragRefPreviousPrefixID = guideFragmentHolder.getFragPrefixID();
        }
        GuideContainerThreadLocal.setGuideFragmentHolder(this.prefixId, null, null, null);
    }

    public void getUnmarkedFragmentPrefixId() {
        GuideContainerThreadLocal.setGuideFragmentHolder(this.fragRefPreviousPrefixID, null, null, null);
    }
}

