/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.progressive;

import com.adobe.aemds.guide.progressive.GuideProgressiveField;
import com.adobe.aemds.guide.service.GuideException;
import java.io.StringWriter;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideProgressiveSectionInfo {
    private String id;
    private String title;
    private String name;
    private List<GuideProgressiveField> fields;
    private String repeatablePanelId;
    private Boolean fetchedFromService = true;
    private String repeatablePanelPath;

    public GuideProgressiveSectionInfo() {
    }

    public String convertToJSON() {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter(jsonStringWriter);
        try {
            jsonWriter.object();
            jsonWriter.key("id").value(this.getId());
            jsonWriter.key("title").value(this.getTitle());
            jsonWriter.key("name").value(this.getName());
            List<GuideProgressiveField> fieldList = this.getFields();
            JSONArray fieldJsonArray = new JSONArray();
            for (int i = 0; i < fieldList.size(); ++i) {
                GuideProgressiveField field = fieldList.get(i);
                JSONObject obj = new JSONObject();
                obj.put("id", field.getId());
                obj.put("path", field.getPath());
                obj.put("prefixId", field.getPrefixId());
                fieldJsonArray.put(obj);
            }
            jsonWriter.key("fields").value(fieldJsonArray);
            jsonWriter.key("repeatablePanelPath").value(this.getRepeatablePanelPath());
            jsonWriter.key("repeatablePanelId").value(this.getRepeatablePanelId());
            jsonWriter.key("fetchedFromService").value(this.getFetchedFromService());
            jsonWriter.key("guideNodeClass").value("guideProgressiveSection");
            jsonWriter.endObject();
        }
        catch (JSONException ex) {
            throw new GuideException(ex.getMessage(), ex);
        }
        return jsonStringWriter.toString();
    }

    public GuideProgressiveSectionInfo(String id, String title, String name, List<GuideProgressiveField> fields, String repeatablePanelPath, String repeatablePanelId) {
        this.id = id;
        this.title = title;
        this.fields = fields;
        this.name = name;
        this.repeatablePanelPath = repeatablePanelPath;
        this.repeatablePanelId = repeatablePanelId;
    }

    public GuideProgressiveSectionInfo(String id, String title, String name, List<GuideProgressiveField> fields, String repeatablePanelPath, String repeatablePanelId, Boolean fetchedFromService) {
        this(id, title, name, fields, repeatablePanelPath, repeatablePanelId);
        this.fetchedFromService = fetchedFromService;
    }

    public String getFetchedFromService() {
        return String.valueOf(this.fetchedFromService);
    }

    public String getRepeatablePanelId() {
        return this.repeatablePanelId;
    }

    public String getRepeatablePanelPath() {
        return this.repeatablePanelPath;
    }

    public List<GuideProgressiveField> getFields() {
        return this.fields;
    }

    public void setFields(List<GuideProgressiveField> fields) {
        this.fields = fields;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name == null ? this.getId() : this.name;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

