/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.progressive;

import com.adobe.aemds.guide.progressive.GuideProgressiveCompletionInfo;
import com.adobe.aemds.guide.progressive.GuideProgressiveField;
import com.adobe.aemds.guide.progressive.GuideProgressiveSectionInfo;
import com.adobe.aemds.guide.service.GuideProgressiveStrategy;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.cq.sightly.WCMUse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideProgressiveSectionManager
extends WCMUse {
    private GuideProgressiveSectionInfo guideProgressiveSectionInfo;
    private List<Object> allSections;
    private GuideProgressiveCompletionInfo guideProgressiveCompletionInfo;
    private Boolean fetchedFromService;
    private String serviceType;
    private static Logger log = LoggerFactory.getLogger(GuideProgressiveSectionManager.class);

    public Boolean getFetchedFromService() {
        return this.fetchedFromService;
    }

    public List<Object> getAllSections() {
        return this.allSections;
    }

    public String getSectionJSON() {
        if (this.guideProgressiveCompletionInfo == null) {
            if (this.guideProgressiveSectionInfo != null) {
                return this.guideProgressiveSectionInfo.convertToJSON();
            }
            return "";
        }
        return this.guideProgressiveCompletionInfo.convertToJSON();
    }

    private JSONArray extractJsonArrayFromJSONObject(JSONObject jsonObject, String arg) {
        JSONArray result = new JSONArray();
        if (jsonObject.has(arg)) {
            try {
                result = (JSONArray)jsonObject.get(arg);
            }
            catch (Exception e) {
                log.error("Error while extracting JSON Array from JSON Object", (Throwable)e);
            }
        }
        return result;
    }

    private String extractFromJSONObject(JSONObject jsonObject, String arg) {
        String result = "";
        if (jsonObject.has(arg)) {
            try {
                result = (String)jsonObject.get(arg);
            }
            catch (Exception e) {
                log.error("Error while extracting value from JSON Object", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void activate() throws Exception {
        String sectionId;
        SlingHttpServletRequest request = this.getRequest();
        ValueMap properties = this.getProperties();
        RequestParameterMap params = request.getRequestParameterMap();
        String afAssetPath = properties.get("guideRef", "");
        String type = properties.get("guideStrategyType", "");
        String progressiveStrategyName = properties.get("strategyName", "");
        String progressiveStrategyParams = properties.get("guideProgressiveStrategyParams", "");
        String progressiveStrategyJcrPath = properties.get("strategyJcrPath", "");
        this.fetchedFromService = Boolean.TRUE;
        Map<String, String> paramMap = GuideUtils.convertStringToMap(progressiveStrategyParams);
        paramMap.put("sectionFieldValue", GuideUtils.paramToString(params.getValue("sectionFieldValue")));
        paramMap.put("strategyJcrPath", progressiveStrategyJcrPath);
        String currentSectionId = GuideUtils.paramToString(params.getValue("currentSectionId"));
        paramMap.put("renderCurrentSection", GuideUtils.paramToString(params.getValue("renderCurrentSection")));
        String lastSectionInfo = request.getParameter("lastSectionInfo");
        JSONObject lastSectionInfoJSONObject = null;
        if (lastSectionInfo != null && (sectionId = this.extractFromJSONObject(lastSectionInfoJSONObject = new JSONObject(lastSectionInfo), "id")) != null && !sectionId.isEmpty()) {
            JSONArray sectionFields = this.extractJsonArrayFromJSONObject(lastSectionInfoJSONObject, "fields");
            ArrayList<GuideProgressiveField> sectionFieldsList = new ArrayList<GuideProgressiveField>();
            if (sectionFields != null && sectionFields.length() > 0) {
                for (int i = 0; i < sectionFields.length(); ++i) {
                    JSONObject field = sectionFields.getJSONObject(i);
                    String id = field.getString("id");
                    String path = field.getString("path");
                    String prefixId = null;
                    if (field.has("prefixId")) {
                        prefixId = field.getString("prefixId");
                    }
                    GuideProgressiveField progressiveField = new GuideProgressiveField(id, path, prefixId, this.getResourceResolver());
                    sectionFieldsList.add(progressiveField);
                }
            }
            if (sectionFieldsList.size() > 0) {
                this.fetchedFromService = Boolean.FALSE;
                String repeatablePanelPath = this.extractFromJSONObject(lastSectionInfoJSONObject, "repeatablePanelPath");
                String repeatablePanelId = this.extractFromJSONObject(lastSectionInfoJSONObject, "repeatablePanelId");
                String sectionTitle = this.extractFromJSONObject(lastSectionInfoJSONObject, "title");
                String sectionName = this.extractFromJSONObject(lastSectionInfoJSONObject, "name");
                if (repeatablePanelId != null && repeatablePanelId.isEmpty() && repeatablePanelPath != null && !repeatablePanelPath.isEmpty()) {
                    ResourceResolver resourceResolver = this.getResourceResolver();
                    Resource repeatablePanelResource = resourceResolver.getResource(repeatablePanelPath);
                    repeatablePanelId = NodeStructureUtils.getGuideNodeHtmlId(repeatablePanelResource);
                }
                this.guideProgressiveSectionInfo = new GuideProgressiveSectionInfo(sectionId, sectionTitle, sectionName, sectionFieldsList, repeatablePanelPath, repeatablePanelId, this.fetchedFromService);
            } else if ("completion".equals(sectionId)) {
                this.fetchedFromService = Boolean.FALSE;
                String completionTitle = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionTitle");
                String completionBeforeMessage = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionBeforeMessage");
                String completionAfterMessage = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionAfterMessage");
                String completionScript = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionScript");
                String completionButtonText = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionButtonText");
                String completionSuccessScript = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionSuccessScript");
                String completionFailureScript = this.extractFromJSONObject(lastSectionInfoJSONObject, "completionFailureScript");
                this.guideProgressiveCompletionInfo = new GuideProgressiveCompletionInfo(completionTitle, completionBeforeMessage, completionAfterMessage, completionScript, completionButtonText, completionSuccessScript, completionFailureScript, this.fetchedFromService);
            }
        }
        if ("service".equals(type) && this.fetchedFromService.booleanValue()) {
            paramMap.put("fetchedFromService", this.fetchedFromService.toString());
            GuideProgressiveStrategyManager guideProgressiveStrategyManager = this.getSlingScriptHelper().getService(GuideProgressiveStrategyManager.class);
            GuideProgressiveStrategy guideProgressiveStrategy = guideProgressiveStrategyManager.getGuideProgressiveStrategyService(progressiveStrategyName);
            this.serviceType = guideProgressiveStrategy.getServiceType();
            if (this.allSections == null || this.allSections.size() == 0) {
                this.allSections = guideProgressiveStrategy.getAllSections(paramMap);
            }
            if (guideProgressiveStrategy != null) {
                this.guideProgressiveSectionInfo = guideProgressiveStrategy.getNextSection(afAssetPath, currentSectionId, paramMap);
                if (this.guideProgressiveSectionInfo == null) {
                    this.guideProgressiveCompletionInfo = guideProgressiveStrategy.getCompletionSection(afAssetPath, paramMap);
                }
            }
        }
    }

    public GuideProgressiveSectionInfo getGuideProgressiveSectionInfo() {
        return this.guideProgressiveSectionInfo;
    }

    public GuideProgressiveCompletionInfo getGuideProgressiveCompletionInfo() {
        return this.guideProgressiveCompletionInfo;
    }
}

