/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Adaptive Form Configuration Service")
@Service(value={AdaptiveFormConfigurationService.class})
public class AdaptiveFormConfigurationServiceImpl
implements AdaptiveFormConfigurationService {
    private Logger logger = LoggerFactory.getLogger(AdaptiveFormConfigurationServiceImpl.class);
    @Property(name="showPlaceholder", boolValue={true}, label="Enable Placeholder in place of Fragment", description="Show a Placeholder instead of Fragment in authoring mode")
    private Boolean showPlaceholder;
    private static final String VISUAL_EDITOR_MODE_DISPLAY_STRING = "Visual Editor";
    private static final String CODE_EDITOR_MODE_DISPLAY_STRING = "Code Editor";
    @Property(value={"1"}, label="Default Mode for Rule Editor", description="Set visual editor or code editor as the default mode for the rule editor.", options={@PropertyOption(name="1", value="Visual Editor"), @PropertyOption(name="2", value="Code Editor")})
    private static final String RULE_EDITOR_DEFAULT_MODE_PROPERTY = "af.ruleeditor.defaultmode";
    private String ruleEditorDefaultMode;
    @Property(name="maximumCacheEntries", intValue={100}, label="Number of Adaptive Forms", description="Maximum number of entries for Adaptive Forms to cache")
    private static int maximumEntries;
    private static final String[] DEFAULT_WSDL_SEARCH_PATHS;
    @Property(value={"/apps", "/libs"}, label="WSDL Config Search Paths", description="The list of absolute paths in repository which are searched for webservices configurations shown in Expression Builder.")
    public static final String WSDL_CONFIG_SEARCH_PATH = "af.wsdl.config.search.paths";
    private String[] searchPaths;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    ConfigurationAdmin configurationAdmin;
    private static final String COMPATIBILITY_MODE_61 = "AEM6.1";
    private static final String COMPATIBILITY_MODE_NONE = "None";
    @Property(value={"None"}, label="Adaptive Forms Version for Compatibility", description="Adaptive Forms Version for Compatibility", options={@PropertyOption(name="AEM6.1", value="AEM Forms 6.1"), @PropertyOption(name="None", value="None")})
    private static final String COMPAT_VERSION = "af.scripting.compatversion";
    private String compatibilityVersion;
    @Property(name="makeFileNameUnique", boolValue={false}, label="Make File Names Unique", description="Make all file names unique while submission")
    private Boolean makeFileNamesUnique;
    @Property(name="preventLiveLinkingFields", boolValue={false}, label="Prevent Sync of Same Mapped Fields", description="All Fields having same xsd schema BindRef or name (in case it's unbound) can have different values during runtime, but will be clobbered in submit xml")
    private Boolean preventLiveLinkingFields;

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.showPlaceholder = PropertiesUtil.toBoolean(props.get("showPlaceholder"), false);
        this.ruleEditorDefaultMode = PropertiesUtil.toString(props.get(RULE_EDITOR_DEFAULT_MODE_PROPERTY), "1");
        maximumEntries = PropertiesUtil.toInteger(props.get("maximumCacheEntries"), 100);
        this.searchPaths = PropertiesUtil.toStringArray(props.get(WSDL_CONFIG_SEARCH_PATH), DEFAULT_WSDL_SEARCH_PATHS);
        this.compatibilityVersion = PropertiesUtil.toString(props.get(COMPAT_VERSION), COMPATIBILITY_MODE_NONE);
        this.makeFileNamesUnique = PropertiesUtil.toBoolean(props.get("makeFileNameUnique"), false);
        this.preventLiveLinkingFields = PropertiesUtil.toBoolean(props.get("preventLiveLinkingFields"), false);
    }

    public boolean getShowPlaceholder() {
        return this.showPlaceholder;
    }

    public String getRuleEditorDefaultMode() {
        return this.ruleEditorDefaultMode;
    }

    public boolean isSlingMaxCallValueSmall() {
        if (this.configurationAdmin != null) {
            try {
                Configuration cfg = this.configurationAdmin.getConfiguration("org.apache.sling.engine.impl.SlingMainServlet", null);
                Dictionary props = cfg.getProperties();
                if (props != null) {
                    Object property = props.get("sling.max.calls");
                    int slingMaxCalls = 1000;
                    if (property != null) {
                        slingMaxCalls = Integer.parseInt(property.toString());
                    }
                    if (slingMaxCalls > 20000) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Cannot get config from sling main servlet", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public int maximumCacheEntries() {
        return maximumEntries;
    }

    public String[] getWSDLConfigSearchPaths() {
        return this.searchPaths;
    }

    public String getScriptingCompatibilityMode() {
        return this.compatibilityVersion;
    }

    public Boolean getMakeFileNamesUnique() {
        return this.makeFileNamesUnique;
    }

    public Boolean getPreventLiveLinkingFields() {
        return this.preventLiveLinkingFields;
    }

    static {
        DEFAULT_WSDL_SEARCH_PATHS = new String[]{"/apps", "/libs"};
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }
}

