/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.AdaptiveFormsDataService;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.utils.AdaptiveFormData;
import com.adobe.aemds.guide.utils.AdaptiveFormInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.aemds.guide.utils.guideJson.EmbeddedFormsData;
import com.adobe.aemds.guide.utils.guideJson.EmbeddedFormsDataCollector;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonItemsTraverser;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, immediate=true, label="Adaptive Forms Data Service", description="Service to gather User Data from Adaptive Forms")
@Service(value={AdaptiveFormsDataService.class})
public class AdaptiveFormsDataServiceImpl
implements AdaptiveFormsDataService {
    private Logger logger = LoggerFactory.getLogger(AdaptiveFormsDataServiceImpl.class);
    @Reference
    private GuideModelTransformer guideModelTransformer;

    @Override
    public List<AdaptiveFormData> getEmbeddedAdaptiveFormsData(AdaptiveFormInfo adaptiveFormInfo) {
        String xmlStr = adaptiveFormInfo.getXmlStr();
        Resource formSetResource = adaptiveFormInfo.getFormResource();
        List<FileAttachmentWrapper> attachmentWrappers = adaptiveFormInfo.getAttachments();
        Document formSetDoc = XMLUtils.strToDoc(xmlStr);
        ResourceResolver resolver = formSetResource.getResourceResolver();
        Element fsBoundRoot = XMLUtils.getBoundDataXmlElement(formSetDoc);
        Element fsUnBoundRoot = XMLUtils.getUnboundDataXmlElement(formSetDoc);
        JSONObject formSetJson = GuideUtils.getFormJson(formSetResource, this.guideModelTransformer);
        String formSetRoot = XMLUtils.extractXsdRootElement(formSetJson);
        ArrayList<AdaptiveFormData> formSetXmlData = new ArrayList<AdaptiveFormData>();
        List<EmbeddedFormsData> embeddedForms = this.getEmbeddedForms(formSetJson);
        for (EmbeddedFormsData form : embeddedForms) {
            Resource formResource = GuideUtils.getFormResource(formSetResource, form.getFragRef());
            JSONObject formJson = GuideUtils.getFormJson(formResource, this.guideModelTransformer);
            String bindRefPrefix = form.getBindRef();
            String formRoot = XMLUtils.extractXsdRootElement(formJson);
            String childBoundRootXpath = XMLUtils.getChildBoundRootXpath(formSetRoot, bindRefPrefix, formRoot);
            boolean keepBoundPart = StringUtils.isNotBlank((CharSequence)(formSetRoot + formRoot));
            Document formXml = XMLUtils.getChildXmlDoc(fsUnBoundRoot, fsBoundRoot, childBoundRootXpath, keepBoundPart);
            List<String> attachmentNames = XMLUtils.extractAttachmentNames(formXml);
            formSetXmlData.add(new AdaptiveFormData(XMLUtils.docToStr(formXml), bindRefPrefix, form.getFragRef(), this.getFormAttachmentsWrappers(attachmentNames, attachmentWrappers)));
        }
        return formSetXmlData;
    }

    private List<FileAttachmentWrapper> getFormAttachmentsWrappers(List<String> attachmentNames, List<FileAttachmentWrapper> attachmentWrappers) {
        ArrayList<FileAttachmentWrapper> formAttachments = new ArrayList<FileAttachmentWrapper>();
        if (attachmentNames != null) {
            for (String attachmentName : attachmentNames) {
                FileAttachmentWrapper attachmentWrapper = GuideUtils.findFileAttachment(attachmentWrappers, attachmentName);
                if (attachmentWrapper == null) continue;
                formAttachments.add(attachmentWrapper);
            }
        }
        return formAttachments;
    }

    private List<EmbeddedFormsData> getEmbeddedForms(JSONObject guideJson) {
        ArrayList<GuideJsonVisitor> visitors = new ArrayList<GuideJsonVisitor>();
        EmbeddedFormsDataCollector embeddedFormsDataCollector = new EmbeddedFormsDataCollector();
        visitors.add(embeddedFormsDataCollector);
        GuideJsonItemsTraverser guideJsonTraverser = new GuideJsonItemsTraverser(guideJson, visitors);
        guideJsonTraverser.traverse();
        return embeddedFormsDataCollector.getEmbeddedForms();
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }
}

