/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.progressive.GuideProgressiveCompletionInfo;
import com.adobe.aemds.guide.progressive.GuideProgressiveField;
import com.adobe.aemds.guide.progressive.GuideProgressiveSectionInfo;
import com.adobe.aemds.guide.service.GuideProgressiveStrategy;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, label="Content Structure based Progressive Strategy", description="Content Structure Progressive Strategy Service")
@Service(value={GuideProgressiveStrategy.class})
public class ContentStructureProgressiveStrategy
implements GuideProgressiveStrategy {
    @Reference(policy=ReferencePolicy.DYNAMIC)
    private ResourceResolverHelper resourceResolverHelper;
    private String name;
    private String displayName;
    private String serviceType;

    protected void activate(ComponentContext context) {
        this.name = "contentStructureStrategy";
        this.displayName = "Content based Progressive Strategy";
        this.serviceType = "static";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    private GuideProgressiveCompletionInfo getCompletionInfo(ValueMap completionSectionValueMap) {
        return new GuideProgressiveCompletionInfo(completionSectionValueMap.get("completionTitle", ""), completionSectionValueMap.get("completionBeforeMessage", ""), completionSectionValueMap.get("completionAfterMessage", ""), completionSectionValueMap.get("completionScript", ""), completionSectionValueMap.get("completionButtonText", ""), completionSectionValueMap.get("completionSuccessScript", ""), completionSectionValueMap.get("completionFailureScript", ""));
    }

    @Override
    public List<Object> getAllSections(Map<String, String> paramMap) {
        String serviceContentStructurePath = paramMap.get("strategyJcrPath");
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        Resource strategyResource = resourceResolver.getResource(serviceContentStructurePath);
        ArrayList<Object> allSections = new ArrayList<Object>();
        GuideProgressiveCompletionInfo completionInfo = null;
        ValueMap completionSectionValueMap = ResourceUtil.getValueMap(strategyResource);
        Boolean isCompletionSectionAsProperty = (String)completionSectionValueMap.get("completionTitle") != null;
        if (isCompletionSectionAsProperty.booleanValue()) {
            completionInfo = this.getCompletionInfo(completionSectionValueMap);
        }
        for (Resource section : strategyResource.getChildren()) {
            ValueMap sectionValueMap = ResourceUtil.getValueMap(section);
            String sectionId = section.getName();
            if ("guideProgressiveSection".equals(sectionValueMap.get("guideNodeClass", ""))) {
                Object fieldArray = null;
                String repeatablePanelPath = sectionValueMap.get("repeatablePanelPath", "");
                String repeatablePanelId = "";
                if (repeatablePanelPath != null && !repeatablePanelPath.isEmpty()) {
                    Resource repeatablePanelResource = resourceResolver.getResource(repeatablePanelPath);
                    repeatablePanelId = NodeStructureUtils.getGuideNodeHtmlId(repeatablePanelResource);
                }
                ArrayList<GuideProgressiveField> fields = new ArrayList<GuideProgressiveField>();
                Resource items = section.getChild(section.getPath() + "/items");
                for (Resource childSection : items.getChildren()) {
                    ValueMap childSectionValueMap = ResourceUtil.getValueMap(childSection);
                    String path = (String)childSectionValueMap.get("path");
                    String id = (String)childSectionValueMap.get("id");
                    String prefixId = (String)childSectionValueMap.get("prefixId");
                    GuideProgressiveField field = new GuideProgressiveField(id, path, prefixId, resourceResolver);
                    fields.add(field);
                }
                GuideProgressiveSectionInfo sectionInfo = new GuideProgressiveSectionInfo(sectionId, sectionValueMap.get("jcr:title", ""), (String)sectionValueMap.get("name"), fields, repeatablePanelPath, repeatablePanelId);
                allSections.add(sectionInfo);
                continue;
            }
            if (!"guideProgressiveCompletionSection".equals(sectionValueMap.get("guideNodeClass", ""))) continue;
            completionInfo = this.getCompletionInfo(sectionValueMap);
        }
        if (completionInfo != null) {
            allSections.add(completionInfo);
        }
        return allSections;
    }

    @Override
    public GuideProgressiveSectionInfo getNextSection(String afPath, String currentSectionId, Map<String, String> data) {
        String strategyJcrPath = data.get("strategyJcrPath");
        Boolean renderCurrentSection = Boolean.valueOf(data.get("renderCurrentSection"));
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        Resource strategyResource = resourceResolver.getResource(strategyJcrPath);
        boolean selectSection = false;
        for (Resource section : strategyResource.getChildren()) {
            ValueMap sectionValueMap = ResourceUtil.getValueMap(section);
            String sectionId = section.getName();
            if (!"guideProgressiveSection".equals(sectionValueMap.get("guideNodeClass", ""))) continue;
            if (currentSectionId == null || currentSectionId.isEmpty()) {
                selectSection = true;
            } else if (currentSectionId != null && currentSectionId.equals(sectionId)) {
                selectSection = true;
                if (!renderCurrentSection.booleanValue()) continue;
            }
            if (!selectSection) continue;
            String repeatablePanelPath = sectionValueMap.get("repeatablePanelPath", "");
            String repeatablePanelId = "";
            if (repeatablePanelPath != null && !repeatablePanelPath.isEmpty()) {
                Resource repeatablePanelResource = resourceResolver.getResource(repeatablePanelPath);
                repeatablePanelId = NodeStructureUtils.getGuideNodeHtmlId(repeatablePanelResource);
            }
            ArrayList<GuideProgressiveField> fields = new ArrayList<GuideProgressiveField>();
            Resource items = section.getChild(section.getPath() + "/items");
            for (Resource childSection : items.getChildren()) {
                ValueMap childSectionValueMap = ResourceUtil.getValueMap(childSection);
                String path = (String)childSectionValueMap.get("path");
                String id = (String)childSectionValueMap.get("id");
                String prefixId = (String)childSectionValueMap.get("prefixId");
                GuideProgressiveField field = new GuideProgressiveField(id, path, prefixId, resourceResolver);
                fields.add(field);
            }
            GuideProgressiveSectionInfo sectionInfo = new GuideProgressiveSectionInfo(sectionId, sectionValueMap.get("jcr:title", ""), (String)sectionValueMap.get("name"), fields, repeatablePanelPath, repeatablePanelId, Boolean.valueOf(data.get("fetchedFromService")));
            return sectionInfo;
        }
        return null;
    }

    @Override
    public GuideProgressiveCompletionInfo getCompletionSection(String afpath, Map<String, String> data) {
        String strategyJcrPath = data.get("strategyJcrPath");
        GuideProgressiveCompletionInfo completionInfo = null;
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        Resource strategyResource = resourceResolver.getResource(strategyJcrPath);
        ValueMap strategyValueMap = ResourceUtil.getValueMap(strategyResource);
        Boolean isCompletionSectionAsProperty = (String)strategyValueMap.get("completionTitle") != null;
        if (isCompletionSectionAsProperty.booleanValue()) {
            completionInfo = this.getCompletionInfo(strategyValueMap);
        } else {
            for (Resource section : strategyResource.getChildren()) {
                ValueMap sectionValueMap = ResourceUtil.getValueMap(section);
                if (!"guideProgressiveCompletionSection".equals(sectionValueMap.get("guideNodeClass", ""))) continue;
                completionInfo = this.getCompletionInfo(sectionValueMap);
            }
        }
        return completionInfo;
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }
}

