/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.GuideIntegrationService;
import com.adobe.aemds.guide.service.GuideIntegrationServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Guide Integration Service", description="Provides Integration Scripts for Guide runtime", immediate=true)
@Service(value={GuideIntegrationService.class})
public class GuideIntegrationServiceImpl
implements GuideIntegrationService {
    private Logger logger = LoggerFactory.getLogger(GuideIntegrationServiceImpl.class);
    @Reference(name="guideIntegrationServiceProvider", referenceInterface=GuideIntegrationServiceProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, GuideIntegrationServiceProvider> providers = new ConcurrentSkipListMap(Collections.reverseOrder());

    private Collection<GuideIntegrationServiceProvider> getProviders() {
        return this.providers.values();
    }

    @Override
    public List<String> getScriptPaths() {
        HashSet<String> paths = new HashSet<String>();
        for (GuideIntegrationServiceProvider provider : this.getProviders()) {
            try {
                List<String> currentPaths = provider.getGuideIntegrationScriptPaths();
                if (currentPaths == null || currentPaths.isEmpty()) continue;
                paths.addAll(currentPaths);
            }
            catch (Exception e) {
                this.logger.error("The current provider could not give path", (Throwable)e);
            }
        }
        return new ArrayList<String>(paths);
    }

    protected void bindGuideIntegrationServiceProvider(GuideIntegrationServiceProvider provider, Map<String, Object> config) {
        this.providers.put(ServiceUtil.getComparableForServiceRanking(config), provider);
    }

    protected void unbindGuideIntegrationServiceProvider(GuideIntegrationServiceProvider provider, Map<String, Object> config) {
        this.providers.remove(ServiceUtil.getComparableForServiceRanking(config));
    }
}

