/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.service.JsonObjectCreator;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideSchema;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.day.cq.i18n.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Guide Localization Service", description="Service for creating dictionaries and handling locales", immediate=true, metatype=true)
@Service(value={GuideLocalizationService.class})
public class GuideLocalizationServiceImpl
implements GuideLocalizationService {
    @Reference
    private JsonObjectCreator jsonObjectCreator;
    @Property(name="supportedLocales", value={"en", "fr", "de", "ja ", "pt-br", "zh-cn", "zh-tw", "ko-kr", "es", "it"}, label="Supported Locales", description="List of locales this component is permitted to support.")
    private static final String PROPERTY_SUPPORTED_LOCALES = "supportedLocales";
    private List<String> locales;
    @Property(name="Localizable Properties", unbounded=PropertyUnbounded.ARRAY, value={"custom"}, label="Localizable Properties", description="List of Properties to localize.( Values of these properties will be used to create dictionary that is used for localization.)")
    private static String LOCALIZABLE_PROPERTIES = "Localizable Properties";
    private Map<String, String> titleLocaleCode = new HashMap<String, String>();
    @Reference(target="(component.name=org.apache.sling.i18n.impl.JcrResourceBundleProvider)")
    private ResourceBundleProvider resourceBundleProvider;
    private Logger logger = LoggerFactory.getLogger(GuideLocalizationServiceImpl.class);

    private String getLocaleTitle(String locale) {
        if (this.titleLocaleCode.containsKey(locale)) {
            return this.titleLocaleCode.get(locale);
        }
        return locale;
    }

    @Override
    public Map<String, String> getLocaleTitleCodeMap() {
        String[] supportedLocales = this.getSupportedLocales();
        HashMap<String, String> codeTitle = new HashMap<String, String>();
        for (int index = 0; index < supportedLocales.length; ++index) {
            String locale = supportedLocales[index];
            if (!StringUtils.isNotEmpty((CharSequence)locale)) continue;
            codeTitle.put(locale, this.getLocaleTitle(locale));
        }
        return codeTitle;
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String[] supportedLocales = OsgiUtil.toStringArray(props.get(PROPERTY_SUPPORTED_LOCALES));
        String[] localizableProperties = OsgiUtil.toStringArray(props.get(LOCALIZABLE_PROPERTIES));
        GuideSchema.emptyLocalizableProperties();
        GuideSchema.addLocalizableProp(null, Arrays.asList(localizableProperties));
        this.locales = new ArrayList<String>();
        if (supportedLocales != null && supportedLocales.length > 0) {
            for (int i = 0; i < supportedLocales.length; ++i) {
                String locale = supportedLocales[i];
                if (locale.isEmpty()) continue;
                this.locales.add(locale);
            }
        }
        this.titleLocaleCode.put("en", "English(en)");
        this.titleLocaleCode.put("fr", "French(fr)");
        this.titleLocaleCode.put("de", "German(de)");
        this.titleLocaleCode.put("ja", "Japanese(ja)");
        this.titleLocaleCode.put("pt-br", "Portuguese(pt-br)");
        this.titleLocaleCode.put("zh-cn", "Chinese (Simplified) (zh-cn)");
        this.titleLocaleCode.put("zh-tw", "Chinese (Traditional) (zn-tw)");
        this.titleLocaleCode.put("ko-kr", "Korean(ko-kr)");
        this.titleLocaleCode.put("es", "Spanish(es)");
        this.titleLocaleCode.put("it", "Italian(it)");
    }

    private String createDictionary(Resource guideContainerResource, JSONCreationOptions jsonCreationOptions, List localeList) throws GuideException {
        String pageRefs = null;
        try {
            ResourceResolver resolver = guideContainerResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            Node containerNode = guideContainerResource.adaptTo(Node.class);
            Node assetsNode = containerNode.hasNode("assets") ? containerNode.getNode("assets") : containerNode.addNode("assets", "nt:unstructured");
            Node dictionaryNode = assetsNode.hasNode("dictionary") ? assetsNode.getNode("dictionary") : assetsNode.addNode("dictionary", "nt:unstructured");
            String baseName = dictionaryNode.getPath();
            GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
            Resource parentResource = guideContainerResource.getParent();
            Iterator<Resource> childrenResources = parentResource.getChildren().iterator();
            JSONArray jsonObjectArray = new JSONArray();
            while (childrenResources.hasNext()) {
                Resource r = childrenResources.next();
                JSONObject jsonObject = this.jsonObjectCreator.create(r, -1, null);
                jsonObjectArray.put(jsonObject);
            }
            GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
            List<String> localeListOrDefault = localeList == null ? this.locales : localeList;
            for (String locale : localeListOrDefault) {
                Node localeNode;
                if (dictionaryNode.hasNode(locale)) {
                    localeNode = dictionaryNode.getNode(locale);
                } else {
                    localeNode = dictionaryNode.addNode(locale, "sling:Folder");
                    localeNode.setProperty("jcr:language", locale);
                    if (localeNode.canAddMixin("mix:language")) {
                        localeNode.addMixin("mix:language");
                    }
                    localeNode.setProperty("sling:basename", baseName);
                }
                Resource res = resolver.getResource(localeNode.getPath());
                GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
                JSONObject dictionaryKeysJson = this.jsonObjectCreator.create(res, -1, null);
                GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
                ArrayList<String> presentDictionaryKeyList = this.extractKeysFromJson(dictionaryKeysJson);
                for (int i = 0; i < jsonObjectArray.length(); ++i) {
                    this.addKeys(jsonObjectArray.getJSONObject(i), localeNode, true, presentDictionaryKeyList);
                }
            }
            session.save();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
        return pageRefs;
    }

    private ArrayList<String> extractKeysFromJson(JSONObject dictionaryKeysJson) throws Exception {
        ArrayList<String> dictionaryKeysList = new ArrayList<String>();
        Iterator<String> jsonKeys = dictionaryKeysJson.keys();
        while (jsonKeys.hasNext()) {
            String key = jsonKeys.next();
            Object object = dictionaryKeysJson.get(key);
            Class<?> objectClass = object.getClass();
            if (objectClass.equals(JSONObject.class)) {
                dictionaryKeysList.addAll(this.extractKeysFromJson((JSONObject)object));
                continue;
            }
            if (!"sling:key".equals(key)) continue;
            dictionaryKeysList.add(object.toString());
        }
        return dictionaryKeysList;
    }

    private void addJsonArrayKeys(JSONArray jsonArray, Node localeNode, Boolean addSlingMessage, ArrayList<String> currentDictionaryKeys) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            String dictKey = null;
            String keyLabel = null;
            String slingMessage = "";
            String arrayItem = jsonArray.get(i).toString();
            keyLabel = arrayItem.contains("=") ? arrayItem.split("=")[1] : arrayItem;
            String keyLabelEscaped = Text.escapeIllegalJcrChars(keyLabel);
            if (keyLabel == null || currentDictionaryKeys.contains(dictKey = keyLabel)) continue;
            currentDictionaryKeys.add(dictKey);
            if (addSlingMessage.booleanValue()) {
                slingMessage = dictKey;
            }
            if (keyLabel.length() > 10) {
                String minimalString = keyLabel.substring(0, 10);
                int keyHash = keyLabel.hashCode();
                keyLabel = minimalString + keyHash;
            }
            if (localeNode.hasNode(GuideUtils.getNamespacedKeys(keyLabelEscaped))) continue;
            Node keyNode = localeNode.addNode(GuideUtils.getNamespacedKeys(keyLabelEscaped), "nt:folder");
            if (keyNode.canAddMixin("sling:Message")) {
                keyNode.addMixin("sling:Message");
            }
            keyNode.setProperty("sling:key", GuideUtils.getNamespacedKeys(dictKey));
            keyNode.setProperty("sling:message", slingMessage);
        }
    }

    private void addKeys(JSONObject jsonObject, Node localeNode, Boolean addSlingMessage, ArrayList<String> currentDictionaryKeys) throws Exception {
        Iterator<String> keys = jsonObject.keys();
        String componentName = null;
        if (jsonObject.has("guideNodeClass")) {
            componentName = jsonObject.getString("guideNodeClass");
        }
        while (keys.hasNext()) {
            String dictKey = null;
            String keyLabel = null;
            String slingMessage = "";
            String key = keys.next();
            Object object = jsonObject.get(key);
            Class<?> objectClass = object.getClass();
            try {
                if (objectClass.equals(JSONObject.class)) {
                    this.addKeys((JSONObject)object, localeNode, addSlingMessage, currentDictionaryKeys);
                    continue;
                }
                if (objectClass.equals(JSONArray.class)) {
                    if (!GuideSchema.isLocalizableProperty(componentName, key)) continue;
                    this.addJsonArrayKeys((JSONArray)object, localeNode, addSlingMessage, currentDictionaryKeys);
                    continue;
                }
                keyLabel = object.toString();
                if (keyLabel == null || currentDictionaryKeys.contains(dictKey = keyLabel)) continue;
                if (addSlingMessage.booleanValue()) {
                    slingMessage = dictKey;
                }
                if (keyLabel.length() > 10) {
                    String minimalString = keyLabel.substring(0, 10);
                    int keyHash = keyLabel.hashCode();
                    keyLabel = minimalString + keyHash;
                }
                String keyLabelEscaped = Text.escapeIllegalJcrChars(keyLabel);
                if (!GuideSchema.isLocalizableProperty(componentName, key) || StringUtils.isEmpty((CharSequence)dictKey)) continue;
                currentDictionaryKeys.add(dictKey);
                if (localeNode.hasNode(GuideUtils.getNamespacedKeys(keyLabelEscaped))) continue;
                Node keyNode = localeNode.addNode(GuideUtils.getNamespacedKeys(keyLabelEscaped), "nt:folder");
                if (keyNode.canAddMixin("sling:Message")) {
                    keyNode.addMixin("sling:Message");
                }
                keyNode.setProperty("sling:key", GuideUtils.getNamespacedKeys(dictKey));
                keyNode.setProperty("sling:message", slingMessage);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    @Override
    public String[] getSupportedLocales() {
        String[] localeStrings = this.locales.toArray(new String[this.locales.size()]);
        return localeStrings;
    }

    @Override
    public void updateDictionaryBaseName(Resource guideContainerResource) throws GuideException {
        try {
            ResourceResolver resolver = guideContainerResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            Node containerNode = guideContainerResource.adaptTo(Node.class);
            Node dictionaryNode = null;
            Node assetsNode = null;
            if (containerNode.hasNode("assets")) {
                assetsNode = containerNode.getNode("assets");
            }
            if (assetsNode != null && assetsNode.hasNode("dictionary")) {
                dictionaryNode = assetsNode.getNode("dictionary");
            }
            if (dictionaryNode != null) {
                NodeIterator iterator = dictionaryNode.getNodes();
                while (iterator.hasNext()) {
                    Node localeNode = iterator.nextNode();
                    Resource localResource = resolver.getResource(localeNode.getPath());
                    ModifiableValueMap map = localResource.adaptTo(ModifiableValueMap.class);
                    map.put("sling:basename", guideContainerResource.getPath() + "/assets/dictionary");
                    localResource.getResourceResolver().commit();
                }
            }
            session.save();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    @Override
    public void createDictionary(Resource guideContainerResource) throws GuideException {
        this.createDictionary(guideContainerResource, null, null);
    }

    @Override
    public JSONObject createDictionaryWithFragmentContent(Resource containerResource, String locale) throws GuideException {
        locale = StringUtils.replace((String)locale, (String)"_", (String)"-");
        Locale localeObj = new Locale(locale);
        I18n i18n = GuideELUtils.getI18n(this.resourceBundleProvider, containerResource, localeObj);
        ArrayList<String> localeList = new ArrayList<String>();
        localeList.add(locale);
        JSONCreationOptions jsonCreationOptions = new JSONCreationOptions(i18n, true, true, localeObj, containerResource);
        JSONArray pageRefsList = null;
        JSONObject dictInfoObject = null;
        String pageRefs = null;
        try {
            GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
            JSONObject jsonObject = this.jsonObjectCreator.createWithContext(containerResource, -1, jsonCreationOptions);
            GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
            pageRefs = jsonObject.getString("assetRefs");
            pageRefsList = new JSONArray(pageRefs);
            pageRefsList.put(containerResource.getPath());
            for (int index = 0; index < pageRefsList.length(); ++index) {
                Resource resource = containerResource.getResourceResolver().getResource(pageRefsList.getString(index));
                this.createDictionary(resource, null, localeList);
            }
            dictInfoObject = GuideUtils.getDictionaryInfoFromAssetPaths(pageRefsList, localeList);
        }
        catch (Exception e) {
            this.logger.error("Could not create dictionary for:  " + containerResource.getPath() + " ", (Throwable)e);
        }
        return dictInfoObject;
    }

    @Override
    public JSONObject createDictionaryWithFragmentContent(Resource containerResource) throws GuideException {
        JSONCreationOptions jsonCreationOptions = new JSONCreationOptions(null, true, true, null, containerResource);
        String pageRefs = this.createDictionary(containerResource, jsonCreationOptions, null);
        JSONArray pageRefsList = null;
        JSONObject dictInfoObject = null;
        try {
            pageRefsList = new JSONArray(pageRefs);
            pageRefsList.put(containerResource.getPath());
            dictInfoObject = GuideUtils.getDictionaryInfoFromAssetPaths(pageRefsList, this.locales);
        }
        catch (Exception e) {
            this.logger.error("Failed to extract information about dictionaries of related assets", (Throwable)e);
        }
        return dictInfoObject;
    }

    @Override
    public JSONObject createDictionaryWithFragmentContent(Resource containerResource, List localeList) throws GuideException {
        JSONCreationOptions jsonCreationOptions = new JSONCreationOptions(null, true, true, null, containerResource);
        String pageRefs = this.createDictionary(containerResource, jsonCreationOptions, localeList);
        JSONArray pageRefsList = null;
        JSONObject dictInfoObject = null;
        try {
            pageRefsList = new JSONArray(pageRefs);
            pageRefsList.put(containerResource.getPath());
            dictInfoObject = GuideUtils.getDictionaryInfoFromAssetPaths(pageRefsList, localeList);
        }
        catch (Exception e) {
            this.logger.error("Failed to extract information about dictionaries of related assets", (Throwable)e);
        }
        return dictInfoObject;
    }

    @Override
    public JSONObject getAvailableLocales(Resource containerResource) throws GuideException {
        JSONObject dictionaryInfo = new JSONObject();
        JSONArray dictInfoArray = new JSONArray();
        try {
            String dictRootPath = containerResource.getPath() + "/" + "assets" + "/" + "dictionary";
            Resource dictRootResource = containerResource.getResourceResolver().getResource(dictRootPath);
            if (dictRootResource != null) {
                Iterable<Resource> dictList = dictRootResource.getChildren();
                for (Resource dict : dictList) {
                    String lang = (String)((Object)dict.adaptTo(ValueMap.class).get("jcr:language", String.class));
                    dictInfoArray.put(lang);
                }
                dictionaryInfo.put("languages", dictInfoArray);
            }
            return dictionaryInfo;
        }
        catch (JSONException e) {
            this.logger.error("{Failed to get available dictionaries}", (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected void bindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        this.jsonObjectCreator = jsonObjectCreator;
    }

    protected void unbindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        if (this.jsonObjectCreator == jsonObjectCreator) {
            this.jsonObjectCreator = null;
        }
    }

    protected void bindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.resourceBundleProvider = resourceBundleProvider;
    }

    protected void unbindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        if (this.resourceBundleProvider == resourceBundleProvider) {
            this.resourceBundleProvider = null;
        }
    }
}

