/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.cache.Cache;
import com.adobe.aemds.guide.cache.CacheManager;
import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.DDModelTransformer;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelImporter;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.XFAModelTransformer;
import com.adobe.aemds.guide.utils.GuideJsonHtmlEmitterFlag;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.LazyLoadingOptions;
import com.adobe.aemds.guide.xfa.XFAJSONTransformer;
import com.adobe.aemds.guide.xsd.XSDJSONVisitor;
import com.adobe.aemds.guide.xsd.XsdEntityResolver;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Guide Model Importer", description="Import guide model from various supported models", immediate=true)
@Service(value={GuideModelImporter.class})
public class GuideModelImporterImpl
implements GuideModelImporter {
    private static final Logger logger = LoggerFactory.getLogger(GuideModelImporterImpl.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private XFAModelTransformer xfaModelTransformerService;
    @Reference
    private ResourceResolverHelper resourceResolverHelper;
    @Reference
    private GuideModelTransformer guideModelTransformer;
    @Reference
    private CacheManager cacheManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private DDModelTransformer ddModelTransformer;

    private XSOMParser getXSOMParser() {
        XSOMParser parser = new XSOMParser();
        XsdEntityResolver entityResolver = new XsdEntityResolver(this.resourceResolverHelper);
        parser.setEntityResolver((EntityResolver)entityResolver);
        parser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        return parser;
    }

    private void closeInputSourceStream(InputSource isrc) {
        InputStream is;
        if (isrc != null && (is = isrc.getByteStream()) != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("Exception while closing Input Source Stream " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private InputSource getInputSource(String xpath) {
        Resource resource = this.resourceResolverHelper.getResourceResolver().getResource(xpath + "/jcr:content");
        int index = xpath.lastIndexOf("/jcr:content/renditions/original");
        String srcPath = xpath;
        if (index > 0) {
            srcPath = xpath.substring(0, index);
        }
        ValueMap propsMap = resource.adaptTo(ValueMap.class);
        InputStream xsdStream = (InputStream)((Object)propsMap.get("jcr:data", InputStream.class));
        InputSource isrc = new InputSource(xsdStream);
        isrc.setSystemId(srcPath);
        return isrc;
    }

    private String getResultString(XSElementDecl rootElement, List<String> listOfAllXSDPaths) {
        StringWriter writer = new StringWriter();
        ResourceResolver resourceResolver = GuideUtils.getResolverFromResourceResolverHelper(this.resourceResolverHelper);
        JSONObject jsonObject = new JSONObject();
        XSDJSONVisitor xsJsonVisitor = new XSDJSONVisitor(jsonObject, listOfAllXSDPaths, resourceResolver);
        rootElement.visit((XSVisitor)xsJsonVisitor);
        return jsonObject.toString();
    }

    @Override
    public JSONArray getXSDRootElements(String xsdPath) throws GuideException {
        JSONArray jsonArray = new JSONArray();
        InputSource isrc = null;
        try {
            isrc = this.getInputSource(xsdPath);
            XSOMParser parser = this.getXSOMParser();
            parser.parse(isrc);
            XSSchemaSet result = parser.getResult();
            if (result != null) {
                Iterator elIterator = result.iterateElementDecls();
                while (elIterator.hasNext()) {
                    JSONObject jsonObject = new JSONObject();
                    String nameOfRoot = ((XSElementDecl)elIterator.next()).getName();
                    jsonObject.put(nameOfRoot, nameOfRoot);
                    jsonArray.put(jsonObject);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in reading XSD from node:" + xsdPath, (Throwable)e);
            throw new GuideException("Error in reading XSD from node:" + xsdPath, e);
        }
        finally {
            this.closeInputSourceStream(isrc);
        }
        return jsonArray;
    }

    public String getFirstXSDRootElementName(Resource resource) {
        String xsdRootElName = "";
        String xsdPath = null;
        if (resource != null) {
            try {
                JSONObject xsdElJsonObj;
                Iterator<String> keys;
                JSONArray xsdElJsonArr;
                xsdPath = this.getXsdRefFromContainer(resource);
                if (StringUtils.isNotBlank((CharSequence)xsdPath) && (xsdElJsonArr = this.getXSDRootElements(xsdPath)).length() > 0 && (keys = (xsdElJsonObj = (JSONObject)xsdElJsonArr.get(0)).keys()).hasNext()) {
                    xsdRootElName = keys.next();
                }
            }
            catch (JSONException e) {
                logger.error("Error in Reading XSD root elements of :" + xsdPath, (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Error in Fetching XSD root element of :" + xsdPath, (Throwable)e);
            }
        }
        return xsdRootElName;
    }

    @Override
    public String importFromXSD(String xsdPath, String elementName, String elementNamespace) throws GuideException {
        InputSource isrc = null;
        try {
            XSElementDecl rootElement;
            XSOMParser parser;
            block7: {
                Iterator elIterator;
                block8: {
                    isrc = this.getInputSource(xsdPath);
                    parser = this.getXSOMParser();
                    rootElement = null;
                    parser.parse(isrc);
                    XSSchemaSet result = parser.getResult();
                    if (result == null) break block7;
                    elIterator = result.iterateElementDecls();
                    if (elementName != null && !elementName.isEmpty()) break block8;
                    if (!elIterator.hasNext()) break block7;
                    rootElement = (XSElementDecl)elIterator.next();
                    break block7;
                }
                elementName = elementName.trim();
                while (elIterator.hasNext()) {
                    XSElementDecl element = (XSElementDecl)elIterator.next();
                    if (!elementName.equals(element.getName())) continue;
                    if (elementNamespace != null && !elementNamespace.isEmpty()) {
                        if (!(elementNamespace = elementNamespace.trim()).equals(element.getTargetNamespace())) continue;
                        rootElement = element;
                        break;
                    }
                    rootElement = element;
                    break;
                }
            }
            List<String> pathOfAllXSD = this.getPathsOfXSDFromEntityResolver(parser);
            pathOfAllXSD.add(this.getNameOfXSDAssetIfUploaded(xsdPath));
            String string = this.getResultString(rootElement, pathOfAllXSD);
            return string;
        }
        catch (Exception e) {
            logger.error("Error in reading XSD from node:" + xsdPath, (Throwable)e);
            throw new GuideException("Error in reading XSD from node:" + xsdPath, e);
        }
        finally {
            this.closeInputSourceStream(isrc);
        }
    }

    private String getXsdRefFromContainer(Resource resource) {
        ValueMap propsMap = resource.adaptTo(ValueMap.class);
        String xsdPath = "";
        String xsdRefPath = propsMap.get("xsdRef", "");
        xsdPath = xsdRefPath.startsWith("/assets") ? resource.getPath() + "/assets/xsdRef.xsd" : xsdRefPath + "/jcr:content/renditions/original";
        return xsdPath;
    }

    @Override
    public String importFromXSD(Resource resource) throws GuideException {
        try {
            String xsdPath = this.getXsdRefFromContainer(resource);
            ValueMap propsMap = resource.adaptTo(ValueMap.class);
            return this.importFromXSD(xsdPath, propsMap.get("xsdRootElement", ""), propsMap.get("xsdRootElNamespace", ""));
        }
        catch (Exception e) {
            logger.error("Error in reading XSD from node:" + resource.getPath(), (Throwable)e);
            throw new GuideException("Error in reading XSD from node:" + resource.getPath(), e);
        }
    }

    @Override
    public JSONArray getXSDComplexTypes(String xsdPath) throws GuideException {
        try {
            InputSource isrc = null;
            isrc = this.getInputSource(xsdPath);
            XSOMParser parser = this.getXSOMParser();
            parser.parse(isrc);
            JSONArray jsonArray = new JSONArray();
            Iterator complexTypeIterator = parser.getResult().iterateComplexTypes();
            while (complexTypeIterator.hasNext()) {
                XSComplexType complexType = (XSComplexType)complexTypeIterator.next();
                String nameOfComplexType = complexType.getName();
                JSONObject typeNameObject = new JSONObject();
                typeNameObject.put(nameOfComplexType, "/" + nameOfComplexType);
                jsonArray.put(typeNameObject);
            }
            return jsonArray;
        }
        catch (Exception e) {
            logger.error("Error in getting complex types", (Throwable)e);
            return null;
        }
    }

    @Override
    public String importFromXSD(InputStream xsdStream, String rootElName, String rootElNamespace) throws GuideException {
        try {
            XSElementDecl rootElement = this.parseXSD(xsdStream, rootElName, rootElNamespace);
            return this.getResultString(rootElement, null);
        }
        catch (Exception e) {
            logger.error("Error in reading XSD from XSD", (Throwable)e);
            throw new GuideException("Error in Creating json from XSD:" + rootElName);
        }
    }

    private XSElementDecl parseXSD(InputStream xsd, String elementName, String elementNamespace) throws SAXException, IOException {
        XSElementDecl rootElement = null;
        XSOMParser parser = this.getXSOMParser();
        parser.parse(xsd);
        XSSchemaSet result = parser.getResult();
        if (result == null) {
            logger.error("No Schema element found in the parsed XSD");
            throw new GuideException("invalid xsd: No Schema element found in the parsed XSD");
        }
        if (StringUtils.isEmpty((CharSequence)elementName) && StringUtils.isEmpty((CharSequence)elementNamespace)) {
            Iterator elIterator = result.iterateElementDecls();
            if (elIterator.hasNext()) {
                rootElement = (XSElementDecl)elIterator.next();
            }
        } else {
            rootElement = result.getElementDecl(elementNamespace, elementName);
        }
        if (rootElement == null) {
            logger.error("No Schema element found in the parsed XSD");
            throw new GuideException("invalid xsd: No Schema element found in the parsed XSD");
        }
        return rootElement;
    }

    @Override
    public String getTypeOfElement(String xsdRef, String rootName, String xPath) throws SAXException, JSONException {
        InputSource isrc = null;
        isrc = this.getInputSource(xsdRef);
        XSOMParser parser = this.getXSOMParser();
        parser.parse(isrc);
        XSSchemaSet result = parser.getResult();
        XSDJSONVisitor xsJsonVisitor = null;
        if (result != null) {
            Iterator elIterator = result.iterateElementDecls();
            while (elIterator.hasNext()) {
                XSElementDecl el = (XSElementDecl)elIterator.next();
                String nameOfRoot = el.getName();
                if (!nameOfRoot.equals(rootName)) continue;
                XSType type = el.getType();
                String currentPath = StringUtils.substringAfter((String)xPath, (String)"/");
                xsJsonVisitor = new XSDJSONVisitor(currentPath, Boolean.valueOf(true));
                xsJsonVisitor.complexType((XSComplexType)type);
                return xsJsonVisitor.returnType();
            }
        }
        return null;
    }

    private boolean isXFAObjectAssetOutdated(Resource guideContainer) {
        Resource xfaObjects = guideContainer.getChild("assets/xfaObjects");
        if (xfaObjects == null) {
            return true;
        }
        ValueMap containerAttributes = ResourceUtil.getValueMap(guideContainer);
        ValueMap xfaObjectsAttributes = ResourceUtil.getValueMap(xfaObjects);
        if (containerAttributes.get("formModelChanged", null) != null) {
            Date updateDate = containerAttributes.get("formModelUpdateTime", null);
            if (updateDate == null) {
                return true;
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date syncDate = null;
            try {
                syncDate = fmt.parse(xfaObjectsAttributes.get("jcr:lastModified", null));
                return updateDate.after(syncDate);
            }
            catch (ParseException e) {
                throw new GuideException(e);
            }
        }
        return false;
    }

    private String getXDPRefFromContainer(Resource container) {
        if (this.xfaModelTransformerService == null) {
            logger.error("xfaModelTransformerService has not been initialized");
            return null;
        }
        ValueMap guideContainerProps = ResourceUtil.getValueMap(container);
        return guideContainerProps.get("xdpRef", null);
    }

    private String getXFAFormDom(Resource guideContainer) {
        String xdpRef = this.getXDPRefFromContainer(guideContainer);
        String xfaFormdomJsonStr = "";
        if (xdpRef != null) {
            if (GuideUtils.isXDPValid(guideContainer)) {
                xfaFormdomJsonStr = this.xfaModelTransformerService.exportXfaFormdomJson(guideContainer);
            } else {
                logger.warn("AF xdpRef [" + xdpRef + "] provided in AF is invalid [" + guideContainer.getPath() + "]");
            }
        }
        return xfaFormdomJsonStr;
    }

    @Override
    public String importFromXFA(Resource guideContainer) throws GuideException {
        String xfaFormdomJsonStr = this.getXFAFormDom(guideContainer);
        if (xfaFormdomJsonStr != null && xfaFormdomJsonStr.length() > 0) {
            boolean syncAssets = this.isXFAObjectAssetOutdated(guideContainer);
            Hashtable<String, Object> result = null;
            if (xfaFormdomJsonStr != null && xfaFormdomJsonStr.length() > 0) {
                result = this.importFromXFA(xfaFormdomJsonStr, syncAssets, this.getXDPRefFromContainer(guideContainer));
            }
            if (syncAssets) {
                Resource xfaObjectsRes = guideContainer.getChild("assets/xfaObjects");
                ResourceResolver resolver = guideContainer.getResourceResolver();
                if (xfaObjectsRes != null) {
                    try {
                        resolver.delete(xfaObjectsRes);
                        resolver.refresh();
                        resolver.commit();
                    }
                    catch (PersistenceException e) {
                        throw new GuideException(e);
                    }
                }
                if (result != null) {
                    Hashtable xfaObjects = (Hashtable)result.get("xfaObjects");
                    try {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                        xfaObjects.put("jcr:lastModified", fmt.format(new Date()));
                        ResourceUtil.getOrCreateResource(resolver, guideContainer.getPath() + "/assets/xfaObjects", xfaObjects, null, true);
                        resolver.commit();
                    }
                    catch (PersistenceException e) {
                        throw new GuideException(e);
                    }
                }
            }
            if (result != null) {
                return (String)result.get("transformedJSON");
            }
        }
        return null;
    }

    @Override
    public Hashtable<String, Object> importFromXFA(String xfaFormdomJson, boolean saveObjects) throws GuideException {
        return this.importFromXFA(xfaFormdomJson, saveObjects, "");
    }

    private Hashtable<String, Object> importFromXFA(String xfaFormdomJson, boolean saveObjects, String xfaPath) throws GuideException {
        try {
            JSONObject xfaJson = new JSONObject(xfaFormdomJson);
            XFAJSONTransformer xfajsonTransformer = new XFAJSONTransformer(xfaJson, saveObjects, this.resourceResolverHelper.getResourceResolver(), xfaPath);
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            result.put("transformedJSON", xfajsonTransformer.transform());
            result.put("xfaObjects", xfajsonTransformer.getXFAObjects());
            return result;
        }
        catch (Exception e) {
            logger.error("Error in importing Xfa Json", (Throwable)e);
            throw new GuideException("Error in in importing Xfa Json", e);
        }
    }

    @Override
    public String importFromDataDictionary(Resource guideContainer) throws GuideException {
        if (guideContainer != null) {
            ValueMap guideContainerProps = ResourceUtil.getValueMap(guideContainer);
            String ddRef = guideContainerProps.get("ddRef", null);
            return this.importFromDataDictionary(ddRef);
        }
        logger.error("GuideContainer is null");
        return null;
    }

    @Override
    public String importFromDataDictionary(String ddRef) throws GuideException {
        if (this.ddModelTransformer == null) {
            logger.error("DDModelTransformer has not been initialized");
            return null;
        }
        return this.ddModelTransformer.exportDDJson(ddRef);
    }

    @Override
    public JSONArray getXDPFragmentSubForms(String xfaPath) throws GuideException {
        JSONArray arrayOfSubFormsMarkedFragments = new JSONArray();
        try {
            JSONObject nameFragmentModelRoot = new JSONObject();
            String xfaJsonString = this.xfaModelTransformerService.exportXfaFormdomJson(xfaPath);
            String guideTypeXfaJsonString = (String)this.importFromXFA(xfaJsonString, false).get("transformedJSON");
            JSONObject guideTypeXfaJsonObject = new JSONObject(guideTypeXfaJsonString);
            Iterator<String> guideTypeXfaJsonObjectKeys = guideTypeXfaJsonObject.keys();
            if (guideTypeXfaJsonObjectKeys.hasNext()) {
                String guideTypeXfaJsonObjectFirstKey = guideTypeXfaJsonObjectKeys.next();
                GuideUtils.visitToCollectProperties(guideTypeXfaJsonObject.getJSONObject(guideTypeXfaJsonObjectFirstKey), "isFragment", "name", "bindRef", arrayOfSubFormsMarkedFragments);
            }
        }
        catch (Exception e) {
            logger.error("Cannot return  fragment marked subforms", (Throwable)e);
            throw new GuideException("Error in reading XDP from node:" + xfaPath, e);
        }
        return arrayOfSubFormsMarkedFragments;
    }

    @Override
    public String importFromXSDForFragment(Resource container) throws GuideException {
        try {
            ValueMap propsMap = container.adaptTo(ValueMap.class);
            String xsdRef = this.getXsdRefFromContainer(container);
            String fragmentModelRoot = (String)propsMap.get("fragmentModelRoot");
            String elementRoot = null;
            String slashStrippedFragmentModelRootOrElementName = StringUtils.substringAfter((String)fragmentModelRoot, (String)"/");
            if (slashStrippedFragmentModelRootOrElementName.length() == 0) {
                return this.importFromXSD(xsdRef, elementRoot, "");
            }
            if (slashStrippedFragmentModelRootOrElementName.indexOf(47) > 0) {
                elementRoot = slashStrippedFragmentModelRootOrElementName.substring(0, slashStrippedFragmentModelRootOrElementName.indexOf(47));
                return this.importFromXSD(xsdRef, elementRoot, "");
            }
            InputSource isrc = null;
            isrc = this.getInputSource(xsdRef);
            XSOMParser parser = this.getXSOMParser();
            parser.parse(isrc);
            Iterator complexTypeIterator = parser.getResult().iterateComplexTypes();
            List<String> pathOfAllXSD = this.getPathsOfXSDFromEntityResolver(parser);
            pathOfAllXSD.add(this.getNameOfXSDAssetIfUploaded(xsdRef));
            while (complexTypeIterator.hasNext()) {
                XSComplexType complexType = (XSComplexType)complexTypeIterator.next();
                if (!complexType.getName().equals(slashStrippedFragmentModelRootOrElementName)) continue;
                StringWriter writer = new StringWriter();
                JSONObject jsonObject = new JSONObject();
                XSDJSONVisitor xsJsonVisitor = new XSDJSONVisitor(jsonObject, pathOfAllXSD, GuideUtils.getResolverFromResourceResolverHelper(this.resourceResolverHelper));
                xsJsonVisitor.buildComplexType(complexType);
                return jsonObject.toString();
            }
        }
        catch (Exception e) {
            logger.error("Error in importing XSD for Fragment", (Throwable)e);
            throw new GuideException("Error in importing XSD for Fragment");
        }
        return null;
    }

    private List<String> getPathsOfXSDFromEntityResolver(XSOMParser parser) {
        ArrayList pathOfAllXSD = ((XsdEntityResolver)parser.getEntityResolver()).getListOfAllXSD();
        if (pathOfAllXSD == null) {
            pathOfAllXSD = new ArrayList();
        }
        return pathOfAllXSD;
    }

    private String getNameOfXSDAssetIfUploaded(String xsdRef) {
        if (StringUtils.endsWith((CharSequence)xsdRef, (CharSequence)"/assets/xsdRef.xsd")) {
            xsdRef = StringUtils.replace((String)xsdRef, (String)"/content/forms/af/", (String)"/content/dam/formsanddocuments/");
            xsdRef = StringUtils.substringBefore((String)xsdRef, (String)"guideContainer");
            Resource damMetaDataNode = GuideUtils.getResolverFromResourceResolverHelper(this.resourceResolverHelper).getResource(xsdRef).getChild("metadata");
            ValueMap valueMap = damMetaDataNode.adaptTo(ValueMap.class);
            xsdRef = (String)valueMap.get("xsdRef");
        }
        return xsdRef;
    }

    @Override
    public String getJSONHTMLFragmentOrForm(LazyLoadingOptions lazyLoadingOptions) throws GuideException {
        try {
            GuideJsonHtmlEmitterFlag whatToBring = lazyLoadingOptions.getGuideJsonHtmlEmitterFlag();
            if (whatToBring == null) {
                throw new GuideException("Need to set GuideJsonHtmlFlag in order to make this API work");
            }
            String templateId = lazyLoadingOptions.getTemplateId();
            String parentContainerPath = lazyLoadingOptions.getParentContainerPath();
            Resource childContainer = lazyLoadingOptions.getChildContainer();
            SlingHttpServletRequest slingRequest = lazyLoadingOptions.getSlingRequest();
            if (parentContainerPath == null) {
                throw new GuideException("Invalid arguments - please provide a parent container");
            }
            if (childContainer == null && whatToBring != GuideJsonHtmlEmitterFlag.GET_PIGGY_BANKED_JSON) {
                throw new GuideException("Invalid arguments - please provide a child container");
            }
            if (slingRequest == null) {
                throw new GuideException("Invalid arguments - please provide sling Request");
            }
            switch (whatToBring) {
                case GET_CHILD_PANEL_JSON: {
                    ResourceResolver resourceResolver = slingRequest.getResourceResolver();
                    Resource parentContainer = resourceResolver.getResource(parentContainerPath);
                    GuideContainer guideContainer = new GuideContainer(slingRequest, parentContainer);
                    ValueMap valueMap = childContainer.adaptTo(ValueMap.class);
                    String ref = (String)valueMap.get("fragRef");
                    String locale = GuideUtils.getGuideRuntimeLocale(slingRequest, parentContainer);
                    Map<String, Object> syncXfaPropsResult = this.guideModelTransformer.syncXfaProps(guideContainer, locale);
                    JSONObject guideJsonObject = new JSONObject((String)syncXfaPropsResult.get("guidejson"));
                    return GuideUtils.findJsonObjectWithProperty(guideJsonObject, "fragRef", ref, childContainer.getPath());
                }
                case GET_CHILD_PANEL_HTML: {
                    String key;
                    SlingHttpServletResponse slingResponse = lazyLoadingOptions.getSlingResponse();
                    if (slingResponse == null) {
                        throw new GuideException("Invalid arguments - please provide slingResponse");
                    }
                    if (StringUtils.isEmpty((CharSequence)templateId)) {
                        throw new GuideException("Invalid arguments - please provide templateId");
                    }
                    ResourceResolver resourceResolver = slingRequest.getResourceResolver();
                    Resource parentContainer = resourceResolver.getResource(parentContainerPath);
                    ValueMap valueMap = childContainer.adaptTo(ValueMap.class);
                    String ref = (String)valueMap.get("fragRef");
                    String locale = GuideUtils.getGuideRuntimeLocale(slingRequest, parentContainer);
                    GuideContainer guideContainer = new GuideContainer(slingRequest, parentContainer);
                    Cache guideHTMLCache = this.cacheManager.getOrCreateCache("cache.html");
                    String html = (String)guideHTMLCache.get(key = guideContainer.getPath() + "_" + locale);
                    if (StringUtils.isEmpty((CharSequence)html)) {
                        logger.debug("Cache Miss for HTML " + key);
                        html = GuideUtils.produceHTML(guideContainer, slingResponse);
                    }
                    return GuideUtils.getAssetHTMLFromFullHTML(templateId, html);
                }
                case GET_PIGGY_BANKED_JSON: {
                    JSONArray listOfTemplateIds = lazyLoadingOptions.getListOfTemplateIds();
                    if (listOfTemplateIds == null) {
                        throw new GuideException("Invalid arguments - please provide list of template IDs");
                    }
                    ResourceResolver resourceResolver = slingRequest.getResourceResolver();
                    Resource parentContainer = resourceResolver.getResource(parentContainerPath);
                    GuideContainer guideContainer = new GuideContainer(slingRequest, parentContainer);
                    String locale = GuideUtils.getGuideRuntimeLocale(slingRequest, parentContainer);
                    Map<String, Object> syncXfaPropsResult = this.guideModelTransformer.syncXfaProps(guideContainer, locale);
                    JSONObject guideJsonObject = new JSONObject((String)syncXfaPropsResult.get("guidejson"));
                    return GuideUtils.getJsonObjectWithGivenTemplateIds(guideJsonObject, listOfTemplateIds);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to execute getJSONHTMLFragmentOrForm ", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<String> getLazyChildren(Resource guideContainer) throws GuideException {
        JSONObject templateJson = this.guideModelTransformer.exportGuideJsonObject(guideContainer);
        JSONArray lazyJsonArray = templateJson.optJSONArray("allLazyChildren");
        ArrayList<String> result = null;
        if (lazyJsonArray != null && lazyJsonArray.length() > 0) {
            result = new ArrayList<String>();
            for (int i = 0; i < lazyJsonArray.length(); ++i) {
                String lazyChild = lazyJsonArray.optString(i);
                if (!StringUtils.isNotBlank((CharSequence)lazyChild)) continue;
                result.add(lazyChild);
            }
        }
        return result;
    }

    protected void bindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        this.xfaModelTransformerService = xFAModelTransformer;
    }

    protected void unbindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        if (this.xfaModelTransformerService == xFAModelTransformer) {
            this.xfaModelTransformerService = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }

    protected void bindCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void unbindCacheManager(CacheManager cacheManager) {
        if (this.cacheManager == cacheManager) {
            this.cacheManager = null;
        }
    }

    protected void bindDdModelTransformer(DDModelTransformer dDModelTransformer) {
        this.ddModelTransformer = dDModelTransformer;
    }

    protected void unbindDdModelTransformer(DDModelTransformer dDModelTransformer) {
        if (this.ddModelTransformer == dDModelTransformer) {
            this.ddModelTransformer = null;
        }
    }
}

