/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.cache.Cache;
import com.adobe.aemds.guide.cache.CacheManager;
import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.common.ResourcePropertyTransformer;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideDraftStateProvider;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.service.GuideStoreContentSubmission;
import com.adobe.aemds.guide.service.JsonObjectCreator;
import com.adobe.aemds.guide.service.XFAModelTransformer;
import com.adobe.aemds.guide.service.external.GuideDataMergerSPI;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.DocumentDataMerger;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.aemds.guide.utils.KeyValueDataMerger;
import com.adobe.aemds.guide.utils.ValueMapDataMerger;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.aemds.guide.utils.XsdDocumentDataMerger;
import com.adobe.aemds.guide.utils.rhino.GuideFunctionObject;
import com.adobe.aemds.guide.utils.rhino.GuideScriptObject;
import com.adobe.aemds.guide.utils.rhino.RhinoScriptProcessor;
import com.adobe.forms.common.service.DataXMLOptions;
import com.adobe.forms.common.service.FormDataXMLProviderRegistry;
import com.adobe.forms.common.service.FormsCommonConfigurationService;
import com.adobe.forms.common.service.StaleAssetIndicatorService;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.commons.Externalizer;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.widget.ClientLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.mozilla.javascript.Scriptable;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, metatype=true, label="Adaptive Form Json Transformer", description="Adaptive Form Json Transformer Service")
@Service(value={GuideModelTransformer.class})
public class GuideModelTransformerImpl
implements GuideModelTransformer {
    private Logger logger = LoggerFactory.getLogger(GuideModelTransformerImpl.class);
    @Property(name="enforceServerUrlConfig", boolValue={false}, label="Enforce Server URL Configuration", description="Enforce the use of server url from externalizer service(com.day.cq.commons.impl.ExternalizerImpl) for making rest calls when doing Adaptive Form Server side validation")
    private Boolean enforceServerUrlConfig;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private XFAModelTransformer xfaModelTransformerService;
    @Reference
    private FormsCommonConfigurationService formsCommonConfigurationService;
    @Reference
    private GuideLocalizationService guideLocalizationService;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference
    private GuideStoreContentSubmission guideStoreContentSubmission;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverHelper resourceResolverHelper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Externalizer externalizer;
    @Reference
    private JsonObjectCreator jsonObjectCreator;
    @Reference
    private AdaptiveFormConfigurationService adaptiveFormConfigurationService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private StaleAssetIndicatorService staleAssetIndicatorService;
    @Reference
    private CacheManager cacheManager;
    @Reference
    private FormDataXMLProviderRegistry formDataXMLProviderRegistry;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideModuleImporter guideModuleImporter;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideDataMergerSPI guideDataMerger;
    private final int ENV_RHINO_PARSER = 8;
    private ArrayList<String> xfaSpecificScript;
    private ArrayList<String> envScript = null;
    private ArrayList<String> scriptToLoadBeforeXFA = null;
    private ArrayList<String> scriptToLoadAfterXFA = null;
    private ArrayList<String> localeSpecificLibs = null;
    private final AtomicBoolean isActivateSuccess = new AtomicBoolean(false);
    private final Locale defaultFallBackLocaleObject = new Locale("en");
    @Reference(name="guideDraftStateProvider", referenceInterface=GuideDraftStateProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, GuideDraftStateProvider> providers = new ConcurrentSkipListMap(Collections.reverseOrder());

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.enforceServerUrlConfig = OsgiUtil.toBoolean(props.get("enforceServerUrlConfig"), false);
        this.isActivateSuccess.set(this.checkIfScriptsCachedDuringActivation());
    }

    private String[] getAemSupportedLocales() {
        String[] aemSupportedlocales = this.guideLocalizationService != null ? this.guideLocalizationService.getSupportedLocales() : GuideConstants.AEM_SUPPORTED_LOCALES;
        return aemSupportedlocales;
    }

    private boolean checkIfScriptsCachedDuringActivation() {
        return this.scriptToLoadBeforeXFA != null && this.xfaSpecificScript != null && this.scriptToLoadAfterXFA != null && this.envScript != null && this.scriptToLoadBeforeXFA.get(0) != null && this.xfaSpecificScript.get(0) != null && this.scriptToLoadAfterXFA.get(0) != null && this.envScript.get(0) != null;
    }

    private void compileAndCacheGuideStaticScripts() {
        String script;
        int i;
        this.localeSpecificLibs = this.getAllLocaleSpecificLibs();
        this.scriptToLoadBeforeXFA = this.getScriptToLoadBeforeXFA();
        this.xfaSpecificScript = this.getXFASpecficScript();
        this.scriptToLoadAfterXFA = this.getScriptToLoadAfterXFA();
        this.envScript = this.getEnvRhinoModules();
        for (int i2 = 0; i2 < this.envScript.size(); ++i2) {
            String script2 = this.envScript.get(i2);
            if (script2 == null || i2 == 8) continue;
            RhinoScriptProcessor.compileAndCache(this.envScript.get(i2), "envScript" + i2);
        }
        String[] aemSupportedLocales = this.getAemSupportedLocales();
        for (i = 0; i < this.localeSpecificLibs.size(); ++i) {
            script = this.localeSpecificLibs.get(i);
            if (script == null) continue;
            RhinoScriptProcessor.compileAndCache(script, "localeSpecificLib" + aemSupportedLocales[i]);
        }
        for (i = 0; i < this.scriptToLoadBeforeXFA.size(); ++i) {
            script = this.scriptToLoadBeforeXFA.get(i);
            if (script == null) continue;
            RhinoScriptProcessor.compileAndCache(script, "scriptToLoadBeforeXFA" + i);
        }
        for (i = 0; i < this.xfaSpecificScript.size(); ++i) {
            script = this.xfaSpecificScript.get(i);
            if (script == null) continue;
            RhinoScriptProcessor.compileAndCache(script, "xfaSpecificScript" + i);
        }
        for (i = 0; i < this.scriptToLoadAfterXFA.size(); ++i) {
            script = this.scriptToLoadAfterXFA.get(i);
            if (script == null) continue;
            RhinoScriptProcessor.compileAndCache(script, "scriptToLoadAfterXFA" + i);
        }
    }

    private ArrayList<String> getScriptToLoadBeforeXFA() {
        String[] clientLibCommonCategories = new String[]{"xfaforms.xfalibutil", "xfaforms.xfalibwidgets"};
        return GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, clientLibCommonCategories);
    }

    private String getLocaleScriptToLoadBeforeXFA(String locale) {
        int index = GuideUtils.getLocaleIndexFromLocale(locale, this.getAemSupportedLocales());
        String[] GUIDES_SUPPORTED_CLIENTLIBS = GuideUtils.sanitizeLocaleList(this.getAemSupportedLocales());
        String[] clientLibCommonCategories = new String[]{"guides.I18N." + GUIDES_SUPPORTED_CLIENTLIBS[index]};
        ArrayList<String> script = GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, clientLibCommonCategories);
        String localeScript = "";
        if (script != null && script.size() > 0) {
            localeScript = script.get(0);
        } else {
            String[] defaultClientLib = new String[]{"guides.I18N.en"};
            ArrayList<String> defaultScript = GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, defaultClientLib);
            localeScript = defaultScript.get(0);
        }
        return localeScript;
    }

    private ArrayList<String> getAllLocaleSpecificLibs() {
        String[] aemSupportedLocales = this.getAemSupportedLocales();
        ArrayList<String> scriptToLoadBeforeXFAForAllLocales = new ArrayList<String>(aemSupportedLocales.length);
        for (String locale : aemSupportedLocales) {
            scriptToLoadBeforeXFAForAllLocales.add(this.getLocaleScriptToLoadBeforeXFA(locale));
        }
        return scriptToLoadBeforeXFAForAllLocales;
    }

    private ArrayList<String> getXFASpecficScript() {
        String[] clientLibXfaCategories = new String[]{"xfaforms.formbridge", "xfaforms.formcalc", "xfaforms.xfalibCoreModel", "xfaforms.xfalibDomModel"};
        return GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, clientLibXfaCategories);
    }

    private ArrayList<String> getEnvRhinoModules() {
        ArrayList<String> envScript = new ArrayList<String>();
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/platform/core.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/platform/rhino.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/console.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/dom.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/event.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/timer.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/html.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/css.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/parser.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/xhr.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/third-party/javascript/envjs/window.js"));
        envScript.add(this.readFile("/etc/clientlibs/fd/af/guidelib/javascript/EnvRhinoFixes.js"));
        return envScript;
    }

    private ArrayList<String> getScriptToLoadAfterXFA() {
        String[] clientLibToLoadAfterXfa = new String[]{"guides.3rdparty", "guides.guidelib", "af.customwidgets", "cqguides.signing"};
        return GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, clientLibToLoadAfterXfa);
    }

    @Override
    public String exportGuideJson(Resource guideContainer, I18n i18n) throws GuideException {
        return this.exportGuideJson(guideContainer, i18n, this.defaultFallBackLocaleObject);
    }

    @Override
    public String exportGuideJson(Resource guideContainer, I18n i18n, Locale locale) throws GuideException {
        JSONObject guideJson = this.exportGuideJsonObject(guideContainer, i18n, locale);
        return guideJson.toString();
    }

    @Override
    public JSONObject exportGuideJsonObject(Resource guideContainer) {
        return this.exportGuideJsonObject(guideContainer, null, this.defaultFallBackLocaleObject);
    }

    @Override
    public JSONObject exportGuideJsonObject(Resource guideContainer, I18n i18n) {
        return this.exportGuideJsonObject(guideContainer, i18n, this.defaultFallBackLocaleObject);
    }

    @Override
    public JSONObject exportGuideJsonObject(Resource guideContainer, I18n i18n, Locale locale) {
        JSONCreationOptions jsonCreationOptions = new JSONCreationOptions(i18n, true, true, locale, guideContainer);
        return this.exportGuideJsonObject(guideContainer, jsonCreationOptions);
    }

    @Override
    public JSONObject exportGuideJsonObject(Resource guideContainer, JSONCreationOptions jsonCreationOptions) {
        try {
            String locale = jsonCreationOptions.getLocale().toString();
            String key = guideContainer.getPath() + "_" + locale;
            Cache guideJsonCache = this.cacheManager.getOrCreateCache("cache.json");
            Map jsonMap = (Map)guideJsonCache.get(key);
            JSONObject guideJson = null;
            if (jsonMap != null) {
                this.logger.debug("Guide Json Cache hit for guideContainer " + guideContainer.getPath());
                String sGuideJson = (String)jsonMap.get("guidejson");
                if (!StringUtils.isEmpty((CharSequence)sGuideJson)) {
                    guideJson = new JSONObject(sGuideJson);
                }
            }
            if (guideJson == null) {
                GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
                guideJson = this.jsonObjectCreator.createWithContext(guideContainer, -1, jsonCreationOptions);
                GuideContainerThreadLocal.setGuideFragmentHolder(null, null, null, null);
                this.logger.debug("Guide Json Cache miss for guideContainer " + guideContainer.getPath());
            }
            if (guideJson.has("assets")) {
                guideJson.remove("assets");
            }
            return guideJson;
        }
        catch (Exception e) {
            this.logger.error("Error in exporting guide json", (Throwable)e);
            throw new GuideException(e);
        }
    }

    @Override
    public Map<String, String> exportXfaJson(Resource guideContainer) throws GuideException {
        try {
            ValueMap valueMap = guideContainer.adaptTo(ValueMap.class);
            String formPath = (String)valueMap.get("xdpRef");
            if (formPath == null || formPath.length() == 0 || !GuideUtils.isXDPValid(guideContainer)) {
                return null;
            }
            return this.xfaModelTransformerService.exportXfaJson(guideContainer, null, null);
        }
        catch (Exception e) {
            this.logger.error("Error in exporting xfa json", (Throwable)e);
            throw new GuideException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportGuideState(String guideStatePath) throws GuideException {
        String result = null;
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            Resource slingResource = resolver.resolve(guideStatePath);
            Node jcrNode = slingResource.adaptTo(Node.class);
            InputStream is = jcrNode.getProperty("jcr:data").getBinary().getStream();
            BufferedInputStream bin = new BufferedInputStream(is);
            try {
                result = new String(this.readStream(bin), "UTF-8");
            }
            finally {
                bin.close();
                is.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in exporting merged json", (Throwable)e);
            throw new GuideException(e);
        }
        return result;
    }

    @Override
    public String exportGuideStateFromStore(String guideStatePathRef) throws GuideException {
        String result = null;
        try {
            for (GuideDraftStateProvider provider : this.getProviders()) {
                try {
                    String state = provider.getGuideDraftState(guideStatePathRef);
                    if (state == null) continue;
                    result = state;
                    break;
                }
                catch (Exception e) {
                    this.logger.error("The current provider could not return the guidestate" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error in exporting merged json from ref", (Throwable)e);
            throw new GuideException(e);
        }
        return result;
    }

    private Collection<GuideDraftStateProvider> getProviders() {
        return this.providers.values();
    }

    private void writeDataJson(Resource guideContainer, CustomJSONWriter jsonWriter, JSONCreationOptions options) throws GuideException {
        block19: {
            try {
                String formContainerPath = options.getFormContainerPath();
                I18n i18n = options.getI18n();
                String dataRef = options.getDataRef();
                ValueMap resourceProps = ResourceUtil.getValueMap(guideContainer);
                String prefillService = (String)resourceProps.get("prefillService");
                ResourceResolver resolver = guideContainer.getResourceResolver();
                DataXMLOptions dataXMLOptions = new DataXMLOptions();
                dataXMLOptions.setAemFormContainer(resolver.getResource(formContainerPath)).setFormResource(guideContainer);
                String data = options.getData();
                InputStream inputStream = null;
                if (data == null) {
                    if (dataRef != null) {
                        dataXMLOptions.setDataRef(dataRef);
                        inputStream = this.formDataXMLProviderRegistry.getDataXMLStreamFromService(dataXMLOptions);
                    } else if (prefillService != null) {
                        dataXMLOptions.setServiceName(prefillService);
                        inputStream = this.formDataXMLProviderRegistry.getDataXMLStreamFromService(dataXMLOptions);
                    }
                } else {
                    inputStream = new ByteArrayInputStream(data.getBytes("UTF-8"));
                }
                if (inputStream == null) break block19;
                ValueMap guideProps = guideContainer.adaptTo(ValueMap.class);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = null;
                try {
                    doc = builder.parse(inputStream);
                }
                catch (SAXException e) {
                    this.logger.error("Error in parsing prefill xml from data Ref", (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error("Error in reading prefill xml from data Ref", (Throwable)e);
                }
                if (doc != null) {
                    boolean startsWithAfData = XMLUtils.isWrappedXml(doc);
                    if (GuideUtils.isTargetEnabled(guideContainer)) {
                        jsonWriter.key("completeDataXML").value(XMLUtils.getXMLfromXsdDom(doc.getDocumentElement()));
                    }
                    JSONObject templateJson = this.exportGuideJsonObject(guideContainer);
                    boolean hasEmbeddedXsdForms = templateJson.optBoolean("isHasEmbeddedXsdForm");
                    if (guideProps.get("xdpRef") != null && GuideUtils.isXDPValid(guideContainer)) {
                        this.getExportedXfaData(guideContainer, jsonWriter, XMLUtils.getBoundDataXmlPart(doc), null);
                        if (startsWithAfData) {
                            jsonWriter.key("unboundDataMap").value(XMLUtils.getMapOfUnboundData(doc));
                            jsonWriter.key("guidePrefillXml").value(XMLUtils.getPrefillXmlWithoutBoundPart(doc));
                        }
                    } else if (guideProps.get("xsdRef") != null || guideProps.get("letterRef") != null || guideProps.get("ddRef") != null || guideProps.get("xdpRef") == null && hasEmbeddedXsdForms) {
                        String boundDataXmlStr = XMLUtils.getBoundDataXmlPart(doc);
                        if (StringUtils.isNotBlank((CharSequence)boundDataXmlStr)) {
                            Document boundDoc = builder.parse(new ByteArrayInputStream(boundDataXmlStr.getBytes("UTF-8")));
                            this.getExportedGuideData(guideContainer, jsonWriter, boundDoc, i18n);
                        }
                        if (startsWithAfData) {
                            jsonWriter.key("unboundDataMap").value(XMLUtils.getMapOfUnboundData(doc));
                        }
                        jsonWriter.key("guidePrefillXml").value(XMLUtils.getXMLfromXsdDom(doc.getDocumentElement()));
                    } else {
                        Document unBoundDoc = builder.parse(new ByteArrayInputStream(XMLUtils.getUnboundDataXmlPart(doc).getBytes("UTF-8")));
                        this.getExportedGuideData(guideContainer, jsonWriter, unBoundDoc, i18n);
                        jsonWriter.key("guidePrefillXml").value(XMLUtils.getPrefillXmlWithoutBoundPart(doc));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error in creating data merged json from data Ref", (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    @Override
    public String getDataJson(Resource guideContainer, JSONCreationOptions options) {
        StringWriter stringWriter = new StringWriter();
        CustomJSONWriter jsonWriter = new CustomJSONWriter(stringWriter);
        jsonWriter.object();
        jsonWriter.key("guideState").object();
        try {
            this.writeDataJson(guideContainer, jsonWriter, options);
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
        String result = stringWriter.toString();
        return result;
    }

    @Override
    public String exportGuideDataJsonFromDataRef(Resource guideContainer, String dataRef, I18n i18n) {
        String result = null;
        try {
            JSONCreationOptions options = new JSONCreationOptions();
            options.setDataRef(dataRef);
            options.setI18n(i18n);
            result = this.getDataJson(guideContainer, options);
        }
        catch (Exception e) {
            this.logger.error("Error in creating data merged json from data Ref", (Throwable)e);
            throw new GuideException(e);
        }
        return result;
    }

    @Override
    public String exportGuideDataJson(Resource guideContainer, String data, I18n i18n) {
        String result = null;
        try {
            JSONCreationOptions options = new JSONCreationOptions();
            options.setData(data);
            options.setI18n(i18n);
            result = this.getDataJson(guideContainer, options);
        }
        catch (Exception e) {
            this.logger.error("Error in creating data merged json from data", (Throwable)e);
            throw new GuideException(e);
        }
        return result;
    }

    private void getExportedXfaData(Resource guideContainer, CustomJSONWriter jsonWriter, String data, String dataRef) {
        Map<String, String> xfaResult = this.xfaModelTransformerService.exportXfaJson(guideContainer, data, dataRef);
        jsonWriter.key("xfaState").object();
        jsonWriter.key("xfaDom").value(xfaResult.get("mergedformdom"));
        jsonWriter.key("xfaRenderContext").value(xfaResult.get("xfaRenderContext"));
        jsonWriter.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExportedGuideData(Resource guideContainer, CustomJSONWriter jsonWriter, Document doc, I18n i18n) throws GuideException {
        block12: {
            JSONObject guideJSON = this.exportGuideJsonObject(guideContainer, i18n);
            ValueMap guideProps = guideContainer.adaptTo(ValueMap.class);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(GuideModuleImporter.class.getName(), this.guideModuleImporter);
            try {
                if (doc != null) {
                    boolean isXsd = guideProps.get("xsdRef") != null;
                    String ddRef = (String)guideProps.get("ddRef");
                    String letterRef = (String)guideProps.get("letterRef");
                    ClassLoader dynamicClassLoader = this.dynamicClassLoaderManager.getDynamicClassLoader();
                    ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        KeyValueDataMerger keyValueDataMerge;
                        Thread.currentThread().setContextClassLoader(dynamicClassLoader);
                        JSONObject templateJson = this.exportGuideJsonObject(guideContainer);
                        boolean hasEmbeddedXsdForms = templateJson.optBoolean("isHasEmbeddedXsdForm");
                        if (this.guideDataMerger != null && (ddRef != null || letterRef != null)) {
                            keyValueDataMerge = this.guideDataMerger.createDataMerger(guideJSON, doc, params);
                        } else if (isXsd || hasEmbeddedXsdForms) {
                            keyValueDataMerge = new XsdDocumentDataMerger(guideJSON, doc, params);
                        } else {
                            if (this.guideModuleImporter != null) {
                                this.guideModuleImporter.extractVariablesFromData(doc, params);
                            }
                            keyValueDataMerge = new DocumentDataMerger(guideJSON, doc, params);
                        }
                        jsonWriter.key("guideDom").value(keyValueDataMerge.merge());
                        break block12;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                    }
                }
                String loadPath = (String)((Object)guideProps.get("loadPath", String.class));
                if (loadPath != null) {
                    ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
                    Resource initialDataResource = resourceResolver.resolve(loadPath);
                    ValueMap valueMap = initialDataResource.adaptTo(ValueMap.class);
                    ValueMapDataMerger keyValueDataMerge = new ValueMapDataMerger(guideJSON, valueMap, params);
                    jsonWriter.key("guideDom").value(keyValueDataMerge.merge());
                }
            }
            catch (Exception e) {
                this.logger.error("Error in creating data merged json", (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    private byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int length = 0;
        length = inputStream.read(buffer);
        while (length != -1) {
            baos.write(buffer, 0, length);
            length = inputStream.read(buffer);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readFile(String path) {
        Resource resource = null;
        StringWriter writer = null;
        Node fileNode = null;
        Node jcrContent = null;
        InputStream content = null;
        try {
            if (this.resourceResolverHelper.getResourceResolver() != null) {
                resource = this.resourceResolverHelper.getResourceResolver().getResource(path);
                fileNode = resource.adaptTo(Node.class);
                jcrContent = fileNode.getNode("jcr:content");
                content = jcrContent.getProperty("jcr:data").getBinary().getStream();
            } else {
                Session serviceSession = null;
                try {
                    serviceSession = this.repository.loginService(null, null);
                    if (serviceSession.nodeExists(path)) {
                        fileNode = serviceSession.getNode(path);
                        jcrContent = fileNode.getNode("jcr:content");
                        content = jcrContent.getProperty("jcr:data").getBinary().getStream();
                    }
                }
                catch (RepositoryException ex) {
                    this.logger.error("Error in accessing the repository using anonymous session " + path + ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (serviceSession != null) {
                        serviceSession.logout();
                    }
                }
            }
            if (content != null) {
                writer = new StringWriter();
                IOUtils.copy((InputStream)content, (Writer)writer);
                content.close();
            }
        }
        catch (IOException ex) {
            this.logger.error("Error in reading the file " + path + ex.getMessage(), (Throwable)ex);
        }
        catch (RepositoryException re) {
            this.logger.error("Error in accessing the file " + path + re.getMessage(), (Throwable)re);
        }
        return writer != null ? writer.toString() : null;
    }

    private String getSyncXfaScript(String guideJson, String xfaJson) {
        StringBuilder syncXfaBuilder = new StringBuilder("");
        syncXfaBuilder.append("window.guidelib.model._getGuideJsonWithSyncXfaProps(" + guideJson + "," + xfaJson + ");").append("\n");
        return syncXfaBuilder.toString();
    }

    private ArrayList<String> getExecutionScript(String clientLibRef, String serverUrl, String guideState, String contextPath) {
        ArrayList<String> execScript = new ArrayList<String>();
        if (clientLibRef != null) {
            String[] clientLib = new String[]{clientLibRef};
            Collection<ClientLibrary> clientLibrary = this.htmlLibraryManager.getLibraries(clientLib, null, true, false);
            Iterator<ClientLibrary> iter = clientLibrary.iterator();
            String path = iter.next().getPath();
            execScript.add(GuideUtils.getScriptAsStringFromClientLib(this.htmlLibraryManager, path));
        }
        if (serverUrl != null) {
            execScript.add("jQuery.support.cors = true;");
            execScript.add("window.guideBridge._updateAjaxUrl(\"" + serverUrl + "\");");
        }
        if (contextPath != null && contextPath.length() > 0) {
            execScript.add("window.guideBridge.registerConfig(\"contextPath\",\"" + contextPath + "\");");
        }
        execScript.add("window.guidelib.model.fireOnContainerDomElementReady(" + guideState + ");");
        execScript.add("var errorList = []; window.guideBridge.validate(errorList, null, false); errorList;");
        return execScript;
    }

    private void embedJavaFunctionsIntoRhinoContext(Scriptable scope) {
        String[] functionNames;
        for (String functionName : functionNames = GuideScriptObject.getExposedMethods()) {
            try {
                GuideScriptObject scriptObject = new GuideScriptObject(this.xfaModelTransformerService);
                scriptObject.setParentScope(scope);
                Method scriptableInstanceMethod = GuideScriptObject.class.getMethod(functionName, Object.class);
                GuideFunctionObject boundJavascriptFunction = new GuideFunctionObject(functionName, scriptableInstanceMethod, (Scriptable)scriptObject);
                scope.put(functionName, scope, (Object)boundJavascriptFunction);
            }
            catch (Exception ex) {
                this.logger.error("Method not found in Guide Script Object " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private Map<String, String>[] validateInternal(String guideState, Resource guideContainer, String serverUrl, String locale, String contextPath) throws GuideException {
        GuideContainer guideContainerBean = new GuideContainer(guideContainer);
        String clientLibRef = guideContainerBean.getClientLibRef();
        ArrayList<String> execScript = this.getExecutionScript(clientLibRef, serverUrl, guideState, contextPath);
        Map[] errorList = null;
        Scriptable scope = RhinoScriptProcessor.getRhinoScope();
        try {
            scope = this.embedGuideStaticScriptsIntoRhino(guideContainerBean, scope, locale);
            this.embedJavaFunctionsIntoRhinoContext(scope);
            int size = execScript.size();
            for (int i = 0; i < size; ++i) {
                String script = execScript.get(i);
                if (script == null) continue;
                if (i == size - 1) {
                    errorList = (Map[])RhinoScriptProcessor.interpret(script, "execScript" + i, scope);
                    continue;
                }
                scope = (Scriptable)RhinoScriptProcessor.interpret(script, "execScript" + i, scope);
            }
            if (errorList != null && errorList.length >= 0) {
                if (errorList.length != 0) {
                    this.logger.info("Server side validation errors for the Adaptive Form :- " + guideContainer.getPath());
                    for (int index = 0; index < errorList.length; ++index) {
                        this.logger.info("SomExpression: " + (String)errorList[index].get("som") + " ErrorMessage: " + (String)errorList[index].get("errorText"));
                    }
                }
                return errorList;
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error("Error while doing server side validation -" + ex.getMessage(), (Throwable)ex);
            throw new GuideException(ex);
        }
    }

    private Scriptable embedGuideStaticScriptsIntoRhino(GuideContainer guideContainer, Scriptable scope, String locale) {
        String script;
        int i;
        String xdpRef = guideContainer.getXdpRef();
        if (this.isActivateSuccess.compareAndSet(false, true)) {
            this.compileAndCacheGuideStaticScripts();
        }
        for (int i2 = 0; i2 < this.envScript.size(); ++i2) {
            scope = i2 == 8 ? (Scriptable)RhinoScriptProcessor.interpret(this.envScript.get(i2), "parser", scope) : RhinoScriptProcessor.execute(this.envScript.get(i2), "envScript" + i2, scope);
        }
        String[] aemSupportedLocales = this.getAemSupportedLocales();
        int index = GuideUtils.getLocaleIndexFromLocale(locale, aemSupportedLocales);
        String localeLib = this.localeSpecificLibs.get(index);
        if (localeLib != null) {
            scope = RhinoScriptProcessor.execute(localeLib, "localeSpecificLib" + aemSupportedLocales[index], scope);
        }
        for (i = 0; i < this.scriptToLoadBeforeXFA.size(); ++i) {
            script = this.scriptToLoadBeforeXFA.get(i);
            if (script == null) continue;
            scope = RhinoScriptProcessor.execute(script, "scriptToLoadBeforeXFA" + i, scope);
        }
        if (xdpRef != null && xdpRef.length() > 0) {
            for (i = 0; i < this.xfaSpecificScript.size(); ++i) {
                script = this.xfaSpecificScript.get(i);
                if (script == null) continue;
                scope = RhinoScriptProcessor.execute(script, "xfaSpecificScript" + i, scope);
            }
        }
        for (i = 0; i < this.scriptToLoadAfterXFA.size(); ++i) {
            script = this.scriptToLoadAfterXFA.get(i);
            if (script == null) continue;
            scope = RhinoScriptProcessor.execute(script, "scriptToLoadAfterXFA" + i, scope);
        }
        scope = (Scriptable)RhinoScriptProcessor.interpret("window.guideBridge.hostName =\"server\";", "setHostName", scope);
        return scope;
    }

    private Map<String, Object> getGuideInitializationStateWithSyncXFAProps(String guideJson, String xfaJson, GuideContainer guideContainer, String locale) {
        String syncXfaScript = this.getSyncXfaScript(guideJson, xfaJson);
        Map guideJsonWithXfaPropsSync = null;
        Scriptable scope = RhinoScriptProcessor.getRhinoScope();
        try {
            scope = this.embedGuideStaticScriptsIntoRhino(guideContainer, scope, locale);
            if (syncXfaScript != null && syncXfaScript.length() > 0) {
                guideJsonWithXfaPropsSync = (Map)RhinoScriptProcessor.interpret(syncXfaScript, "syncXfaScript", scope);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error during sync xfa props -" + ex.getMessage(), (Throwable)ex);
            throw new GuideException(ex);
        }
        if (guideJsonWithXfaPropsSync != null && guideJsonWithXfaPropsSync.size() > 0) {
            return guideJsonWithXfaPropsSync;
        }
        return null;
    }

    private HashMap<String, Object> getGuideJsonForLocale(GuideContainer guideContainer, String locale) {
        try {
            Resource guideResource = guideContainer.getResource();
            String[] aemSupportedLocales = this.getAemSupportedLocales();
            HashMap<String, Object> guideJsonListForLocale = new HashMap<String, Object>(aemSupportedLocales.length);
            Locale localeObject = new Locale(locale);
            I18n i18n = GuideUtils.getI18nForDesiredLocale(guideContainer.getSlingRequest(), guideResource, localeObject);
            guideJsonListForLocale.put(locale, this.exportGuideJson(guideResource, i18n, localeObject));
            return guideJsonListForLocale;
        }
        catch (Exception e) {
            this.logger.error("Error in getGuideJsonForAllLocales", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> syncXfaProps(GuideContainer guideContainer, String locale) throws GuideException {
        try {
            Cache guideJsonCache = this.cacheManager.getOrCreateCache("cache.json");
            String containerPath = guideContainer.getPath();
            String key = containerPath + "_" + locale;
            HashMap<String, Object> renderHasMap = null;
            Map<Object, Object> guideXFAmap = null;
            Calendar lastModifiedTime = GuideUtils.getLastModifiedTimeFromStaleAssetIndicatorService(guideContainer, this.staleAssetIndicatorService);
            boolean isCacheStale = guideJsonCache.isCacheEntryStale(key, lastModifiedTime);
            if (isCacheStale) {
                for (String supportedLocale : this.guideLocalizationService.getSupportedLocales()) {
                    String currentKey = containerPath + "_" + supportedLocale;
                    guideJsonCache.clear(currentKey);
                }
                this.logger.debug("resetting cache since the entry is stale");
            }
            if (!guideJsonCache.entryExists(key)) {
                String guideJson = null;
                String xfaJson = guideContainer.getXfaJson();
                String localeString = GuideUtils.getGuideRuntimeLocale(guideContainer.getSlingRequest(), guideContainer.getResource());
                HashMap<String, Object> guideJsonListForAllLocales = this.getGuideJsonForLocale(guideContainer, locale);
                guideJson = (String)guideJsonListForAllLocales.get(locale);
                if (guideContainer.getXdpRef().length() > 0) {
                    guideXFAmap = this.getGuideInitializationStateWithSyncXFAProps(guideJson, xfaJson, guideContainer, locale);
                } else {
                    guideXFAmap = new HashMap();
                    guideXFAmap.put("guidejson", guideJson);
                    guideXFAmap.put("xfajson", xfaJson);
                }
                if (guideContainer.getSlingRequest() != null && WCMMode.fromRequest((ServletRequest)guideContainer.getSlingRequest()).equals((Object)WCMMode.DISABLED)) {
                    guideJsonCache.put(key, guideXFAmap, lastModifiedTime);
                    if (guideContainer.isRenderCall()) {
                        String guideJsonString = (String)guideXFAmap.get("guidejson");
                        JSONObject trimmedJsonObject = GuideUtils.trimLazyChildren(guideJsonString);
                        renderHasMap = new HashMap();
                        renderHasMap.put("guidejson", trimmedJsonObject.toString());
                        renderHasMap.put("xfajson", guideXFAmap.get("xfajson"));
                        return renderHasMap;
                    }
                }
            } else {
                guideXFAmap = (HashMap<String, Object>)guideJsonCache.get(key);
            }
            renderHasMap = guideXFAmap;
            if (guideContainer.isRenderCall()) {
                String guideJsonString = (String)renderHasMap.get("guidejson");
                JSONObject trimmedJsonObject = GuideUtils.trimLazyChildren(guideJsonString);
                String xfaJsonString = (String)renderHasMap.get("xfajson");
                renderHasMap = new HashMap<String, Object>();
                renderHasMap.put("guidejson", trimmedJsonObject.toString());
                renderHasMap.put("xfajson", xfaJsonString);
            }
            return renderHasMap;
        }
        catch (Exception e) {
            this.logger.error("syncXfaProps call failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public Map<String, String>[] validate(String dataXml, Resource guideContainerResource, String serverUrl, String locale, String contextPath) throws GuideException {
        if (dataXml != null && guideContainerResource != null) {
            String newServerUrl = serverUrl;
            GuideContainer guideContainer = new GuideContainer(guideContainerResource);
            guideContainer.setGuideModelTransformer(this);
            if (this.enforceServerUrlConfig.booleanValue()) {
                try {
                    String externalUrl = this.externalizer.externalLink(guideContainerResource.getResourceResolver(), "local", "");
                    if (externalUrl != null) {
                        int index = StringUtils.ordinalIndexOf((CharSequence)externalUrl, (CharSequence)"/", (int)3);
                        if (index != -1) {
                            newServerUrl = externalUrl.substring(0, index);
                            new URL(newServerUrl);
                        } else {
                            newServerUrl = serverUrl;
                        }
                    }
                }
                catch (MalformedURLException ex) {
                    newServerUrl = serverUrl;
                    this.logger.error("URL Provided in Externalizer Service Configuration is invalid. Falling back to URL generated from request object " + ex.getMessage(), (Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    newServerUrl = serverUrl;
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return this.validateInternal(guideContainer.getGuideInitializationState(dataXml, locale), guideContainerResource, newServerUrl, locale, contextPath);
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<String, String>[] validate(String dataXml, Resource guideContainerResource, String serverUrl, String contextPath) throws GuideException {
        return this.validate(dataXml, guideContainerResource, serverUrl, "en", contextPath);
    }

    protected void bindGuideDraftStateProvider(GuideDraftStateProvider provider, Map<String, Object> config) {
        this.providers.put(ServiceUtil.getComparableForServiceRanking(config), provider);
    }

    protected void unbindGuideDraftStateProvider(GuideDraftStateProvider provider, Map<String, Object> config) {
        this.providers.remove(ServiceUtil.getComparableForServiceRanking(config));
    }

    @Override
    public GuideValidationResult validateData(String dataXml, Resource guideContainerResource, String serverUrl, String locale, String contextPath) throws GuideException {
        if (locale == null) {
            locale = "en";
        }
        List<GuideError> guideErrorList = this.transformValidationData(this.validate(dataXml, guideContainerResource, serverUrl, locale, contextPath));
        return new GuideValidationResult(guideErrorList);
    }

    private List<GuideError> transformValidationData(Map<String, String>[] validationArr) {
        if (validationArr == null) {
            return null;
        }
        ArrayList<GuideError> transformedList = new ArrayList<GuideError>();
        for (int i = 0; i < validationArr.length; ++i) {
            Map<String, String> validationItem = validationArr[i];
            transformedList.add(new GuideError(validationItem.get("som"), validationItem.get("errorText")));
        }
        return transformedList;
    }

    @Override
    public String getAdaptiveFormTreeJSON(Resource guideContainer, ResourcePropertyTransformer transformer) throws JSONException {
        JSONCreationOptions options = new JSONCreationOptions();
        options.setIncludeFragmentJson(true);
        options.setTransformer(transformer);
        JSONObject obj = this.jsonObjectCreator.create(guideContainer, -1, options);
        return obj.toString();
    }

    protected void bindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        this.xfaModelTransformerService = xFAModelTransformer;
    }

    protected void unbindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        if (this.xfaModelTransformerService == xFAModelTransformer) {
            this.xfaModelTransformerService = null;
        }
    }

    protected void bindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        this.formsCommonConfigurationService = formsCommonConfigurationService;
    }

    protected void unbindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        if (this.formsCommonConfigurationService == formsCommonConfigurationService) {
            this.formsCommonConfigurationService = null;
        }
    }

    protected void bindGuideLocalizationService(GuideLocalizationService guideLocalizationService) {
        this.guideLocalizationService = guideLocalizationService;
    }

    protected void unbindGuideLocalizationService(GuideLocalizationService guideLocalizationService) {
        if (this.guideLocalizationService == guideLocalizationService) {
            this.guideLocalizationService = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        this.guideStoreContentSubmission = guideStoreContentSubmission;
    }

    protected void unbindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        if (this.guideStoreContentSubmission == guideStoreContentSubmission) {
            this.guideStoreContentSubmission = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        this.jsonObjectCreator = jsonObjectCreator;
    }

    protected void unbindJsonObjectCreator(JsonObjectCreator jsonObjectCreator) {
        if (this.jsonObjectCreator == jsonObjectCreator) {
            this.jsonObjectCreator = null;
        }
    }

    protected void bindAdaptiveFormConfigurationService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        this.adaptiveFormConfigurationService = adaptiveFormConfigurationService;
    }

    protected void unbindAdaptiveFormConfigurationService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        if (this.adaptiveFormConfigurationService == adaptiveFormConfigurationService) {
            this.adaptiveFormConfigurationService = null;
        }
    }

    protected void bindStaleAssetIndicatorService(StaleAssetIndicatorService staleAssetIndicatorService) {
        this.staleAssetIndicatorService = staleAssetIndicatorService;
    }

    protected void unbindStaleAssetIndicatorService(StaleAssetIndicatorService staleAssetIndicatorService) {
        if (this.staleAssetIndicatorService == staleAssetIndicatorService) {
            this.staleAssetIndicatorService = null;
        }
    }

    protected void bindCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void unbindCacheManager(CacheManager cacheManager) {
        if (this.cacheManager == cacheManager) {
            this.cacheManager = null;
        }
    }

    protected void bindFormDataXMLProviderRegistry(FormDataXMLProviderRegistry formDataXMLProviderRegistry) {
        this.formDataXMLProviderRegistry = formDataXMLProviderRegistry;
    }

    protected void unbindFormDataXMLProviderRegistry(FormDataXMLProviderRegistry formDataXMLProviderRegistry) {
        if (this.formDataXMLProviderRegistry == formDataXMLProviderRegistry) {
            this.formDataXMLProviderRegistry = null;
        }
    }

    protected void bindGuideModuleImporter(GuideModuleImporter guideModuleImporter) {
        this.guideModuleImporter = guideModuleImporter;
    }

    protected void unbindGuideModuleImporter(GuideModuleImporter guideModuleImporter) {
        if (this.guideModuleImporter == guideModuleImporter) {
            this.guideModuleImporter = null;
        }
    }

    protected void bindGuideDataMerger(GuideDataMergerSPI guideDataMergerSPI) {
        this.guideDataMerger = guideDataMergerSPI;
    }

    protected void unbindGuideDataMerger(GuideDataMergerSPI guideDataMergerSPI) {
        if (this.guideDataMerger == guideDataMergerSPI) {
            this.guideDataMerger = null;
        }
    }
}

