/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.GuideProgressiveStrategy;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferenceStrategy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, metatype=false, label="Adaptive Form Progressive Strategy Manager", description="Adaptive Form Progressive Strategy Manager Service")
@Service(value={GuideProgressiveStrategyManager.class})
@References(value={@Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, strategy=ReferenceStrategy.EVENT, referenceInterface=GuideProgressiveStrategy.class)})
public class GuideProgressiveStrategyManagerImpl
implements GuideProgressiveStrategyManager {
    private static Logger logger = LoggerFactory.getLogger(GuideProgressiveStrategyManagerImpl.class);
    private Map<String, GuideProgressiveStrategy> guideProgressiveStrategies = new HashMap<String, GuideProgressiveStrategy>();
    private final Object strategyRegLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindGuideProgressiveStrategy(GuideProgressiveStrategy guideProgressiveStrategy) {
        Object object = this.strategyRegLock;
        synchronized (object) {
            if (this.guideProgressiveStrategies.get(guideProgressiveStrategy.getName()) != null) {
                logger.warn("Strategy Name Conflict: Strategy with name " + guideProgressiveStrategy.getName() + " already exist. Discarding the old service and registering the new one with same name.");
            }
            this.guideProgressiveStrategies.put(guideProgressiveStrategy.getName(), guideProgressiveStrategy);
            logger.info("Registering strategy " + guideProgressiveStrategy.getName() + ": " + guideProgressiveStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindGuideProgressiveStrategy(GuideProgressiveStrategy guideProgressiveStrategy) {
        Object object = this.strategyRegLock;
        synchronized (object) {
            this.guideProgressiveStrategies.remove(guideProgressiveStrategy.getName());
            logger.info("Un-registering strategy " + guideProgressiveStrategy.getName() + ": " + guideProgressiveStrategy);
        }
    }

    @Override
    public GuideProgressiveStrategy getGuideProgressiveStrategyService(String name) {
        return this.guideProgressiveStrategies.get(name);
    }

    @Override
    public Collection<GuideProgressiveStrategy> getAllGuideProgressiveStrategyServices() {
        return this.guideProgressiveStrategies.values();
    }
}

