/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideStoreContentSubmission;
import com.adobe.granite.security.user.UserManagementService;
import com.day.cq.commons.jcr.JcrUtil;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false, label="Adaptive Form Submission Service", description="Service to aid in submission using service-users")
@Service(value={GuideStoreContentSubmission.class})
public class GuideStoreContentSubmissionImpl
implements GuideStoreContentSubmission {
    private Logger log = LoggerFactory.getLogger(GuideStoreContentSubmission.class);
    @Reference
    private SlingRepository repository;
    @Reference
    private UserManagementService userManagementService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submissionForStoreContentUsingServiceUser(String authType, Session userSession, String guideStartParameter, String path) throws GuideException {
        Session serviceSession = null;
        try {
            serviceSession = this.repository.loginService(null, null);
            if (userSession.hasPermission("/content/usergenerated/content/forms", "add_node") && userSession.hasPermission(path, "add_node") && StringUtils.isNotEmpty((CharSequence)authType)) {
                Node parent;
                Node node = JcrUtil.createPath(path, "sling:Folder", serviceSession);
                if (node != null) {
                    node.setProperty("afStoreContentTempPermission", path);
                }
                if (!(parent = node.getParent()).hasProperty("nodePath") && StringUtils.startsWith((CharSequence)guideStartParameter, (CharSequence)"/content/forms/af/")) {
                    parent.setProperty("nodePath", guideStartParameter);
                }
                serviceSession.save();
                UserManager userManager = AccessControlUtil.getUserManager(serviceSession);
                Authorizable userSessionAuthorizable = userManager.getAuthorizable(userSession.getUserID());
                Authorizable everyoneAuthorizable = userManager.getAuthorizable(((JackrabbitSession)serviceSession).getPrincipalManager().getEveryone());
                AccessControlUtil.replaceAccessControlEntry(serviceSession, path, everyoneAuthorizable.getPrincipal(), new String[0], new String[]{"{http://www.jcp.org/jcr/1.0}all"}, new String[0], null);
                if (userSessionAuthorizable != null) {
                    AccessControlUtil.replaceAccessControlEntry(serviceSession, path, userSessionAuthorizable.getPrincipal(), new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}modifyProperties", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement"}, new String[0], new String[0], null);
                }
            } else {
                this.log.error("User does not have add_node permissions or its an anonymous user on {}", (Object)path);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to create path or set permissions.", (Throwable)e);
        }
        finally {
            try {
                if (serviceSession != null) {
                    if (serviceSession.hasPendingChanges()) {
                        serviceSession.save();
                    }
                    serviceSession.logout();
                }
            }
            catch (Exception e) {
                this.log.error("Failed to save the changes made in the repository", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetPrivilegesForStoreContent(Session userSession, String path) {
        Session serviceSession = null;
        try {
            serviceSession = this.repository.loginService(null, null);
            UserManager userManager = AccessControlUtil.getUserManager(serviceSession);
            Authorizable userSessionAuthorizable = userManager.getAuthorizable(userSession.getUserID());
            if (userSessionAuthorizable != null) {
                AccessControlUtil.replaceAccessControlEntry(serviceSession, path, userSessionAuthorizable.getPrincipal(), new String[0], new String[0], new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}modifyProperties", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement"}, null);
            }
        }
        catch (Exception e) {
            this.log.error("Unable to remove privileges", (Throwable)e);
        }
        finally {
            try {
                if (serviceSession != null) {
                    if (serviceSession.hasPendingChanges()) {
                        serviceSession.save();
                    }
                    serviceSession.logout();
                }
            }
            catch (Exception e) {
                this.log.error("Failed to save the changes made in the repository", (Throwable)e);
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    protected void unbindUserManagementService(UserManagementService userManagementService) {
        if (this.userManagementService == userManagementService) {
            this.userManagementService = null;
        }
    }
}

