/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service.impl;

import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideModelImporter;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.service.JsonObjectCreator;
import com.adobe.aemds.guide.service.XFAModelTransformer;
import com.adobe.aemds.guide.service.impl.GuideModelImporterImpl;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideSchema;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.aemds.guide.utils.guideJson.AbsoluteBindrefResolver;
import com.adobe.aemds.guide.utils.guideJson.AssetRefCollector;
import com.adobe.aemds.guide.utils.guideJson.CrossFragFieldsCollector;
import com.adobe.aemds.guide.utils.guideJson.DuplicateBindrefsCollector;
import com.adobe.aemds.guide.utils.guideJson.EmbeddedFormsXsdRootFixer;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonItemsTraverser;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import com.adobe.aemds.guide.utils.guideJson.LazyPanelsCollector;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false, label="Adaptive Form Json Object creator", description="Adaptive Form Json Object creator Service")
@Service(value={JsonObjectCreator.class})
public class JsonObjectCreatorImpl
implements JsonObjectCreator {
    private static Logger log = LoggerFactory.getLogger(JsonObjectCreatorImpl.class);
    @Reference(target="(component.name=org.apache.sling.i18n.impl.JcrResourceBundleProvider)")
    private ResourceBundleProvider resourceBundleProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideModuleImporter guideModuleImporter;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private XFAModelTransformer xfaModelTransformerService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideModelImporter guideModelImporterService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideModelTransformer guideModelTransformer;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private AdaptiveFormConfigurationService adaptiveFormConfigurationService;
    private static Set<String> blackListProp = new HashSet<String>(Arrays.asList("expJson", "cssStyle", "styleProperties", "cq:cssClass", "jcr:lastModified", "jcr:lastModifiedBy", "jcr:primaryType"));
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private static final DateFormat CALENDAR_FORMAT = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", DATE_FORMAT_LOCALE);

    public JSONObject create(Resource resource, int maxRecursionLevels, JSONCreationOptions jsonCreationOptions) throws JSONException {
        JSONObject jsonObject = this.create(resource, 0, maxRecursionLevels, jsonCreationOptions, "");
        return jsonObject;
    }

    public JSONObject createWithContext(Resource resource, int maxRecursionLevels, JSONCreationOptions jsonCreationOptions) {
        JSONObject guideJson = null;
        try {
            guideJson = this.create(resource, maxRecursionLevels, jsonCreationOptions);
            this.refineGuideJsonPostCreation(guideJson, resource);
        }
        catch (Exception e) {
            log.error("Could not emit JSON with context", (Throwable)e);
        }
        return guideJson;
    }

    private void refineGuideJsonPostCreation(JSONObject guideJson, Resource resource) {
        String xsdRootEl;
        ArrayList<GuideJsonVisitor> visitors = new ArrayList<GuideJsonVisitor>();
        JSONObject guideContainer = GuideUtils.getGuideContainer(guideJson);
        if (guideContainer.has("xsdRef") && XMLUtils.isValidXsdRoot(xsdRootEl = this.fixXsdRootElementProperty(guideContainer, resource))) {
            visitors.add(new AbsoluteBindrefResolver(xsdRootEl));
        }
        DuplicateBindrefsCollector duplicateBindrefsCollector = new DuplicateBindrefsCollector();
        if (!this.adaptiveFormConfigurationService.getPreventLiveLinkingFields().booleanValue()) {
            visitors.add(duplicateBindrefsCollector);
        }
        CrossFragFieldsCollector crossFragFieldsCollector = new CrossFragFieldsCollector();
        visitors.add(crossFragFieldsCollector);
        LazyPanelsCollector lazyPanelsCollector = new LazyPanelsCollector();
        visitors.add(lazyPanelsCollector);
        AssetRefCollector assetRefCollector = new AssetRefCollector();
        visitors.add(assetRefCollector);
        EmbeddedFormsXsdRootFixer embeddedFormsXsdRootFixer = new EmbeddedFormsXsdRootFixer(resource, this.guideModelTransformer);
        visitors.add(embeddedFormsXsdRootFixer);
        GuideJsonItemsTraverser guideJsonItemsTraverser = new GuideJsonItemsTraverser(guideContainer, visitors);
        guideJsonItemsTraverser.traverse();
        try {
            guideContainer.put("repeatBindRef", duplicateBindrefsCollector.getDuplicatedBindRefs());
            guideContainer.put("guideGlobalLazyField", crossFragFieldsCollector.getGlobals());
            guideContainer.put("allLazyChildren", lazyPanelsCollector.getLazyTemplateIds());
            guideContainer.put("assetRefs", assetRefCollector.getAssetRefs());
            if (embeddedFormsXsdRootFixer.isHasEmbeddedForms()) {
                guideContainer.put("hasEmbeddedForms", true);
                if (embeddedFormsXsdRootFixer.isHasEmbeddedXsdForm()) {
                    guideContainer.put("isHasEmbeddedXsdForm", true);
                }
            }
        }
        catch (JSONException e) {
            log.error("Failed to write properties in guideJson", (Throwable)e);
        }
    }

    private String fixXsdRootElementProperty(JSONObject guideJson, Resource resource) {
        String xsdRootEl = XMLUtils.extractXsdRootElement(guideJson);
        if (!XMLUtils.isValidXsdRoot(xsdRootEl)) {
            log.debug("Failed read XSD root element name property from node for XSD based form");
            xsdRootEl = ((GuideModelImporterImpl)this.guideModelImporterService).getFirstXSDRootElementName(resource);
            if (!XMLUtils.isValidXsdRoot(xsdRootEl)) {
                log.debug("Failed to fetch XSD root element by parsing XSD schema");
                xsdRootEl = "?";
            }
            try {
                guideJson.put("xsdRootElement", xsdRootEl);
            }
            catch (JSONException e) {
                log.error("Failed to add xsdRootElement property in Guide Json", (Throwable)e);
            }
        }
        return XMLUtils.extractXsdRootElement(guideJson);
    }

    private JSONObject create(Resource resource, int currentRecursionLevel, int maxRecursionLevels, JSONCreationOptions jsonCreationOptions, String parentSOM) throws JSONException {
        if (jsonCreationOptions == null) {
            jsonCreationOptions = new JSONCreationOptions();
        }
        I18n i18n = jsonCreationOptions.getI18n();
        ValueMap valueMap = resource.adaptTo(ValueMap.class);
        ValueMap propertyMap = valueMap != null ? valueMap : resource.adaptTo(Map.class);
        JSONObject obj = new JSONObject();
        String templateId = null;
        if (propertyMap == null) {
            String value = resource.adaptTo(String.class);
            if (value != null) {
                obj.put(ResourceUtil.getName(resource), value);
            } else {
                String[] values = resource.adaptTo(String[].class);
                if (values != null) {
                    obj.put(ResourceUtil.getName(resource), new JSONArray(Arrays.asList(values)));
                }
            }
        } else if (jsonCreationOptions.getTransformer() != null) {
            JSONObject tmpObj = jsonCreationOptions.getTransformer().transform(resource, parentSOM);
            if (tmpObj == null) {
                return null;
            }
            Iterator<String> keys = tmpObj.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                obj.put(key, tmpObj.get(key));
            }
        } else {
            Iterator props = propertyMap.entrySet().iterator();
            String resourceType = (String)propertyMap.get("sling:resourceType");
            if (resource.getPath() != null && !"items".equals(resource.getName())) {
                templateId = NodeStructureUtils.getGuideNodeHtmlId(resource);
                if (templateId != null && templateId.length() > 0) {
                    obj.put("templateId", templateId);
                    obj.put("id", "");
                }
                if (jsonCreationOptions.isIncludeJcrPath()) {
                    obj.put("jcr:path", resource.getPath());
                }
            }
            if (!"items".equals(resource.getName())) {
                String effectiveBindRef;
                String compName = null;
                if (propertyMap.containsKey("guideNodeClass") && "guideSeparator".equals(compName = (String)propertyMap.get("guideNodeClass"))) {
                    return null;
                }
                while (props.hasNext()) {
                    Map.Entry prop = props.next();
                    String propName = prop.getKey().toString();
                    Object propValue = prop.getValue();
                    if (propValue instanceof String && compName != null && i18n != null && GuideSchema.isLocalizableProperty(compName, propName)) {
                        String translatedString = GuideUtils.translateOrReturnOriginal((String)propValue, i18n);
                        propValue = translatedString;
                    }
                    if (blackListProp.contains(propName)) continue;
                    JsonObjectCreatorImpl.createProperty(obj, valueMap, propName, propValue, i18n, resource);
                }
                String bindRef = JsonObjectCreatorImpl.handleMinMaxOccursAndBindRefForFragments(propertyMap, obj);
                String name = (String)propertyMap.get("name");
                String string = effectiveBindRef = bindRef != null ? bindRef : name;
                if (!StringUtils.isEmpty((CharSequence)compName) && propertyMap.containsKey("jcr:title")) {
                    String nonLocalizedTitle = (String)propertyMap.get("jcr:title");
                    JsonObjectCreatorImpl.createProperty(obj, valueMap, "nonLocalizedTitle", nonLocalizedTitle, null, resource);
                }
                String slingResourceType = jsonCreationOptions.getFormResourceProperty("sling:resourceType");
                if (this.guideModuleImporter != null && !"fd/adaddon/components/guideDocumentContainer".equals(slingResourceType)) {
                    String resolvedHtml;
                    if (propertyMap.containsKey("assetRef")) {
                        resolvedHtml = "";
                        String assetRef = (String)propertyMap.get("assetRef");
                        if (!StringUtils.isEmpty((CharSequence)assetRef) && !StringUtils.isEmpty((CharSequence)compName)) {
                            if ("guideAdModule".equals(compName)) {
                                resolvedHtml = this.guideModuleImporter.getModuleResolution(assetRef, null);
                            } else if ("guideAdModuleGroup".equals(compName)) {
                                HashMap<String, Object> moduleParameter = new HashMap<String, Object>();
                                moduleParameter.put("letterRef", jsonCreationOptions.getFormResourceProperty("letterRef"));
                                resolvedHtml = this.guideModuleImporter.getModuleGroupResolution(assetRef, moduleParameter);
                            }
                        }
                        obj.put("_value", resolvedHtml);
                    } else if ("guideAdModuleGroup".equals(compName)) {
                        resolvedHtml = "";
                        Resource itemsResource = resource.getChild("items");
                        if (itemsResource != null) {
                            ArrayList<String> moduleAssetRefs = new ArrayList<String>();
                            for (Resource itemResource : itemsResource.getChildren()) {
                                ValueMap itemValueMap = ResourceUtil.getValueMap(itemResource);
                                String itemAssetRef = itemValueMap.get("assetRef", "");
                                if (StringUtils.isEmpty((CharSequence)itemAssetRef)) continue;
                                moduleAssetRefs.add(itemAssetRef);
                            }
                            HashMap<String, Object> moduleParameter = new HashMap<String, Object>();
                            moduleParameter.put("moduleList", moduleAssetRefs);
                            resolvedHtml = this.guideModuleImporter.getModuleGroupResolution(null, moduleParameter);
                        }
                        obj.put("_value", resolvedHtml);
                    }
                }
            }
        }
        if (JsonObjectCreatorImpl.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            Iterator<Resource> children = ResourceUtil.listChildren(resource);
            while (children.hasNext()) {
                Resource n = children.next();
                if (obj.has("SOM")) {
                    parentSOM = obj.getString("SOM");
                }
                this.createSingleResource(n, obj, currentRecursionLevel, maxRecursionLevels, jsonCreationOptions, parentSOM);
            }
        }
        return obj;
    }

    private static synchronized String format(Calendar date) {
        return CALENDAR_FORMAT.format(date.getTime());
    }

    private static Object getValue(Object value) {
        if (value instanceof InputStream) {
            return 0;
        }
        if (value instanceof Calendar) {
            return JsonObjectCreatorImpl.format((Calendar)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSingleResource(Resource n, JSONObject parent, int currentRecursionLevel, int maxRecursionLevels, JSONCreationOptions jsonCreationOptions, String parentSOM) throws JSONException {
        block18: {
            JSONObject obj;
            block19: {
                I18n i18nPrevious;
                String prevGuideContainerPath;
                String bindPrefixForFragmentPrevious;
                String fragmentModelRootPrevious;
                String previousPrefixId;
                block17: {
                    if (!JsonObjectCreatorImpl.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) break block18;
                    obj = null;
                    Map propertyMap = n.adaptTo(ValueMap.class);
                    String fragRef = (String)propertyMap.get("fragRef");
                    if (fragRef == null || fragRef.length() <= 0) break block19;
                    String fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRef);
                    Resource fragRefContainerResource = n.getResourceResolver().getResource(fragRefContainerPath);
                    Resource fragRootPanel = null;
                    if (fragRefContainerResource != null) {
                        fragRootPanel = GuideUtils.getRootPanel(fragRefContainerResource);
                    } else {
                        log.warn("The fragment at specified path " + fragRef + " is not available.");
                    }
                    previousPrefixId = null;
                    fragmentModelRootPrevious = null;
                    String bindPrefixForFragment = null;
                    bindPrefixForFragmentPrevious = null;
                    prevGuideContainerPath = null;
                    i18nPrevious = null;
                    try {
                        String fragmentModelRoot;
                        GuideFragmentHolder guideFragmentHolderPrev = GuideContainerThreadLocal.getGuideFragmentHolder();
                        prevGuideContainerPath = GuideContainerThreadLocal.getGuideContainerPath();
                        if (guideFragmentHolderPrev != null) {
                            previousPrefixId = guideFragmentHolderPrev.getFragPrefixID();
                            bindPrefixForFragmentPrevious = guideFragmentHolderPrev.getBindRefPrefixForFragment();
                            fragmentModelRootPrevious = guideFragmentHolderPrev.getFragmentModelRoot();
                            i18nPrevious = guideFragmentHolderPrev.getI18n();
                        }
                        String currentPrefixId = NodeStructureUtils.getFragPrefixString(n, previousPrefixId);
                        obj = this.create(n, currentRecursionLevel + 1, maxRecursionLevels, jsonCreationOptions, parentSOM);
                        parent.put(ResourceUtil.getName(n), obj);
                        if (fragRefContainerResource == null) break block17;
                        ValueMap containerValueMap = ResourceUtil.getValueMap(fragRefContainerResource);
                        if (obj != null && obj.has("bindRef")) {
                            bindPrefixForFragment = (String)obj.get("bindRef");
                        }
                        if (StringUtils.isBlank((CharSequence)(fragmentModelRoot = containerValueMap.get("xsdRootElement", containerValueMap.get("fragmentModelRoot", ""))))) {
                            Map<String, String> mapOfNameAndFragmentModelRoot;
                            if (containerValueMap.containsKey("xdpRef") && (mapOfNameAndFragmentModelRoot = this.xfaModelTransformerService.getXDPFramgmentRootSubform((String)containerValueMap.get("xdpRef"))) != null) {
                                fragmentModelRoot = mapOfNameAndFragmentModelRoot.get("fragmentModelRoot");
                            }
                        } else if (!StringUtils.startsWith((CharSequence)fragmentModelRoot, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)fragmentModelRoot, (CharSequence)"xfa[0].form[0]")) {
                            fragmentModelRoot = "/" + fragmentModelRoot;
                        }
                        I18n i18nForFragment = GuideELUtils.getI18n(this.resourceBundleProvider, fragRefContainerResource, jsonCreationOptions.getLocale());
                        GuideContainerThreadLocal.setGuideFragmentHolder(currentPrefixId, bindPrefixForFragment, fragmentModelRoot, i18nForFragment);
                        GuideContainerThreadLocal.setGuideContainerPath(fragRefContainerResource.getPath());
                        boolean includeFragmentJson = false;
                        if (jsonCreationOptions != null) {
                            includeFragmentJson = jsonCreationOptions.isIncludeFragmentJson();
                        }
                        if (!includeFragmentJson) break block17;
                        JSONCreationOptions jsonCreationOptionsWithFragmentI18n = new JSONCreationOptions(i18nForFragment, jsonCreationOptions.isIncludeJcrPath(), jsonCreationOptions.isIncludeFragmentJson(), jsonCreationOptions.getLocale(), jsonCreationOptions.getFormResource());
                        jsonCreationOptionsWithFragmentI18n.setTransformer(jsonCreationOptions.getTransformer());
                        JSONObject itemsNode = new JSONObject();
                        obj.put("items", itemsNode);
                        String currentParentSOM = parentSOM;
                        if (obj.has("SOM")) {
                            currentParentSOM = obj.getString("SOM");
                        }
                        for (Resource childOfRoot : fragRootPanel.getChild("items").getChildren()) {
                            if (childOfRoot.adaptTo(ValueMap.class).get("fragRef") != null) {
                                this.createSingleResource(childOfRoot, itemsNode, currentRecursionLevel, maxRecursionLevels, jsonCreationOptionsWithFragmentI18n, currentParentSOM);
                                continue;
                            }
                            itemsNode.put(childOfRoot.getName(), this.create(childOfRoot, currentRecursionLevel + 1, maxRecursionLevels, jsonCreationOptionsWithFragmentI18n, currentParentSOM));
                        }
                    }
                    catch (Exception e) {
                        try {
                            log.error("Error while clearing thread local in JsonObjectCreator", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            GuideContainerThreadLocal.setGuideContainerPath(prevGuideContainerPath);
                            GuideContainerThreadLocal.setGuideFragmentHolder(previousPrefixId, bindPrefixForFragmentPrevious, fragmentModelRootPrevious, i18nPrevious);
                            throw throwable;
                        }
                        GuideContainerThreadLocal.setGuideContainerPath(prevGuideContainerPath);
                        GuideContainerThreadLocal.setGuideFragmentHolder(previousPrefixId, bindPrefixForFragmentPrevious, fragmentModelRootPrevious, i18nPrevious);
                        break block18;
                    }
                }
                GuideContainerThreadLocal.setGuideContainerPath(prevGuideContainerPath);
                GuideContainerThreadLocal.setGuideFragmentHolder(previousPrefixId, bindPrefixForFragmentPrevious, fragmentModelRootPrevious, i18nPrevious);
                break block18;
            }
            obj = this.create(n, currentRecursionLevel + 1, maxRecursionLevels, jsonCreationOptions, parentSOM);
            if (obj != null) {
                parent.put(ResourceUtil.getName(n), obj);
            }
        }
    }

    private static boolean recursionLevelActive(int currentRecursionLevel, int maxRecursionLevels) {
        return maxRecursionLevels < 0 || currentRecursionLevel < maxRecursionLevels;
    }

    private static void createProperty(JSONObject obj, ValueMap valueMap, String key, Object value, I18n i18n, Resource resource) throws JSONException {
        Object[] values = null;
        if (value.getClass().isArray() && (values = (Object[])value).length == 0) {
            obj.put(key, new JSONArray());
            return;
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            if (values == null) {
                obj.put(":" + key, JsonObjectCreatorImpl.getLength(valueMap, -1, key, (InputStream)value));
            } else {
                JSONArray result = new JSONArray();
                for (int i = 0; i < values.length; ++i) {
                    result.put(JsonObjectCreatorImpl.getLength(valueMap, i, key, (InputStream)values[i]));
                }
                obj.put(":" + key, result);
            }
            return;
        }
        if (!value.getClass().isArray()) {
            Object[] optionsArray;
            JSONArray result;
            Resource optionPath;
            boolean isGuideOptionsListPath;
            obj.put(key, JsonObjectCreatorImpl.getValue(value));
            boolean bl = isGuideOptionsListPath = valueMap.containsKey("guideNodeClass") && "optionsLoadPath".equals(key);
            if (isGuideOptionsListPath && (optionPath = resource.getResourceResolver().getResource((String)JsonObjectCreatorImpl.getValue(value))) != null && (result = JsonObjectCreatorImpl.getItemsJSONFromList(optionsArray = optionPath.adaptTo(String[].class), i18n, true)) != null) {
                obj.put("options", result);
            }
        } else {
            JSONArray result;
            boolean isGuideOptions;
            boolean bl = isGuideOptions = valueMap.containsKey("guideNodeClass") && "options".equals(key);
            if (isGuideOptions && !obj.has("options")) {
                JSONArray result2 = JsonObjectCreatorImpl.getItemsJSONFromList(values, i18n, true);
                if (result2 != null) {
                    obj.put(key, result2);
                }
            } else if (!isGuideOptions && (result = JsonObjectCreatorImpl.getItemsJSONFromList(values, i18n, false)) != null) {
                obj.put(key, result);
            }
        }
    }

    private static JSONArray getItemsJSONFromList(Object[] values, I18n i18n, boolean isGuideOptions) {
        if (values == null) {
            return null;
        }
        JSONArray result = new JSONArray();
        for (Object v : values) {
            String[] valueStringArray;
            boolean optionAdded = false;
            if (isGuideOptions && (valueStringArray = v.toString().split("=")).length > 1) {
                String keyString = valueStringArray[0];
                String valueString = valueStringArray[1];
                String translatedString = GuideUtils.translateOrReturnOriginal(valueString, i18n);
                result.put(StringUtils.trimToEmpty((String)keyString) + "=" + StringUtils.trimToEmpty((String)translatedString));
                optionAdded = true;
            }
            if (optionAdded) continue;
            Object value = JsonObjectCreatorImpl.getValue(v);
            if (value instanceof String) {
                String valueString = value.toString();
                String translatedString = GuideUtils.translateOrReturnOriginal(valueString, i18n);
                result.put(translatedString);
                continue;
            }
            result.put(value);
        }
        return result;
    }

    private static long getLength(ValueMap valueMap, int index, String key, InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException ignore) {
            log.trace("Error in getLength, ignoring it." + ignore.getMessage(), (Throwable)ignore);
        }
        long length = -1L;
        if (valueMap != null) {
            if (index == -1) {
                length = valueMap.get(key, length);
            } else {
                Long[] lengths = (Long[])valueMap.get(key, Long[].class);
                if (lengths != null && lengths.length > index) {
                    length = lengths[index];
                }
            }
        }
        return length;
    }

    private static String handleMinMaxOccursAndBindRefForFragments(Map propertyMap, JSONObject obj) {
        String oldBindRef = null;
        String newBindRef = null;
        if (propertyMap.containsKey("bindRef")) {
            oldBindRef = (String)propertyMap.get("bindRef");
        }
        try {
            newBindRef = JsonObjectCreatorImpl.handleBindRefForFragments(propertyMap);
            obj.put("bindRef", newBindRef);
            if (StringUtils.isNotEmpty((CharSequence)oldBindRef) && StringUtils.isEmpty((CharSequence)newBindRef)) {
                obj.put("minOccur", 1);
                obj.put("maxOccur", 1);
            }
        }
        catch (Exception e) {
            log.error("Exception while handling bindRef or Min Max for " + obj.toString(), (Throwable)e);
        }
        return newBindRef;
    }

    private static String handleBindRefForFragments(Map propertyMap) {
        String bindRef = null;
        if (propertyMap.containsKey("bindRef")) {
            bindRef = (String)propertyMap.get("bindRef");
            GuideFragmentHolder guideFragmentHolder = null;
            try {
                guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
            }
            catch (Exception e) {
                log.error("Error while getting bind prefix  map ", (Throwable)e);
            }
            if (guideFragmentHolder != null) {
                String bindRefPrefixForFragment = guideFragmentHolder.getBindRefPrefixForFragment();
                String fragmentRoot = guideFragmentHolder.getFragmentModelRoot();
                return GuideUtils.manipulateBindRefForFragments(bindRefPrefixForFragment, bindRef, fragmentRoot);
            }
        }
        return bindRef;
    }

    protected void bindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.resourceBundleProvider = resourceBundleProvider;
    }

    protected void unbindResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        if (this.resourceBundleProvider == resourceBundleProvider) {
            this.resourceBundleProvider = null;
        }
    }

    protected void bindGuideModuleImporter(GuideModuleImporter guideModuleImporter) {
        this.guideModuleImporter = guideModuleImporter;
    }

    protected void unbindGuideModuleImporter(GuideModuleImporter guideModuleImporter) {
        if (this.guideModuleImporter == guideModuleImporter) {
            this.guideModuleImporter = null;
        }
    }

    protected void bindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        this.xfaModelTransformerService = xFAModelTransformer;
    }

    protected void unbindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        if (this.xfaModelTransformerService == xFAModelTransformer) {
            this.xfaModelTransformerService = null;
        }
    }

    protected void bindGuideModelImporterService(GuideModelImporter guideModelImporter) {
        this.guideModelImporterService = guideModelImporter;
    }

    protected void unbindGuideModelImporterService(GuideModelImporter guideModelImporter) {
        if (this.guideModelImporterService == guideModelImporter) {
            this.guideModelImporterService = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }

    protected void bindAdaptiveFormConfigurationService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        this.adaptiveFormConfigurationService = adaptiveFormConfigurationService;
    }

    protected void unbindAdaptiveFormConfigurationService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        if (this.adaptiveFormConfigurationService == adaptiveFormConfigurationService) {
            this.adaptiveFormConfigurationService = null;
        }
    }
}

