/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Adaptive Form Bulk Editor"}), @Property(name="sling.servlet.selectors", value={"af.bulkeditor"})})
public class BulkEditorServlet
extends SlingAllMethodsServlet {
    private Logger logger = LoggerFactory.getLogger(BulkEditorServlet.class);

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource formResource = request.getResource();
        ValueMap properties = ResourceUtil.getValueMap(formResource);
        StringBuilder sb = new StringBuilder();
        sb.append(request.getContextPath());
        sb.append("/etc/importers/bulkeditor.html?rootPath=");
        String actionPath = request.getParameter("storePath");
        if (actionPath == null || actionPath.trim().length() == 0) {
            response.sendError(400, "Missing 'storePath' property on node " + formResource.getPath());
        }
        if (actionPath.endsWith("*")) {
            actionPath = actionPath.substring(0, actionPath.length() - 1);
        }
        if (actionPath.endsWith("/")) {
            actionPath = actionPath.substring(0, actionPath.length() - 1);
        }
        sb.append(this.encodeValue(actionPath));
        sb.append("&initialSearch=true&contentMode=false&spc=true");
        ArrayList<String> fields = new ArrayList<String>();
        this.getFieldsFromGuideContainer(formResource, fields);
        this.logger.error("size is " + fields.size());
        for (String field : fields) {
            sb.append("&cs=");
            sb.append(field);
            sb.append("&cv=");
            sb.append(field);
        }
        response.sendRedirect(sb.toString());
    }

    public String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public void getFieldsFromGuideContainer(Resource formResource, List<String> fields) {
        ValueMap vm = formResource.adaptTo(ValueMap.class);
        String guideNodeClass = "";
        if (vm.containsKey("guideNodeClass")) {
            guideNodeClass = vm.get("guideNodeClass", "");
        }
        if (GuideUtils.isGuideFieldModel(guideNodeClass)) {
            boolean isButton = GuideUtils.isGuideButtonModel(guideNodeClass);
            boolean isFileUpload = GuideUtils.isGuideFileUploadModel(guideNodeClass);
            if (!isButton && !isFileUpload && !vm.containsKey("bindRef") && vm.containsKey("name")) {
                fields.add(vm.get("name", ""));
            }
        }
        for (Resource child : formResource.getChildren()) {
            this.getFieldsFromGuideContainer(child, fields);
        }
    }
}

