/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.XFAModelTransformer;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.SubmitDataCollector;
import com.adobe.aemds.guide.utils.XsdSubmitDataCollector;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form Internal Submit"}), @Property(name="sling.servlet.selectors", value={"af.internalsubmit"})})
public class GuideInternalSubmitServlet
extends SlingAllMethodsServlet {
    private Logger logger = LoggerFactory.getLogger(GuideInternalSubmitServlet.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private XFAModelTransformer xfaModelTransformerService;
    @Reference
    private GuideModelTransformer guideModelTransformer;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        I18n i18n = GuideELUtils.getI18n(request, request.getResource());
        String guideState = request.getParameter("guideState");
        String xdpRef = null;
        String xsdRef = null;
        String guidePrefillXml = null;
        Object dorTemplateRef = null;
        String submissionInfo = null;
        Object computedData = null;
        boolean isLazyXml = false;
        try {
            JSONObject templateJson = this.guideModelTransformer.exportGuideJsonObject(request.getResource(), i18n);
            JSONObject jsonObject = new JSONObject(guideState);
            JSONObject guide = new JSONObject(jsonObject.getString("guideState"));
            JSONObject guideJson = null;
            String guideDom = null;
            if (guide.has("guideDom")) {
                guideDom = guide.getString("guideDom");
                guideJson = new JSONObject(guideDom);
            }
            if (guide.has("guideContext")) {
                JSONObject guideContext = new JSONObject(guide.getString("guideContext"));
                if (guideContext.has("xdpRef")) {
                    xdpRef = guideContext.getString("xdpRef");
                }
                if (guideContext.has("xsdRef")) {
                    xsdRef = guideContext.getString("xsdRef");
                }
                if (guideContext.has("guidePrefillXml")) {
                    guidePrefillXml = guideContext.getString("guidePrefillXml");
                }
                if (guideContext.has("afSubmissionInfo")) {
                    submissionInfo = guideContext.getString("afSubmissionInfo");
                }
            }
            if (guide.has("guideLiveXml")) {
                guidePrefillXml = guide.getString("guideLiveXml");
                isLazyXml = true;
            }
            SubmitDataCollector submitDataCollector = null;
            boolean hasEmbeddedXsdForms = templateJson.optBoolean("isHasEmbeddedXsdForm");
            if (xsdRef != null || xdpRef == null && hasEmbeddedXsdForms) {
                submitDataCollector = new XsdSubmitDataCollector(guideDom, templateJson, guidePrefillXml, submissionInfo, isLazyXml);
            } else {
                String xfaResult = "";
                if (xdpRef != null && guide.has("xfaState")) {
                    JSONObject xfaState = guide.getJSONObject("xfaState");
                    String xfaDom = "";
                    String xfaPrefillXml = "";
                    if (xfaState.has("xfaDom")) {
                        xfaDom = xfaState.getString("xfaDom");
                    }
                    if (xfaState.has("renderContext")) {
                        JSONObject xfaRenderContext = new JSONObject(xfaState.getString("renderContext"));
                        String string = xfaPrefillXml = xfaRenderContext.has("data") ? xfaRenderContext.getString("data") : null;
                        if (guidePrefillXml == null) {
                            guidePrefillXml = xfaPrefillXml;
                        }
                    }
                    try {
                        xfaResult = this.xfaModelTransformerService.getDataXMLFromXfaDom(guideJson.getString("xdpRef"), xfaDom, xfaPrefillXml);
                    }
                    catch (Exception e) {
                        xfaResult = null;
                        this.logger.info("AF: Unable to getDataXML from XFA DOM. Setting it to null", (Throwable)e);
                    }
                }
                submitDataCollector = new SubmitDataCollector(guideDom, templateJson, guidePrefillXml, xfaResult, submissionInfo, isLazyXml);
            }
            JSONObject submitData = submitDataCollector.collectSubmitData();
            PrintWriter out = response.getWriter();
            out.write(submitData.toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected void bindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        this.xfaModelTransformerService = xFAModelTransformer;
    }

    protected void unbindXfaModelTransformerService(XFAModelTransformer xFAModelTransformer) {
        if (this.xfaModelTransformerService == xFAModelTransformer) {
            this.xfaModelTransformerService = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }
}

