/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuidePropertyProviderUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.aemfd.expeditor.service.ExpressionEditorService;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.widget.HtmlLibraryManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/infoprovider"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Adaptive Form Component Info Provider"})})
public class GuidePropertyProvider
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -930058691346704417L;
    private static final String RT_AEM_FORM_CONTAINER = "fd/af/components/aemform";
    private static final String RT_AEM_APPS_FORM_CONTAINER = "fd/appsaddon/components/aemappsform";
    private static Logger logger = LoggerFactory.getLogger(GuidePropertyProvider.class);
    private static final String LAYOUT = "layout";
    private static final String ACTIONS = "action";
    private static final String FORMATTERS = "formatters";
    private static final String SUBMITACTION = "submitAction";
    private static final String AUTOSAVEACTION = "autoSaveAction";
    private static final String LCPROCESS = "lcProcess";
    private static final String MOBILELAYOUT = "mobileLayout";
    private static final String PROGRESSIVE_STRATEGIES = "progressiveStrategies";
    private static final String PROGRESSIVE_LAYOUT = "progressiveLayout";
    private static final String FRAG_FINDER = "fragfinder";
    private static final String ADAPTIVE_FORM_ASSET = "guide";
    private static final String ADAPTIVE_DOCUMENT_ASSET = "adaptivedocument";
    private static final String FRAGMENT_ASSET = "affragment";
    private static final String PANEL = "panel";
    private static final String AEM_APPS_FORM_CONTAINER = "aemappsform";
    private static final String REQUIRED_COMPONENT_TYPE_PARAM = "requiredComponentType";
    private static final String DOCUMENT_FRAGMENT_LAYOUT = "documentFragmentLayout";
    private static final String CHART_REDUCER = "chartReducer";
    private static final String THEME = "theme";
    private static final String APPEARANCE = "appearance";
    private static final String CUSTOM_FUNCTION = "customFunction";
    private static final String WEB_SERVICES = "webServices";
    private static final String GUIDE_CONTAINER_PATH = "guideContainerPath";
    private static final String CLIENT_LIB_REF = "clientLibRef";
    private static final String WEBSERVICES_CFG_NODE_TYPE = "fd/af/webServices";
    @Reference
    private ExpressionEditorService expressionEditorService;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference
    private GuidePropertyProviderUtils guidePropertyProviderUtils;
    @Reference
    private AdaptiveFormConfigurationService configService;
    @Reference
    private QueryBuilder queryBuilder;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        String type = request.getParameter("type");
        PrintWriter writer = new PrintWriter(response.getWriter());
        JSONWriter jsonWriter = new JSONWriter(response.getWriter());
        ResourceResolver resolver = request.getResourceResolver();
        String[] searchPaths = resolver.getSearchPath();
        if (FRAG_FINDER.equals(type)) {
            this.queryFragFinder(request, writer, FRAGMENT_ASSET, "fd/af/components/panel");
        } else if (ADAPTIVE_FORM_ASSET.equals(type)) {
            String requiredComponentType = request.getParameter(REQUIRED_COMPONENT_TYPE_PARAM);
            requiredComponentType = PANEL.equals(requiredComponentType) ? "fd/af/components/panel" : (AEM_APPS_FORM_CONTAINER.equals(requiredComponentType) ? RT_AEM_APPS_FORM_CONTAINER : RT_AEM_FORM_CONTAINER);
            this.queryFragFinder(request, writer, ADAPTIVE_FORM_ASSET, requiredComponentType);
        } else if (ADAPTIVE_DOCUMENT_ASSET.equals(type)) {
            String requiredComponentType = request.getParameter(REQUIRED_COMPONENT_TYPE_PARAM);
            requiredComponentType = AEM_APPS_FORM_CONTAINER.equals(requiredComponentType) ? RT_AEM_APPS_FORM_CONTAINER : RT_AEM_FORM_CONTAINER;
            this.queryFragFinder(request, writer, ADAPTIVE_DOCUMENT_ASSET, requiredComponentType);
        } else if (LAYOUT.equals(type)) {
            this.queryLayout(request, writer, searchPaths);
        } else if (type.equalsIgnoreCase(THEME)) {
            this.queryTheme(writer);
        } else if (type.equalsIgnoreCase(ACTIONS)) {
            this.queryAction(writer, searchPaths);
        } else if (type.equalsIgnoreCase(PROGRESSIVE_STRATEGIES)) {
            this.queryProgressiveStrategies(writer, searchPaths);
        } else if (type.equalsIgnoreCase(PROGRESSIVE_LAYOUT)) {
            this.queryProgressiveLayout(writer, searchPaths);
        } else if (type.equalsIgnoreCase(FORMATTERS)) {
            this.queryFormatters(request, writer, searchPaths);
        } else if (type.equalsIgnoreCase(SUBMITACTION) || type.equalsIgnoreCase(AUTOSAVEACTION)) {
            this.querySubmitOrAutoSaveAction(request, writer, type, searchPaths);
        } else if (type.equalsIgnoreCase(LCPROCESS)) {
            this.queryLcProcess(writer);
        } else if (type.equalsIgnoreCase(MOBILELAYOUT)) {
            this.queryMobileLayout(writer, searchPaths);
        } else if (type.equalsIgnoreCase(DOCUMENT_FRAGMENT_LAYOUT)) {
            this.queryDocumentFragmentLayout(jsonWriter, resolver, searchPaths);
        } else if (type.equalsIgnoreCase(CHART_REDUCER)) {
            this.queryChartReducer(writer, searchPaths);
        } else if (type.equalsIgnoreCase(CUSTOM_FUNCTION)) {
            this.queryCustomFunction(request, jsonWriter);
        } else if (type.equalsIgnoreCase(WEB_SERVICES)) {
            this.queryWebServices(resolver, jsonWriter);
        } else if (type.equalsIgnoreCase(APPEARANCE)) {
            this.queryAppearance(request, writer, searchPaths);
        }
    }

    private void queryAppearance(SlingHttpServletRequest request, PrintWriter writer, String[] searchPaths) {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("guideNodeClass", request.getParameter("guideNodeClass"));
        JSONArray response = this.guidePropertyProviderUtils.queryAppearance(searchPaths, optionsMap);
        writer.write(response.toString());
        writer.close();
    }

    private void queryFragFinder(SlingHttpServletRequest request, PrintWriter writer, String formType, String resourceType) {
        String QUERY = "query";
        String START = "start";
        String LIMIT = "limit";
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("assetType", request.getParameter("assetType"));
        optionsMap.put("query", request.getParameter("query"));
        optionsMap.put("start", request.getParameter("start"));
        optionsMap.put("limit", request.getParameter("limit"));
        JSONObject response = this.guidePropertyProviderUtils.queryFragFinder(formType, resourceType, optionsMap);
        writer.write(response.toString());
        writer.close();
    }

    private void queryLayout(SlingHttpServletRequest request, PrintWriter writer, String[] searchPaths) {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("layoutType", request.getParameter("layoutType"));
        optionsMap.put("isAfField", request.getParameter("isAfField"));
        JSONArray response = this.guidePropertyProviderUtils.queryLayout(searchPaths, optionsMap, request);
        writer.write(response.toString());
        writer.close();
    }

    private void queryTheme(PrintWriter writer) {
        JSONArray response = this.guidePropertyProviderUtils.queryTheme();
        writer.write(response.toString());
        writer.close();
    }

    private void queryAction(PrintWriter writer, String[] searchPaths) {
        JSONArray response = this.guidePropertyProviderUtils.queryAction(searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void queryProgressiveStrategies(PrintWriter writer, String[] searchPaths) {
        JSONArray response = this.guidePropertyProviderUtils.queryProgressiveStrategies(searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void queryProgressiveLayout(PrintWriter writer, String[] searchPaths) {
        JSONArray response = this.guidePropertyProviderUtils.queryProgressiveLayout(searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void queryFormatters(SlingHttpServletRequest request, PrintWriter writer, String[] searchPaths) {
        String guideNodeClass = request.getParameter("guideNodeClass");
        JSONArray response = this.guidePropertyProviderUtils.queryFormatters(guideNodeClass, searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void querySubmitOrAutoSaveAction(SlingHttpServletRequest request, PrintWriter writer, String type, String[] searchPaths) {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        String requestedDataModel = request.getParameter("guideDataModel");
        optionsMap.put("type", type);
        optionsMap.put("guideDataModel", requestedDataModel);
        JSONArray response = this.guidePropertyProviderUtils.querySubmitOrAutoSaveAction(searchPaths, optionsMap);
        writer.write(response.toString());
        writer.close();
    }

    private void queryLcProcess(PrintWriter writer) {
        JSONArray response = this.guidePropertyProviderUtils.queryLcProcess();
        writer.write(response.toString());
        writer.close();
    }

    private void queryMobileLayout(PrintWriter writer, String[] searchPaths) {
        JSONArray response = this.guidePropertyProviderUtils.queryMobileLayout(searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void queryDocumentFragmentLayout(JSONWriter writer, ResourceResolver resolver, String[] searchPaths) {
        try {
            writer.array();
            for (int i = 0; i < searchPaths.length; ++i) {
                String query = "SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/adaddon/documentFragmentLayout' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                Iterator<Resource> layouts = resolver.findResources(query, "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = layouts.next();
                    ValueMap properties = r.getValueMap();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    writer.array();
                    writer.value(properties.get(LAYOUT, ""));
                    writer.value(desc == null ? r.getPath() : desc);
                    writer.endArray();
                }
            }
            writer.endArray();
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    private void queryChartReducer(PrintWriter writer, String[] searchPaths) {
        JSONArray response = this.guidePropertyProviderUtils.queryChartReducer(searchPaths);
        writer.write(response.toString());
        writer.close();
    }

    private void queryCustomFunction(SlingHttpServletRequest request, JSONWriter writer) {
        String guideContainerPath = request.getParameter(GUIDE_CONTAINER_PATH);
        if (guideContainerPath != null && guideContainerPath.length() > 0) {
            try {
                ValueMap valueMap;
                Object clientLib;
                writer.object();
                JSONArray configJson = new JSONArray();
                ResourceResolver resourceResolver = request.getResourceResolver();
                Resource guideContainerResource = resourceResolver.getResource(guideContainerPath);
                if (guideContainerResource != null && (clientLib = (valueMap = guideContainerResource.getValueMap()).get(CLIENT_LIB_REF)) != null) {
                    String[] clientLibs = clientLib.toString().split(",");
                    ArrayList<String> scripts = GuideUtils.getScriptFromClientLibList(this.htmlLibraryManager, clientLibs);
                    for (String script : scripts) {
                        configJson = this.expressionEditorService.getFunctionsList(script, "eesJavascript");
                    }
                    if (configJson.length() > 0) {
                        writer.key(CUSTOM_FUNCTION).value(configJson);
                    }
                }
                writer.endObject();
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    private boolean isValidSearchPath(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && path.trim().startsWith("/");
    }

    private PredicateGroup webServicesSearchPathPredicate() {
        String[] searchPaths = this.configService.getWSDLConfigSearchPaths();
        PredicateGroup predicate = new PredicateGroup();
        predicate.setAllRequired(false);
        for (String searchPath : searchPaths) {
            if (!this.isValidSearchPath(searchPath)) continue;
            Predicate pathPred = this.createPathPredicate(searchPath);
            predicate.add(pathPred);
        }
        return predicate;
    }

    private Predicate createPropertyPredicate(String propName, String value) {
        Predicate propPred = new Predicate("property");
        propPred.set("property", propName);
        propPred.set("value", WEBSERVICES_CFG_NODE_TYPE);
        return propPred;
    }

    private Predicate createTypePredicate(String type) {
        Predicate typePred = new Predicate("type");
        typePred.set("type", type);
        return typePred;
    }

    private Predicate createPathPredicate(String path) {
        Predicate pathPred = new Predicate("path");
        pathPred.set("path", path);
        return pathPred;
    }

    private PredicateGroup webServicesPredicate() {
        PredicateGroup searchPathPredicates = this.webServicesSearchPathPredicate();
        if (searchPathPredicates.size() < 1) {
            logger.warn("No search paths found, aborting webservices search");
            return null;
        }
        PredicateGroup predicate = new PredicateGroup();
        Predicate typePred = this.createTypePredicate("nt:unstructured");
        predicate.add(typePred);
        Predicate propPred = this.createPropertyPredicate("guideComponentType", WEBSERVICES_CFG_NODE_TYPE);
        predicate.add(propPred);
        predicate.add(this.webServicesSearchPathPredicate());
        return predicate;
    }

    private Query webServiceQuery(ResourceResolver rr) {
        PredicateGroup predicate = this.webServicesPredicate();
        if (predicate == null) {
            return null;
        }
        return this.queryBuilder.createQuery(this.webServicesPredicate(), rr.adaptTo(Session.class));
    }

    private void queryWebServices(ResourceResolver resolver, JSONWriter writer) {
        SearchResult searchResult;
        Iterator<Resource> webServiceResources;
        Query query = this.webServiceQuery(resolver);
        if (query != null && (webServiceResources = (searchResult = query.getResult()).getResources()) != null) {
            try {
                writer.array();
                while (webServiceResources.hasNext()) {
                    writer.object();
                    Resource resource = webServiceResources.next();
                    String path = resource.getPath();
                    writer.key(path);
                    this.webServiceJsonCreator(resource, writer);
                    writer.endObject();
                }
                writer.endArray();
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        }
    }

    private void webServiceJsonCreator(Resource resource, JSONWriter writer) {
        try {
            writer.object();
            ValueMap properties = ResourceUtil.getValueMap(resource);
            for (Map.Entry pairs : properties.entrySet()) {
                String key = (String)pairs.getKey();
                if (key.equals("guideComponentType") || key.equals("jcr:primaryType")) continue;
                writer.key(key).value(pairs.getValue());
            }
            Iterable<Resource> children = resource.getChildren();
            for (Resource child : children) {
                String name = child.getName();
                writer.key(name);
                this.webServiceJsonCreator(child, writer);
            }
            writer.endObject();
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected void bindExpressionEditorService(ExpressionEditorService expressionEditorService) {
        this.expressionEditorService = expressionEditorService;
    }

    protected void unbindExpressionEditorService(ExpressionEditorService expressionEditorService) {
        if (this.expressionEditorService == expressionEditorService) {
            this.expressionEditorService = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    protected void bindGuidePropertyProviderUtils(GuidePropertyProviderUtils guidePropertyProviderUtils) {
        this.guidePropertyProviderUtils = guidePropertyProviderUtils;
    }

    protected void unbindGuidePropertyProviderUtils(GuidePropertyProviderUtils guidePropertyProviderUtils) {
        if (this.guidePropertyProviderUtils == guidePropertyProviderUtils) {
            this.guidePropertyProviderUtils = null;
        }
    }

    protected void bindConfigService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        this.configService = adaptiveFormConfigurationService;
    }

    protected void unbindConfigService(AdaptiveFormConfigurationService adaptiveFormConfigurationService) {
        if (this.configService == adaptiveFormConfigurationService) {
            this.configService = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

