/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guidefield", "fd/af/components/guideimage", "fd/af/components/guidetextdraw", "fd/af/components/table", "fd/af/components/panel", "fd/af/components/rootPanel", "fd/af/components/toolbar"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Adaptive Form SOM provider"}), @Property(name="sling.servlet.selectors", value={"af.somprovider"})})
public class GuideSOMProviderServlet
extends SlingAllMethodsServlet {
    private Logger logger = LoggerFactory.getLogger(GuideSOMProviderServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource element = request.getResource();
        String somExpression = this.generateSOM(element);
        response.getWriter().write(somExpression);
    }

    public String generateSOM(Resource element) {
        String som = "";
        ValueMap valueMap = ResourceUtil.getValueMap(element);
        Resource parentElement = element.getParent();
        String guideNodeClass = (String)valueMap.get("guideNodeClass");
        if (guideNodeClass != null) {
            som = valueMap.get("name") + "[0]";
            if ("guideContainerNode".equals(guideNodeClass)) {
                return "guide[0]." + som;
            }
        } else {
            return this.generateSOM(parentElement) + som;
        }
        return this.generateSOM(parentElement) + "." + som;
    }
}

