/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.taglibs;

import com.adobe.aemds.guide.cache.Cache;
import com.adobe.aemds.guide.cache.CacheManager;
import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.utils.GuideCacheResponseWrapper;
import com.adobe.aemds.guide.utils.GuideHTMLParser;
import com.adobe.aemds.guide.utils.GuideHTMLParserOptions;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.StaleAssetIndicatorService;
import com.day.cq.wcm.api.WCMMode;
import java.util.Calendar;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideContainerLayoutHTML
extends TagSupport {
    private Logger logger = LoggerFactory.getLogger(GuideContainerLayoutHTML.class);
    private String html;

    public int doStartTag() throws JspException {
        GuideContainer guideContainer = (GuideContainer)this.pageContext.getAttribute("guideContainer", 2);
        if (guideContainer != null) {
            Resource resource = guideContainer.getResource();
            SlingHttpServletRequest request = (SlingHttpServletRequest)this.pageContext.getAttribute("slingRequest");
            SlingHttpServletResponse response = (SlingHttpServletResponse)this.pageContext.getAttribute("slingResponse");
            String script = GuideUtils.getLayoutScriptFromContainer(guideContainer);
            try {
                String locale = GuideUtils.getGuideRuntimeLocale(request, resource);
                String containerPath = resource.getPath();
                try {
                    SlingScriptHelper slingScriptHelper = (SlingScriptHelper)this.pageContext.getAttribute("sling");
                    CacheManager cacheManager = slingScriptHelper.getService(CacheManager.class);
                    Cache guideHTMLCache = cacheManager.getOrCreateCache("cache.html");
                    StaleAssetIndicatorService staleAssetIndicatorService = slingScriptHelper.getService(StaleAssetIndicatorService.class);
                    Calendar lastModifiedTime = null;
                    if (WCMMode.fromRequest((ServletRequest)request).equals((Object)WCMMode.DISABLED) && GuideUtils.isCacheableContainerResource(resource)) {
                        String key = containerPath + "_" + locale;
                        String html = (String)guideHTMLCache.get(key);
                        boolean isCacheValid = true;
                        lastModifiedTime = GuideUtils.getLastModifiedTimeFromStaleAssetIndicatorService(guideContainer, staleAssetIndicatorService);
                        if (!guideHTMLCache.isCacheEntryStale(key, lastModifiedTime)) {
                            this.logger.debug("HTML cache hit for AF container layout " + containerPath);
                        } else {
                            if (guideHTMLCache.entryExists(key)) {
                                String[] supportedLocales;
                                GuideLocalizationService localizationService = slingScriptHelper.getService(GuideLocalizationService.class);
                                for (String supportedLocale : supportedLocales = localizationService.getSupportedLocales()) {
                                    guideHTMLCache.clear(containerPath + "_" + supportedLocale);
                                }
                            }
                            html = this.includeContainerLayoutScript(false, script);
                            guideHTMLCache.put(key, html, lastModifiedTime);
                            this.logger.debug("HTML cache miss for AF container layout " + containerPath);
                        }
                        GuideHTMLParserOptions guideHTMLParserOptions = new GuideHTMLParserOptions(html);
                        html = GuideHTMLParser.stripAllOnDemandChildren(guideHTMLParserOptions);
                        this.pageContext.getOut().write(html);
                    }
                    this.includeContainerLayoutScript(true, script);
                }
                catch (Exception e) {
                    this.logger.error("Some Problem While Posting to rest End Point", (Throwable)e);
                    throw e;
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                throw new GuideException(ex);
            }
        } else {
            this.logger.error("No guide found");
            throw new GuideException("No guide found");
        }
        return 0;
    }

    private String includeContainerLayoutScript(boolean writeToJSP, String script) throws JspException {
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        ServletResolver servletResolver = scriptHelper.getService(ServletResolver.class);
        RequestProgressTracker tracker = TagUtil.getRequest(this.pageContext).getRequestProgressTracker();
        String servletName = null;
        Resource resource = bindings.getResource();
        Servlet servlet = servletResolver.resolveServlet(resource, script);
        if (servlet != null) {
            servletName = RequestUtil.getServletName(servlet);
            tracker.log("Including script {0} for path={1}, type={2}: {3}", script, resource.getPath(), resource.getResourceType(), servletName);
        }
        if (servlet == null) {
            throw new JspException("Could not find script " + script);
        }
        try {
            GuideCacheResponseWrapper wrappedResponse = new GuideCacheResponseWrapper(this.pageContext, writeToJSP);
            servlet.service(this.pageContext.getRequest(), (ServletResponse)wrappedResponse);
            return wrappedResponse.getHTMLString();
        }
        catch (Exception e) {
            this.logger.error("Error while executing script " + script, (Throwable)e);
            throw new JspException("Error while executing script " + script, (Throwable)e);
        }
    }
}

