/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.taglibs;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.components.Toolbar;
import com.day.cq.widget.ClientLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideELUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideELUtils.class);

    public static boolean hasNestablePanelLayout(GuideNode parentNode, GuideNode node) {
        try {
            String nodeLayout;
            if (parentNode == null || !GuideUtils.isLayoutablePanel(parentNode)) {
                return false;
            }
            if (node == null || !GuideUtils.isLayoutablePanel(node)) {
                return false;
            }
            String parentNodeLayout = parentNode.getLayoutPath();
            if (parentNodeLayout != null && (parentNodeLayout.startsWith("/libs/") || parentNodeLayout.startsWith("/apps/"))) {
                parentNodeLayout = parentNodeLayout.substring(6);
            }
            if ((nodeLayout = node.getLayoutPath()) != null && (nodeLayout.startsWith("/libs/") || nodeLayout.startsWith("/apps/"))) {
                nodeLayout = nodeLayout.substring(6);
            }
            return StringUtils.equals((CharSequence)parentNodeLayout, (CharSequence)nodeLayout);
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public static String getGuideContainerPath(SlingHttpServletRequest request, Resource resource) {
        String guideContainerPath = null;
        String guideContainerNodeName = "guideContainer";
        String containerParamValue = request.getParameter("guideContainerName");
        if (containerParamValue != null) {
            guideContainerNodeName = containerParamValue;
        } else if (GuideContainerThreadLocal.getGuideContainerName() != null) {
            guideContainerNodeName = GuideContainerThreadLocal.getGuideContainerName();
        } else {
            logger.debug("Guide container name not found in ThreadLocal.");
        }
        if (GuideConstants.CONTAINER_RESOURCES.contains(resource.getResourceType())) {
            guideContainerPath = resource.getPath();
        }
        try {
            Resource guideContainerResource;
            if (guideContainerPath == null) {
                Resource parent;
                ResourceResolver resolver = request.getResourceResolver();
                for (parent = resource.getParent(); parent != null && !parent.getResourceType().equals("cq:Page"); parent = parent.getParent()) {
                    String normalizedNodeType = GuideUtils.getNormalizedNodeType(parent.getResourceType(), parent.getResourceSuperType());
                    if (!GuideConstants.CONTAINER_RESOURCES.contains(normalizedNodeType)) continue;
                    guideContainerPath = parent.getPath();
                    break;
                }
                if (guideContainerPath == null && parent != null && parent.getResourceType().equals("cq:Page")) {
                    guideContainerPath = resource.getPath() + "/" + guideContainerNodeName;
                }
            }
            if ((guideContainerResource = request.getResourceResolver().getResource(guideContainerPath)) == null) {
                guideContainerPath = null;
            } else {
                ValueMap properties = ResourceUtil.getValueMap(guideContainerResource);
                String guideRef = properties.get("guideRef", null);
                if (guideRef != null && guideRef.length() != 0) {
                    String path = GuideUtils.guideRefToGuidePath(guideRef);
                    Resource guideContainer = request.getResourceResolver().getResource(path);
                    if (guideContainer != null) {
                        guideContainerPath = path;
                    } else {
                        logger.error("No guide found in guide reference present in guide container");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GuideException("No guide Container found", e);
        }
        return guideContainerPath;
    }

    public static List getFileAttachmentList(SlingHttpServletRequest request, String guideContainerPath) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String rootPanelPath = guideContainerPath + "/" + "rootPanel" + "/" + "items";
        Resource guideRootPanel = resourceResolver.getResource(rootPanelPath);
        ArrayList<String> result = new ArrayList<String>();
        GuideUtils.walkThroughContent(result, guideRootPanel, "fd/af/components/guidefileupload");
        return result;
    }

    public static Object consumeContextProperty(String contextPropertyName, SlingHttpServletRequest request) {
        Object contextProp = request.getAttribute(contextPropertyName);
        request.removeAttribute(contextPropertyName);
        return contextProp;
    }

    public static boolean setToolbarLabel(String name, String title, EditContext editContext, SlingHttpServletRequest request) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (name != null) {
                tb.add(0, new Toolbar.Label(title + name));
            }
            tb.add(1, new Toolbar.Separator());
            return true;
        }
        return false;
    }

    public static boolean setEmbedFragButton(String title, EditContext editContext, SlingHttpServletRequest request, String fragRef, String currentPanelPath, String bindRef) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (title != null) {
                tb.add(new Toolbar.Separator());
                fragRef = StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
                tb.add(new Toolbar.Button(title, "function(){guidelib.author.AuthorUtils.embedFragment(\"" + fragRef + "\", \"" + currentPanelPath + "\" ,\"" + bindRef + "\");}"));
            }
            return true;
        }
        return false;
    }

    public static String encodeForHtml(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTML(str);
        return result == null ? "" : result;
    }

    public static String encodeForHtmlAttr(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTMLAttr(str);
        return result == null ? "" : result;
    }

    public static String filterHtml(String str, XSSAPI xssapi) {
        String result = xssapi.filterHTML(str);
        return result == null ? "" : result;
    }

    private static XSSAPI getXssAPI(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssapi = bindings.getSling().getService(XSSAPI.class);
        return xssapi;
    }

    public static String getDefaultLocale(Resource resource) throws RepositoryException {
        String defaultLocale = "en";
        try {
            Node parentNode;
            Node containerNode = resource.adaptTo(Node.class);
            if (containerNode != null && (parentNode = containerNode.getParent()) != null && parentNode.hasProperty("jcr:language")) {
                defaultLocale = parentNode.getProperty("jcr:language").getString();
            }
        }
        catch (Exception e) {
            logger.error("Unable to access Page Locale", (Throwable)e);
        }
        return defaultLocale;
    }

    public static String getThemeClientLibName(Resource resource) {
        try {
            String theme;
            Node containerNode = resource.adaptTo(Node.class);
            if (containerNode != null && containerNode.hasProperty("themeRef") && !(theme = containerNode.getProperty("themeRef").getString()).isEmpty()) {
                Resource themeResource = resource.getResourceResolver().getResource(theme + "/jcr:content/metadata");
                if (themeResource != null) {
                    Node themeNode = themeResource.adaptTo(Node.class);
                    if (themeNode != null && themeNode.hasProperty("clientlibCategory")) {
                        return themeNode.getProperty("clientlibCategory").getString();
                    }
                } else {
                    logger.warn("Unable to retrieve the theme resource: " + theme);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to get Client lib name: " + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getLocale(SlingHttpServletRequest request, Resource guideContainerResource) {
        try {
            String defaultLocale = GuideELUtils.getDefaultLocale(guideContainerResource);
            String localeCode = null;
            String clientLibPrefix = "guides.I18N";
            Object locale = null;
            SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
            HtmlLibraryManager clientlibManager = bindings.getSling().getService(HtmlLibraryManager.class);
            boolean clientLibForDefaultLocaleExists = clientlibManager.getLibraries(new String[]{clientLibPrefix + "." + defaultLocale}, null, true, false).toArray().length > 0;
            String acceptLang = request.getParameter("afAcceptLang");
            if (acceptLang == null || "".equals(acceptLang.trim())) {
                acceptLang = request.getHeader("Accept-Language");
            }
            if (acceptLang == null || "".equals(acceptLang.trim())) {
                acceptLang = defaultLocale;
            }
            String[] locales = StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                String[] categories;
                Collection<ClientLibrary> libraries;
                boolean clientLibForLocaleExists;
                localeCode = StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                boolean bl = clientLibForLocaleExists = (libraries = clientlibManager.getLibraries(categories = new String[]{clientLibPrefix + "." + localeCode}, null, true, false)).toArray().length > 0;
                if (clientLibForLocaleExists) {
                    return localeCode;
                }
                if (splitLocale.length <= 1) continue;
                categories = new String[]{clientLibPrefix + "." + splitLocale[0].toLowerCase()};
                libraries = clientlibManager.getLibraries(categories, null, true, false);
                boolean bl2 = clientLibForLocaleExists = libraries.toArray().length > 0;
                if (!clientLibForLocaleExists) continue;
                return splitLocale[0].toLowerCase();
            }
            if (clientLibForDefaultLocaleExists) {
                return defaultLocale;
            }
            return "en";
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public static I18n getI18n(SlingHttpServletRequest request, Resource guideContainerResource) {
        try {
            String acceptLang = GuideUtils.getAcceptLang(request);
            String containerPath = GuideELUtils.getGuideContainerPath(request, guideContainerResource);
            if (containerPath == null || containerPath.isEmpty()) {
                containerPath = GuideUtils.getGuideContainerPathFromResource(request, guideContainerResource);
            }
            String baseName = containerPath + "/assets/dictionary";
            Locale locale = new Locale(acceptLang);
            return new I18n(request.getResourceBundle(baseName, locale));
        }
        catch (Exception e) {
            logger.error("There was certainly some problem in geti18n api", (Throwable)e);
            return null;
        }
    }

    public static I18n getI18n(ResourceBundleProvider resourceBundleProvider, Resource containerResource, Locale locale) {
        if (resourceBundleProvider != null && containerResource != null && locale != null) {
            return new I18n(resourceBundleProvider.getResourceBundle(containerResource.getPath(), locale));
        }
        return null;
    }
}

