/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.taglibs;

import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.utils.GuideHTMLParser;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyLoadPanelTag
extends BodyTagSupport {
    private static final Logger logger = LoggerFactory.getLogger(LazyLoadPanelTag.class);

    public int doAfterBody() throws JspException {
        try {
            boolean lazyLoadEnabled;
            Resource resource = (Resource)this.pageContext.getAttribute("resource");
            ValueMap valueMap = resource.getValueMap();
            GuidePanel guidePanel = (GuidePanel)this.pageContext.getAttribute("guidePanel", 2);
            String templateId = null;
            try {
                templateId = guidePanel.getId();
            }
            catch (Exception e) {
                logger.error("Could not get id for panel" + resource.getPath(), (Throwable)e);
                throw new JspException((Throwable)e);
            }
            String fragRef = valueMap.get("fragRef", "");
            String optimizeRenderPerf = valueMap.get("optimizeRenderPerformance", "");
            String guideNodeClass = valueMap.get("guideNodeClass", "");
            BodyContent body = this.getBodyContent();
            String bodyContent = body.getString();
            JspWriter out = body.getEnclosingWriter();
            if (fragRef.length() > 0 && guideNodeClass.equals("guidePanel") && (lazyLoadEnabled = StringUtils.isNotEmpty((String)optimizeRenderPerf))) {
                out.print(GuideHTMLParser.lazyFragmentMarker(templateId, bodyContent));
            }
            out.print(bodyContent);
        }
        catch (IOException ioe) {
            logger.error("Error parsing body of lazily loaded fragment: " + ioe);
            throw new JspException((Throwable)ioe);
        }
        return 0;
    }
}

