/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.w3c.dom.Document;

public class GuideModelUtils {
    public static String getDataForDORMerge(Document dorDoc, Document dataDocument, JSONObject guideContainerJson) throws JSONException {
        String xdpRef = guideContainerJson.has("xdpRef") ? guideContainerJson.getString("xdpRef") : null;
        String xsdRef = guideContainerJson.has("xsdRef") ? guideContainerJson.getString("xsdRef") : null;
        String excludeFromDorIfHidden = guideContainerJson.has("excludeFromDoRIfHidden") ? guideContainerJson.getString("excludeFromDoRIfHidden") : null;
        return GuideModelUtils.getDataForDORMerge(dorDoc, dataDocument, xdpRef, xsdRef, excludeFromDorIfHidden);
    }

    public static String getDataForDORMerge(Document dorDoc, Document dataDocument, Resource guideContainerResource) {
        ValueMap guideContainerProps = guideContainerResource.getValueMap();
        String xdpRef = (String)((Object)guideContainerProps.get("xdpRef", String.class));
        String xsdRef = (String)((Object)guideContainerProps.get("xsdRef", String.class));
        String excludeFromDorIfHidden = (String)((Object)guideContainerProps.get("excludeFromDoRIfHidden", String.class));
        return GuideModelUtils.getDataForDORMerge(dorDoc, dataDocument, xdpRef, xsdRef, excludeFromDorIfHidden);
    }

    private static String getDataForDORMerge(Document dorDoc, Document dataDocument, String xdpRef, String xsdRef, String excludeFromDorIfHidden) {
        return XMLUtils.getDorDataXmlPart(dorDoc, dataDocument, excludeFromDorIfHidden, StringUtils.isEmpty((String)xdpRef));
    }
}

