/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLCServiceConnector;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONArrayIterator;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.aemfd.expeditor.service.ExpressionEditorService;
import com.adobe.forms.common.service.DataXMLProvider;
import com.adobe.forms.common.service.FormDataXMLProviderRegistry;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.cq.widget.HtmlLibraryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value={GuidePropertyProviderUtils.class})
@Component
public class GuidePropertyProviderUtils {
    private static final String COMPONENT_PATH = "component-path";
    private final Logger logger = LoggerFactory.getLogger(GuidePropertyProviderUtils.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideLCServiceConnector guideLCServiceConnector;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private GuideProgressiveStrategyManager guideProgressiveStrategyManager;
    @Reference
    private ExpressionEditorService expressionEditorService;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference
    ResourceResolverHelper resourceResolverHelper;
    @Reference
    FormDataXMLProviderRegistry prefillRegistry;
    private static String SUBMITACTION = "submitAction";

    public JSONArray queryAppearance(String[] searchPaths, Map<String, String> options) {
        try {
            String guideNodeClass = options.get("guideNodeClass");
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            firstObj.put("text", "none");
            firstObj.put("value", JSONObject.NULL);
            response.put(firstObj);
            if (guideNodeClass != null && !guideNodeClass.isEmpty() && GuideUtils.listContains(GuideConstants.GUIDE_FIELDS_CLASS_NAMES, guideNodeClass, Boolean.TRUE).booleanValue()) {
                for (int i = 0; i < searchPaths.length; ++i) {
                    String query = "SELECT * FROM nt:base WHERE guideComponentType= 'fd/af/components/appearance/" + guideNodeClass + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator<Resource> appearances = resolver.findResources(query, "sql");
                    if (appearances == null) continue;
                    while (appearances.hasNext()) {
                        String qtip;
                        Resource r = appearances.next();
                        String path = r.getPath();
                        if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                            path = path.substring(6);
                        }
                        if (StringUtils.isEmpty((String)path)) continue;
                        String text = NodeStructureUtils.getLayoutDescription(r);
                        if (StringUtils.isEmpty((String)text)) {
                            text = path;
                        }
                        if (StringUtils.isEmpty((String)(qtip = NodeStructureUtils.getLayoutQtip(r)))) {
                            qtip = text;
                        }
                        JSONObject respObj = new JSONObject();
                        respObj.put("text", text);
                        respObj.put("value", path);
                        respObj.put("qtip", qtip);
                        response.put(respObj);
                    }
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONObject queryFragFinder(String formType, String resourceType, Map<String, String> options) {
        String[] searchPathsForFragments = new String[]{"/content/dam/formsanddocuments"};
        ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
        String QUERY = "query";
        String START = "start";
        String LIMIT = "limit";
        String QUERY_LANG = "xpath";
        String QUERY_ROOT = "/jcr:root";
        String QUERY_ELEMENT_TYPE = "//element(*, dam:Asset)";
        String SORT_BY_LAST_MODIFIED = " order by jcr:content/@jcr:lastModified descending";
        String PREDICATE = "jcr:content/metadata/@formmodel=";
        String FORM_PREDICATE = "jcr:content/@" + formType + " ='1'";
        String ASSET_TYPE_NONE = "'none'";
        String ASSET_TYPE_XSD = "'xmlschema'";
        String ASSET_TYPE_XFA = "'formtemplates'";
        try {
            JSONArray fragRefs = new JSONArray();
            String nameOrTitle = options.get("query");
            String alreadySentNodesString = options.get("start");
            String maxLimitToSendString = options.get("limit");
            ArrayList<String> typePredicates = new ArrayList<String>();
            String assetTypeParam = options.get("assetType");
            if (StringUtils.isNotBlank((String)assetTypeParam)) {
                for (String assetType : StringUtils.remove((String)assetTypeParam, (char)' ').split(",")) {
                    String filterType = null;
                    if ("none".equals(assetType)) {
                        filterType = "'none'";
                    } else if ("xfa".equals(assetType)) {
                        filterType = "'formtemplates'";
                    } else if ("xsd".equals(assetType)) {
                        filterType = "'xmlschema'";
                    }
                    if (filterType == null) continue;
                    typePredicates.add("jcr:content/metadata/@formmodel=" + filterType);
                }
            }
            String combinedTypePredicates = "";
            if (typePredicates.size() > 0) {
                combinedTypePredicates = " and ( " + StringUtils.join(typePredicates, (String)" or ") + " )";
            }
            for (String searchPathsForFragment : searchPathsForFragments) {
                String query = "/jcr:root" + searchPathsForFragment + "//element(*, dam:Asset)" + "[" + FORM_PREDICATE + combinedTypePredicates + "]" + " order by jcr:content/@jcr:lastModified descending";
                Iterator<Resource> fragmentNodes = resolver.findResources(query, "xpath");
                int alreadySentNodes = -1;
                int maxLimitToSend = -1;
                int nodesLeft = -1;
                if (maxLimitToSendString != null && maxLimitToSendString.length() > 0) {
                    maxLimitToSend = Integer.parseInt(maxLimitToSendString);
                }
                if (alreadySentNodesString != null && alreadySentNodesString.length() > 0) {
                    alreadySentNodes = Integer.parseInt(alreadySentNodesString);
                    nodesLeft = maxLimitToSend - alreadySentNodes;
                }
                if (fragmentNodes == null) continue;
                if (alreadySentNodes != -1) {
                    for (int node = 0; node < alreadySentNodes; ++node) {
                        if (!fragmentNodes.hasNext()) continue;
                        fragmentNodes.next();
                    }
                }
                while (fragmentNodes.hasNext() && (nodesLeft == -1 || nodesLeft-- != 0)) {
                    Resource r = fragmentNodes.next();
                    ValueMap properties = r.getChild("jcr:content").getChild("metadata").getValueMap();
                    boolean titleOrNameMatches = false;
                    if (nameOrTitle != null && nameOrTitle.length() > 0) {
                        boolean bl = titleOrNameMatches = StringUtils.containsIgnoreCase((String)((String)properties.get("name")), (String)nameOrTitle) || StringUtils.containsIgnoreCase((String)((String)properties.get("title")), (String)nameOrTitle);
                    }
                    if (nameOrTitle != null && !nameOrTitle.equals("") && !titleOrNameMatches) continue;
                    JSONObject fragObj = new JSONObject();
                    String name = properties.get("title", "");
                    if (name.length() == 0) {
                        name = r.getName();
                    }
                    String resourcePath = r.getPath();
                    String imageRef = resourcePath + "/jcr:content" + "/renditions/cq5dam.thumbnail.319.319.png";
                    String fragRef = resourcePath;
                    fragRef = StringUtils.substringBefore((String)fragRef, (String)"/jcr:content");
                    fragObj.put("name", name);
                    fragObj.put("jcr:primaryType", "nt:unstructured");
                    fragObj.put("sling:resourceType", resourceType);
                    Resource componentResource = resolver.getResource(resourceType);
                    fragObj.put(COMPONENT_PATH, componentResource.getPath());
                    fragObj.put("image", imageRef);
                    fragObj.put("path", fragRef);
                    fragRefs.put(fragObj);
                }
            }
            JSONObject response = new JSONObject();
            response.put("fragRefs", fragRefs);
            return response;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryLayout(String[] searchPaths, Map<String, String> options, SlingHttpServletRequest request) {
        JSONArray response = new JSONArray();
        String layoutType = "";
        String isAfField = "";
        if (options.get("layoutType") != null && options.get("layoutType").length() > 0) {
            layoutType = options.get("layoutType");
            isAfField = options.get("isAfField");
        }
        if (layoutType.length() > 0) {
            try {
                if ("fd/af/layouts/field".equals(layoutType)) {
                    JSONObject firstObj = new JSONObject();
                    firstObj.put("text", "");
                    firstObj.put("value", "");
                    response.put(firstObj);
                }
                ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
                ArrayList<String> listOfLayouts = new ArrayList<String>();
                for (int i = 0; i < searchPaths.length; ++i) {
                    String query = "SELECT * FROM nt:base WHERE guideComponentType='" + layoutType + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator<Resource> layouts = resolver.findResources(query, "sql");
                    if (layouts == null) continue;
                    while (layouts.hasNext()) {
                        Resource r = layouts.next();
                        String path = r.getPath();
                        if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                            path = path.substring(6);
                        }
                        String desc = NodeStructureUtils.getLayoutDescription(r);
                        if (listOfLayouts.contains(path)) continue;
                        JSONObject respObj = new JSONObject();
                        if ("fd/af/layouts/panel".equals(layoutType)) {
                            respObj.put("guideNavigatorTab", NodeStructureUtils.getGuideNavigatorTabProperty(r));
                        }
                        I18n i18n = new I18n(request.getResourceBundle(new Locale(request.getLocale().getLanguage())));
                        desc = "true".equals(isAfField) && path != null && path.indexOf("defaultFieldLayout") > 0 ? i18n.get("Inherit From Adaptive Form Configuration") : desc;
                        respObj.put("text", desc == null ? r.getPath() : desc);
                        String qtip = NodeStructureUtils.getLayoutQtip(r);
                        respObj.put("value", path);
                        if ("fd/af/layouts/field".equals(layoutType)) {
                            XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
                            qtip = GuideELUtils.encodeForHtml(qtip, xssapi);
                        }
                        respObj.put("qtip", qtip);
                        listOfLayouts.add(path);
                        response.put(respObj);
                    }
                }
            }
            catch (JSONException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        } else {
            this.logger.warn("Request did not have layout type mentioned.So, not returning any layout types");
        }
        return response;
    }

    public JSONArray queryPrefillServiceProviders() {
        JSONArray result = new JSONArray();
        try {
            List<DataXMLProvider> providers = this.prefillRegistry.getProviders();
            for (DataXMLProvider provider : providers) {
                JSONObject obj = new JSONObject();
                String serviceName = provider.getServiceName();
                String serviceDescription = provider.getServiceDescription();
                obj.put("text", serviceDescription);
                obj.put("value", serviceName);
                obj.put("qtip", serviceDescription);
                result.put(obj);
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
        return result;
    }

    public JSONArray queryTheme() {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            String[] searchPathsForThemes = new String[]{"/content/dam/formsanddocuments-themes"};
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            firstObj.put("text", "");
            firstObj.put("value", "");
            firstObj.put("name", "");
            response.put(firstObj);
            for (int i = 0; i < searchPathsForThemes.length; ++i) {
                Iterator<Resource> themes = resolver.findResources("SELECT *  FROM dam:Asset WHERE jcr:path LIKE '" + searchPathsForThemes[i] + "%'", "sql");
                if (themes == null) continue;
                while (themes.hasNext()) {
                    Resource r = themes.next();
                    Resource metadataResource = r.getChild("jcr:content/metadata");
                    Node node = metadataResource.adaptTo(Node.class);
                    try {
                        String themeName = node.getProperty("title").getString();
                        String themeNodePath = node.getParent().getParent().getPath();
                        JSONObject respObj = new JSONObject();
                        respObj.put("text", themeName);
                        respObj.put("value", themeNodePath);
                        respObj.put("name", themeName);
                        response.put(respObj);
                    }
                    catch (RepositoryException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        throw new GuideException((Exception)((Object)e));
                    }
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryAction(String[] searchPaths) {
        HashMap<String, Resource> resourceMappings = new HashMap<String, Resource>();
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator<Resource> layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/components/action' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (layouts == null) continue;
                resourceMappings.clear();
                while (layouts.hasNext()) {
                    Resource r = layouts.next();
                    String path = r.getPath();
                    if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                        path = path.substring(6);
                    }
                    if (resourceMappings.containsKey(path) && !r.getPath().startsWith("/apps/")) continue;
                    resourceMappings.put(path, r);
                }
                for (Map.Entry entry : resourceMappings.entrySet()) {
                    Resource resource = (Resource)entry.getValue();
                    JSONObject respObj = new JSONObject();
                    String desc = NodeStructureUtils.getLayoutDescription(resource);
                    respObj.put("text", desc == null ? (String)entry.getKey() : desc);
                    respObj.put("value", entry.getKey());
                    respObj.put("name", resource.getName());
                    respObj.put("path", resource.getPath());
                    if (resource.getResourceSuperType() != null) {
                        respObj.put("sling:resourceSuperType", resource.getResourceSuperType());
                    }
                    respObj.put("templatePath", this.getComponentTemplatePath(resource));
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryProgressiveStrategies(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            for (String searchPath : searchPaths) {
                Iterator<Resource> services = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '/libs/fd/af/components/progressiveDataCapture' AND jcr:path LIKE '" + searchPath + "%'", "sql");
                if (services == null) continue;
                while (services.hasNext()) {
                    Resource r = services.next();
                    String value = r.getPath();
                    ValueMap properties = r.getValueMap();
                    String displayName = NodeStructureUtils.getLayoutDescription(r);
                    String strategyName = properties.get("strategyName", "");
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", displayName);
                    respObj.put("qtip", displayName);
                    respObj.put("value", value);
                    respObj.put("strategyName", strategyName);
                    respObj.put("type", "service");
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryProgressiveLayout(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator<Resource> layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/progressive' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = layouts.next();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", desc == null ? r.getPath() : desc);
                    String qtip = NodeStructureUtils.getLayoutQtip(r);
                    respObj.put("qtip", qtip);
                    String path = r.getPath();
                    respObj.put("value", path + "/layout.html");
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryFormatters(String guideNodeClass, String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            firstObj.put("text", "none");
            firstObj.put("value", "");
            response.put(firstObj);
            if (guideNodeClass != null && !guideNodeClass.isEmpty() && GuideUtils.listContains(GuideConstants.GUIDE_FIELDS_CLASS_NAMES, guideNodeClass, Boolean.TRUE).booleanValue()) {
                for (int i = 0; i < searchPaths.length; ++i) {
                    Resource format;
                    String query = "SELECT * FROM nt:base WHERE guideComponentType= 'fd/af/components/formatter/" + guideNodeClass + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator<Resource> formats = resolver.findResources(query, "sql");
                    if (!formats.hasNext() || (format = formats.next()) == null) continue;
                    ValueMap properties = format.getValueMap();
                    for (Map.Entry pairs : properties.entrySet()) {
                        String key = (String)pairs.getKey();
                        if (!key.startsWith("pattern")) continue;
                        JSONObject respObj = new JSONObject();
                        String value = (String)pairs.getValue();
                        String[] arr = value.split("=", 2);
                        respObj.put("text", arr[0]);
                        respObj.put("value", arr[1]);
                        response.put(respObj);
                    }
                }
            }
            JSONObject lastObj = new JSONObject();
            lastObj.put("text", "Custom");
            lastObj.put("value", "custom");
            response.put(lastObj);
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray querySubmitOrAutoSaveAction(String[] searchPaths, Map<String, String> options) {
        String type = options.get("type");
        String requestedDataModel = options.get("guideDataModel");
        String guideComponentType = type.equalsIgnoreCase(SUBMITACTION) ? "fd/af/components/guidesubmittype" : "fd/af/components/guideautosavetype";
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            ArrayList<String> listOfSubmitAction = new ArrayList<String>();
            JSONArray response = new JSONArray();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator<Resource> actions = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '" + guideComponentType + "' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (actions == null) continue;
                while (actions.hasNext()) {
                    Resource r = actions.next();
                    String value = r.getPath();
                    if (value.startsWith("/libs/") || value.startsWith("/apps/")) {
                        value = value.substring(6);
                    }
                    ValueMap properties = r.getValueMap();
                    String text = properties.get("jcr:description", "");
                    String qtip = properties.get("qtip", "");
                    Boolean addOption = true;
                    if (requestedDataModel != null) {
                        String dataModel = properties.get("guideDataModel", "");
                        addOption = dataModel.toLowerCase().contains(requestedDataModel.toLowerCase()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!addOption.booleanValue() || listOfSubmitAction.contains(value)) continue;
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", text);
                    listOfSubmitAction.add(value);
                    respObj.put("value", value);
                    respObj.put("qtip", qtip);
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryLcProcess() {
        try {
            JSONArray response = new JSONArray();
            List<String> services = this.guideLCServiceConnector.getServices();
            for (String s : services) {
                JSONObject respObj = new JSONObject();
                respObj.put("text", s);
                respObj.put("value", s);
                response.put(respObj);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("Cannot fetch LCServices", (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryMobileLayout(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            ArrayList<String> listOfMobileLayoutPath = new ArrayList<String>();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator<Resource> layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/mobile' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = layouts.next();
                    String path = r.getPath();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                        path = path.substring(6);
                    }
                    if (listOfMobileLayoutPath.contains(path)) continue;
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", desc == null ? r.getPath() : desc);
                    String qtip = NodeStructureUtils.getLayoutQtip(r);
                    respObj.put("qtip", qtip);
                    listOfMobileLayoutPath.add(path);
                    respObj.put("value", path);
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryChartReducer(String[] searchPaths) {
        JSONArray response = new JSONArray();
        try {
            JSONObject firstObj = new JSONObject();
            firstObj.put("text", "None");
            firstObj.put("value", "none");
            firstObj.put("qtip", "None");
            response.put(firstObj);
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator<Resource> reducerFunctions = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/reducer' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (reducerFunctions == null) continue;
                while (reducerFunctions.hasNext()) {
                    String qtip;
                    Resource r = reducerFunctions.next();
                    ValueMap properties = r.getValueMap();
                    String val = (String)properties.get("value");
                    if (StringUtils.isEmpty((String)val)) continue;
                    String text = NodeStructureUtils.getLayoutDescription(r);
                    if (StringUtils.isEmpty((String)text)) {
                        text = val;
                    }
                    if (StringUtils.isEmpty((String)(qtip = NodeStructureUtils.getLayoutQtip(r)))) {
                        qtip = text;
                    }
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", text);
                    respObj.put("value", val);
                    respObj.put("qtip", qtip);
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray fetchEsignCloudServiceConfiguration(String rootPath, ResourceResolver resourceResolver) {
        JSONArray response = new JSONArray();
        try {
            ConfigurationManager configManager = resourceResolver.adaptTo(ConfigurationManager.class);
            if (rootPath != null) {
                com.day.cq.wcm.webservicesupport.Service service = configManager.getService(configManager.getServiceName(rootPath));
                Iterator<Configuration> iter = configManager.getConfigurations(rootPath);
                while (iter.hasNext()) {
                    Configuration cfg = iter.next();
                    Template template = cfg.getTemplate();
                    if (template == null || service == null || !service.isSelectableChild(template.getPath()).booleanValue()) continue;
                    String description = cfg.getDescription() != null ? cfg.getDescription() : template.getDescription();
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", cfg.getTitle());
                    respObj.put("value", cfg.getPath());
                    respObj.put("icon", cfg.getIconPath());
                    respObj.put("description", description);
                    response.put(respObj);
                }
            } else {
                this.logger.warn("Missing parameter for 'rootPath'");
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while listing cloudservice configs: ", (Throwable)e);
        }
        return response;
    }

    private String getComponentTemplatePath(Resource componentResource) {
        try {
            Node componentNode = componentResource.adaptTo(Node.class);
            ValueMap componentProperties = componentResource.adaptTo(ValueMap.class);
            String templatePath = (String)componentProperties.get("cq:templatePath");
            if (templatePath == null && componentNode.hasNode("cq:template")) {
                templatePath = componentNode.getNode("cq:template").getPath();
            }
            return templatePath;
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public Iterator<JSONObject> getJSONIterator(JSONArray arr) {
        return new JSONArrayIterator(arr);
    }

    public Map<String, Object> getMapFromJSONObject(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object jsonObject = null;
        try {
            Iterator<String> keys = object.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                Object value = object.get(key);
                if (value instanceof JSONObject) {
                    map.put(key, this.getMapFromJSONObject((JSONObject)value));
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.length(); ++i) {
                        jsonObject = array.get(i);
                        if (jsonObject instanceof JSONObject) {
                            list.add(this.getMapFromJSONObject((JSONObject)jsonObject));
                            continue;
                        }
                        list.add(jsonObject);
                    }
                    map.put(key, list);
                    continue;
                }
                map.put(key, value);
            }
            return map;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public JSONArray queryDocumentFragmentLayout(String[] searchPaths) {
        try {
            JSONArray response = new JSONArray();
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONObject firstObj = new JSONObject();
            firstObj.put("text", "");
            firstObj.put("value", "");
            response.put(firstObj);
            for (int i = 0; i < searchPaths.length; ++i) {
                String query = "SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/adaddon/documentFragmentLayout' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                Iterator<Resource> layouts = resolver.findResources(query, "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = layouts.next();
                    ValueMap properties = r.getValueMap();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", desc == null ? r.getPath() : desc);
                    respObj.put("value", properties.get("layout", ""));
                    response.put(respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected void bindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        this.guideLCServiceConnector = guideLCServiceConnector;
    }

    protected void unbindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        if (this.guideLCServiceConnector == guideLCServiceConnector) {
            this.guideLCServiceConnector = null;
        }
    }

    protected void bindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        this.guideProgressiveStrategyManager = guideProgressiveStrategyManager;
    }

    protected void unbindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        if (this.guideProgressiveStrategyManager == guideProgressiveStrategyManager) {
            this.guideProgressiveStrategyManager = null;
        }
    }

    protected void bindExpressionEditorService(ExpressionEditorService expressionEditorService) {
        this.expressionEditorService = expressionEditorService;
    }

    protected void unbindExpressionEditorService(ExpressionEditorService expressionEditorService) {
        if (this.expressionEditorService == expressionEditorService) {
            this.expressionEditorService = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindPrefillRegistry(FormDataXMLProviderRegistry formDataXMLProviderRegistry) {
        this.prefillRegistry = formDataXMLProviderRegistry;
    }

    protected void unbindPrefillRegistry(FormDataXMLProviderRegistry formDataXMLProviderRegistry) {
        if (this.prefillRegistry == formDataXMLProviderRegistry) {
            this.prefillRegistry = null;
        }
    }
}

