/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideSchema {
    private static List<String> localizableProp = new ArrayList<String>();
    private static HashMap<String, List<String>> exclusiveLocalizable = new HashMap();
    private static String[] supportedLocalizableProperties = new String[]{"jcr:title", "jcr:description", "customAssist", "shortDescription", "longDescription", "mandatoryMessage", "validateExpMessage", "formatMessage", "validatePictureClauseMessage", "placeholderText", "buttonText", "tncTextContent", "tncCheckBoxContent", "displayMsg", "options", "xAxisTitle", "yAxisTitle", "placeholderDay", "placeholderMonth", "placeholderYear", "titleMonth", "titleDay", "titleYear"};

    public static void emptyLocalizableProperties() {
        int localizablePropSize = localizableProp.size();
        for (int i = supportedLocalizableProperties.length; i < localizablePropSize; ++i) {
            localizableProp.remove(supportedLocalizableProperties.length);
        }
    }

    public static void addLocalizableProp(String compName, List<String> properties) {
        if (compName == null) {
            localizableProp.addAll(properties);
        } else {
            List<Object> existingProp = new ArrayList();
            if (exclusiveLocalizable.containsKey(compName)) {
                existingProp = exclusiveLocalizable.get(compName);
            } else {
                exclusiveLocalizable.put(compName, existingProp);
            }
            existingProp.addAll(properties);
        }
    }

    public static boolean isLocalizableProperty(String compName, String propName) {
        boolean localizable = false;
        if (propName != null) {
            if (compName != null && exclusiveLocalizable.get(compName) != null) {
                localizable = exclusiveLocalizable.get(compName).contains(propName);
            }
            if (!localizable) {
                localizable = localizableProp.contains(propName);
            }
        }
        return localizable;
    }

    static {
        GuideSchema.addLocalizableProp(null, Arrays.asList(supportedLocalizableProperties));
        ArrayList<String> textDrawProp = new ArrayList<String>();
        textDrawProp.add("_value");
        GuideSchema.addLocalizableProp("guideTextDraw", textDrawProp);
    }
}

