/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideThemeUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideThemeUtils.class);

    public static String getThemeClientlibPath(Node resourceNode) throws GuideException {
        String clientLibProperty = "./metadata/clientlibRef";
        String clientLibPath = "";
        try {
            if (resourceNode != null && resourceNode.hasProperty(clientLibProperty)) {
                clientLibPath = resourceNode.getProperty(clientLibProperty).getString() + "/" + resourceNode.getParent().getName();
            }
        }
        catch (ValueFormatException e) {
            logger.error("Exception in getClientlibNode()", (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
        catch (PathNotFoundException e) {
            logger.error("Exception in getClientlibNode()", (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
        catch (RepositoryException e) {
            logger.error("Exception in getClientlibNode()", (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
        return clientLibPath;
    }

    public static String getConfiguredFormPagePath(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String formRef = null;
        try {
            String formPagePath;
            Session session = resourceResolver.adaptTo(Session.class);
            String formAssetPath = GuideThemeUtils.getConfiguredFormPath(resourceResolver, themeContentPath);
            if (formAssetPath != null && !formAssetPath.isEmpty() && (formPagePath = StringUtils.replace((String)formAssetPath, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1)).startsWith("/content/forms/af/") && session.nodeExists(formPagePath)) {
                formRef = formPagePath;
            }
            if (formRef == null) {
                Resource defaultForm = resourceResolver.getResource("fd/af/themes/default");
                formRef = defaultForm.getPath();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return formRef;
    }

    public static String getConfiguredFormPath(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String formAssetPath = null;
        try {
            Node themeContentNode;
            Session session = resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/formRef")) {
                formAssetPath = themeContentNode.getProperty("metadata/formRef").getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return formAssetPath;
    }

    public static String getThemeName(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String themePath = null;
        try {
            Node themeContentNode;
            Session session = resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/title")) {
                themePath = themeContentNode.getProperty("metadata/title").getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return themePath;
    }

    public static String getThemeClientlibCategory(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String themeClientlibCategory = null;
        try {
            Node themeContentNode;
            Session session = resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/clientlibCategory")) {
                themeClientlibCategory = themeContentNode.getProperty("metadata/clientlibCategory").getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return themeClientlibCategory;
    }

    public static String getBaseClientlibCategory(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String baseClientlibCategory = null;
        try {
            String clientlibLoc;
            Node clientlibNode;
            Node themeContentNode;
            Session session = resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/clientlibRef") && (clientlibNode = session.getNode((clientlibLoc = themeContentNode.getProperty("metadata/clientlibRef").getString()) + "/" + themeContentNode.getParent().getName())).hasProperty("dependencies")) {
                Value[] values = clientlibNode.getProperty("dependencies").getValues();
                baseClientlibCategory = values[0].getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return baseClientlibCategory;
    }

    public static String getErrorSimulatorString(ValueMap properties) {
        String validatePictureClauseMessage;
        String mandatoryMessageAttribute = null;
        boolean mandatory = properties.get("mandatory", false);
        if (mandatory) {
            String mandatoryMessage = (String)((Object)properties.get("mandatoryMessage", String.class));
            mandatoryMessageAttribute = mandatoryMessage != null && !mandatoryMessage.equals("") ? mandatoryMessage : "There is an error in this field !";
        } else {
            String validateExpMessage = (String)((Object)properties.get("validateExpMessage", String.class));
            if (validateExpMessage != null && !validateExpMessage.equals("")) {
                mandatoryMessageAttribute = validateExpMessage;
            }
        }
        if (mandatoryMessageAttribute != null && (validatePictureClauseMessage = (String)((Object)properties.get("validatePictureClauseMessage", String.class))) != null) {
            mandatoryMessageAttribute = validatePictureClauseMessage;
        }
        return mandatoryMessageAttribute;
    }
}

