/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.ResourcePropertyTransformer;
import com.day.cq.i18n.I18n;
import java.util.Locale;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONCreationOptions {
    private Logger logger = LoggerFactory.getLogger(JSONCreationOptions.class);
    private boolean includeJcrPath;
    private I18n i18n;
    private boolean includeFragmentJson;
    private String dataRef;
    private String pagePath;
    private String formContainerPath;
    private boolean contextNeeded;
    private Resource formResource;
    private ResourcePropertyTransformer transformer;
    private String data;
    private Locale locale;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getContextNeeded() {
        return this.contextNeeded;
    }

    public JSONCreationOptions() {
        this.contextNeeded = false;
    }

    public JSONCreationOptions(I18n i18n, boolean includeJcrPath, boolean includeFragmentJson, Locale locale, Resource formResource) {
        this.includeJcrPath = includeJcrPath;
        this.i18n = i18n;
        this.includeFragmentJson = includeFragmentJson;
        this.locale = locale;
        this.formResource = formResource;
        this.contextNeeded = true;
    }

    public void setTransformer(ResourcePropertyTransformer transformer) {
        this.transformer = transformer;
    }

    public JSONCreationOptions setI18n(I18n i18n) {
        this.i18n = i18n;
        return this;
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public boolean isIncludeJcrPath() {
        return this.includeJcrPath;
    }

    public boolean isIncludeFragmentJson() {
        return this.includeFragmentJson;
    }

    public void setIncludeFragmentJson(boolean includeFragmentJson) {
        this.includeFragmentJson = includeFragmentJson;
    }

    public Resource getFormResource() {
        return this.formResource;
    }

    public void setFormResource(Resource formResource) {
        this.formResource = formResource;
    }

    public String getFormResourceProperty(String propertyName) {
        String propertyValue = "";
        if (this.formResource != null) {
            ValueMap resourceProps = ResourceUtil.getValueMap(this.formResource);
            propertyValue = resourceProps.get(propertyName, "");
        }
        return propertyValue;
    }

    public ResourcePropertyTransformer getTransformer() {
        return this.transformer;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public JSONCreationOptions setDataRef(String dataRef) {
        this.dataRef = dataRef;
        return this;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public JSONCreationOptions setPagePath(String pagePath) {
        this.pagePath = pagePath;
        return this;
    }

    public String getFormContainerPath() {
        return this.formContainerPath;
    }

    public JSONCreationOptions setFormContainerPath(String formContainerPath) {
        this.formContainerPath = formContainerPath;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public JSONCreationOptions setData(String data) {
        this.data = data;
        return this;
    }
}

