/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueDataMerger {
    protected Logger logger = LoggerFactory.getLogger(KeyValueDataMerger.class);
    protected JSONObject guideJSON;
    protected CustomJSONWriter jsonWriter;
    protected StringWriter stringWriter;
    protected GuideModuleImporter guideModuleImporter;
    protected Map<String, Object> moduleParameter;

    public KeyValueDataMerger(JSONObject guideJson, Map<String, Object> params) {
        this.guideJSON = guideJson;
        this.stringWriter = new StringWriter();
        this.jsonWriter = new CustomJSONWriter(this.stringWriter);
        this.moduleParameter = params;
        if (params != null) {
            this.guideModuleImporter = (GuideModuleImporter)params.get(GuideModuleImporter.class.getName());
        }
    }

    public JSONObject merge() throws GuideException {
        try {
            this.jsonWriter.object();
            this.mergeJSONObject(this.guideJSON);
            this.jsonWriter.endObject();
            return new JSONObject(this.stringWriter.toString());
        }
        catch (XPathExpressionException e) {
            if (e.getCause() instanceof TransformerException && "Empty expression!".equals(e.getCause().getMessage())) {
                throw new GuideException("It might be that Unbound repeatable panels are present in AF.This is not supported for adaptive forms using the XFA form template or XSD.", e);
            }
            throw new GuideException("Invalid X Path", e);
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public void updateMergedJson(JSONObject jsonObject) throws Exception {
    }

    protected void moduleMergeJson(JSONObject jsonObject, String guideNodeClass) throws Exception {
        if (("guideAdModule".equals(guideNodeClass) || "guideAdModuleGroup".equals(guideNodeClass)) && this.moduleParameter != null && this.guideModuleImporter != null) {
            String resolvedHTML = null;
            if ("guideAdModule".equals(guideNodeClass)) {
                if (jsonObject.has("assetRef")) {
                    resolvedHTML = this.guideModuleImporter.getModuleResolution(jsonObject.getString("assetRef"), this.moduleParameter);
                }
            } else if ("guideAdModuleGroup".equals(guideNodeClass)) {
                String assetRef = null;
                if (jsonObject.has("assetRef")) {
                    assetRef = jsonObject.getString("assetRef");
                }
                if (StringUtils.isEmpty(assetRef)) {
                    JSONObject itemsJSONObject = null;
                    if (jsonObject.has("items")) {
                        itemsJSONObject = (JSONObject)jsonObject.get("items");
                        Iterator<String> itemKeys = itemsJSONObject.keys();
                        ArrayList<String> moduleAssetRefs = new ArrayList<String>();
                        while (itemKeys.hasNext()) {
                            JSONObject moduleJSONObject = (JSONObject)itemsJSONObject.get(itemKeys.next());
                            if (!moduleJSONObject.has("assetRef")) continue;
                            moduleAssetRefs.add(moduleJSONObject.getString("assetRef"));
                        }
                        this.moduleParameter.put("moduleList", moduleAssetRefs);
                        resolvedHTML = this.guideModuleImporter.getModuleGroupResolution(null, this.moduleParameter);
                    }
                } else {
                    resolvedHTML = this.guideModuleImporter.getModuleGroupResolution(assetRef, this.moduleParameter);
                }
            }
            if (resolvedHTML != null) {
                this.jsonWriter.key("_value").value(resolvedHTML);
            }
        }
    }

    protected void mergeJSONObject(JSONObject jsonObject) throws Exception {
        String name = "";
        String guideNodeClass = null;
        if (jsonObject.has("guideNodeClass")) {
            guideNodeClass = jsonObject.getString("guideNodeClass");
            this.jsonWriter.key("guideNodeClass").value(guideNodeClass);
        }
        if (jsonObject.has("name")) {
            name = jsonObject.getString("name");
            this.jsonWriter.key("name").value(name);
            if (GuideUtils.isGuideFieldModel(guideNodeClass)) {
                this.updateMergedJson(jsonObject);
            }
        }
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = jsonObject.get(key);
            if (!"guideAdModuleGroup".equals(guideNodeClass) && value instanceof JSONObject) {
                this.jsonWriter.key(key).object();
                this.mergeJSONObject((JSONObject)value);
                this.jsonWriter.endObject();
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.logger.trace("found an json array in guide node structure. Ignoring this. Key:" + key);
        }
        this.moduleMergeJson(jsonObject, guideNodeClass);
    }
}

