/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    public static final String[] DISALLOWED_PANEL_ELEMENTS_IN_TABLE = new String[]{"guidePanel", "guideTable"};
    public static final String GUIDE_NODE_CLASS = "guideNodeClass";
    public static final String ITEMS = "items";
    private static Logger logger = LoggerFactory.getLogger(TableUtils.class);

    public static int getColumnsCount(JSONObject table) {
        int columnsCount = 0;
        try {
            JSONObject tableItems = table.getJSONObject(ITEMS);
            Iterator<String> itr = tableItems.keys();
            JSONObject item = null;
            while (itr.hasNext() && ((item = tableItems.optJSONObject(itr.next())) == null || !item.has(GUIDE_NODE_CLASS))) {
            }
            JSONObject headerRow = item;
            JSONObject headerRowItems = headerRow.getJSONObject(ITEMS);
            itr = headerRowItems.keys();
            while (itr.hasNext()) {
                item = headerRowItems.optJSONObject(itr.next());
                if (item == null || !item.has(GUIDE_NODE_CLASS)) continue;
                ++columnsCount;
            }
        }
        catch (JSONException e) {
            logger.error("JSON exception while finding number of columns in a table", (Throwable)e);
        }
        return columnsCount;
    }

    public static boolean shouldGenerateDoRTable(JSONObject panel) {
        try {
            JSONObject panelItems = panel.getJSONObject(ITEMS);
            Iterator<String> itr = panelItems.keys();
            while (itr.hasNext()) {
                JSONObject item = panelItems.optJSONObject(itr.next());
                if (item == null || !Arrays.asList(DISALLOWED_PANEL_ELEMENTS_IN_TABLE).contains(item.optString(GUIDE_NODE_CLASS))) continue;
                logger.warn("Not converting Repeatable panel to Table as it contains a " + item.optString(GUIDE_NODE_CLASS));
                return false;
            }
        }
        catch (JSONException e) {
            logger.error("JSON exception while finding whether to convert repeatable panel to Table in DoR", (Throwable)e);
        }
        return true;
    }
}

