/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.guideJson;

import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsoluteBindrefResolver
implements GuideJsonVisitor {
    private static Logger log = LoggerFactory.getLogger(AbsoluteBindrefResolver.class);
    private String xsdRootElem = null;

    public AbsoluteBindrefResolver(String xsdRootEl) {
        this.xsdRootElem = xsdRootEl;
    }

    public void visitItem(JSONObject obj) {
        try {
            String relBindRef;
            if (XMLUtils.isXsd(obj) && StringUtils.isNotBlank((CharSequence)(relBindRef = XMLUtils.getRelativeXpath(obj.optString("bindRef"), this.xsdRootElem)))) {
                obj.put("bindRef", "/" + this.xsdRootElem + "/" + relBindRef);
            }
        }
        catch (JSONException e) {
            log.debug("Failed to modify absolute bindRef of item : " + obj.toString(), (Throwable)e);
        }
    }

    public void preRecurse(JSONObject obj) {
    }

    public void postRecurse(JSONObject obj) {
    }
}

