/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.guideJson;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateBindrefsCollector
implements GuideJsonVisitor {
    private Map<String, Boolean> bindRefDupStatus = new HashMap<String, Boolean>();
    private Boolean skipDescendants = false;
    private String currentRepeatable = null;

    @Override
    public void visitItem(JSONObject obj) {
        if (!this.skipDescendants.booleanValue() && !"guidePanel".equals(obj.optString("guideNodeClass"))) {
            String bindRef = obj.optString("bindRef");
            String effectiveBindRef = null;
            if (StringUtils.isBlank((CharSequence)bindRef)) {
                effectiveBindRef = obj.optString("name");
            } else if (StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"/")) {
                effectiveBindRef = bindRef;
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)effectiveBindRef))) {
                this.bindRefDupStatus.put(effectiveBindRef, this.bindRefDupStatus.containsKey(effectiveBindRef));
            }
        }
    }

    public List<String> getDuplicatedBindRefs() {
        ArrayList<String> duplicatedBindRefs = new ArrayList<String>();
        for (String bindRef : this.bindRefDupStatus.keySet()) {
            if (!this.bindRefDupStatus.get(bindRef).booleanValue()) continue;
            duplicatedBindRefs.add(bindRef);
        }
        return duplicatedBindRefs;
    }

    private boolean isSkippableItem(JSONObject obj) {
        return GuideUtils.isCompositeField(obj) || GuideUtils.isRepeatablePanel(obj);
    }

    @Override
    public void preRecurse(JSONObject obj) {
        if (!this.skipDescendants.booleanValue() && this.isSkippableItem(obj)) {
            this.skipDescendants = true;
            this.currentRepeatable = obj.optString("templateId");
        }
    }

    @Override
    public void postRecurse(JSONObject obj) {
        if (this.skipDescendants.booleanValue() && StringUtils.isNotBlank((CharSequence)this.currentRepeatable) && StringUtils.equals((CharSequence)this.currentRepeatable, (CharSequence)obj.optString("templateId"))) {
            this.skipDescendants = false;
            this.currentRepeatable = null;
        }
    }
}

