/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.guideJson;

import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedFormsXsdRootFixer
implements GuideJsonVisitor {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedFormsXsdRootFixer.class);
    private final Resource resource;
    private final GuideModelTransformer guideModelTransformer;
    private boolean hasEmbeddedForms = false;
    private boolean isHasEmbeddedXsdForm = false;

    public EmbeddedFormsXsdRootFixer(Resource resource, GuideModelTransformer guideModelTransformer) {
        this.resource = resource;
        this.guideModelTransformer = guideModelTransformer;
    }

    public void visitItem(JSONObject panel) {
        try {
            if (panel.optBoolean("isForm")) {
                this.hasEmbeddedForms = true;
                String fragRef = panel.optString("fragRef");
                Resource formResource = GuideUtils.getFormResource(this.resource, fragRef);
                JSONObject formJson = GuideUtils.getFormJson(formResource, this.guideModelTransformer);
                if (formJson != null && StringUtils.isNotBlank((CharSequence)formJson.optString("xsdRef"))) {
                    this.isHasEmbeddedXsdForm = true;
                    String childXsdRootEl = formJson.optString("xsdRootElement");
                    panel.put("xsdRootElement", childXsdRootEl);
                }
            }
        }
        catch (JSONException e) {
            log.error("Failed to handle embedded form Json", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to fetch/modify embedded form Json", (Throwable)e);
        }
    }

    public boolean isHasEmbeddedForms() {
        return this.hasEmbeddedForms;
    }

    public boolean isHasEmbeddedXsdForm() {
        return this.isHasEmbeddedXsdForm;
    }

    public void preRecurse(JSONObject obj) {
    }

    public void postRecurse(JSONObject obj) {
    }
}

