/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.guideJson;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.guideJson.GuideJsonVisitor;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideJsonItemsTraverser {
    private static Logger log = LoggerFactory.getLogger(GuideJsonItemsTraverser.class);
    private JSONObject rootPanel = null;
    List<GuideJsonVisitor> visitors = null;

    public GuideJsonItemsTraverser(JSONObject guideJson, List<GuideJsonVisitor> visitors) {
        try {
            this.rootPanel = GuideUtils.getGuideContainer(guideJson).getJSONObject("rootPanel");
        }
        catch (JSONException e) {
            log.error("Could not get rootPanel for traversal within GuideJson : " + guideJson.toString(), (Throwable)e);
        }
        this.visitors = visitors;
    }

    public void traverse() {
        this.traverse(this.rootPanel);
    }

    private void traverse(JSONObject obj) {
        if (JSONObject.NULL.equals(obj)) {
            return;
        }
        for (GuideJsonVisitor visitor : this.visitors) {
            visitor.visitItem(obj);
            visitor.preRecurse(obj);
        }
        this.recurse(obj);
        for (GuideJsonVisitor visitor : this.visitors) {
            visitor.postRecurse(obj);
        }
    }

    private void recurse(JSONObject obj) {
        JSONObject itemsObj = obj.optJSONObject("items");
        if (!JSONObject.NULL.equals(itemsObj) && itemsObj.length() > 0) {
            try {
                JSONArray itemsArr = itemsObj.toJSONArray(itemsObj.names());
                for (int i = 0; i < itemsArr.length(); ++i) {
                    this.traverse(itemsArr.optJSONObject(i));
                }
            }
            catch (JSONException e) {
                log.error("Could not get items for recursion within GuideJson : " + itemsObj.toString(), (Throwable)e);
            }
        }
    }
}

