/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.rhino;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.rhino.RhinoValueConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoScriptProcessor {
    private static final Log logger = LogFactory.getLog(RhinoScriptProcessor.class);
    private static final Map<String, Script> scriptCache = new ConcurrentHashMap<String, Script>(25);
    private static final int RHINO_COMPILER_OPTIMIZATION_LEVEL = 3;

    public static void reset() {
        scriptCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Script checkAndAddInCache(String scriptContent, String name) throws Exception {
        Script script = scriptCache.get(name);
        if (script == null) {
            Context cx = Context.enter();
            cx.setOptimizationLevel(3);
            try {
                script = cx.compileString(scriptContent, name, 1, null);
                scriptCache.put(name, script);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to compile script " + name + " with optimization level" + 3), (Throwable)e);
            }
            finally {
                Context.exit();
            }
        }
        return script;
    }

    public static void compileAndCache(String scriptContent, String name) {
        if (scriptContent == null) {
            return;
        }
        try {
            RhinoScriptProcessor.checkAndAddInCache(scriptContent, name);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to compile and cache the script '" + name + "': " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static Scriptable execute(String scriptContent, String name, Scriptable scope) {
        if (scriptContent == null) {
            return scope;
        }
        try {
            Script script = RhinoScriptProcessor.checkAndAddInCache(scriptContent, name);
            RhinoScriptProcessor.executeCompiledScript(script, name, scope);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to execute script '" + name + "': " + ex.getMessage()), (Throwable)ex);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object interpret(String scriptContent, String name, Scriptable givenScope) {
        Object result = null;
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        try {
            result = cx.evaluateString(givenScope, scriptContent, name, 1, null);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to execute script '" + name + "': " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            Context.exit();
        }
        return RhinoValueConverter.convertValueForJava(result, givenScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object executeCompiledScript(Script script, String name, Scriptable givenScope) throws GuideException {
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        Object result = null;
        try {
            result = script.exec(cx, givenScope);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to execute compiled script '" + name + "': " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            Context.exit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable getRhinoScope() {
        Context cx = null;
        ScriptableObject scope = null;
        cx = Context.enter();
        try {
            scope = cx.initStandardObjects(null, false);
        }
        finally {
            Context.exit();
        }
        return scope;
    }
}

