/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils.rhino;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class RhinoValueConverter {
    public static final Object convertValueForJava(Object value, Scriptable scope) {
        if (value == null) {
            return scope;
        }
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Map[] result = new HashMap[(int)arr.getLength()];
            for (Object o : arr.getIds()) {
                Object[] propIds;
                int index = (Integer)o;
                NativeObject obj = (NativeObject)arr.get(index, null);
                result[index] = new HashMap();
                if (obj == null) continue;
                for (Object propId : propIds = NativeObject.getPropertyIds((Scriptable)obj)) {
                    String key = propId.toString();
                    String value1 = NativeObject.getProperty((Scriptable)obj, (String)key).toString();
                    result[index].put(key, value1);
                }
            }
            return result;
        }
        if (value instanceof NativeObject) {
            Object[] propIds = ((NativeObject)value).getIds();
            HashMap<String, String> propValues = new HashMap<String, String>(propIds.length);
            for (int i = 0; i < propIds.length; ++i) {
                Object propId = propIds[i];
                if (!(propId instanceof String)) continue;
                Object val = ((NativeObject)value).get((String)propId, scope);
                if (val instanceof String) {
                    propValues.put((String)propId, (String)val);
                    continue;
                }
                if (!(val instanceof ConsString)) continue;
                propValues.put((String)propId, val.toString());
            }
            if (propValues.size() > 0) {
                return propValues;
            }
            return scope;
        }
        return scope;
    }
}

