/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.xfa;

import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFAJSONTransformerUtil {
    private Logger logger = LoggerFactory.getLogger(XFAJSONTransformerUtil.class);
    public static final Hashtable<String, String[]> fieldUiRTMap = new Hashtable();
    public static final Hashtable<String, String> defaultFieldUiMap;
    public static final Hashtable<String, String[]> drawUiRTMap;
    public static final Hashtable<String, String> mandatoryConvertor;
    public static final Hashtable<String, String> assistPriorityConvertor;
    public static final Hashtable<String, String> multiSelectConvertor;
    public static final Hashtable<String, List<String>> oneOfChild;
    private static String UNNAMED_PREFIX;
    private int unnamedCount = 0;
    private ResourceResolver resourceResolver;
    private String xfaPath;
    private HashMap<String, Integer> nameCountMap;

    public XFAJSONTransformerUtil() {
        this.resourceResolver = null;
        this.xfaPath = "";
        this.nameCountMap = new HashMap();
    }

    public XFAJSONTransformerUtil(ResourceResolver resourceResolver, String xfaPath) {
        this.resourceResolver = resourceResolver;
        this.xfaPath = xfaPath;
        this.nameCountMap = new HashMap();
    }

    public Object getOrElse(JSONObject jsonObject, String jsonXpath, Object defaultValue, boolean isAttr) throws Exception {
        JSONObject currObject = jsonObject;
        String[] propChain = jsonXpath.split("\\.");
        Object value = null;
        block0: for (int i = 0; i < propChain.length; ++i) {
            String property = propChain[i];
            String attrName = "";
            String attrValue = "";
            int attrIndex = property.indexOf("(");
            if (attrIndex != -1) {
                String attrString;
                property = propChain[i].substring(0, attrIndex);
                attrName = attrString = propChain[i].substring(attrIndex + 1, propChain[i].length() - 1);
                int ind = attrString.indexOf("=");
                if (ind != -1) {
                    attrName = attrString.substring(0, ind);
                    attrValue = attrString.substring(ind + 1);
                }
            }
            boolean isLastProp = i == propChain.length - 1;
            JSONObject tmpCurrentObject = currObject;
            currObject = null;
            value = null;
            if (tmpCurrentObject != null) {
                if ("oneOfChild".equals(property)) {
                    currObject = this.getOneOfChild(tmpCurrentObject, oneOfChild.get(tmpCurrentObject.get("_class")));
                    continue;
                }
                if (isLastProp && tmpCurrentObject.has(property)) {
                    value = tmpCurrentObject.get(property);
                    continue;
                }
                if ((isLastProp && isAttr || !tmpCurrentObject.has("children") || !(tmpCurrentObject.get("children") instanceof JSONArray)) && (!tmpCurrentObject.has("items") || !(tmpCurrentObject.get("items") instanceof JSONObject))) continue;
                JSONArray array = tmpCurrentObject.getJSONArray("children");
                for (int j = 0; j < array.length(); ++j) {
                    String arrayItemAttrValue;
                    boolean flag;
                    JSONObject arrayItem = array.getJSONObject(j);
                    if (!property.equals(arrayItem.getString("_class")) && (!arrayItem.has("guideNodeClass") || !property.equals(arrayItem.getString("guideNodeClass")))) continue;
                    boolean bl = flag = attrIndex == -1;
                    if (!flag && attrValue.equals(arrayItemAttrValue = arrayItem.getString(attrName))) {
                        flag = true;
                    }
                    if (!flag) continue;
                    currObject = arrayItem;
                    continue block0;
                }
                continue;
            }
            return defaultValue;
        }
        if (currObject != null) {
            return currObject;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Object getOrElseFromAfJson(JSONObject jsonObject, String jsonXpath, Object defaultValue, boolean isAttr) throws Exception {
        JSONObject currObject = jsonObject;
        String[] propChain = jsonXpath.split("\\.");
        String value = null;
        for (int i = 0; i < propChain.length; ++i) {
            String property = propChain[i];
            boolean isLastProp = i == propChain.length - 1;
            JSONObject tmpCurrentObject = currObject;
            currObject = null;
            value = null;
            if (tmpCurrentObject == null) continue;
            if (!isAttr && tmpCurrentObject.has(property)) {
                currObject = (JSONObject)tmpCurrentObject.get(property);
                continue;
            }
            if ((!isLastProp || !isAttr) && tmpCurrentObject.has("items") && tmpCurrentObject.get("items") instanceof JSONObject) {
                JSONObject itemsJsonObject = (JSONObject)tmpCurrentObject.get("items");
                if (itemsJsonObject.has(property)) {
                    currObject = (JSONObject)itemsJsonObject.get(property);
                    continue;
                }
                currObject = null;
                continue;
            }
            if (isLastProp && isAttr) {
                value = tmpCurrentObject.getString(property);
                continue;
            }
            return defaultValue;
        }
        if (currObject != null) {
            return currObject;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private Hashtable<String, JSONObject> getItems(JSONObject fieldJson) throws Exception {
        Hashtable<String, JSONObject> result = new Hashtable<String, JSONObject>();
        if (fieldJson.has("children") && fieldJson.get("children") instanceof JSONArray) {
            JSONObject saveItems = null;
            JSONObject displayItems = null;
            JSONArray fieldChildren = fieldJson.getJSONArray("children");
            for (int i = 0; i < fieldChildren.length(); ++i) {
                JSONObject fieldChild = fieldChildren.getJSONObject(i);
                if (!"items".equals(fieldChild.get("_class"))) continue;
                if (fieldChild.has("save") && "1".equals(fieldChild.getString("save"))) {
                    saveItems = fieldChild;
                    continue;
                }
                displayItems = fieldChild;
            }
            if (saveItems == null && displayItems != null) {
                saveItems = displayItems;
            }
            if (saveItems != null) {
                result.put("saveItems", saveItems);
                if (displayItems == null) {
                    displayItems = saveItems;
                }
                result.put("displayItems", displayItems);
            }
        }
        return result;
    }

    public String[] getDropDownOptions(JSONObject fieldJson) throws Exception {
        Hashtable<String, JSONObject> items = this.getItems(fieldJson);
        JSONObject saveItems = items.get("saveItems");
        JSONObject displayItems = items.get("displayItems");
        JSONArray saveChildren = null;
        JSONArray displayChildren = null;
        String[] result = new String[]{};
        if (saveItems != null && saveItems.has("children")) {
            saveChildren = (JSONArray)saveItems.get("children");
            displayChildren = (JSONArray)displayItems.get("children");
        }
        if (saveChildren != null && saveChildren.length() > 0) {
            result = new String[saveChildren.length()];
            for (int i = 0; i < saveChildren.length(); ++i) {
                JSONObject saveChild = saveChildren.getJSONObject(i);
                JSONObject displayChild = displayChildren.getJSONObject(i);
                String saveValue = (String)this.getOrElse(saveChild, "_value", "", true);
                String displayValue = (String)this.getOrElse(displayChild, "_value", "", true);
                result[i] = saveValue + "=" + displayValue;
            }
        }
        return result;
    }

    public String convertItemsToOptions(JSONObject fieldJson) throws Exception {
        Hashtable<String, JSONObject> items = this.getItems(fieldJson);
        JSONObject saveItems = items.get("saveItems");
        if (saveItems != null && saveItems.has("children") && saveItems.get("children") instanceof JSONArray && saveItems.getJSONArray("children").length() > 0) {
            JSONObject itemValueChild = saveItems.getJSONArray("children").getJSONObject(0);
            String itemOption = (String)this.getOrElse(itemValueChild, "_value", "", true);
            String title = this.getTitle(fieldJson);
            return itemOption + "=" + title;
        }
        return null;
    }

    public JSONObject getOneOfChild(JSONObject jsonObject, List<String> oneOfChildList) throws Exception {
        if (jsonObject != null && jsonObject.has("children") && jsonObject.get("children") instanceof JSONArray) {
            JSONArray objectChildren = jsonObject.getJSONArray("children");
            for (int i = 0; i < objectChildren.length(); ++i) {
                JSONObject child = (JSONObject)objectChildren.get(i);
                String childType = child.getString("_class");
                if (!oneOfChildList.contains(childType)) continue;
                return child;
            }
        }
        return null;
    }

    public Hashtable<String, Object> getTableProperties(Hashtable<String, Object> input) {
        if (input == null) {
            input = new Hashtable();
        }
        input.put("sling:resourceType", "fd/af/components/table");
        input.put("guideNodeClass", "guideTable");
        return input;
    }

    public Hashtable<String, Object> getPanelProperties(Hashtable<String, Object> input) {
        if (input == null) {
            input = new Hashtable();
        }
        input.put("sling:resourceType", "fd/af/components/panel");
        input.put("guideNodeClass", "guidePanel");
        return input;
    }

    public Hashtable<String, Object> getLayoutProperties(Hashtable<String, Object> input, boolean isTableMode) {
        if (input == null) {
            input = new Hashtable();
        }
        input.put("jcr:primaryType", "nt:unstructured");
        if (isTableMode) {
            input.put("sling:resourceType", "fd/af/layouts/tableLayout");
            input.put("mobileLayout", "headersLeft");
        } else {
            input.put("sling:resourceType", "fd/af/layouts/gridFluidLayout");
        }
        return input;
    }

    public Hashtable<String, Object> getCommonProperties(Hashtable<String, Object> input, JSONObject jsonObject) throws Exception {
        if (input == null) {
            input = new Hashtable();
        }
        input.put("name", GuideUtils.getOrGenerateUniqueName(this.getOrGenerateName(jsonObject), this.nameCountMap));
        String title = this.getTitle(jsonObject);
        if (title == null) {
            title = "";
        }
        input.put("jcr:title", title);
        input.put("jcr:primaryType", "nt:unstructured");
        this.putGuideProp(input, jsonObject, "bindRef", "extras.extras(name=FS_EXTRAS).text(name=FS_SOM)._value", null, null);
        this.putGuideProp(input, jsonObject, "dataSom", "extras.extras(name=FS_EXTRAS).text(name=FS_DATA_SOM)._value", null, null);
        this.putGuideProp(input, jsonObject, "isFragment", "extras.extras(name=FS_EXTRAS).text(name=isFragment)._value", null, null);
        String usehref = (String)this.getOrElse(jsonObject, "extras.extras(name=FS_EXTRAS).text(name=usehref)._value", null, true);
        if (usehref != null && usehref.length() > 0) {
            this.handleXDPFragment(input, jsonObject, usehref);
        }
        return input;
    }

    public void handleXDPFragment(Hashtable<String, Object> input, JSONObject obj, String usehref) {
        try {
            String xdpRef = StringUtils.substringBeforeLast((String)usehref, (String)"#");
            String fragmentModelRootFromUsehref = "";
            String fragRef = null;
            String bindRef = (String)input.get("bindRef");
            fragmentModelRootFromUsehref = StringUtils.substringAfter((String)usehref, (String)"#subform");
            fragmentModelRootFromUsehref = StringUtils.substringBeforeLast((String)fragmentModelRootFromUsehref, (String)")");
            fragmentModelRootFromUsehref = StringUtils.replace((String)fragmentModelRootFromUsehref, (String)".", (String)"[0].") + "[0]";
            String basePathOfXFAFile = StringUtils.substringBeforeLast((String)this.xfaPath, (String)"/");
            xdpRef = StringUtils.replace((String)xdpRef, (String)"\\", (String)"/");
            xdpRef = StringUtils.substringBeforeLast((String)xdpRef, (String)"#");
            xdpRef = basePathOfXFAFile + "/" + xdpRef;
            xdpRef = ResourceUtil.normalize(xdpRef);
            String query = "/jcr:root/content/dam/formsanddocuments//element(*, dam:Asset) \n[\njcr:content/metadata/@xdpRef = '" + xdpRef + "'\n]";
            Iterator<Resource> fragmentNodes = this.resourceResolver.findResources(query, "xpath");
            if (fragmentNodes.hasNext()) {
                Resource resource = fragmentNodes.next();
                fragRef = resource.getPath();
                Resource fMmetaDataNode = resource.getChild("jcr:content").getChild("metadata");
                ValueMap valueMap = fMmetaDataNode.adaptTo(ValueMap.class);
                String fragmentModelRootFromMetaData = (String)valueMap.get("fragmentModelRoot");
                if (StringUtils.contains((CharSequence)fragmentModelRootFromMetaData, (CharSequence)fragmentModelRootFromUsehref)) {
                    input.put("fragRef", fragRef);
                }
            }
            if (!input.containsKey("fragRef")) {
                input.put("usehref", xdpRef + "#" + fragmentModelRootFromUsehref);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in handling usehref for fragment", (Throwable)e);
        }
    }

    public Hashtable<String, Object> getFieldProperties(Hashtable<String, Object> input, JSONObject fieldJson) throws Exception {
        if (fieldJson == null) {
            return null;
        }
        if (input == null) {
            input = new Hashtable();
        }
        input = this.getCommonProperties(input, fieldJson);
        String fieldUiType = (String)this.getOrElse(fieldJson, "ui.oneOfChild._class", "defaultUi", true);
        String fieldValueType = (String)this.getOrElse(fieldJson, "value.oneOfChild._class", null, true);
        if ("defaultUi".equals(fieldUiType) && fieldValueType != null) {
            fieldUiType = defaultFieldUiMap.get(fieldValueType);
        }
        if ("imageEdit".equals(fieldUiType)) {
            String scribbleName = (String)this.getOrElse(fieldJson, "ui.extras.name", null, true);
            if ("x-scribble-add-on".equals(scribbleName)) {
                fieldUiType = "scribble";
            }
        } else if ("dateTimeEdit".equals(fieldUiType) && ("time".equals(fieldValueType) || "dateTime".equals(fieldValueType))) {
            fieldUiType = "textEdit";
        }
        String[] guideUiType = null;
        if (fieldUiType != null) {
            guideUiType = fieldUiRTMap.get(fieldUiType);
        }
        if (guideUiType != null && guideUiType.length == 2) {
            String prop;
            input.put("sling:resourceType", guideUiType[0]);
            input.put("guideNodeClass", guideUiType[1]);
            this.putGuideProp(input, fieldJson, "mandatory", "validate.nullTest", "false", mandatoryConvertor);
            this.putGuideProp(input, fieldJson, "mandatoryMessage", "validate.message.text(name=nullTest)._value", null, null);
            this.putGuideProp(input, fieldJson, "_value", "value.oneOfChild._value", null, null);
            this.putGuideProp(input, fieldJson, "validateExpMessage", "validate.message.text(name=scriptTest)._value", null, null);
            this.putGuideProp(input, fieldJson, "validatePictureClauseMessage", "validate.message.text(name=formatTest)._value", null, null);
            this.putGuideProp(input, fieldJson, "assistPriority", "assist.speak.priority", null, assistPriorityConvertor);
            this.putGuideProp(input, fieldJson, "custom", "assist.speak._value", null, null);
            this.putGuideProp(input, fieldJson, "shortDescription", "assist.toolTip._value", null, null);
            if (!"time".equals(fieldValueType) && !"dateTime".equals(fieldValueType)) {
                prop = (String)this.getOrElse(fieldJson, "format.picture._value", null, true);
                if (prop != null && prop.length() > 0) {
                    input.put("displayPictureClause", prop);
                }
                if ((prop = (String)this.getOrElse(fieldJson, "validate.picture._value", null, true)) != null && prop.length() > 0) {
                    input.put("validatePictureClause", prop);
                }
            }
            if ("guideScribble".equals(guideUiType[1])) {
                input.put("aspectRatio", XFAJSONTransformerUtil.calculateAspectRatio(fieldJson) + "");
            }
            if ("guideDatePicker".equals(guideUiType[1]) && (prop = (String)this.getOrElse(fieldJson, "ui.picture._value", null, true)) != null && prop.length() > 0) {
                input.put("editPictureClause", prop);
            }
            if ("guideCheckBox".equals(guideUiType[1])) {
                String[] option = new String[]{this.convertItemsToOptions(fieldJson)};
                input.put("options", option);
            } else if ("guideNumericBox".equals(guideUiType[1])) {
                input.put("dataType", fieldValueType);
                this.putGuideProp(input, fieldJson, "leadDigits", "value.oneOfChild.fracDigits", null, null);
                this.putGuideProp(input, fieldJson, "leadDigits", "value.oneOfChild.leadDigits", null, null);
            } else if ("guideTextBox".equals(guideUiType[1])) {
                Hashtable<String, String> multiLineConvertor = new Hashtable<String, String>();
                multiLineConvertor.put("1", "true");
                this.putGuideProp(input, fieldJson, "multiLine", "ui.textEdit.multiLine", null, multiLineConvertor);
                this.putGuideProp(input, fieldJson, "maxChars", "value.text.maxChars", null, null);
            } else if ("guideDropDownList".equals(guideUiType[1])) {
                this.putGuideProp(input, fieldJson, "multiSelect", "ui.choiceList.open", null, multiSelectConvertor);
                String[] options = this.getDropDownOptions(fieldJson);
                if (options.length > 0) {
                    input.put("options", options);
                }
            }
        } else {
            this.logger.warn("unrecognized type, treating it as text: " + fieldUiType + " : " + fieldUiType);
            input.put("sling:resourceType", "fd/af/components/guidetextbox");
            input.put("guideNodeClass", "guideTextBox");
        }
        return input;
    }

    public static double calculateAspectRatio(JSONObject fieldJson) throws Exception {
        double height = GuideUtils.convertToPx((String)fieldJson.get("h"));
        double ratio = height - 34.0 > 0.0 ? GuideUtils.convertToPx((String)fieldJson.get("w")) / height : GuideConstants.DEFAULT_ASPECT_RATIO;
        return ratio;
    }

    public Hashtable<String, Object> getExclGroupProperties(Hashtable<String, Object> input, JSONObject exclGroupJson) throws Exception {
        if (exclGroupJson == null) {
            return null;
        }
        if (input == null) {
            input = new Hashtable();
        }
        input = this.getCommonProperties(input, exclGroupJson);
        input.put("sling:resourceType", "fd/af/components/guideradiobutton");
        input.put("guideNodeClass", "guideRadioButton");
        if (exclGroupJson.has("children") && exclGroupJson.get("children") instanceof JSONArray) {
            JSONArray children = exclGroupJson.getJSONArray("children");
            ArrayList<String> options = new ArrayList<String>();
            String value = null;
            for (int i = 0; i < children.length(); ++i) {
                JSONObject child = children.getJSONObject(i);
                if (!"field".equals(child.getString("_class"))) continue;
                options.add(this.convertItemsToOptions(child));
                value = (String)this.getOrElse(child, "value.oneOfChild._value", value, true);
            }
            input.put("options", options.toArray(new String[options.size()]));
            if (value != null) {
                input.put("_value", value);
            }
            this.putGuideProp(input, exclGroupJson, "mandatory", "validate.nullTest", "false", mandatoryConvertor);
            this.putGuideProp(input, exclGroupJson, "mandatoryMessage", "validate.message.text(name=nullTest)._value", null, null);
        }
        return input;
    }

    public Hashtable<String, Object> getDrawProperties(Hashtable<String, Object> input, JSONObject drawJson) throws Exception {
        if (drawJson == null) {
            return null;
        }
        if (input == null) {
            input = new Hashtable();
        }
        input = this.getCommonProperties(input, drawJson);
        String drawUiType = (String)this.getOrElse(drawJson, "ui.oneOfChild._class", "defaultUi", true);
        String drawValueType = (String)this.getOrElse(drawJson, "value.oneOfChild._class", null, true);
        if ("defaultUi".equals(drawUiType) && drawValueType != null) {
            drawUiType = defaultFieldUiMap.get(drawValueType);
        }
        String[] guideUiType = null;
        if (drawUiType != null) {
            guideUiType = drawUiRTMap.get(drawUiType);
        }
        if (guideUiType != null && guideUiType.length == 2) {
            input.put("sling:resourceType", guideUiType[0]);
            input.put("guideNodeClass", guideUiType[1]);
            if ("guideTextDraw".equals(guideUiType[1])) {
                String textValue = (String)this.getOrElse(drawJson, "value." + drawValueType + "._value", "", true);
                input.put("_value", StringEscapeUtils.escapeHtml4((String)textValue));
                if ("text".equals(drawValueType)) {
                    input.put("textIsRich", false);
                } else if ("exData".equals(drawValueType)) {
                    input.put("textIsRich", true);
                }
            }
        } else {
            this.logger.warn("Unsupported draw type:" + drawUiType + ":" + drawValueType);
        }
        return input;
    }

    public String getTitle(JSONObject jsonObject) throws Exception {
        String title = null;
        if ("field".equals(jsonObject.getString("_class"))) {
            title = (String)this.getOrElse(jsonObject, "caption.value.text._value", null, true);
        }
        if (title == null && jsonObject.has("name")) {
            String nodeName = jsonObject.getString("name");
            title = GuideUtils.humanize(nodeName);
        }
        return title;
    }

    public String getOrGenerateName(JSONObject jsonObject) throws Exception {
        String name = (String)this.getOrElse(jsonObject, "name", null, true);
        if (name == null || "".equals(name)) {
            name = UNNAMED_PREFIX + this.unnamedCount++ + "_" + jsonObject.getString("_class");
        }
        return name;
    }

    private boolean putGuideProp(Hashtable<String, Object> input, JSONObject obj, String guideProp, String xfaProp, String def, Hashtable<String, String> convertor) throws Exception {
        String val = (String)this.getOrElse(obj, xfaProp, null, true);
        val = convertor == null ? val : (val == null ? val : convertor.get(val));
        String string = val = val == null ? def : val;
        if (val != null) {
            input.put(guideProp, val);
            return true;
        }
        return false;
    }

    static {
        String[] arr = new String[]{"fd/af/components/guidebutton", "guideButton"};
        fieldUiRTMap.put("button", arr);
        String[] arr1 = new String[]{"fd/af/components/guidecheckbox", "guideCheckBox"};
        fieldUiRTMap.put("checkButton", arr1);
        String[] arr2 = new String[]{"fd/af/components/guidedropdownlist", "guideDropDownList"};
        fieldUiRTMap.put("choiceList", arr2);
        String[] arr3 = new String[]{"fd/af/components/guidedatepicker", "guideDatePicker"};
        fieldUiRTMap.put("dateTimeEdit", arr3);
        String[] arr4 = new String[]{"fd/af/components/guidenumericbox", "guideNumericBox"};
        fieldUiRTMap.put("numericEdit", arr4);
        String[] arr5 = new String[]{"fd/af/components/guidepasswordbox", "guidePasswordBox"};
        fieldUiRTMap.put("passwordEdit", arr5);
        String[] arr6 = new String[]{"fd/af/components/guidetextbox", "guideTextBox"};
        fieldUiRTMap.put("textEdit", arr6);
        String[] arr7 = new String[]{"fd/af/components/guidescribble", "guideScribble"};
        fieldUiRTMap.put("scribble", arr7);
        String[] arr8 = new String[]{};
        fieldUiRTMap.put("defaultUi", arr8);
        fieldUiRTMap.put("exObject", arr8);
        fieldUiRTMap.put("imageEdit", arr8);
        fieldUiRTMap.put("signature", arr8);
        fieldUiRTMap.put("barcode", arr8);
        drawUiRTMap = new Hashtable();
        drawUiRTMap.put("textEdit", new String[]{"fd/af/components/guidetextdraw", "guideTextDraw"});
        drawUiRTMap.put("imageEdit", new String[]{"fd/af/components/guideimage", "guideImage"});
        defaultFieldUiMap = new Hashtable();
        defaultFieldUiMap.put("integer", "numericEdit");
        defaultFieldUiMap.put("boolean", "checkButton");
        defaultFieldUiMap.put("decimal", "numericEdit");
        defaultFieldUiMap.put("float", "numericEdit");
        defaultFieldUiMap.put("date", "dateTimeEdit");
        defaultFieldUiMap.put("dateTime", "dateTimeEdit");
        defaultFieldUiMap.put("time", "dateTimeEdit");
        defaultFieldUiMap.put("text", "textEdit");
        defaultFieldUiMap.put("exdata", "textEdit");
        defaultFieldUiMap.put("arc", "defaultUi");
        defaultFieldUiMap.put("line", "defaultUi");
        defaultFieldUiMap.put("rectangle", "defaultUi");
        defaultFieldUiMap.put("image", "imageEdit");
        oneOfChild = new Hashtable();
        oneOfChild.put("ui", Arrays.asList("barcode", "button", "checkButton", "choiceList", "dateTimeEdit", "defaultUi", "exObject", "imageEdit", "numericEdit", "passwordEdit", "signature", "textEdit"));
        oneOfChild.put("value", Arrays.asList("arc", "boolean", "date", "dateTime", "decimal", "exData", "float", "image", "integer", "line", "rectangle", "text", "time"));
        mandatoryConvertor = new Hashtable();
        mandatoryConvertor.put("disabled", "false");
        mandatoryConvertor.put("error", "true");
        mandatoryConvertor.put("warning", "false");
        assistPriorityConvertor = new Hashtable();
        assistPriorityConvertor.put("custom", "custom");
        assistPriorityConvertor.put("toolTip", "shortDescription");
        assistPriorityConvertor.put("caption", "label");
        assistPriorityConvertor.put("name", "name");
        multiSelectConvertor = new Hashtable();
        multiSelectConvertor.put("multiSelect", "true");
        UNNAMED_PREFIX = "_unnamed";
    }
}

